/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.spark.internal;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.spark.internal.HoodieDataSourceInternalBatchWriteBuilder;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.connector.catalog.SupportsWrite;
import org.apache.spark.sql.connector.catalog.TableCapability;
import org.apache.spark.sql.connector.write.LogicalWriteInfo;
import org.apache.spark.sql.connector.write.WriteBuilder;
import org.apache.spark.sql.types.StructType;

class HoodieDataSourceInternalTable
implements SupportsWrite {
    private final String instantTime;
    private final HoodieWriteConfig writeConfig;
    private final StructType structType;
    private final SparkSession jss;
    private final StorageConfiguration<?> storageConf;
    private final boolean arePartitionRecordsSorted;
    private final Map<String, String> properties;
    private final boolean populateMetaFields;

    public HoodieDataSourceInternalTable(String instantTime, HoodieWriteConfig config, StructType schema, SparkSession jss, StorageConfiguration<?> storageConf, Map<String, String> properties, boolean populateMetaFields, boolean arePartitionRecordsSorted) {
        this.instantTime = instantTime;
        this.writeConfig = config;
        this.structType = schema;
        this.jss = jss;
        this.storageConf = storageConf;
        this.properties = properties;
        this.populateMetaFields = populateMetaFields;
        this.arePartitionRecordsSorted = arePartitionRecordsSorted;
    }

    public String name() {
        return this.getClass().toString();
    }

    public StructType schema() {
        return this.structType;
    }

    public Set<TableCapability> capabilities() {
        return new HashSet<TableCapability>(){
            {
                this.add(TableCapability.BATCH_WRITE);
                this.add(TableCapability.TRUNCATE);
            }
        };
    }

    public WriteBuilder newWriteBuilder(LogicalWriteInfo logicalWriteInfo) {
        return new HoodieDataSourceInternalBatchWriteBuilder(this.instantTime, this.writeConfig, this.structType, this.jss, this.storageConf, this.properties, this.populateMetaFields, this.arePartitionRecordsSorted);
    }
}

