/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.catalog;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Locale;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.AvroConversionUtils$;
import org.apache.hudi.DataSourceOptionsHelper$;
import org.apache.hudi.HoodieWriterUtils$;
import org.apache.hudi.common.config.DFSPropertiesConfiguration;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.TimelineUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.apache.hudi.keygen.constant.KeyGeneratorType;
import org.apache.hudi.keygen.factory.HoodieSparkKeyGeneratorFactory;
import org.apache.hudi.storage.HoodieStorageUtils;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.util.SparkConfigUtils$;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.avro.SchemaConverters$;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable$;
import org.apache.spark.sql.hudi.HoodieOptionConfig$;
import org.apache.spark.sql.hudi.HoodieSqlCommonUtils$;
import org.apache.spark.sql.hudi.command.exception.HoodieAnalysisException;
import org.apache.spark.sql.hudi.command.exception.HoodieAnalysisException$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t=b\u0001B\u00181\u0001uB\u0001b\u000e\u0001\u0003\u0006\u0004%\tA\u0013\u0005\t\u001f\u0002\u0011\t\u0011)A\u0005\u0017\"A\u0001\u000b\u0001BA\u0002\u0013\u0005\u0011\u000b\u0003\u0005W\u0001\t\u0005\r\u0011\"\u0001X\u0011!i\u0006A!A!B\u0013\u0011\u0006\"\u00020\u0001\t\u0003y\u0006bB2\u0001\u0005\u0004%I\u0001\u001a\u0005\u0007k\u0002\u0001\u000b\u0011B3\t\u000fY\u0004!\u0019!C\u0001o\"9\u0011q\u0001\u0001!\u0002\u0013A\b\"CA\u0005\u0001\t\u0007I\u0011AA\u0006\u0011!\t\u0019\u0002\u0001Q\u0001\n\u00055\u0001\u0002CA\u000b\u0001\t\u0007I\u0011A<\t\u000f\u0005]\u0001\u0001)A\u0005q\"I\u0011\u0011\u0004\u0001C\u0002\u0013\u0005\u00111\u0004\u0005\t\u0003G\u0001\u0001\u0015!\u0003\u0002\u001e!Q\u0011Q\u0005\u0001\t\u0006\u0004%\t!a\n\t\u0015\u0005]\u0002\u0001#b\u0001\n\u0003\tI\u0004C\u0005\u0002B\u0001A)\u0019!C\u0001o\"I\u00111\t\u0001\t\u0006\u0004%\ta\u001e\u0005\u000b\u0003\u000b\u0002\u0001R1A\u0005\u0002\u0005\u001d\u0003\"CA+\u0001!\u0015\r\u0011\"\u0001x\u0011)\t9\u0006\u0001EC\u0002\u0013\u0005\u0011\u0011\f\u0005\u000b\u0003C\u0002\u0001R1A\u0005\u0002\u0005\r\u0004BCA;\u0001!\u0015\r\u0011\"\u0001\u0002Z!Q\u0011q\u000f\u0001\t\u0006\u0004%\t!a\u0007\t\u0015\u0005e\u0004\u0001#b\u0001\n\u0003\tY\b\u0003\u0006\u0002\n\u0002A)\u0019!C\u0001\u0003wB!\"a#\u0001\u0011\u000b\u0007I\u0011AA>\u0011)\ti\t\u0001EC\u0002\u0013\u0005\u00111\u0010\u0005\b\u0003\u001f\u0003A\u0011AAI\u0011\u001d\t)\u000b\u0001C\u0001\u00037Aq!a*\u0001\t\u0003\tI\u000bC\u0004\u0002,\u0002!I!!,\t\u000f\u0005U\u0006\u0001\"\u0003\u00028\"I\u0011Q\u0019\u0001\u0012\u0002\u0013%\u0011q\u0019\u0005\n\u0003;\u0004\u0011\u0013!C\u0005\u0003\u000fDq!a8\u0001\t\u0013\t\t\u000fC\u0004\u0002j\u0002!I!a;\b\u000f\t-\u0001\u0007#\u0001\u0003\u000e\u00191q\u0006\rE\u0001\u0005\u001fAaAX\u0015\u0005\u0002\tE\u0001\"\u0003B\nS\t\u0007I\u0011\u0001B\u000b\u0011!\u0011Y\"\u000bQ\u0001\n\t]\u0001b\u0002B\u000fS\u0011\u0005!q\u0004\u0005\b\u0005;IC\u0011\u0001B\u0014\u0005IAun\u001c3jK\u000e\u000bG/\u00197pOR\u000b'\r\\3\u000b\u0005E\u0012\u0014aB2bi\u0006dwn\u001a\u0006\u0003gQ\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003kY\n1a]9m\u0015\t9\u0004(A\u0003ta\u0006\u00148N\u0003\u0002:u\u00051\u0011\r]1dQ\u0016T\u0011aO\u0001\u0004_J<7\u0001A\n\u0004\u0001y\"\u0005CA C\u001b\u0005\u0001%\"A!\u0002\u000bM\u001c\u0017\r\\1\n\u0005\r\u0003%AB!osJ+g\r\u0005\u0002F\u00116\taI\u0003\u0002Hm\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002J\r\n9Aj\\4hS:<W#A&\u0011\u00051kU\"\u0001\u001b\n\u00059#$\u0001D*qCJ\\7+Z:tS>t\u0017AB:qCJ\\\u0007%A\u0003uC\ndW-F\u0001S!\t\u0019F+D\u00011\u0013\t)\u0006G\u0001\u0007DCR\fGn\\4UC\ndW-A\u0005uC\ndWm\u0018\u0013fcR\u0011\u0001l\u0017\t\u0003\u007feK!A\u0017!\u0003\tUs\u0017\u000e\u001e\u0005\b9\u0012\t\t\u00111\u0001S\u0003\rAH%M\u0001\u0007i\u0006\u0014G.\u001a\u0011\u0002\rqJg.\u001b;?)\r\u0001\u0017M\u0019\t\u0003'\u0002AQa\u000e\u0004A\u0002-CQ\u0001\u0015\u0004A\u0002I\u000b1b\u001d;pe\u0006<WmQ8oMV\tQ\rE\u0002gW6l\u0011a\u001a\u0006\u0003Q&\fqa\u001d;pe\u0006<WM\u0003\u0002kq\u0005!\u0001.\u001e3j\u0013\tawM\u0001\u000bTi>\u0014\u0018mZ3D_:4\u0017nZ;sCRLwN\u001c\t\u0003]Nl\u0011a\u001c\u0006\u0003aF\fAaY8oM*\u0011!\u000fO\u0001\u0007Q\u0006$wn\u001c9\n\u0005Q|'!D\"p]\u001aLw-\u001e:bi&|g.\u0001\u0007ti>\u0014\u0018mZ3D_:4\u0007%\u0001\tdCR\fGn\\4UC\ndWMT1nKV\t\u0001\u0010E\u0002z\u0003\u0003q!A\u001f@\u0011\u0005m\u0004U\"\u0001?\u000b\u0005ud\u0014A\u0002\u001fs_>$h(\u0003\u0002\u0000\u0001\u00061\u0001K]3eK\u001aLA!a\u0001\u0002\u0006\t11\u000b\u001e:j]\u001eT!a !\u0002#\r\fG/\u00197pOR\u000b'\r\\3OC6,\u0007%A\tdCR\fGn\\4Qe>\u0004XM\u001d;jKN,\"!!\u0004\u0011\u000be\fy\u0001\u001f=\n\t\u0005E\u0011Q\u0001\u0002\u0004\u001b\u0006\u0004\u0018AE2bi\u0006dwn\u001a)s_B,'\u000f^5fg\u0002\nQ\u0002^1cY\u0016dunY1uS>t\u0017A\u0004;bE2,Gj\\2bi&|g\u000eI\u0001\u0012Q>|G-[3UC\ndW-\u0012=jgR\u001cXCAA\u000f!\ry\u0014qD\u0005\u0004\u0003C\u0001%a\u0002\"p_2,\u0017M\\\u0001\u0013Q>|G-[3UC\ndW-\u0012=jgR\u001c\b%\u0001\u0006nKR\f7\t\\5f]R,\"!!\u000b\u0011\t\u0005-\u00121G\u0007\u0003\u0003[Q1\u0001UA\u0018\u0015\r\t\t$[\u0001\u0007G>lWn\u001c8\n\t\u0005U\u0012Q\u0006\u0002\u0016\u0011>|G-[3UC\ndW-T3uC\u000ec\u0017.\u001a8u\u0003-!\u0018M\u00197f\u0007>tg-[4\u0016\u0005\u0005m\u0002\u0003BA\u0016\u0003{IA!a\u0010\u0002.\t\t\u0002j\\8eS\u0016$\u0016M\u00197f\u0007>tg-[4\u0002\u0013Q\f'\r\\3OC6,\u0017\u0001\u00043bi\u0006\u0014\u0017m]3OC6,\u0017!\u0003;bE2,G+\u001f9f+\t\tI\u0005\u0005\u0003\u0002L\u0005ESBAA'\u0015\u0011\ty%a\f\u0002\u000b5|G-\u001a7\n\t\u0005M\u0013Q\n\u0002\u0010\u0011>|G-[3UC\ndW\rV=qK\u0006iA/\u00192mKRK\b/\u001a(b[\u0016\f1\u0002\u001d:j[\u0006\u0014\u0018pS3zgV\u0011\u00111\f\t\u0005\u007f\u0005u\u00030C\u0002\u0002`\u0001\u0013Q!\u0011:sCf\fab\u001c:eKJLgn\u001a$jK2$7/\u0006\u0002\u0002fA)\u0011qMA9q6\u0011\u0011\u0011\u000e\u0006\u0005\u0003W\ni'\u0001\u0003vi&d'BAA8\u0003\u0011Q\u0017M^1\n\t\u0005M\u0014\u0011\u000e\u0002\u0005\u0019&\u001cH/A\bqCJ$\u0018\u000e^5p]\u001aKW\r\u001c3t\u0003\u0001J7/T;mi&\u0004H.\u001a\"bg\u00164\u0015\u000e\\3G_Jl\u0017\r^:F]\u0006\u0014G.\u001a3\u0002\u0017Q\f'\r\\3TG\",W.Y\u000b\u0003\u0003{\u0002B!a \u0002\u00066\u0011\u0011\u0011\u0011\u0006\u0004\u0003\u0007#\u0014!\u0002;za\u0016\u001c\u0018\u0002BAD\u0003\u0003\u0013!b\u0015;sk\u000e$H+\u001f9f\u0003q!\u0018M\u00197f'\u000eDW-\\1XSRDw.\u001e;NKR\fg)[3mIN\f!\u0002Z1uCN\u001b\u0007.Z7b\u0003=\u0001\u0018M\u001d;ji&|gnU2iK6\f\u0017!E4fiB\u000b'\u000f^5uS>t\u0007+\u0019;igV\u0011\u00111\u0013\t\u0006\u0003+\u000by\n\u001f\b\u0005\u0003/\u000bYJD\u0002|\u00033K\u0011!Q\u0005\u0004\u0003;\u0003\u0015a\u00029bG.\fw-Z\u0005\u0005\u0003C\u000b\u0019KA\u0002TKFT1!!(A\u0003II7\u000fU1si&$\u0018n\u001c8fIR\u000b'\r\\3\u0002\u001f%t\u0017\u000e\u001e%p_\u0012LW\rV1cY\u0016$\u0012\u0001W\u0001\u0016a\u0006\u00148/Z*dQ\u0016l\u0017-\u00118e\u0007>tg-[4t)\t\ty\u000bE\u0004@\u0003c\u000bi(!\u0004\n\u0007\u0005M\u0006I\u0001\u0004UkBdWMM\u0001\u0011Kb$(/\u0019+bE2,7i\u001c8gS\u001e$\u0002\"!\u0004\u0002:\u0006u\u0016\u0011\u0019\u0005\b\u0003w\u001b\u0003\u0019AA\u000f\u0003-!\u0018M\u00197f\u000bbL7\u000f^:\t\u0013\u0005}6\u0005%AA\u0002\u00055\u0011!E8sS\u001eLg\u000eV1cY\u0016\u001cuN\u001c4jO\"I\u00111Y\u0012\u0011\u0002\u0003\u0007\u0011QB\u0001\u000bgFdw\n\u001d;j_:\u001c\u0018AG3yiJ\fG+\u00192mK\u000e{gNZ5hI\u0011,g-Y;mi\u0012\u0012TCAAeU\u0011\ti!a3,\u0005\u00055\u0007\u0003BAh\u00033l!!!5\u000b\t\u0005M\u0017Q[\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a6A\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u00037\f\tNA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f!$\u001a=ue\u0006$\u0016M\u00197f\u0007>tg-[4%I\u00164\u0017-\u001e7uIM\n1\u0004\\8bIR\u000b'\r\\3TG\",W.\u0019\"z\u001b\u0016$\u0018m\u00117jK:$HCAAr!\u0015y\u0014Q]A?\u0013\r\t9\u000f\u0011\u0002\u0007\u001fB$\u0018n\u001c8\u0002!Y,'/\u001b4z\t\u0006$\u0018mU2iK6\fGc\u0002-\u0002n\u0006e(\u0011\u0001\u0005\b\u0003_<\u0003\u0019AAy\u0003=!\u0018M\u00197f\u0013\u0012,g\u000e^5gS\u0016\u0014\b\u0003BAz\u0003kl\u0011AM\u0005\u0004\u0003o\u0014$a\u0004+bE2,\u0017\nZ3oi&4\u0017.\u001a:\t\u000f\u0005\u0015s\u00051\u0001\u0002|B\u00191+!@\n\u0007\u0005}\bG\u0001\tDCR\fGn\\4UC\ndW\rV=qK\"9\u00111R\u0014A\u0002\t\r\u0001CBAK\u0003?\u0013)\u0001\u0005\u0003\u0002\u0000\t\u001d\u0011\u0002\u0002B\u0005\u0003\u0003\u00131b\u0015;sk\u000e$h)[3mI\u0006\u0011\u0002j\\8eS\u0016\u001c\u0015\r^1m_\u001e$\u0016M\u00197f!\t\u0019\u0016f\u0005\u0002*}Q\u0011!QB\u0001\u0010]\u0016,GMR5mi\u0016\u0014\bK]8qgV\u0011!q\u0003\t\u0006\u0003+\u0013I\u0002_\u0005\u0005\u0003g\n\u0019+\u0001\toK\u0016$g)\u001b7uKJ\u0004&o\u001c9tA\u0005)\u0011\r\u001d9msR)\u0001M!\t\u0003&!1!1E\u0017A\u0002-\u000bAb\u001d9be.\u001cVm]:j_:Dq!a<.\u0001\u0004\t\t\u0010F\u0003a\u0005S\u0011Y\u0003\u0003\u0004\u0003$9\u0002\ra\u0013\u0005\u0007\u0005[q\u0003\u0019\u0001*\u0002\u0019\r\fG/\u00197pOR\u000b'\r\\3")
public class HoodieCatalogTable
implements Logging {
    private HoodieTableMetaClient metaClient;
    private HoodieTableConfig tableConfig;
    private String tableName;
    private String databaseName;
    private HoodieTableType tableType;
    private String tableTypeName;
    private String[] primaryKeys;
    private java.util.List<String> orderingFields;
    private String[] partitionFields;
    private boolean isMultipleBaseFileFormatsEnabled;
    private StructType tableSchema;
    private StructType tableSchemaWithoutMetaFields;
    private StructType dataSchema;
    private StructType partitionSchema;
    private final SparkSession spark;
    private CatalogTable table;
    private final StorageConfiguration<Configuration> storageConf;
    private final String catalogTableName;
    private final scala.collection.immutable.Map<String, String> catalogProperties;
    private final String tableLocation;
    private final boolean hoodieTableExists;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile int bitmap$0;

    public static HoodieCatalogTable apply(SparkSession sparkSession, CatalogTable catalogTable) {
        return HoodieCatalogTable$.MODULE$.apply(sparkSession, catalogTable);
    }

    public static HoodieCatalogTable apply(SparkSession sparkSession, TableIdentifier tableIdentifier) {
        return HoodieCatalogTable$.MODULE$.apply(sparkSession, tableIdentifier);
    }

    public static List<String> needFilterProps() {
        return HoodieCatalogTable$.MODULE$.needFilterProps();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public SparkSession spark() {
        return this.spark;
    }

    public CatalogTable table() {
        return this.table;
    }

    public void table_$eq(CatalogTable x$1) {
        this.table = x$1;
    }

    private StorageConfiguration<Configuration> storageConf() {
        return this.storageConf;
    }

    public String catalogTableName() {
        return this.catalogTableName;
    }

    public scala.collection.immutable.Map<String, String> catalogProperties() {
        return this.catalogProperties;
    }

    public String tableLocation() {
        return this.tableLocation;
    }

    public boolean hoodieTableExists() {
        return this.hoodieTableExists;
    }

    private HoodieTableMetaClient metaClient$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 1) == 0) {
                this.metaClient = HoodieTableMetaClient.builder().setBasePath(this.tableLocation()).setConf(this.storageConf()).build();
                this.bitmap$0 |= 1;
            }
        }
        return this.metaClient;
    }

    public HoodieTableMetaClient metaClient() {
        if ((this.bitmap$0 & 1) == 0) {
            return this.metaClient$lzycompute();
        }
        return this.metaClient;
    }

    private HoodieTableConfig tableConfig$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 2) == 0) {
                this.tableConfig = this.metaClient().getTableConfig();
                this.bitmap$0 |= 2;
            }
        }
        return this.tableConfig;
    }

    public HoodieTableConfig tableConfig() {
        if ((this.bitmap$0 & 2) == 0) {
            return this.tableConfig$lzycompute();
        }
        return this.tableConfig;
    }

    private String tableName$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 4) == 0) {
                this.tableName = this.tableConfig().getTableName();
                this.bitmap$0 |= 4;
            }
        }
        return this.tableName;
    }

    public String tableName() {
        if ((this.bitmap$0 & 4) == 0) {
            return this.tableName$lzycompute();
        }
        return this.tableName;
    }

    private String databaseName$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 8) == 0) {
                this.databaseName = this.tableConfig().getDatabaseName();
                this.bitmap$0 |= 8;
            }
        }
        return this.databaseName;
    }

    public String databaseName() {
        if ((this.bitmap$0 & 8) == 0) {
            return this.databaseName$lzycompute();
        }
        return this.databaseName;
    }

    private HoodieTableType tableType$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x10) == 0) {
                this.tableType = this.tableConfig().getTableType();
                this.bitmap$0 |= 0x10;
            }
        }
        return this.tableType;
    }

    public HoodieTableType tableType() {
        if ((this.bitmap$0 & 0x10) == 0) {
            return this.tableType$lzycompute();
        }
        return this.tableType;
    }

    private String tableTypeName$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x20) == 0) {
                this.tableTypeName = this.tableType().name();
                this.bitmap$0 |= 0x20;
            }
        }
        return this.tableTypeName;
    }

    public String tableTypeName() {
        if ((this.bitmap$0 & 0x20) == 0) {
            return this.tableTypeName$lzycompute();
        }
        return this.tableTypeName;
    }

    private String[] primaryKeys$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x40) == 0) {
                this.primaryKeys = (String[])this.tableConfig().getRecordKeyFields().orElse(Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)));
                this.bitmap$0 |= 0x40;
            }
        }
        return this.primaryKeys;
    }

    public String[] primaryKeys() {
        if ((this.bitmap$0 & 0x40) == 0) {
            return this.primaryKeys$lzycompute();
        }
        return this.primaryKeys;
    }

    private java.util.List<String> orderingFields$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x80) == 0) {
                this.orderingFields = this.tableConfig().getOrderingFields();
                this.bitmap$0 |= 0x80;
            }
        }
        return this.orderingFields;
    }

    public java.util.List<String> orderingFields() {
        if ((this.bitmap$0 & 0x80) == 0) {
            return this.orderingFields$lzycompute();
        }
        return this.orderingFields;
    }

    private String[] partitionFields$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x100) == 0) {
                this.partitionFields = (String[])this.tableConfig().getPartitionFields().orElse(Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)));
                this.bitmap$0 |= 0x100;
            }
        }
        return this.partitionFields;
    }

    public String[] partitionFields() {
        if ((this.bitmap$0 & 0x100) == 0) {
            return this.partitionFields$lzycompute();
        }
        return this.partitionFields;
    }

    private boolean isMultipleBaseFileFormatsEnabled$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x200) == 0) {
                this.isMultipleBaseFileFormatsEnabled = this.tableConfig().isMultipleBaseFileFormatsEnabled();
                this.bitmap$0 |= 0x200;
            }
        }
        return this.isMultipleBaseFileFormatsEnabled;
    }

    public boolean isMultipleBaseFileFormatsEnabled() {
        if ((this.bitmap$0 & 0x200) == 0) {
            return this.isMultipleBaseFileFormatsEnabled$lzycompute();
        }
        return this.isMultipleBaseFileFormatsEnabled;
    }

    private StructType tableSchema$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x400) == 0) {
                StructType structType;
                Option<StructType> schemaFromMetaOpt = this.loadTableSchemaByMetaClient();
                if (schemaFromMetaOpt.nonEmpty()) {
                    structType = (StructType)schemaFromMetaOpt.get();
                } else if (this.table().schema().nonEmpty()) {
                    structType = HoodieSqlCommonUtils$.MODULE$.addMetaFields(this.table().schema());
                } else {
                    throw new HoodieAnalysisException(new StringBuilder(33).append(this.catalogTableName()).append(" does not contains schema fields.").toString(), HoodieAnalysisException$.MODULE$.$lessinit$greater$default$2(), HoodieAnalysisException$.MODULE$.$lessinit$greater$default$3());
                }
                this.tableSchema = structType;
                this.bitmap$0 |= 0x400;
            }
        }
        return this.tableSchema;
    }

    public StructType tableSchema() {
        if ((this.bitmap$0 & 0x400) == 0) {
            return this.tableSchema$lzycompute();
        }
        return this.tableSchema;
    }

    private StructType tableSchemaWithoutMetaFields$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x800) == 0) {
                this.tableSchemaWithoutMetaFields = HoodieSqlCommonUtils$.MODULE$.removeMetaFields(this.tableSchema());
                this.bitmap$0 |= 0x800;
            }
        }
        return this.tableSchemaWithoutMetaFields;
    }

    public StructType tableSchemaWithoutMetaFields() {
        if ((this.bitmap$0 & 0x800) == 0) {
            return this.tableSchemaWithoutMetaFields$lzycompute();
        }
        return this.tableSchemaWithoutMetaFields;
    }

    private StructType dataSchema$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x1000) == 0) {
                this.dataSchema = StructType$.MODULE$.apply((Seq)this.tableSchema().filterNot((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)HoodieCatalogTable.$anonfun$dataSchema$1(this, f))));
                this.bitmap$0 |= 0x1000;
            }
        }
        return this.dataSchema;
    }

    public StructType dataSchema() {
        if ((this.bitmap$0 & 0x1000) == 0) {
            return this.dataSchema$lzycompute();
        }
        return this.dataSchema;
    }

    private StructType partitionSchema$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x2000) == 0) {
                this.partitionSchema = StructType$.MODULE$.apply((Seq)this.tableSchema().filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)HoodieCatalogTable.$anonfun$partitionSchema$1(this, f))));
                this.bitmap$0 |= 0x2000;
            }
        }
        return this.partitionSchema;
    }

    public StructType partitionSchema() {
        if ((this.bitmap$0 & 0x2000) == 0) {
            return this.partitionSchema$lzycompute();
        }
        return this.partitionSchema;
    }

    public Seq<String> getPartitionPaths() {
        java.util.List droppedPartitions = TimelineUtils.getDroppedPartitions((HoodieTableMetaClient)this.metaClient(), (org.apache.hudi.common.util.Option)org.apache.hudi.common.util.Option.empty(), (org.apache.hudi.common.util.Option)org.apache.hudi.common.util.Option.empty());
        return (Seq)HoodieSqlCommonUtils$.MODULE$.getAllPartitionPaths(this.spark(), this.table(), this.metaClient()).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)HoodieCatalogTable.$anonfun$getPartitionPaths$1(droppedPartitions, x$3)));
    }

    public boolean isPartitionedTable() {
        return this.table().partitionColumnNames().nonEmpty();
    }

    public void initHoodieTable() {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Init hoodie.properties for ").append(this.table().identifier().unquotedString()).toString());
        Tuple2<StructType, scala.collection.immutable.Map<String, String>> tuple2 = this.parseSchemaAndConfigs();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        StructType finalSchema = (StructType)tuple2._1();
        scala.collection.immutable.Map tableConfigs = (scala.collection.immutable.Map)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)finalSchema, (Object)tableConfigs);
        StructType finalSchema2 = (StructType)tuple22._1();
        scala.collection.immutable.Map tableConfigs2 = (scala.collection.immutable.Map)tuple22._2();
        if (!this.hoodieTableExists()) {
            StructType dataSchema = HoodieSqlCommonUtils$.MODULE$.removeMetaFields(finalSchema2);
            CatalogTable qual$1 = this.table();
            StructType x$1 = finalSchema2;
            TableIdentifier x$2 = qual$1.copy$default$1();
            CatalogTableType x$3 = qual$1.copy$default$2();
            CatalogStorageFormat x$4 = qual$1.copy$default$3();
            Option x$5 = qual$1.copy$default$5();
            Seq x$6 = qual$1.copy$default$6();
            Option x$7 = qual$1.copy$default$7();
            String x$8 = qual$1.copy$default$8();
            long x$9 = qual$1.copy$default$9();
            long x$10 = qual$1.copy$default$10();
            String x$11 = qual$1.copy$default$11();
            scala.collection.immutable.Map x$12 = qual$1.copy$default$12();
            Option x$13 = qual$1.copy$default$13();
            Option x$14 = qual$1.copy$default$14();
            Option x$15 = qual$1.copy$default$15();
            Seq x$16 = qual$1.copy$default$16();
            boolean x$17 = qual$1.copy$default$17();
            boolean x$18 = qual$1.copy$default$18();
            scala.collection.immutable.Map x$19 = qual$1.copy$default$19();
            Option x$20 = qual$1.copy$default$20();
            this.table_$eq(qual$1.copy(x$2, x$3, x$4, x$1, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20));
            TypedProperties properties = TypedProperties.fromMap((java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)tableConfigs2).asJava()));
            String catalogDatabaseName = HoodieSqlCommonUtils$.MODULE$.formatName(this.spark(), (String)this.table().identifier().database().getOrElse((Function0 & Serializable & scala.Serializable)() -> this.spark().sessionState().catalog().getCurrentDatabase()));
            Tuple2 tuple23 = AvroConversionUtils$.MODULE$.getAvroRecordNameAndNamespace(this.table().identifier().table());
            if (tuple23 == null) {
                throw new MatchError((Object)tuple23);
            }
            String recordName = (String)tuple23._1();
            String namespace = (String)tuple23._2();
            Tuple2 tuple24 = new Tuple2((Object)recordName, (Object)namespace);
            String recordName2 = (String)tuple24._1();
            String namespace2 = (String)tuple24._2();
            Schema schema = SchemaConverters$.MODULE$.toAvroType((DataType)dataSchema, false, recordName2, namespace2);
            String partitionColumns = SparkConfigUtils$.MODULE$.containsConfigProperty((scala.collection.immutable.Map<String, String>)tableConfigs2, KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME) ? SparkConfigUtils$.MODULE$.getStringWithAltKeys((Map<String, String>)tableConfigs2, KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME) : (this.table().partitionColumnNames().isEmpty() ? null : this.table().partitionColumnNames().mkString(","));
            HoodieTableMetaClient.newTableBuilder().fromProperties((Properties)properties).setTableVersion(Predef$.MODULE$.Integer2int(Integer.valueOf(SparkConfigUtils$.MODULE$.getStringWithAltKeys((Map<String, String>)tableConfigs2, HoodieWriteConfig.WRITE_TABLE_VERSION)))).setTableFormat(SparkConfigUtils$.MODULE$.getStringWithAltKeys((Map<String, String>)tableConfigs2, HoodieTableConfig.TABLE_FORMAT)).setDatabaseName(catalogDatabaseName).setTableName(this.table().identifier().table()).setTableCreateSchema(schema.toString()).setPartitionFields(partitionColumns).initTable(this.storageConf(), this.tableLocation());
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    private Tuple2<StructType, scala.collection.immutable.Map<String, String>> parseSchemaAndConfigs() {
        globalProps = ((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter((Properties)DFSPropertiesConfiguration.getGlobalProps()).asScala()).toMap(Predef$.MODULE$.$conforms());
        globalTableConfigs = HoodieWriterUtils$.MODULE$.mappingSparkDatasourceConfigsToTableConfigs((scala.collection.immutable.Map<String, String>)globalProps);
        globalSqlOptions = HoodieOptionConfig$.MODULE$.mapHoodieConfigsToSqlOptions(globalTableConfigs);
        sqlOptions = HoodieOptionConfig$.MODULE$.withDefaultSqlOptions((scala.collection.immutable.Map<String, String>)globalSqlOptions.$plus$plus(HoodieOptionConfig$.MODULE$.mapHoodieConfigsToSqlOptions(this.catalogProperties())));
        var9_5 = new Tuple2((Object)this.table().tableType(), (Object)BoxesRunTime.boxToBoolean((boolean)this.hoodieTableExists()));
        if (var9_5 == null) ** GOTO lbl-1000
        var10_6 = (CatalogTableType)var9_5._1();
        var11_7 = var9_5._2$mcZ$sp();
        v0 = CatalogTableType$.MODULE$.EXTERNAL();
        var12_8 = var10_6;
        if (!(v0 != null ? v0.equals(var12_8) == false : var12_8 != null) && var11_7) {
            existingTableConfig = ((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter((Properties)this.tableConfig().getProps()).asScala()).toMap(Predef$.MODULE$.$conforms());
            currentTableConfig = globalTableConfigs.$plus$plus((GenTraversableOnce)existingTableConfig);
            catalogTableProps = HoodieOptionConfig$.MODULE$.mapSqlOptionsToTableConfigs(this.catalogProperties());
            HoodieWriterUtils$.MODULE$.validateTableConfig(this.spark(), catalogTableProps, HoodieWriterUtils$.MODULE$.convertMapToHoodieConfig((scala.collection.immutable.Map<String, String>)existingTableConfig));
            options = this.extraTableConfig(this.hoodieTableExists(), (scala.collection.immutable.Map<String, String>)currentTableConfig, this.extraTableConfig$default$3()).$plus$plus(HoodieOptionConfig$.MODULE$.mapSqlOptionsToTableConfigs(sqlOptions)).$plus$plus((GenTraversableOnce)currentTableConfig);
            v1 = new Tuple2((Object)this.tableSchema(), (Object)options);
        } else if (var9_5 != null && !(var17_13 = var9_5._2$mcZ$sp())) {
            ValidationUtils.checkArgument((boolean)this.table().schema().nonEmpty(), (String)new StringBuilder(33).append("Missing schema for Create Table: ").append(this.catalogTableName()).toString());
            schema = this.table().schema();
            options = this.extraTableConfig(false, globalTableConfigs, sqlOptions).$plus$plus(HoodieOptionConfig$.MODULE$.mapSqlOptionsToTableConfigs(sqlOptions));
            v1 = new Tuple2((Object)HoodieSqlCommonUtils$.MODULE$.addMetaFields(schema), (Object)options);
        } else {
            if (var9_5 != null) {
                var20_16 = (CatalogTableType)var9_5._1();
                var21_17 = var9_5._2$mcZ$sp();
                v2 = CatalogTableType$.MODULE$.MANAGED();
                var22_18 = var20_16;
                if (!(v2 != null ? v2.equals(var22_18) == false : var22_18 != null) && var21_17) {
                    throw new HoodieAnalysisException(new StringBuilder(81).append("Can not create the managed table('").append(this.catalogTableName()).append("')").append(". The associated location('").append(this.tableLocation()).append("') already exists.").toString(), HoodieAnalysisException$.MODULE$.$lessinit$greater$default$2(), HoodieAnalysisException$.MODULE$.$lessinit$greater$default$3());
                }
            }
            throw new MatchError((Object)var9_5);
        }
        var8_19 = v1;
        if (var8_19 == null) {
            throw new MatchError((Object)var8_19);
        }
        finalSchema = (StructType)var8_19._1();
        tableConfigs = (scala.collection.immutable.Map)var8_19._2();
        var7_22 = new Tuple2((Object)finalSchema, (Object)tableConfigs);
        finalSchema = (StructType)var7_22._1();
        tableConfigs = (scala.collection.immutable.Map)var7_22._2();
        HoodieOptionConfig$.MODULE$.validateTable(this.spark(), finalSchema, HoodieOptionConfig$.MODULE$.mapHoodieConfigsToSqlOptions((scala.collection.immutable.Map<String, String>)tableConfigs));
        resolver = this.spark().sessionState().conf().resolver();
        dataSchema = (Seq)finalSchema.filterNot((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$parseSchemaAndConfigs$1$adapted(org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable scala.Function2 org.apache.spark.sql.types.StructField ), (Lorg/apache/spark/sql/types/StructField;)Ljava/lang/Object;)((HoodieCatalogTable)this, (Function2)resolver));
        this.verifyDataSchema(this.table().identifier(), this.table().tableType(), (Seq<StructField>)dataSchema);
        return new Tuple2((Object)finalSchema, (Object)tableConfigs);
    }

    private scala.collection.immutable.Map<String, String> extraTableConfig(boolean tableExists, scala.collection.immutable.Map<String, String> originTableConfig, scala.collection.immutable.Map<String, String> sqlOptions) {
        scala.collection.mutable.Map extraConfig = Map$.MODULE$.empty();
        if (tableExists) {
            Seq<String> allPartitionPaths = this.getPartitionPaths();
            if (originTableConfig.contains((Object)HoodieTableConfig.HIVE_STYLE_PARTITIONING_ENABLE.key())) {
                extraConfig.update((Object)HoodieTableConfig.HIVE_STYLE_PARTITIONING_ENABLE.key(), originTableConfig.apply((Object)HoodieTableConfig.HIVE_STYLE_PARTITIONING_ENABLE.key()));
            } else {
                extraConfig.update((Object)HoodieTableConfig.HIVE_STYLE_PARTITIONING_ENABLE.key(), (Object)String.valueOf(HoodieSqlCommonUtils$.MODULE$.isHiveStyledPartitioning(allPartitionPaths, this.table())));
            }
            if (originTableConfig.contains((Object)HoodieTableConfig.URL_ENCODE_PARTITIONING.key())) {
                extraConfig.update((Object)HoodieTableConfig.URL_ENCODE_PARTITIONING.key(), originTableConfig.apply((Object)HoodieTableConfig.URL_ENCODE_PARTITIONING.key()));
            } else {
                extraConfig.update((Object)HoodieTableConfig.URL_ENCODE_PARTITIONING.key(), (Object)String.valueOf(HoodieSqlCommonUtils$.MODULE$.isUrlEncodeEnabled(allPartitionPaths, this.table())));
            }
        } else {
            extraConfig.update((Object)HoodieTableConfig.HIVE_STYLE_PARTITIONING_ENABLE.key(), (Object)"true");
            extraConfig.update((Object)HoodieTableConfig.URL_ENCODE_PARTITIONING.key(), HoodieTableConfig.URL_ENCODE_PARTITIONING.defaultValue());
        }
        if (originTableConfig.contains((Object)HoodieTableConfig.KEY_GENERATOR_CLASS_NAME.key())) {
            extraConfig.update((Object)HoodieTableConfig.KEY_GENERATOR_CLASS_NAME.key(), (Object)HoodieSparkKeyGeneratorFactory.convertToSparkKeyGenerator((String)((String)originTableConfig.apply((Object)HoodieTableConfig.KEY_GENERATOR_CLASS_NAME.key()))));
        } else if (originTableConfig.contains((Object)HoodieTableConfig.KEY_GENERATOR_TYPE.key())) {
            extraConfig.update((Object)HoodieTableConfig.KEY_GENERATOR_CLASS_NAME.key(), (Object)HoodieSparkKeyGeneratorFactory.convertToSparkKeyGenerator((String)KeyGeneratorType.valueOf((String)((String)originTableConfig.apply((Object)HoodieTableConfig.KEY_GENERATOR_TYPE.key()))).getClassName()));
        } else {
            String primaryKeys = this.table().properties().getOrElse((Object)HoodieOptionConfig$.MODULE$.SQL_KEY_TABLE_PRIMARY_KEY().sqlKeyName(), (Function0 & Serializable & scala.Serializable)() -> this.table().storage().properties().get((Object)HoodieOptionConfig$.MODULE$.SQL_KEY_TABLE_PRIMARY_KEY().sqlKeyName())).toString();
            Option partitionFieldsOpt = Option$.MODULE$.apply((Object)SparkConfigUtils$.MODULE$.getStringWithAltKeys((Map<String, String>)originTableConfig, HoodieTableConfig.PARTITION_FIELDS)).orElse((Function0 & Serializable & scala.Serializable)() -> sqlOptions.get((Object)KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key()));
            String partitions = (String)partitionFieldsOpt.getOrElse((Function0 & Serializable & scala.Serializable)() -> this.table().partitionColumnNames().mkString(","));
            extraConfig.update((Object)HoodieTableConfig.KEY_GENERATOR_CLASS_NAME.key(), (Object)DataSourceOptionsHelper$.MODULE$.inferKeyGenClazz(primaryKeys, partitions));
        }
        return extraConfig.toMap(Predef$.MODULE$.$conforms());
    }

    private scala.collection.immutable.Map<String, String> extraTableConfig$default$2() {
        return Predef$.MODULE$.Map().empty();
    }

    private scala.collection.immutable.Map<String, String> extraTableConfig$default$3() {
        return Predef$.MODULE$.Map().empty();
    }

    private Option<StructType> loadTableSchemaByMetaClient() {
        None$ none$;
        Function2 resolver = this.spark().sessionState().conf().resolver();
        try {
            none$ = HoodieSqlCommonUtils$.MODULE$.getTableSqlSchema(this.metaClient(), true).map((Function1 & Serializable & scala.Serializable)originSchema -> {
                Tuple2 tuple2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])originSchema.fields())).map((Function1 & Serializable & scala.Serializable)f -> {
                    boolean x$1 = true;
                    String x$2 = f.copy$default$1();
                    DataType x$3 = f.copy$default$2();
                    Metadata x$4 = f.copy$default$4();
                    StructField nullableField = f.copy(x$2, x$3, x$1, x$4);
                    Option<StructField> catalogField = HoodieSqlCommonUtils$.MODULE$.findColumnByName(this.table().schema(), nullableField.name(), (Function2<String, String, Object>)resolver);
                    if (catalogField.isDefined()) {
                        return (StructField)((StructField)catalogField.get()).getComment().map((Function1 & Serializable & scala.Serializable)comment -> nullableField.withComment(comment)).getOrElse((Function0 & Serializable & scala.Serializable)() -> nullableField);
                    }
                    return nullableField;
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))))).partition((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)HoodieCatalogTable.$anonfun$loadTableSchemaByMetaClient$5(this, f)));
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                StructField[] partFields = (StructField[])tuple2._1();
                StructField[] dataFields = (StructField[])tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)partFields, (Object)dataFields);
                StructField[] partFields2 = (StructField[])tuple22._1();
                StructField[] dataFields2 = (StructField[])tuple22._2();
                scala.collection.immutable.Map nameToField = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partFields2)).map((Function1 & Serializable & scala.Serializable)field -> new Tuple2((Object)field.name(), field), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
                Seq orderedPartFields = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.partitionFields())).map((Function1 & Serializable & scala.Serializable)x$9 -> (StructField)nameToField.apply(x$9), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))))).toSeq();
                return new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dataFields2)).$plus$plus((GenTraversableOnce)orderedPartFields, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
            });
        }
        catch (Throwable cause) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to load table schema from meta client.", cause);
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private void verifyDataSchema(TableIdentifier tableIdentifier, CatalogTableType tableType, Seq<StructField> dataSchema) {
        CatalogTableType catalogTableType = tableType;
        CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.VIEW();
        if (catalogTableType == null ? catalogTableType2 != null : !catalogTableType.equals(catalogTableType2)) {
            Seq invalidChars = (Seq)new .colon.colon((Object)",", (List)new .colon.colon((Object)":", (List)new .colon.colon((Object)";", (List)Nil$.MODULE$)));
            dataSchema.foreach((Function1 & Serializable & scala.Serializable)f -> {
                HoodieCatalogTable.$anonfun$verifyDataSchema$4(tableIdentifier, invalidChars, f);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public static final /* synthetic */ String $anonfun$new$1(String x$1) {
        return x$1.toLowerCase(Locale.ROOT);
    }

    public static final /* synthetic */ String $anonfun$new$2(String x$2) {
        return x$2.toLowerCase(Locale.ROOT);
    }

    public static final /* synthetic */ boolean $anonfun$dataSchema$1(HoodieCatalogTable $this, StructField f) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.partitionFields())).contains((Object)f.name());
    }

    public static final /* synthetic */ boolean $anonfun$partitionSchema$1(HoodieCatalogTable $this, StructField f) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.partitionFields())).contains((Object)f.name());
    }

    public static final /* synthetic */ boolean $anonfun$getPartitionPaths$1(java.util.List droppedPartitions$1, String x$3) {
        return !droppedPartitions$1.contains(x$3);
    }

    public static final /* synthetic */ boolean $anonfun$parseSchemaAndConfigs$2(Function2 resolver$1, StructField f$1, String x$7) {
        return BoxesRunTime.unboxToBoolean((Object)resolver$1.apply((Object)x$7, (Object)f$1.name()));
    }

    public static final /* synthetic */ boolean $anonfun$parseSchemaAndConfigs$1(HoodieCatalogTable $this, Function2 resolver$1, StructField f) {
        return $this.table().partitionColumnNames().exists((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)HoodieCatalogTable.$anonfun$parseSchemaAndConfigs$2(resolver$1, f, x$7)));
    }

    public static final /* synthetic */ boolean $anonfun$loadTableSchemaByMetaClient$5(HoodieCatalogTable $this, StructField f) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.partitionFields())).contains((Object)f.name());
    }

    public static final /* synthetic */ boolean $anonfun$verifyDataSchema$2(StructField f$2, CharSequence x$1) {
        return f$2.name().contains(x$1);
    }

    public static final /* synthetic */ void $anonfun$verifyDataSchema$1(Seq invalidChars$1, TableIdentifier tableIdentifier$1, StructField f) {
        DataType dataType = f.dataType();
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            HoodieCatalogTable.verifyNestedColumnNames$1(structType, invalidChars$1, tableIdentifier$1);
            return;
        }
        if (invalidChars$1.exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)HoodieCatalogTable.$anonfun$verifyDataSchema$2(f, x$1)))) {
            String invalidCharsString = ((TraversableOnce)invalidChars$1.map((Function1 & Serializable & scala.Serializable)c -> new StringBuilder(2).append("'").append((String)c).append("'").toString(), Seq$.MODULE$.canBuildFrom())).mkString(", ");
            String errMsg = new StringBuilder(123).append("Cannot create a table having a nested column whose name contains ").append("invalid characters (").append(invalidCharsString).append(") in Hive metastore. Table: ").append(tableIdentifier$1).append("; ").append("Column: ").append(f.name()).toString();
            throw new HoodieAnalysisException(errMsg, HoodieAnalysisException$.MODULE$.$lessinit$greater$default$2(), HoodieAnalysisException$.MODULE$.$lessinit$greater$default$3());
        }
    }

    private static final void verifyNestedColumnNames$1(StructType schema, Seq invalidChars$1, TableIdentifier tableIdentifier$1) {
        schema.foreach((Function1 & Serializable & scala.Serializable)f -> {
            HoodieCatalogTable.$anonfun$verifyDataSchema$1(invalidChars$1, tableIdentifier$1, f);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$verifyDataSchema$4(TableIdentifier tableIdentifier$1, Seq invalidChars$1, StructField f) {
        DataType dataType = f.dataType();
        if (f.name().contains(",")) {
            throw new HoodieAnalysisException(new StringBuilder(101).append("Cannot create a table having a column whose name ").append("contains commas in Hive metastore. Table: ").append(tableIdentifier$1).append("; Column: ").append(f.name()).toString(), HoodieAnalysisException$.MODULE$.$lessinit$greater$default$2(), HoodieAnalysisException$.MODULE$.$lessinit$greater$default$3());
        }
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            HoodieCatalogTable.verifyNestedColumnNames$1(structType, invalidChars$1, tableIdentifier$1);
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    public HoodieCatalogTable(SparkSession spark, CatalogTable table) {
        this.spark = spark;
        this.table = table;
        super();
        Logging.$init$((Logging)this);
        v0 = this.table().provider().map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$new$1(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)()).orNull(Predef$.MODULE$.$conforms());
        var3_3 = "hudi";
        if (!(v0 == null ? var3_3 != null : v0.equals(var3_3) == false)) ** GOTO lbl-1000
        v1 = this.table().provider().map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$new$2(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)()).orNull(Predef$.MODULE$.$conforms());
        var4_4 = "org.apache.hudi";
        if (!(v1 != null ? v1.equals(var4_4) == false : var4_4 != null)) lbl-1000:
        // 2 sources

        {
            v2 = true;
        } else {
            v2 = false;
        }
        ValidationUtils.checkArgument((boolean)v2, (String)new StringBuilder(21).append(" ").append(this.table().qualifiedName()).append(" is not a Hudi table").toString());
        this.storageConf = HadoopFSUtils.getStorageConfWithCopy((Configuration)spark.sessionState().newHadoopConf());
        this.catalogTableName = this.table().qualifiedName();
        this.catalogProperties = HoodieOptionConfig$.MODULE$.makeOptionsCaseInsensitive((scala.collection.immutable.Map<String, String>)this.table().storage().properties().$plus$plus((GenTraversableOnce)this.table().properties()));
        this.tableLocation = HoodieSqlCommonUtils$.MODULE$.getTableLocation(this.table(), spark);
        this.hoodieTableExists = HoodieSqlCommonUtils$.MODULE$.tableExistsInPath(this.tableLocation(), HoodieStorageUtils.getStorage((String)this.tableLocation(), this.storageConf()));
    }

    public static final /* synthetic */ Object $anonfun$parseSchemaAndConfigs$1$adapted(HoodieCatalogTable $this, Function2 resolver$1, StructField f) {
        return BoxesRunTime.boxToBoolean((boolean)HoodieCatalogTable.$anonfun$parseSchemaAndConfigs$1($this, resolver$1, f));
    }
}

