/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.orc;

import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.orc.OrcConf;
import org.apache.orc.OrcFile;
import org.apache.orc.TypeDescription;
import org.apache.orc.mapreduce.OrcInputFormat;
import org.apache.parquet.schema.MessageType;
import org.apache.spark.TaskContext$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.JoinedRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.codegen.GenerateUnsafeProjection$;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.RecordReaderIterator;
import org.apache.spark.sql.execution.datasources.SparkColumnarFileReader;
import org.apache.spark.sql.execution.datasources.orc.OrcColumnarBatchReader;
import org.apache.spark.sql.execution.datasources.orc.OrcDeserializer;
import org.apache.spark.sql.execution.datasources.orc.OrcFilters$;
import org.apache.spark.sql.execution.datasources.orc.OrcUtils$;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.Utils$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005Ec!\u0002\u0006\f\u0003\u0003Q\u0002\u0002C\u0013\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0014\t\u0011%\u0002!\u0011!Q\u0001\n)B\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006IA\n\u0005\tc\u0001\u0011\t\u0011)A\u0005M!)!\u0007\u0001C\u0001g!)!\b\u0001C!w!9\u0011\u0011\u0005\u0001\u0007\u0002\u0005\r\u0002bBA\u001a\u0001\u0019\u0005\u0011Q\u0007\u0005\b\u0003{\u0001a\u0011AA \u0005I\u0019\u0006/\u0019:l\u001fJ\u001c'+Z1eKJ\u0014\u0015m]3\u000b\u00051i\u0011aA8sG*\u0011abD\u0001\fI\u0006$\u0018m]8ve\u000e,7O\u0003\u0002\u0011#\u0005IQ\r_3dkRLwN\u001c\u0006\u0003%M\t1a]9m\u0015\t!R#A\u0003ta\u0006\u00148N\u0003\u0002\u0017/\u00051\u0011\r]1dQ\u0016T\u0011\u0001G\u0001\u0004_J<7\u0001A\n\u0004\u0001m\t\u0003C\u0001\u000f \u001b\u0005i\"\"\u0001\u0010\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0001j\"AB!osJ+g\r\u0005\u0002#G5\tQ\"\u0003\u0002%\u001b\t92\u000b]1sW\u000e{G.^7oCJ4\u0015\u000e\\3SK\u0006$WM]\u0001\u0017K:\f'\r\\3WK\u000e$xN]5{K\u0012\u0014V-\u00193feB\u0011AdJ\u0005\u0003Qu\u0011qAQ8pY\u0016\fg.\u0001\u0006eCR\f7k\u00195f[\u0006\u0004\"a\u000b\u0018\u000e\u00031R!!L\t\u0002\u000bQL\b/Z:\n\u0005=b#AC*ueV\u001cG\u000fV=qK\u0006\trN]2GS2$XM\u001d)vg\"$un\u001e8\u0002\u001f%\u001c8)Y:f'\u0016t7/\u001b;jm\u0016\fa\u0001P5oSRtD#\u0002\u001b7oaJ\u0004CA\u001b\u0001\u001b\u0005Y\u0001\"B\u0013\u0006\u0001\u00041\u0003\"B\u0015\u0006\u0001\u0004Q\u0003\"\u0002\u0019\u0006\u0001\u00041\u0003\"B\u0019\u0006\u0001\u00041\u0013\u0001\u0002:fC\u0012$\u0012\u0002\u0010(T+^[g/!\u0004\u0011\u0007u*\u0005J\u0004\u0002?\u0007:\u0011qHQ\u0007\u0002\u0001*\u0011\u0011)G\u0001\u0007yI|w\u000e\u001e \n\u0003yI!\u0001R\u000f\u0002\u000fA\f7m[1hK&\u0011ai\u0012\u0002\t\u0013R,'/\u0019;pe*\u0011A)\b\t\u0003\u00132k\u0011A\u0013\u0006\u0003\u0017F\t\u0001bY1uC2L8\u000f^\u0005\u0003\u001b*\u00131\"\u00138uKJt\u0017\r\u001c*po\")qJ\u0002a\u0001!\u0006!a-\u001b7f!\t\u0011\u0013+\u0003\u0002S\u001b\ty\u0001+\u0019:uSRLwN\\3e\r&dW\rC\u0003U\r\u0001\u0007!&\u0001\bsKF,\u0018N]3e'\u000eDW-\\1\t\u000bY3\u0001\u0019\u0001\u0016\u0002\u001fA\f'\u000f^5uS>t7k\u00195f[\u0006DQ\u0001\u0017\u0004A\u0002e\u000b\u0011#\u001b8uKJt\u0017\r\\*dQ\u0016l\u0017m\u00149u!\rQ\u0016mY\u0007\u00027*\u0011A,X\u0001\u0005kRLGN\u0003\u0002_?\u000611m\\7n_:T!\u0001Y\u000b\u0002\t!,H-[\u0005\u0003En\u0013aa\u00149uS>t\u0007C\u00013j\u001b\u0005)'B\u00014h\u0003\u0019\u00198\r[3nC*\u0011\u0001nX\u0001\tS:$XM\u001d8bY&\u0011!.\u001a\u0002\u000f\u0013:$XM\u001d8bYN\u001b\u0007.Z7b\u0011\u0015ag\u00011\u0001n\u0003\u001d1\u0017\u000e\u001c;feN\u00042!\u00108q\u0013\tywIA\u0002TKF\u0004\"!\u001d;\u000e\u0003IT!a]\t\u0002\u000fM|WO]2fg&\u0011QO\u001d\u0002\u0007\r&dG/\u001a:\t\u000b]4\u0001\u0019\u0001=\u0002\u0017M$xN]1hK\u000e{gN\u001a\t\u0004srtX\"\u0001>\u000b\u0005m|\u0016aB:u_J\fw-Z\u0005\u0003{j\u0014Ac\u0015;pe\u0006<WmQ8oM&<WO]1uS>t\u0007cA@\u0002\n5\u0011\u0011\u0011\u0001\u0006\u0005\u0003\u0007\t)!\u0001\u0003d_:4'bAA\u0004+\u00051\u0001.\u00193p_BLA!a\u0003\u0002\u0002\ti1i\u001c8gS\u001e,(/\u0019;j_:D\u0011\"a\u0004\u0007!\u0003\u0005\r!!\u0005\u0002\u001dQ\f'\r\\3TG\",W.Y(qiB!!,YA\n!\u0011\t)\"!\b\u000e\u0005\u0005]!b\u00014\u0002\u001a)\u0019\u00111D\u000b\u0002\u000fA\f'/];fi&!\u0011qDA\f\u0005-iUm]:bO\u0016$\u0016\u0010]3\u0002+A\f'\u000f^5uS>tW\r\u001a$jY\u0016$v\u000eU1uQR!\u0011QEA\u0019!\u0011\t9#!\f\u000e\u0005\u0005%\"\u0002BA\u0016\u0003\u000b\t!AZ:\n\t\u0005=\u0012\u0011\u0006\u0002\u0005!\u0006$\b\u000eC\u0003P\u000f\u0001\u0007\u0001+A\u0006ck&dGMU3bI\u0016\u0014HCAA\u001c!\r)\u0014\u0011H\u0005\u0004\u0003wY!AF(sG\u000e{G.^7oCJ\u0014\u0015\r^2i%\u0016\fG-\u001a:\u0002-M$(/^2u)f\u0004X\rV8BiR\u0014\u0018NY;uKN$B!!\u0011\u0002PA!QH\\A\"!\u0011\t)%a\u0013\u000e\u0005\u0005\u001d#bAA%\u0015\u0006YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0013\u0011\ti%a\u0012\u0003\u0013\u0005#HO]5ckR,\u0007\"\u00024\n\u0001\u0004Q\u0003")
public abstract class SparkOrcReaderBase
implements SparkColumnarFileReader {
    private final boolean enableVectorizedReader;
    private final StructType dataSchema;
    private final boolean orcFilterPushDown;
    private final boolean isCaseSensitive;

    public org.apache.hudi.common.util.Option<MessageType> read$default$7() {
        return SparkColumnarFileReader.read$default$7$((SparkColumnarFileReader)this);
    }

    public Iterator<InternalRow> read(PartitionedFile file, StructType requiredSchema, StructType partitionSchema, org.apache.hudi.common.util.Option<InternalSchema> internalSchemaOpt, Seq<Filter> filters, StorageConfiguration<Configuration> storageConf, org.apache.hudi.common.util.Option<MessageType> tableSchemaOpt) {
        Tuple2 tuple2;
        StructType resultSchema = new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])requiredSchema.fields())).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionSchema.fields())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
        Configuration conf = (Configuration)storageConf.unwrap();
        Path filePath = this.partitionedFileToPath(file);
        FileSystem fs = filePath.getFileSystem(conf);
        OrcFile.ReaderOptions readerOptions = OrcFile.readerOptions((Configuration)conf).filesystem(fs);
        TypeDescription orcSchema = (TypeDescription)Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> OrcFile.createReader((Path)filePath, (OrcFile.ReaderOptions)readerOptions), (Function1 & Serializable & scala.Serializable)x$1 -> x$1.getSchema());
        Option resultedColPruneInfo = OrcUtils$.MODULE$.requestedColumnIds(this.isCaseSensitive, this.dataSchema, requiredSchema, orcSchema, conf);
        if (resultedColPruneInfo.isEmpty()) {
            return package$.MODULE$.Iterator().empty();
        }
        if (this.orcFilterPushDown && filters.nonEmpty()) {
            StructType fileSchema = OrcUtils$.MODULE$.toCatalystSchema(orcSchema);
            OrcFilters$.MODULE$.createFilter(fileSchema, filters).foreach((Function1 & Serializable & scala.Serializable)f -> {
                SparkOrcReaderBase.$anonfun$read$3(conf, fileSchema, f);
                return BoxedUnit.UNIT;
            });
        }
        if ((tuple2 = (Tuple2)resultedColPruneInfo.get()) == null) {
            throw new MatchError((Object)tuple2);
        }
        int[] requestedColIds = (int[])tuple2._1();
        boolean canPruneCols = tuple2._2$mcZ$sp();
        Tuple2 tuple22 = new Tuple2((Object)requestedColIds, (Object)BoxesRunTime.boxToBoolean((boolean)canPruneCols));
        int[] requestedColIds2 = (int[])tuple22._1();
        boolean canPruneCols2 = tuple22._2$mcZ$sp();
        String resultSchemaString = OrcUtils$.MODULE$.orcResultSchemaString(canPruneCols2, this.dataSchema, resultSchema, partitionSchema, conf);
        Predef$.MODULE$.assert(requestedColIds2.length == requiredSchema.length(), (Function0 & Serializable & scala.Serializable)() -> "[BUG] requested column IDs do not match required schema");
        Configuration taskConf = new Configuration(conf);
        String includeColumns = new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(requestedColIds2)).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$3 -> x$3 != -1))).sorted((Ordering)Ordering.Int$.MODULE$))).mkString(",");
        taskConf.set(OrcConf.INCLUDE_COLUMNS.getAttribute(), includeColumns);
        FileSplit fileSplit = new FileSplit(filePath, file.start(), file.length(), (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)));
        TaskAttemptID attemptId = new TaskAttemptID(new TaskID(new JobID(), TaskType.MAP, 0), 0);
        TaskAttemptContextImpl taskAttemptContext = new TaskAttemptContextImpl(taskConf, attemptId);
        if (this.enableVectorizedReader) {
            OrcColumnarBatchReader batchReader = this.buildReader();
            RecordReaderIterator iter = new RecordReaderIterator((RecordReader)batchReader);
            Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get()).foreach((Function1 & Serializable & scala.Serializable)x$4 -> x$4.addTaskCompletionListener((Function1 & Serializable & scala.Serializable)x$5 -> {
                iter.close();
                return BoxedUnit.UNIT;
            }));
            int[] requestedDataColIds = (int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(requestedColIds2)).$plus$plus((GenTraversableOnce)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])Array$.MODULE$.fill(partitionSchema.length(), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> -1, ClassTag$.MODULE$.Int()))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
            int[] requestedPartitionColIds = (int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])Array$.MODULE$.fill(requiredSchema.length(), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> -1, ClassTag$.MODULE$.Int()))).$plus$plus((GenTraversableOnce)package$.MODULE$.Range().apply(0, partitionSchema.length()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
            batchReader.initialize((InputSplit)fileSplit, (TaskAttemptContext)taskAttemptContext);
            batchReader.initBatch(TypeDescription.fromString((String)resultSchemaString), resultSchema.fields(), requestedDataColIds, requestedPartitionColIds, file.partitionValues());
            return iter;
        }
        RecordReader orcRecordReader = new OrcInputFormat().createRecordReader((InputSplit)fileSplit, (TaskAttemptContext)taskAttemptContext);
        RecordReaderIterator iter = new RecordReaderIterator(orcRecordReader);
        Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get()).foreach((Function1 & Serializable & scala.Serializable)x$6 -> x$6.addTaskCompletionListener((Function1 & Serializable & scala.Serializable)x$7 -> {
            iter.close();
            return BoxedUnit.UNIT;
        }));
        Seq fullSchema = (Seq)this.structTypeToAttributes(requiredSchema).$plus$plus(this.structTypeToAttributes(partitionSchema), Seq$.MODULE$.canBuildFrom());
        UnsafeProjection unsafeProjection = (UnsafeProjection)GenerateUnsafeProjection$.MODULE$.generate((Object)fullSchema, fullSchema);
        OrcDeserializer deserializer = new OrcDeserializer(requiredSchema, requestedColIds2);
        if (partitionSchema.length() == 0) {
            return iter.map((Function1 & Serializable & scala.Serializable)value -> unsafeProjection.apply(deserializer.deserialize(value)));
        }
        JoinedRow joinedRow = new JoinedRow();
        return iter.map((Function1 & Serializable & scala.Serializable)value -> unsafeProjection.apply((InternalRow)joinedRow.apply(deserializer.deserialize(value), file.partitionValues())));
    }

    public abstract Path partitionedFileToPath(PartitionedFile var1);

    public abstract OrcColumnarBatchReader buildReader();

    public abstract Seq<Attribute> structTypeToAttributes(StructType var1);

    public static final /* synthetic */ void $anonfun$read$3(Configuration conf$1, StructType fileSchema$1, SearchArgument f) {
        OrcInputFormat.setSearchArgument((Configuration)conf$1, (SearchArgument)f, (String[])fileSchema$1.fieldNames());
    }

    public SparkOrcReaderBase(boolean enableVectorizedReader, StructType dataSchema, boolean orcFilterPushDown, boolean isCaseSensitive) {
        this.enableVectorizedReader = enableVectorizedReader;
        this.dataSchema = dataSchema;
        this.orcFilterPushDown = orcFilterPushDown;
        this.isCaseSensitive = isCaseSensitive;
    }
}

