/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.HashSet;
import java.util.Map;
import java.util.function.UnaryOperator;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hudi.AvroConversionUtils$;
import org.apache.hudi.HoodieFileIndex$;
import org.apache.hudi.HoodiePartitionCDCFileGroupMapping;
import org.apache.hudi.HoodiePartitionFileSliceMapping;
import org.apache.hudi.HoodieSparkUtils$;
import org.apache.hudi.HoodieTableSchema;
import org.apache.hudi.SparkAdapterSupport;
import org.apache.hudi.SparkFileFormatInternalRowReaderContext;
import org.apache.hudi.avro.AvroSchemaUtils;
import org.apache.hudi.cdc.CDCFileGroupIterator;
import org.apache.hudi.cdc.CDCRelation$;
import org.apache.hudi.cdc.HoodieCDCFileGroupSplit;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.config.HoodieMemoryConfig;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.HoodieReaderContext;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.BaseFile;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.ParquetTableSchemaResolver;
import org.apache.hudi.common.table.cdc.HoodieCDCFileSplit;
import org.apache.hudi.common.table.read.HoodieFileGroupReader;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.data.CloseableIteratorListener;
import org.apache.hudi.exception.HoodieNotSupportedException;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.io.IOUtils;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.hadoop.HadoopStorageConfiguration;
import org.apache.parquet.schema.AvroSchemaRepair;
import org.apache.parquet.schema.MessageType;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.HoodieCatalystExpressionUtils$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.expressions.JoinedRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.execution.datasources.HoodieSparkPartitionedFileUtils;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.SparkColumnarFileReader;
import org.apache.spark.sql.execution.datasources.orc.OrcUtils$;
import org.apache.spark.sql.execution.datasources.parquet.HoodieFormatTrait;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat;
import org.apache.spark.sql.execution.datasources.parquet.ParquetUtils$;
import org.apache.spark.sql.execution.vectorized.OffHeapColumnVector;
import org.apache.spark.sql.execution.vectorized.OnHeapColumnVector;
import org.apache.spark.sql.hudi.MultipleColumnarFileFormatReader;
import org.apache.spark.sql.hudi.SparkAdapter;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import org.apache.spark.sql.vectorized.ColumnarBatchUtils;
import org.apache.spark.util.SerializableConfiguration;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\r%e\u0001\u0002\u00180\u0001yB\u0001\u0002\u0017\u0001\u0003\u0002\u0003\u0006I!\u0017\u0005\tI\u0002\u0011\t\u0011)A\u0005K\"A\u0001\u000e\u0001B\u0001B\u0003%\u0011\f\u0003\u0005j\u0001\t\u0005\t\u0015!\u0003Z\u0011!Q\u0007A!A!\u0002\u0013Y\u0007\u0002\u0003;\u0001\u0005\u0003\u0005\u000b\u0011B;\t\u0011a\u0004!\u0011!Q\u0001\nUD\u0001\"\u001f\u0001\u0003\u0002\u0003\u0006I!\u001e\u0005\tu\u0002\u0011\t\u0011)A\u00053\"A1\u0010\u0001B\u0001B\u0003%Q\u000f\u0003\u0005}\u0001\t\u0005\t\u0015!\u0003~\u0011%\tI\u0001\u0001B\u0001B\u0003%Q\u000f\u0003\u0006\u0002\f\u0001\u0011\t\u0011)A\u0005\u0003\u001bAq!!\b\u0001\t\u0003\ty\u0002\u0003\u0006\u0002>\u0001A)\u0019!C\u0005\u0003\u007fA!\"!\u0014\u0001\u0011\u000b\u0007I\u0011BA(\u0011)\tY\u0007\u0001EC\u0002\u0013%\u0011Q\u000e\u0005\u000b\u0003_\u0002\u0001R1A\u0005\n\u00055\u0004bBA9\u0001\u0011\u0005\u00131\u000f\u0005\b\u0003k\u0002A\u0011IA:\u0011\u001d\t9\b\u0001C\u0001\u0003sB\u0011\"a\u001f\u0001\u0005\u0004%I!! \t\u0011\u00055\u0005\u0001)A\u0005\u0003\u007fB\u0011\"a$\u0001\u0001\u0004%I!!\u001c\t\u0013\u0005E\u0005\u00011A\u0005\n\u0005M\u0005bBAP\u0001\u0001\u0006K!\u001e\u0005\n\u0003C\u0003\u0001\u0019!C\u0005\u0003[B\u0011\"a)\u0001\u0001\u0004%I!!*\t\u000f\u0005%\u0006\u0001)Q\u0005k\"9\u00111\u0016\u0001\u0005B\u00055\u0006bBAe\u0001\u0011\u0005\u00131\u001a\u0005\u000b\u0003O\u0004\u0001R1A\u0005\n\u0005%\bbBA}\u0001\u0011\u0005\u00131 \u0005\b\u0005;\u0001A\u0011\tB\u0010\u0011\u001d\u0011\t\u0007\u0001C\u0005\u0005GBqA!\u001f\u0001\t\u0013\u0011Y\bC\u0004\u0003\f\u0002!IA!$\t\u000f\t\r\u0007\u0001\"\u0003\u0003F\"9!Q\u001f\u0001\u0005\n\t]\bbBB\u0001\u0001\u0011%11\u0001\u0005\b\u0007'\u0001A\u0011BB\u000b\u0011\u001d\u0019)\u0004\u0001C\u0005\u0007oAqaa\u0012\u0001\t\u0013\u0019I\u0005C\u0004\u0004T\u0001!\te!\u0016\t\u000f\r%\u0004\u0001\"\u0011\u0004l\t!\u0003j\\8eS\u00164\u0015\u000e\\3He>,\bOU3bI\u0016\u0014()Y:fI\u001aKG.\u001a$pe6\fGO\u0003\u00021c\u00059\u0001/\u0019:rk\u0016$(B\u0001\u001a4\u0003-!\u0017\r^1t_V\u00148-Z:\u000b\u0005Q*\u0014!C3yK\u000e,H/[8o\u0015\t1t'A\u0002tc2T!\u0001O\u001d\u0002\u000bM\u0004\u0018M]6\u000b\u0005iZ\u0014AB1qC\u000eDWMC\u0001=\u0003\ry'oZ\u0002\u0001'\u0019\u0001qhQ%M%B\u0011\u0001)Q\u0007\u0002_%\u0011!i\f\u0002\u0012!\u0006\u0014\u0018/^3u\r&dWMR8s[\u0006$\bC\u0001#H\u001b\u0005)%B\u0001$:\u0003\u0011AW\u000fZ5\n\u0005!+%aE*qCJ\\\u0017\tZ1qi\u0016\u00148+\u001e9q_J$\bC\u0001!K\u0013\tYuFA\tI_>$\u0017.\u001a$pe6\fG\u000f\u0016:bSR\u0004\"!\u0014)\u000e\u00039S!aT\u001c\u0002\u0011%tG/\u001a:oC2L!!\u0015(\u0003\u000f1{wmZ5oOB\u00111KV\u0007\u0002)*\tQ+A\u0003tG\u0006d\u0017-\u0003\u0002X)\na1+\u001a:jC2L'0\u00192mK\u0006IA/\u00192mKB\u000bG\u000f\u001b\t\u00035\u0006t!aW0\u0011\u0005q#V\"A/\u000b\u0005yk\u0014A\u0002\u001fs_>$h(\u0003\u0002a)\u00061\u0001K]3eK\u001aL!AY2\u0003\rM#(/\u001b8h\u0015\t\u0001G+A\u0006uC\ndWmU2iK6\f\u0007C\u0001#g\u0013\t9WIA\tI_>$\u0017.\u001a+bE2,7k\u00195f[\u0006\f\u0011\u0002^1cY\u0016t\u0015-\\3\u0002\u001dE,XM]=US6,7\u000f^1na\u0006yQ.\u00198eCR|'/\u001f$jK2$7\u000fE\u0002mcfs!!\\8\u000f\u0005qs\u0017\"A+\n\u0005A$\u0016a\u00029bG.\fw-Z\u0005\u0003eN\u00141aU3r\u0015\t\u0001H+A\u0003jg6{%\u000b\u0005\u0002Tm&\u0011q\u000f\u0016\u0002\b\u0005>|G.Z1o\u0003-I7OQ8piN$(/\u00199\u0002\u001b%\u001c\u0018J\\2sK6,g\u000e^1m\u000311\u0018\r\\5e\u0007>lW.\u001b;t\u0003]\u0019\bn\\;mIV\u001bXMU3d_J$\u0007k\\:ji&|g.A\bsKF,\u0018N]3e\r&dG/\u001a:t!\ra\u0017O \t\u0004\u007f\u0006\u0015QBAA\u0001\u0015\r\t\u0019!N\u0001\bg>,(oY3t\u0013\u0011\t9!!\u0001\u0003\r\u0019KG\u000e^3s\u0003\u0001J7/T;mi&\u0004H.\u001a\"bg\u00164\u0015\u000e\\3G_Jl\u0017\r^:F]\u0006\u0014G.\u001a3\u0002!!|w\u000eZ5f\r&dWMR8s[\u0006$\b\u0003BA\b\u00033i!!!\u0005\u000b\t\u0005M\u0011QC\u0001\u0006[>$W\r\u001c\u0006\u0004\u0003/)\u0015AB2p[6|g.\u0003\u0003\u0002\u001c\u0005E!\u0001\u0005%p_\u0012LWMR5mK\u001a{'/\\1u\u0003\u0019a\u0014N\\5u}Qa\u0012\u0011EA\u0012\u0003K\t9#!\u000b\u0002,\u00055\u0012qFA\u0019\u0003g\t)$a\u000e\u0002:\u0005m\u0002C\u0001!\u0001\u0011\u0015Af\u00021\u0001Z\u0011\u0015!g\u00021\u0001f\u0011\u0015Ag\u00021\u0001Z\u0011\u0015Ig\u00021\u0001Z\u0011\u0015Qg\u00021\u0001l\u0011\u0015!h\u00021\u0001v\u0011\u0015Ah\u00021\u0001v\u0011\u0015Ih\u00021\u0001v\u0011\u0015Qh\u00021\u0001Z\u0011\u0015Yh\u00021\u0001v\u0011\u0015ah\u00021\u0001~\u0011\u0019\tIA\u0004a\u0001k\"9\u00111\u0002\bA\u0002\u00055\u0011aD1we>$\u0016M\u00197f'\u000eDW-\\1\u0016\u0005\u0005\u0005\u0003\u0003BA\"\u0003\u0013j!!!\u0012\u000b\u0007\u0005\u001d\u0013(\u0001\u0003bmJ|\u0017\u0002BA&\u0003\u000b\u0012aaU2iK6\f\u0017\u0001\u0007;bE2,7k\u00195f[\u0006\f5/T3tg\u0006<W\rV=qKV\u0011\u0011\u0011\u000b\t\u0007\u0003'\nI&!\u0018\u000e\u0005\u0005U#\u0002BA,\u0003+\tA!\u001e;jY&!\u00111LA+\u0005\u0019y\u0005\u000f^5p]B!\u0011qLA4\u001b\t\t\tG\u0003\u0003\u0002d\u0005\u0015\u0014AB:dQ\u0016l\u0017M\u0003\u00021s%!\u0011\u0011NA1\u0005-iUm]:bO\u0016$\u0016\u0010]3\u0002I!\f7\u000fV5nKN$\u0018-\u001c9NS2d\u0017n\u001d$jK2$\u0017J\u001c+bE2,7k\u00195f[\u0006,\u0012!^\u0001\u001cgV\u0004\bo\u001c:u\u0005\u0006$8\r[,ji\"$\u0016M\u00197f'\u000eDW-\\1\u0002\u0013MDwN\u001d;OC6,G#A-\u0002\u0011Q|7\u000b\u001e:j]\u001e\f!cZ3u%\u0016\fX/\u001b:fI\u001aKG\u000e^3sgV\tQ0\u0001\ntC:LG/\u001b>fIR\u000b'\r\\3OC6,WCAA@!\u0011\t\t)a#\u000e\u0005\u0005\r%\u0002BAC\u0003\u000f\u000bA\u0001\\1oO*\u0011\u0011\u0011R\u0001\u0005U\u00064\u0018-C\u0002c\u0003\u0007\u000b1c]1oSRL'0\u001a3UC\ndWMT1nK\u0002\nQc];qa>\u0014HOV3di>\u0014\u0018N_3e%\u0016\fG-A\rtkB\u0004xN\u001d;WK\u000e$xN]5{K\u0012\u0014V-\u00193`I\u0015\fH\u0003BAK\u00037\u00032aUAL\u0013\r\tI\n\u0016\u0002\u0005+:LG\u000f\u0003\u0005\u0002\u001ef\t\t\u00111\u0001v\u0003\rAH%M\u0001\u0017gV\u0004\bo\u001c:u-\u0016\u001cGo\u001c:ju\u0016$'+Z1eA\u0005)2/\u001e9q_J$(+\u001a;ve:Lgn\u001a\"bi\u000eD\u0017!G:vaB|'\u000f\u001e*fiV\u0014h.\u001b8h\u0005\u0006$8\r[0%KF$B!!&\u0002(\"A\u0011Q\u0014\u000f\u0002\u0002\u0003\u0007Q/\u0001\ftkB\u0004xN\u001d;SKR,(O\\5oO\n\u000bGo\u00195!\u00031\u0019X\u000f\u001d9peR\u0014\u0015\r^2i)\u0015)\u0018qVA^\u0011\u001d\t\tL\ba\u0001\u0003g\u000bAb\u001d9be.\u001cVm]:j_:\u0004B!!.\u000286\tQ'C\u0002\u0002:V\u0012Ab\u00159be.\u001cVm]:j_:Dq!a\u0019\u001f\u0001\u0004\ti\f\u0005\u0003\u0002@\u0006\u0015WBAAa\u0015\r\t\u0019-N\u0001\u0006if\u0004Xm]\u0005\u0005\u0003\u000f\f\tM\u0001\u0006TiJ,8\r\u001e+za\u0016\f1B^3di>\u0014H+\u001f9fgRA\u0011QZAi\u0003+\fI\u000e\u0005\u0003T\u0003\u001f\\\u0017bAA.)\"9\u00111[\u0010A\u0002\u0005u\u0016A\u0004:fcVL'/\u001a3TG\",W.\u0019\u0005\b\u0003/|\u0002\u0019AA_\u0003=\u0001\u0018M\u001d;ji&|gnU2iK6\f\u0007bBAn?\u0001\u0007\u0011Q\\\u0001\bgFd7i\u001c8g!\u0011\ty.a9\u000e\u0005\u0005\u0005(BA(6\u0013\u0011\t)/!9\u0003\u000fM\u000bFjQ8oM\u0006\t\u0012N\u001c;fe:\fGnU2iK6\fw\n\u001d;\u0016\u0005\u0005-\bCBA*\u00033\ni\u000f\u0005\u0003\u0002p\u0006UXBAAy\u0015\u0011\t\u0019'a=\u000b\u0005=+\u0015\u0002BA|\u0003c\u0014a\"\u00138uKJt\u0017\r\\*dQ\u0016l\u0017-A\u0006jgN\u0003H.\u001b;bE2,GcB;\u0002~\u0006}(\u0011\u0002\u0005\b\u0003c\u000b\u0003\u0019AAZ\u0011\u001d\u0011\t!\ta\u0001\u0005\u0007\tqa\u001c9uS>t7\u000fE\u0003[\u0005\u000bI\u0016,C\u0002\u0003\b\r\u00141!T1q\u0011\u001d\u0011Y!\ta\u0001\u0005\u001b\tA\u0001]1uQB!!q\u0002B\r\u001b\t\u0011\tB\u0003\u0003\u0003\u0014\tU\u0011A\u00014t\u0015\r\u00119\"O\u0001\u0007Q\u0006$wn\u001c9\n\t\tm!\u0011\u0003\u0002\u0005!\u0006$\b.\u0001\u0010ck&dGMU3bI\u0016\u0014x+\u001b;i!\u0006\u0014H/\u001b;j_:4\u0016\r\\;fgR\u0001\"\u0011\u0005B!\u0005\u0007\u00129E!\u0013\u0003L\t=#\u0011\u000b\t\b'\n\r\"q\u0005B\u0018\u0013\r\u0011)\u0003\u0016\u0002\n\rVt7\r^5p]F\u0002BA!\u000b\u0003,5\t\u0011'C\u0002\u0003.E\u0012q\u0002U1si&$\u0018n\u001c8fI\u001aKG.\u001a\t\u0006Y\nE\"QG\u0005\u0004\u0005g\u0019(\u0001C%uKJ\fGo\u001c:\u0011\t\t]\"QH\u0007\u0003\u0005sQ1Aa\u000f6\u0003!\u0019\u0017\r^1msN$\u0018\u0002\u0002B \u0005s\u00111\"\u00138uKJt\u0017\r\u001c*po\"1\u0001H\ta\u0001\u0003gCqA!\u0012#\u0001\u0004\ti,\u0001\u0006eCR\f7k\u00195f[\u0006Dq!a6#\u0001\u0004\ti\fC\u0004\u0002T\n\u0002\r!!0\t\r\t5#\u00051\u0001~\u0003\u001d1\u0017\u000e\u001c;feNDqA!\u0001#\u0001\u0004\u0011\u0019\u0001C\u0004\u0003T\t\u0002\rA!\u0016\u0002\u0015!\fGm\\8q\u0007>tg\r\u0005\u0003\u0003X\tuSB\u0001B-\u0015\u0011\u0011YF!\u0006\u0002\t\r|gNZ\u0005\u0005\u0005?\u0012IFA\u0007D_:4\u0017nZ;sCRLwN\\\u0001\u0014EVLG\u000e\u001a\"bg\u00164\u0015\u000e\\3SK\u0006$WM\u001d\u000b\r\u0005K\u0012YG!\u001c\u0003p\tM$Q\u000f\t\u0005\u0005S\u00119'C\u0002\u0003jE\u0012qc\u00159be.\u001cu\u000e\\;n]\u0006\u0014h)\u001b7f%\u0016\fG-\u001a:\t\ra\u001a\u0003\u0019AAZ\u0011\u001d\u0011\ta\ta\u0001\u0005\u0007AqA!\u001d$\u0001\u0004\u0011)&A\u0007d_:4\u0017nZ;sCRLwN\u001c\u0005\b\u0005\u000b\u001a\u0003\u0019AA_\u0011\u0019\u00119h\ta\u0001k\u0006!RM\\1cY\u00164Vm\u0019;pe&TX\r\u001a*fC\u0012\f\u0011d]3u'\u000eDW-\\1Fm>dW\u000f^5p]\u000e{gNZ5hgR!\u0011Q\u0013B?\u0011\u001d\u0011Y\u0006\na\u0001\u0005\u007f\u0002bA!!\u0003\b\nUSB\u0001BB\u0015\r\u0011))R\u0001\bgR|'/Y4f\u0013\u0011\u0011IIa!\u0003)M#xN]1hK\u000e{gNZ5hkJ\fG/[8o\u0003Y\u0011W/\u001b7e\u0007\u0012\u001b%+Z2pe\u0012LE/\u001a:bi>\u0014HC\u0004B\u0018\u0005\u001f\u0013IJ!(\u0003\"\nE&1\u0017\u0005\b\u0005#+\u0003\u0019\u0001BJ\u0003\u001dBwn\u001c3jKB\u000b'\u000f^5uS>t7\tR\"GS2,wI]8vaNc\u0017nY3NCB\u0004\u0018N\\4\u0011\u0007\u0011\u0013)*C\u0002\u0003\u0018\u0016\u0013!\u0005S8pI&,\u0007+\u0019:uSRLwN\\\"E\u0007\u001aKG.Z$s_V\u0004X*\u00199qS:<\u0007b\u0002BNK\u0001\u0007!QM\u0001\u000fE\u0006\u001cXMR5mKJ+\u0017\rZ3s\u0011\u001d\u0011y*\na\u0001\u0005\u007f\n1b\u001d;pe\u0006<WmQ8oM\"9!1U\u0013A\u0002\t\u0015\u0016!\u00029s_B\u001c\b\u0003\u0002BT\u0005[k!A!+\u000b\t\t-\u0016QC\u0001\u0007G>tg-[4\n\t\t=&\u0011\u0016\u0002\u0010)f\u0004X\r\u001a)s_B,'\u000f^5fg\"9\u00111[\u0013A\u0002\u0005u\u0006b\u0002B[K\u0001\u0007!qW\u0001\u000b[\u0016$\u0018m\u00117jK:$\b\u0003\u0002B]\u0005\u007fk!Aa/\u000b\t\tu\u0016QC\u0001\u0006i\u0006\u0014G.Z\u0005\u0005\u0005\u0003\u0014YLA\u000bI_>$\u0017.\u001a+bE2,W*\u001a;b\u00072LWM\u001c;\u00023\u0005\u0004\b/\u001a8e!\u0006\u0014H/\u001b;j_:\fe\u000e\u001a)s_*,7\r\u001e\u000b\u000f\u0005_\u00119Ma6\u0003\\\nu'\u0011\u001dBs\u0011\u001d\u0011IM\na\u0001\u0005\u0017\fA!\u001b;feB1!Q\u001aBj\u0005ki!Aa4\u000b\t\tE\u0017QK\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002Bk\u0005\u001f\u0014\u0001c\u00117pg\u0006\u0014G.Z%uKJ\fGo\u001c:\t\u000f\teg\u00051\u0001\u0002>\u0006Y\u0011N\u001c9viN\u001b\u0007.Z7b\u0011\u001d\t9N\na\u0001\u0003{CqAa8'\u0001\u0004\ti,\u0001\u0002u_\"9!1\u001d\u0014A\u0002\tU\u0012a\u00049beRLG/[8o-\u0006dW/Z:\t\u000f\t\u001dh\u00051\u0001\u0003j\u0006)b-\u001b=fIB\u000b'\u000f^5uS>t\u0017J\u001c3fq\u0016\u001c\b#\u0002.\u0003l\n=\u0018b\u0001BwG\n\u00191+\u001a;\u0011\u0007M\u0013\t0C\u0002\u0003tR\u00131!\u00138u\u00035\u0001(o\u001c6fGR\u001c6\r[3nCRA!q\u0006B}\u0005w\u0014y\u0010C\u0004\u0003J\u001e\u0002\rAa3\t\u000f\tux\u00051\u0001\u0002>\u0006!aM]8n\u0011\u001d\u0011yn\na\u0001\u0003{\u000b1&\\1lK\u000ecwn]3bE2,g)\u001b7f\u000fJ|W\u000f]'baBLgn\u001a*fG>\u0014H-\u0013;fe\u0006$xN\u001d\u000b\u0007\u0005_\u0019)a!\u0003\t\u000f\r\u001d\u0001\u00061\u0001\u0003L\u0006\u00013\r\\8tK\u0006\u0014G.\u001a$jY\u0016<%o\\;q%\u0016\u001cwN\u001d3Ji\u0016\u0014\u0018\r^8s\u0011\u001d\u0019Y\u0001\u000ba\u0001\u0007\u001b\tq\"\\1qa&twMR;oGRLwN\u001c\t\b5\u000e=!Q\u0007B\u001b\u0013\r\u0019\tb\u0019\u0002\t\rVt7\r^5p]\u0006a!/Z1e\u0005\u0006\u001cXMR5mKR1\"qFB\f\u00077\u0019yba\t\u0004(\r%21FB\u0017\u0007c\u0019\u0019\u0004C\u0004\u0004\u001a%\u0002\rAa\n\u0002\t\u0019LG.\u001a\u0005\b\u0007;I\u0003\u0019\u0001B3\u0003E\u0001\u0018M]9vKR4\u0015\u000e\\3SK\u0006$WM\u001d\u0005\b\u0007CI\u0003\u0019AA_\u0003=\u0011X-];fgR,GmU2iK6\f\u0007bBB\u0013S\u0001\u0007\u0011QX\u0001\u0019e\u0016l\u0017-\u001b8j]\u001e\u0004\u0016M\u001d;ji&|gnU2iK6\f\u0007b\u0002BtS\u0001\u0007!\u0011\u001e\u0005\b\u0003'L\u0003\u0019AA_\u0011\u001d\t9.\u000ba\u0001\u0003{Cqaa\f*\u0001\u0004\ti,\u0001\u0007pkR\u0004X\u000f^*dQ\u0016l\u0017\r\u0003\u0004\u0003N%\u0002\r! \u0005\b\u0005?K\u0003\u0019\u0001B@\u0003-\u0001(o\u001c6fGRLE/\u001a:\u0015\u0011\t=2\u0011HB\"\u0007\u000bBqA!3+\u0001\u0004\u0019Y\u0004E\u0003m\u0005c\u0019i\u0004E\u0002T\u0007\u007fI1a!\u0011U\u0005\r\te.\u001f\u0005\b\u0005{T\u0003\u0019AA_\u0011\u001d\u0011yN\u000ba\u0001\u0003{\u000bqcZ3u\r&DX\r\u001a)beRLG/[8o-\u0006dW/Z:\u0015\u0011\tU21JB(\u0007#Bqa!\u0014,\u0001\u0004\u0011)$\u0001\nbY2\u0004\u0016M\u001d;ji&|gNV1mk\u0016\u001c\bbBAlW\u0001\u0007\u0011Q\u0018\u0005\b\u0005O\\\u0003\u0019\u0001Bu\u0003-IgNZ3s'\u000eDW-\\1\u0015\u0011\r]3\u0011LB.\u0007;\u0002RaUAh\u0003{Cq!!--\u0001\u0004\t\u0019\fC\u0004\u0003\u00021\u0002\rAa\u0001\t\u000f\r}C\u00061\u0001\u0004b\u0005)a-\u001b7fgB!A.]B2!\u0011\u0011ya!\u001a\n\t\r\u001d$\u0011\u0003\u0002\u000b\r&dWm\u0015;biV\u001c\u0018\u0001\u00049sKB\f'/Z,sSR,GCCB7\u0007g\u001a)h!\"\u0004\bB!!\u0011FB8\u0013\r\u0019\t(\r\u0002\u0014\u001fV$\b/\u001e;Xe&$XM\u001d$bGR|'/\u001f\u0005\b\u0003ck\u0003\u0019AAZ\u0011\u001d\u00199(\fa\u0001\u0007s\n1A[8c!\u0011\u0019Yh!!\u000e\u0005\ru$\u0002BB@\u0005+\t\u0011\"\\1qe\u0016$WoY3\n\t\r\r5Q\u0010\u0002\u0004\u0015>\u0014\u0007b\u0002B\u0001[\u0001\u0007!1\u0001\u0005\b\u0005\u000bj\u0003\u0019AA_\u0001")
public class HoodieFileGroupReaderBasedFileFormat
extends ParquetFileFormat
implements SparkAdapterSupport,
HoodieFormatTrait {
    private Schema avroTableSchema;
    private Option<MessageType> tableSchemaAsMessageType;
    private boolean hasTimestampMillisFieldInTableSchema;
    private boolean supportBatchWithTableSchema;
    private Option<InternalSchema> internalSchemaOpt;
    private final String tablePath;
    private final HoodieTableSchema tableSchema;
    private final String tableName;
    private final String queryTimestamp;
    private final Seq<String> mandatoryFields;
    private final boolean isMOR;
    private final boolean isBootstrap;
    private final boolean isIncremental;
    private final String validCommits;
    private final boolean shouldUseRecordPosition;
    private final Seq<Filter> requiredFilters;
    private final boolean isMultipleBaseFileFormatsEnabled;
    private final HoodieFileFormat hoodieFileFormat;
    private final String sanitizedTableName;
    private boolean supportVectorizedRead;
    private boolean supportReturningBatch;
    private boolean isProjected;
    private SparkAdapter sparkAdapter;
    private volatile byte bitmap$0;

    @Override
    public boolean isProjected() {
        return this.isProjected;
    }

    @Override
    public void isProjected_$eq(boolean x$1) {
        this.isProjected = x$1;
    }

    private SparkAdapter sparkAdapter$lzycompute() {
        HoodieFileGroupReaderBasedFileFormat hoodieFileGroupReaderBasedFileFormat = this;
        synchronized (hoodieFileGroupReaderBasedFileFormat) {
            if ((byte)(this.bitmap$0 & 0x20) == 0) {
                this.sparkAdapter = SparkAdapterSupport.sparkAdapter$((SparkAdapterSupport)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
            }
        }
        return this.sparkAdapter;
    }

    public SparkAdapter sparkAdapter() {
        if ((byte)(this.bitmap$0 & 0x20) == 0) {
            return this.sparkAdapter$lzycompute();
        }
        return this.sparkAdapter;
    }

    private Schema avroTableSchema$lzycompute() {
        HoodieFileGroupReaderBasedFileFormat hoodieFileGroupReaderBasedFileFormat = this;
        synchronized (hoodieFileGroupReaderBasedFileFormat) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.avroTableSchema = new Schema.Parser().parse(this.tableSchema.avroSchemaStr());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.avroTableSchema;
    }

    private Schema avroTableSchema() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.avroTableSchema$lzycompute();
        }
        return this.avroTableSchema;
    }

    private Option<MessageType> tableSchemaAsMessageType$lzycompute() {
        HoodieFileGroupReaderBasedFileFormat hoodieFileGroupReaderBasedFileFormat = this;
        synchronized (hoodieFileGroupReaderBasedFileFormat) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.tableSchemaAsMessageType = Option.ofNullable((Object)ParquetTableSchemaResolver.convertAvroSchemaToParquet((Schema)this.avroTableSchema(), (Configuration)new Configuration()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.tableSchemaAsMessageType;
    }

    private Option<MessageType> tableSchemaAsMessageType() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.tableSchemaAsMessageType$lzycompute();
        }
        return this.tableSchemaAsMessageType;
    }

    private boolean hasTimestampMillisFieldInTableSchema$lzycompute() {
        HoodieFileGroupReaderBasedFileFormat hoodieFileGroupReaderBasedFileFormat = this;
        synchronized (hoodieFileGroupReaderBasedFileFormat) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.hasTimestampMillisFieldInTableSchema = AvroSchemaRepair.hasTimestampMillisField((Schema)this.avroTableSchema());
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.hasTimestampMillisFieldInTableSchema;
    }

    private boolean hasTimestampMillisFieldInTableSchema() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.hasTimestampMillisFieldInTableSchema$lzycompute();
        }
        return this.hasTimestampMillisFieldInTableSchema;
    }

    private boolean supportBatchWithTableSchema$lzycompute() {
        HoodieFileGroupReaderBasedFileFormat hoodieFileGroupReaderBasedFileFormat = this;
        synchronized (hoodieFileGroupReaderBasedFileFormat) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.supportBatchWithTableSchema = HoodieSparkUtils$.MODULE$.gteqSpark3_5() || !this.hasTimestampMillisFieldInTableSchema();
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.supportBatchWithTableSchema;
    }

    private boolean supportBatchWithTableSchema() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.supportBatchWithTableSchema$lzycompute();
        }
        return this.supportBatchWithTableSchema;
    }

    public String shortName() {
        return "HudiFileGroup";
    }

    public String toString() {
        return "HoodieFileGroupReaderBasedFileFormat";
    }

    @Override
    public Seq<Filter> getRequiredFilters() {
        return this.requiredFilters;
    }

    private String sanitizedTableName() {
        return this.sanitizedTableName;
    }

    private boolean supportVectorizedRead() {
        return this.supportVectorizedRead;
    }

    private void supportVectorizedRead_$eq(boolean x$1) {
        this.supportVectorizedRead = x$1;
    }

    private boolean supportReturningBatch() {
        return this.supportReturningBatch;
    }

    private void supportReturningBatch_$eq(boolean x$1) {
        this.supportReturningBatch = x$1;
    }

    public boolean supportBatch(SparkSession sparkSession, StructType schema) {
        boolean bl;
        boolean orcBatchSupported;
        SQLConf conf = sparkSession.sessionState().conf();
        boolean parquetBatchSupported = ParquetUtils$.MODULE$.isBatchReadSupportedForSchema(conf, schema) && this.supportBatchWithTableSchema();
        boolean bl2 = orcBatchSupported = conf.orcVectorizedReaderEnabled() && schema.forall((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)OrcUtils$.MODULE$.supportColumnarReads(s.dataType(), sparkSession.sessionState().conf().orcVectorizedReaderNestedColumnEnabled())));
        if (this.isMultipleBaseFileFormatsEnabled) {
            bl = parquetBatchSupported && orcBatchSupported;
        } else {
            HoodieFileFormat hoodieFileFormat = this.hoodieFileFormat;
            HoodieFileFormat hoodieFileFormat2 = HoodieFileFormat.PARQUET;
            if (!(hoodieFileFormat != null ? !hoodieFileFormat.equals(hoodieFileFormat2) : hoodieFileFormat2 != null)) {
                bl = parquetBatchSupported;
            } else {
                HoodieFileFormat hoodieFileFormat3 = this.hoodieFileFormat;
                HoodieFileFormat hoodieFileFormat4 = HoodieFileFormat.ORC;
                if (!(hoodieFileFormat3 != null ? !hoodieFileFormat3.equals(hoodieFileFormat4) : hoodieFileFormat4 != null)) {
                    bl = orcBatchSupported;
                } else {
                    throw new HoodieNotSupportedException(new java.lang.StringBuilder(25).append("Unsupported file format: ").append(this.hoodieFileFormat).toString());
                }
            }
        }
        boolean supportBatch = bl;
        this.supportVectorizedRead_$eq(!this.isIncremental && !this.isBootstrap && supportBatch);
        this.supportReturningBatch_$eq(!this.isMOR && this.supportVectorizedRead());
        this.logInfo((Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(101).append("supportReturningBatch: ").append(this.supportReturningBatch()).append(", supportVectorizedRead: ").append(this.supportVectorizedRead()).append(", isIncremental: ").append($this.isIncremental).append(", ").append("isBootstrap: ").append($this.isBootstrap).append(", superSupportBatch: ").append(supportBatch).toString());
        return this.supportReturningBatch();
    }

    public scala.Option<Seq<String>> vectorTypes(StructType requiredSchema, StructType partitionSchema, SQLConf sqlConf) {
        scala.Option originalVectorTypes = super.vectorTypes(requiredSchema, partitionSchema, sqlConf);
        if (this.mandatoryFields.isEmpty()) {
            return originalVectorTypes;
        }
        String regularVectorType = !sqlConf.offHeapColumnVectorEnabled() ? OnHeapColumnVector.class.getName() : OffHeapColumnVector.class.getName();
        return originalVectorTypes.map((Function1 & Serializable & scala.Serializable)o -> (Seq)((TraversableLike)o.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)a -> {
            if (a._2$mcI$sp() >= requiredSchema.length() && $this.mandatoryFields.contains((Object)partitionSchema.fields()[a._2$mcI$sp() - requiredSchema.length()].name())) {
                return regularVectorType;
            }
            return (String)a._1();
        }, Seq$.MODULE$.canBuildFrom()));
    }

    private Option<InternalSchema> internalSchemaOpt$lzycompute() {
        HoodieFileGroupReaderBasedFileFormat hoodieFileGroupReaderBasedFileFormat = this;
        synchronized (hoodieFileGroupReaderBasedFileFormat) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.internalSchemaOpt = this.tableSchema.internalSchema().isEmpty() ? Option.empty() : Option.of((Object)this.tableSchema.internalSchema().get());
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.internalSchemaOpt;
    }

    private Option<InternalSchema> internalSchemaOpt() {
        if ((byte)(this.bitmap$0 & 0x10) == 0) {
            return this.internalSchemaOpt$lzycompute();
        }
        return this.internalSchemaOpt;
    }

    public boolean isSplitable(SparkSession sparkSession, scala.collection.immutable.Map<String, String> options, Path path) {
        return false;
    }

    public Function1<PartitionedFile, Iterator<InternalRow>> buildReaderWithPartitionValues(SparkSession spark, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, scala.collection.immutable.Map<String, String> options, Configuration hadoopConf) {
        StructType outputSchema = new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])requiredSchema.fields())).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionSchema.fields())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
        boolean isCount = requiredSchema.isEmpty() && !this.isMOR && !this.isIncremental;
        StorageConfiguration augmentedStorageConf = new HadoopStorageConfiguration(hadoopConf).getInline();
        this.setSchemaEvolutionConfigs((StorageConfiguration<Configuration>)augmentedStorageConf);
        augmentedStorageConf.set("spark.hudi.logicalTimestampField.repair.enable", Boolean.toString(this.hasTimestampMillisFieldInTableSchema()));
        Tuple2 tuple2 = ((GenericTraversableTemplate)((TraversableLike)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionSchema.fields())).toSeq().zipWithIndex(Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)HoodieFileGroupReaderBasedFileFormat.$anonfun$buildReaderWithPartitionValues$1(this, p)))).unzip((Function1)Predef$.MODULE$.$conforms());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq remainingPartitionSchemaArr = (Seq)tuple2._1();
        Seq fixedPartitionIndexesArr = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)remainingPartitionSchemaArr, (Object)fixedPartitionIndexesArr);
        Seq remainingPartitionSchemaArr2 = (Seq)tuple22._1();
        Seq fixedPartitionIndexesArr2 = (Seq)tuple22._2();
        StructType remainingPartitionSchema = StructType$.MODULE$.apply(remainingPartitionSchemaArr2);
        Set fixedPartitionIndexes = fixedPartitionIndexesArr2.toSet();
        HashSet<String> exclusionFields = new HashSet<String>();
        exclusionFields.add("op");
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionSchema.fields())).foreach((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)exclusionFields.add(f.name())));
        StructType requestedSchema = new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])requiredSchema.fields())).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionSchema.fields())).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)this.mandatoryFields.contains((Object)f.name()))))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
        Schema requestedAvroSchema = AvroSchemaUtils.pruneDataSchema((Schema)this.avroTableSchema(), (Schema)AvroConversionUtils$.MODULE$.convertStructTypeToAvroSchema((DataType)requestedSchema, this.sanitizedTableName()), exclusionFields);
        Schema dataAvroSchema = AvroSchemaUtils.pruneDataSchema((Schema)this.avroTableSchema(), (Schema)AvroConversionUtils$.MODULE$.convertStructTypeToAvroSchema((DataType)dataSchema, this.sanitizedTableName()), exclusionFields);
        spark.sessionState().conf().setConfString("spark.sql.parquet.enableVectorizedReader", Boolean.toString(this.supportVectorizedRead()));
        Broadcast baseFileReader = spark.sparkContext().broadcast((Object)this.buildBaseFileReader(spark, options, (Configuration)augmentedStorageConf.unwrap(), dataSchema, this.supportVectorizedRead()), ClassTag$.MODULE$.apply(SparkColumnarFileReader.class));
        Broadcast fileGroupBaseFileReader = this.isMOR && this.supportVectorizedRead() ? spark.sparkContext().broadcast((Object)this.buildBaseFileReader(spark, options, (Configuration)augmentedStorageConf.unwrap(), dataSchema, false), ClassTag$.MODULE$.apply(SparkColumnarFileReader.class)) : baseFileReader;
        Broadcast broadcastedStorageConf = spark.sparkContext().broadcast((Object)new SerializableConfiguration((Configuration)augmentedStorageConf.unwrap()), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
        TypedProperties fileIndexProps = HoodieFileIndex$.MODULE$.getConfigProperties(spark, options, null);
        HoodieSparkEngineContext engineContext = new HoodieSparkEngineContext(new JavaSparkContext(spark.sparkContext()));
        long maxMemoryPerCompaction = IOUtils.getMaxMemoryPerCompaction((TaskContextSupplier)engineContext.getTaskContextSupplier(), (Map)((Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(options).asJava()));
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(augmentedStorageConf).setBasePath(this.tablePath).build();
        return arg_0 -> HoodieFileGroupReaderBasedFileFormat.$anonfun$buildReaderWithPartitionValues$4(this, broadcastedStorageConf, isCount, requiredSchema, fileGroupBaseFileReader, filters, metaClient, options, maxMemoryPerCompaction, dataAvroSchema, requestedAvroSchema, requestedSchema, remainingPartitionSchema, outputSchema, fixedPartitionIndexes, baseFileReader, partitionSchema, fileIndexProps, arg_0);
    }

    private SparkColumnarFileReader buildBaseFileReader(SparkSession spark, scala.collection.immutable.Map<String, String> options, Configuration configuration, StructType dataSchema, boolean enableVectorizedRead) {
        if (this.isMultipleBaseFileFormatsEnabled) {
            return new MultipleColumnarFileFormatReader(this.sparkAdapter().createParquetFileReader(enableVectorizedRead, spark.sessionState().conf(), options, configuration), this.sparkAdapter().createOrcFileReader(enableVectorizedRead, spark.sessionState().conf(), options, configuration, dataSchema));
        }
        HoodieFileFormat hoodieFileFormat = this.hoodieFileFormat;
        HoodieFileFormat hoodieFileFormat2 = HoodieFileFormat.PARQUET;
        if (!(hoodieFileFormat != null ? !hoodieFileFormat.equals(hoodieFileFormat2) : hoodieFileFormat2 != null)) {
            return this.sparkAdapter().createParquetFileReader(enableVectorizedRead, spark.sessionState().conf(), options, configuration);
        }
        HoodieFileFormat hoodieFileFormat3 = this.hoodieFileFormat;
        HoodieFileFormat hoodieFileFormat4 = HoodieFileFormat.ORC;
        if (!(hoodieFileFormat3 != null ? !hoodieFileFormat3.equals(hoodieFileFormat4) : hoodieFileFormat4 != null)) {
            return this.sparkAdapter().createOrcFileReader(enableVectorizedRead, spark.sessionState().conf(), options, configuration, dataSchema);
        }
        throw new HoodieNotSupportedException(new java.lang.StringBuilder(25).append("Unsupported file format: ").append(this.hoodieFileFormat).toString());
    }

    private void setSchemaEvolutionConfigs(StorageConfiguration<Configuration> conf) {
        if (this.internalSchemaOpt().isPresent()) {
            conf.set("hoodie.tablePath", this.tablePath);
            conf.set("hoodie.valid.commits.list", this.validCommits);
            return;
        }
    }

    private Iterator<InternalRow> buildCDCRecordIterator(HoodiePartitionCDCFileGroupMapping hoodiePartitionCDCFileGroupSliceMapping, SparkColumnarFileReader baseFileReader, StorageConfiguration<Configuration> storageConf, TypedProperties props, StructType requiredSchema, HoodieTableMetaClient metaClient) {
        HoodieCDCFileSplit[] fileSplits = (HoodieCDCFileSplit[])hoodiePartitionCDCFileGroupSliceMapping.getFileSplits().toArray(ClassTag$.MODULE$.apply(HoodieCDCFileSplit.class));
        HoodieCDCFileGroupSplit cdcFileGroupSplit = new HoodieCDCFileGroupSplit(fileSplits);
        props.setProperty("hoodie.table.name", this.tableName);
        StructType cdcSchema = CDCRelation$.MODULE$.FULL_CDC_SPARK_SCHEMA();
        return new CDCFileGroupIterator(cdcFileGroupSplit, metaClient, storageConf, baseFileReader, this.tableSchema, cdcSchema, requiredSchema, props);
    }

    private Iterator<InternalRow> appendPartitionAndProject(ClosableIterator<InternalRow> iter, StructType inputSchema, StructType partitionSchema, StructType to, InternalRow partitionValues, Set<Object> fixedPartitionIndexes) {
        if (partitionSchema.isEmpty()) {
            return this.projectSchema(iter, inputSchema, to);
        }
        InternalRow fixedPartitionValues = partitionSchema.length() == partitionValues.numFields() ? partitionValues : this.getFixedPartitionValues(partitionValues, partitionSchema, fixedPartitionIndexes);
        UnsafeProjection unsafeProjection = HoodieCatalystExpressionUtils$.MODULE$.generateUnsafeProjection(new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])inputSchema.fields())).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionSchema.fields())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)))), to);
        JoinedRow joinedRow = new JoinedRow();
        return this.makeCloseableFileGroupMappingRecordIterator(iter, (Function1<InternalRow, InternalRow>)(Function1 & Serializable & scala.Serializable)d -> unsafeProjection.apply((InternalRow)joinedRow.apply(d, fixedPartitionValues)));
    }

    private Iterator<InternalRow> projectSchema(ClosableIterator<InternalRow> iter, StructType from, StructType to) {
        UnsafeProjection unsafeProjection = HoodieCatalystExpressionUtils$.MODULE$.generateUnsafeProjection(from, to);
        return this.makeCloseableFileGroupMappingRecordIterator(iter, (Function1<InternalRow, InternalRow>)(Function1 & Serializable & scala.Serializable)d -> unsafeProjection.apply(d));
    }

    private Iterator<InternalRow> makeCloseableFileGroupMappingRecordIterator(ClosableIterator<InternalRow> closeableFileGroupRecordIterator, Function1<InternalRow, InternalRow> mappingFunction) {
        CloseableIteratorListener.addListener(closeableFileGroupRecordIterator);
        return new Iterator<InternalRow>(null, closeableFileGroupRecordIterator, mappingFunction){
            private final ClosableIterator closeableFileGroupRecordIterator$1;
            private final Function1 mappingFunction$1;

            public Iterator<InternalRow> seq() {
                return Iterator.seq$((Iterator)this);
            }

            public boolean isEmpty() {
                return Iterator.isEmpty$((Iterator)this);
            }

            public boolean isTraversableAgain() {
                return Iterator.isTraversableAgain$((Iterator)this);
            }

            public boolean hasDefiniteSize() {
                return Iterator.hasDefiniteSize$((Iterator)this);
            }

            public Iterator<InternalRow> take(int n) {
                return Iterator.take$((Iterator)this, (int)n);
            }

            public Iterator<InternalRow> drop(int n) {
                return Iterator.drop$((Iterator)this, (int)n);
            }

            public Iterator<InternalRow> slice(int from, int until) {
                return Iterator.slice$((Iterator)this, (int)from, (int)until);
            }

            public Iterator<InternalRow> sliceIterator(int from, int until) {
                return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
            }

            public <B> Iterator<B> map(Function1<InternalRow, B> f) {
                return Iterator.map$((Iterator)this, f);
            }

            public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                return Iterator.$plus$plus$((Iterator)this, that);
            }

            public <B> Iterator<B> flatMap(Function1<InternalRow, GenTraversableOnce<B>> f) {
                return Iterator.flatMap$((Iterator)this, f);
            }

            public Iterator<InternalRow> filter(Function1<InternalRow, Object> p) {
                return Iterator.filter$((Iterator)this, p);
            }

            public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<InternalRow, B, Object> p) {
                return Iterator.corresponds$((Iterator)this, that, p);
            }

            public Iterator<InternalRow> withFilter(Function1<InternalRow, Object> p) {
                return Iterator.withFilter$((Iterator)this, p);
            }

            public Iterator<InternalRow> filterNot(Function1<InternalRow, Object> p) {
                return Iterator.filterNot$((Iterator)this, p);
            }

            public <B> Iterator<B> collect(PartialFunction<InternalRow, B> pf) {
                return Iterator.collect$((Iterator)this, pf);
            }

            public <B> Iterator<B> scanLeft(B z, Function2<B, InternalRow, B> op) {
                return Iterator.scanLeft$((Iterator)this, z, op);
            }

            public <B> Iterator<B> scanRight(B z, Function2<InternalRow, B, B> op) {
                return Iterator.scanRight$((Iterator)this, z, op);
            }

            public Iterator<InternalRow> takeWhile(Function1<InternalRow, Object> p) {
                return Iterator.takeWhile$((Iterator)this, p);
            }

            public Tuple2<Iterator<InternalRow>, Iterator<InternalRow>> partition(Function1<InternalRow, Object> p) {
                return Iterator.partition$((Iterator)this, p);
            }

            public Tuple2<Iterator<InternalRow>, Iterator<InternalRow>> span(Function1<InternalRow, Object> p) {
                return Iterator.span$((Iterator)this, p);
            }

            public Iterator<InternalRow> dropWhile(Function1<InternalRow, Object> p) {
                return Iterator.dropWhile$((Iterator)this, p);
            }

            public <B> Iterator<Tuple2<InternalRow, B>> zip(Iterator<B> that) {
                return Iterator.zip$((Iterator)this, that);
            }

            public <A1> Iterator<A1> padTo(int len, A1 elem) {
                return Iterator.padTo$((Iterator)this, (int)len, elem);
            }

            public Iterator<Tuple2<InternalRow, Object>> zipWithIndex() {
                return Iterator.zipWithIndex$((Iterator)this);
            }

            public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
            }

            public <U> void foreach(Function1<InternalRow, U> f) {
                Iterator.foreach$((Iterator)this, f);
            }

            public boolean forall(Function1<InternalRow, Object> p) {
                return Iterator.forall$((Iterator)this, p);
            }

            public boolean exists(Function1<InternalRow, Object> p) {
                return Iterator.exists$((Iterator)this, p);
            }

            public boolean contains(Object elem) {
                return Iterator.contains$((Iterator)this, (Object)elem);
            }

            public scala.Option<InternalRow> find(Function1<InternalRow, Object> p) {
                return Iterator.find$((Iterator)this, p);
            }

            public int indexWhere(Function1<InternalRow, Object> p) {
                return Iterator.indexWhere$((Iterator)this, p);
            }

            public int indexWhere(Function1<InternalRow, Object> p, int from) {
                return Iterator.indexWhere$((Iterator)this, p, (int)from);
            }

            public <B> int indexOf(B elem) {
                return Iterator.indexOf$((Iterator)this, elem);
            }

            public <B> int indexOf(B elem, int from) {
                return Iterator.indexOf$((Iterator)this, elem, (int)from);
            }

            public BufferedIterator<InternalRow> buffered() {
                return Iterator.buffered$((Iterator)this);
            }

            public <B> Iterator.GroupedIterator<B> grouped(int size) {
                return Iterator.grouped$((Iterator)this, (int)size);
            }

            public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                return Iterator.sliding$((Iterator)this, (int)size, (int)step);
            }

            public <B> int sliding$default$2() {
                return Iterator.sliding$default$2$((Iterator)this);
            }

            public int length() {
                return Iterator.length$((Iterator)this);
            }

            public Tuple2<Iterator<InternalRow>, Iterator<InternalRow>> duplicate() {
                return Iterator.duplicate$((Iterator)this);
            }

            public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
            }

            public <B> void copyToArray(Object xs, int start, int len) {
                Iterator.copyToArray$((Iterator)this, (Object)xs, (int)start, (int)len);
            }

            public boolean sameElements(Iterator<?> that) {
                return Iterator.sameElements$((Iterator)this, that);
            }

            public Traversable<InternalRow> toTraversable() {
                return Iterator.toTraversable$((Iterator)this);
            }

            public Iterator<InternalRow> toIterator() {
                return Iterator.toIterator$((Iterator)this);
            }

            public Stream<InternalRow> toStream() {
                return Iterator.toStream$((Iterator)this);
            }

            public String toString() {
                return Iterator.toString$((Iterator)this);
            }

            public List<InternalRow> reversed() {
                return TraversableOnce.reversed$((TraversableOnce)this);
            }

            public int size() {
                return TraversableOnce.size$((TraversableOnce)this);
            }

            public boolean nonEmpty() {
                return TraversableOnce.nonEmpty$((TraversableOnce)this);
            }

            public int count(Function1<InternalRow, Object> p) {
                return TraversableOnce.count$((TraversableOnce)this, p);
            }

            public <B> scala.Option<B> collectFirst(PartialFunction<InternalRow, B> pf) {
                return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
            }

            public <B> B $div$colon(B z, Function2<B, InternalRow, B> op) {
                return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
            }

            public <B> B $colon$bslash(B z, Function2<InternalRow, B, B> op) {
                return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
            }

            public <B> B foldLeft(B z, Function2<B, InternalRow, B> op) {
                return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
            }

            public <B> B foldRight(B z, Function2<InternalRow, B, B> op) {
                return (B)TraversableOnce.foldRight$((TraversableOnce)this, z, op);
            }

            public <B> B reduceLeft(Function2<B, InternalRow, B> op) {
                return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
            }

            public <B> B reduceRight(Function2<InternalRow, B, B> op) {
                return (B)TraversableOnce.reduceRight$((TraversableOnce)this, op);
            }

            public <B> scala.Option<B> reduceLeftOption(Function2<B, InternalRow, B> op) {
                return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
            }

            public <B> scala.Option<B> reduceRightOption(Function2<InternalRow, B, B> op) {
                return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
            }

            public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
            }

            public <A1> scala.Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                return TraversableOnce.reduceOption$((TraversableOnce)this, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, InternalRow, B> seqop, Function2<B, B, B> combop) {
                return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)TraversableOnce.sum$((TraversableOnce)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)TraversableOnce.product$((TraversableOnce)this, num);
            }

            public Object min(Ordering cmp) {
                return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
            }

            public Object max(Ordering cmp) {
                return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
            }

            public Object maxBy(Function1 f, Ordering cmp) {
                return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public Object minBy(Function1 f, Ordering cmp) {
                return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public <B> void copyToBuffer(Buffer<B> dest) {
                TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
            }

            public <B> void copyToArray(Object xs, int start) {
                TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
            }

            public <B> void copyToArray(Object xs) {
                TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
            }

            public <B> Object toArray(ClassTag<B> evidence$1) {
                return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
            }

            public List<InternalRow> toList() {
                return TraversableOnce.toList$((TraversableOnce)this);
            }

            public Iterable<InternalRow> toIterable() {
                return TraversableOnce.toIterable$((TraversableOnce)this);
            }

            public Seq<InternalRow> toSeq() {
                return TraversableOnce.toSeq$((TraversableOnce)this);
            }

            public IndexedSeq<InternalRow> toIndexedSeq() {
                return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
            }

            public <B> Buffer<B> toBuffer() {
                return TraversableOnce.toBuffer$((TraversableOnce)this);
            }

            public <B> Set<B> toSet() {
                return TraversableOnce.toSet$((TraversableOnce)this);
            }

            public Vector<InternalRow> toVector() {
                return TraversableOnce.toVector$((TraversableOnce)this);
            }

            public <Col> Col to(CanBuildFrom<Nothing$, InternalRow, Col> cbf) {
                return (Col)TraversableOnce.to$((TraversableOnce)this, cbf);
            }

            public <T, U> scala.collection.immutable.Map<T, U> toMap(Predef.$less$colon$less<InternalRow, Tuple2<T, U>> ev) {
                return TraversableOnce.toMap$((TraversableOnce)this, ev);
            }

            public String mkString(String start, String sep, String end) {
                return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
            }

            public String mkString(String sep) {
                return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
            }

            public String mkString() {
                return TraversableOnce.mkString$((TraversableOnce)this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
            }

            public StringBuilder addString(StringBuilder b, String sep) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
            }

            public StringBuilder addString(StringBuilder b) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
            }

            public int sizeHintIfCheap() {
                return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
            }

            public boolean hasNext() {
                return this.closeableFileGroupRecordIterator$1.hasNext();
            }

            public InternalRow next() {
                return (InternalRow)this.mappingFunction$1.apply(this.closeableFileGroupRecordIterator$1.next());
            }

            public void close() {
                this.closeableFileGroupRecordIterator$1.close();
            }
            {
                this.closeableFileGroupRecordIterator$1 = closeableFileGroupRecordIterator$1;
                this.mappingFunction$1 = mappingFunction$1;
                GenTraversableOnce.$init$((GenTraversableOnce)this);
                TraversableOnce.$init$((TraversableOnce)this);
                Iterator.$init$((Iterator)this);
            }
        };
    }

    private Iterator<InternalRow> readBaseFile(PartitionedFile file, SparkColumnarFileReader parquetFileReader, StructType requestedSchema, StructType remainingPartitionSchema, Set<Object> fixedPartitionIndexes, StructType requiredSchema, StructType partitionSchema, StructType outputSchema, Seq<Filter> filters, StorageConfiguration<Configuration> storageConf) {
        if (remainingPartitionSchema.fields().length == partitionSchema.fields().length) {
            return parquetFileReader.read(file, requiredSchema, partitionSchema, this.internalSchemaOpt(), filters, storageConf, this.tableSchemaAsMessageType());
        }
        if (remainingPartitionSchema.fields().length == 0) {
            HoodieSparkPartitionedFileUtils pfileUtils = this.sparkAdapter().getSparkPartitionedFileUtils();
            PartitionedFile modifiedFile = pfileUtils.createPartitionedFile(InternalRow$.MODULE$.empty(), pfileUtils.getPathFromPartitionedFile(file), file.start(), file.length());
            return parquetFileReader.read(modifiedFile, outputSchema, new StructType(), this.internalSchemaOpt(), filters, storageConf, this.tableSchemaAsMessageType());
        }
        HoodieSparkPartitionedFileUtils pfileUtils = this.sparkAdapter().getSparkPartitionedFileUtils();
        InternalRow partitionValues = this.getFixedPartitionValues(file.partitionValues(), partitionSchema, fixedPartitionIndexes);
        PartitionedFile modifiedFile = pfileUtils.createPartitionedFile(partitionValues, pfileUtils.getPathFromPartitionedFile(file), file.start(), file.length());
        Iterator iter = parquetFileReader.read(modifiedFile, requestedSchema, remainingPartitionSchema, this.internalSchemaOpt(), filters, storageConf, this.tableSchemaAsMessageType());
        return this.projectIter((Iterator<Object>)iter, new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])requestedSchema.fields())).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])remainingPartitionSchema.fields())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)))), outputSchema);
    }

    private Iterator<InternalRow> projectIter(Iterator<Object> iter, StructType from, StructType to) {
        UnsafeProjection unsafeProjection = HoodieCatalystExpressionUtils$.MODULE$.generateUnsafeProjection(from, to);
        UnaryOperator<ColumnarBatch> batchProjection = ColumnarBatchUtils.generateProjection(from, to);
        return iter.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Object object = x0$1;
            if (object instanceof InternalRow) {
                InternalRow internalRow = (InternalRow)object;
                return unsafeProjection.apply(internalRow);
            }
            if (object instanceof ColumnarBatch) {
                ColumnarBatch columnarBatch = (ColumnarBatch)object;
                return batchProjection.apply(columnarBatch);
            }
            throw new MatchError(object);
        });
    }

    private InternalRow getFixedPartitionValues(InternalRow allPartitionValues, StructType partitionSchema, Set<Object> fixedPartitionIndexes) {
        return InternalRow$.MODULE$.fromSeq((Seq)((TraversableLike)((TraversableLike)allPartitionValues.toSeq(partitionSchema).zipWithIndex(Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)fixedPartitionIndexes.contains((Object)BoxesRunTime.boxToInteger((int)p._2$mcI$sp()))))).map((Function1 & Serializable & scala.Serializable)p -> p._1(), Seq$.MODULE$.canBuildFrom()));
    }

    public scala.Option<StructType> inferSchema(SparkSession sparkSession, scala.collection.immutable.Map<String, String> options, Seq<FileStatus> files) {
        block3: {
            block2: {
                if (this.isMultipleBaseFileFormatsEnabled) break block2;
                HoodieFileFormat hoodieFileFormat = this.hoodieFileFormat;
                HoodieFileFormat hoodieFileFormat2 = HoodieFileFormat.PARQUET;
                if (hoodieFileFormat != null ? !hoodieFileFormat.equals(hoodieFileFormat2) : hoodieFileFormat2 != null) break block3;
            }
            return ParquetUtils$.MODULE$.inferSchema(sparkSession, options, files);
        }
        return OrcUtils$.MODULE$.inferSchema(sparkSession, files, options);
    }

    public OutputWriterFactory prepareWrite(SparkSession sparkSession, Job job, scala.collection.immutable.Map<String, String> options, StructType dataSchema) {
        throw new HoodieNotSupportedException("HoodieFileGroupReaderBasedFileFormat does not support writing");
    }

    public static final /* synthetic */ boolean $anonfun$buildReaderWithPartitionValues$1(HoodieFileGroupReaderBasedFileFormat $this, Tuple2 p) {
        return !$this.mandatoryFields.contains((Object)((StructField)p._1()).name());
    }

    public static final /* synthetic */ Object $anonfun$buildReaderWithPartitionValues$5(TypedProperties props$1, Tuple2 kv) {
        return props$1.setProperty((String)kv._1(), (String)kv._2());
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ Iterator $anonfun$buildReaderWithPartitionValues$4(HoodieFileGroupReaderBasedFileFormat $this, Broadcast broadcastedStorageConf$1, boolean isCount$1, StructType requiredSchema$2, Broadcast fileGroupBaseFileReader$1, Seq filters$1, HoodieTableMetaClient metaClient$1, scala.collection.immutable.Map options$1, long maxMemoryPerCompaction$1, Schema dataAvroSchema$1, Schema requestedAvroSchema$1, StructType requestedSchema$1, StructType remainingPartitionSchema$1, StructType outputSchema$1, Set fixedPartitionIndexes$1, Broadcast baseFileReader$1, StructType partitionSchema$2, TypedProperties fileIndexProps$1, PartitionedFile file) {
        block5: {
            block4: {
                storageConf = new HadoopStorageConfiguration(((SerializableConfiguration)broadcastedStorageConf$1.value()).value());
                var24_20 = file.partitionValues();
                if (!(var24_20 instanceof HoodiePartitionFileSliceMapping)) break block4;
                var25_21 = (HoodiePartitionFileSliceMapping)var24_20;
                fileGroupName = FSUtils.getFileIdFromFilePath((StoragePath)$this.sparkAdapter().getSparkPartitionedFileUtils().getPathFromPartitionedFile(file));
                var27_23 = var25_21.getSlice(fileGroupName);
                if (!(var27_23 instanceof Some)) ** GOTO lbl-1000
                var28_24 = (Some)var27_23;
                fileSlice = (FileSlice)var28_24.value();
                if (!isCount$1 && (requiredSchema$2.nonEmpty() || fileSlice.getLogFiles().findAny().isPresent())) {
                    readerContext = new SparkFileFormatInternalRowReaderContext((SparkColumnarFileReader)fileGroupBaseFileReader$1.value(), filters$1, $this.requiredFilters, (StorageConfiguration)storageConf, metaClient$1.getTableConfig());
                    readerContext.setEnableLogicalTimestampFieldRepair(storageConf.getBoolean("spark.hudi.logicalTimestampField.repair.enable", true));
                    props = metaClient$1.getTableConfig().getProps();
                    options$1.foreach((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$buildReaderWithPartitionValues$5(org.apache.hudi.common.config.TypedProperties scala.Tuple2 ), (Lscala/Tuple2;)Ljava/lang/Object;)((TypedProperties)props));
                    props.put((Object)HoodieMemoryConfig.MAX_MEMORY_FOR_MERGE.key(), (Object)String.valueOf(maxMemoryPerCompaction$1));
                    baseFileLength = fileSlice.getBaseFile().isPresent() != false ? ((BaseFile)fileSlice.getBaseFile().get()).getFileSize() : 0L;
                    reader = HoodieFileGroupReader.newBuilder().withReaderContext((HoodieReaderContext)readerContext).withHoodieTableMetaClient(metaClient$1).withLatestCommitTime($this.queryTimestamp).withFileSlice(fileSlice).withDataSchema(dataAvroSchema$1).withRequestedSchema(requestedAvroSchema$1).withInternalSchema($this.internalSchemaOpt()).withProps(props).withStart(file.start()).withLength(baseFileLength).withShouldUseRecordPosition($this.shouldUseRecordPosition).build();
                    v0 = $this.appendPartitionAndProject((ClosableIterator<InternalRow>)reader.getClosableIterator(), requestedSchema$1, remainingPartitionSchema$1, outputSchema$1, var25_21.getPartitionValues(), (Set<Object>)fixedPartitionIndexes$1);
                } else lbl-1000:
                // 2 sources

                {
                    v0 = $this.readBaseFile(file, (SparkColumnarFileReader)baseFileReader$1.value(), requestedSchema$1, remainingPartitionSchema$1, (Set<Object>)fixedPartitionIndexes$1, requiredSchema$2, partitionSchema$2, outputSchema$1, (Seq<Filter>)((Seq)filters$1.$plus$plus($this.requiredFilters, Seq$.MODULE$.canBuildFrom())), (StorageConfiguration<Configuration>)storageConf);
                }
                break block5;
            }
            if (var24_20 instanceof HoodiePartitionCDCFileGroupMapping) {
                var35_30 = (HoodiePartitionCDCFileGroupMapping)var24_20;
                v0 = $this.buildCDCRecordIterator(var35_30, (SparkColumnarFileReader)fileGroupBaseFileReader$1.value(), (StorageConfiguration<Configuration>)storageConf, fileIndexProps$1, requiredSchema$2, metaClient$1);
            } else {
                v0 = $this.readBaseFile(file, (SparkColumnarFileReader)baseFileReader$1.value(), requestedSchema$1, remainingPartitionSchema$1, (Set<Object>)fixedPartitionIndexes$1, requiredSchema$2, partitionSchema$2, outputSchema$1, (Seq<Filter>)((Seq)filters$1.$plus$plus($this.requiredFilters, Seq$.MODULE$.canBuildFrom())), (StorageConfiguration<Configuration>)storageConf);
            }
        }
        iter = v0;
        return CloseableIteratorListener.addListener(iter);
    }

    public HoodieFileGroupReaderBasedFileFormat(String tablePath, HoodieTableSchema tableSchema, String tableName, String queryTimestamp, Seq<String> mandatoryFields, boolean isMOR, boolean isBootstrap, boolean isIncremental, String validCommits, boolean shouldUseRecordPosition, Seq<Filter> requiredFilters, boolean isMultipleBaseFileFormatsEnabled, HoodieFileFormat hoodieFileFormat) {
        this.tablePath = tablePath;
        this.tableSchema = tableSchema;
        this.tableName = tableName;
        this.queryTimestamp = queryTimestamp;
        this.mandatoryFields = mandatoryFields;
        this.isMOR = isMOR;
        this.isBootstrap = isBootstrap;
        this.isIncremental = isIncremental;
        this.validCommits = validCommits;
        this.shouldUseRecordPosition = shouldUseRecordPosition;
        this.requiredFilters = requiredFilters;
        this.isMultipleBaseFileFormatsEnabled = isMultipleBaseFileFormatsEnabled;
        this.hoodieFileFormat = hoodieFileFormat;
        SparkAdapterSupport.$init$((SparkAdapterSupport)this);
        HoodieFormatTrait.$init$(this);
        this.sanitizedTableName = AvroSchemaUtils.getAvroRecordQualifiedName((String)tableName);
        this.supportVectorizedRead = false;
        this.supportReturningBatch = false;
    }
}

