/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.catalog;

import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.view.FileSystemViewManager;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.storage.StoragePath;
import org.apache.spark.api.java.JavaSparkContext$;
import org.apache.spark.sql.HoodieSparkCatalogUtils$MatchBucketTransform$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.connector.expressions.FieldReference;
import org.apache.spark.sql.connector.expressions.IdentityTransform;
import org.apache.spark.sql.connector.expressions.IdentityTransform$;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.connector.expressions.Transform;
import scala.Array$;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class HoodieCatalog$ {
    public static HoodieCatalog$ MODULE$;

    static {
        new HoodieCatalog$();
    }

    public Tuple2<Seq<String>, Option<BucketSpec>> convertTransforms(Seq<Transform> transforms) {
        ArrayBuffer identityCols = new ArrayBuffer();
        ObjectRef bucketSpec = ObjectRef.create((Object)Option$.MODULE$.empty());
        transforms.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Seq seq;
            Some some;
            FieldReference fieldReference;
            Transform transform = x0$1;
            Option option = IdentityTransform$.MODULE$.unapply(transform);
            if (!option.isEmpty() && (fieldReference = (FieldReference)option.get()) != null && !(some = Seq$.MODULE$.unapplySeq(seq = fieldReference.parts())).isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0) {
                String col = (String)((SeqLike)some.get()).apply(0);
                return identityCols.$plus$eq((Object)col);
            }
            Option<Tuple3<Object, Seq<NamedReference>, Seq<NamedReference>>> option2 = HoodieSparkCatalogUtils$MatchBucketTransform$.MODULE$.unapply(transform);
            if (!option2.isEmpty()) {
                int numBuckets = BoxesRunTime.unboxToInt((Object)((Tuple3)option2.get())._1());
                Seq col = (Seq)((Tuple3)option2.get())._2();
                Seq sortCol = (Seq)((Tuple3)option2.get())._3();
                if (((Option)bucketSpec$1.elem).nonEmpty()) {
                    throw new HoodieException("Multiple bucket transformations are not supported");
                }
                if (sortCol.isEmpty()) {
                    bucketSpec$1.elem = new Some((Object)new BucketSpec(numBuckets, (Seq)col.map((Function1 & Serializable & scala.Serializable)x$4 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$4.fieldNames())).mkString("."), Seq$.MODULE$.canBuildFrom()), (Seq)Nil$.MODULE$));
                    return BoxedUnit.UNIT;
                }
                bucketSpec$1.elem = new Some((Object)new BucketSpec(numBuckets, (Seq)col.map((Function1 & Serializable & scala.Serializable)x$5 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$5.fieldNames())).mkString("."), Seq$.MODULE$.canBuildFrom()), (Seq)sortCol.map((Function1 & Serializable & scala.Serializable)x$6 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$6.fieldNames())).mkString("."), Seq$.MODULE$.canBuildFrom())));
                return BoxedUnit.UNIT;
            }
            throw new HoodieException(new StringBuilder(50).append("Partitioning by transformation `").append(transform).append("` is not supported").toString());
        });
        return new Tuple2((Object)identityCols.toSeq(), (Object)((Option)bucketSpec.elem));
    }

    public boolean isTablePartitioned(Option<CatalogTable> table) {
        return table.exists((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)HoodieCatalog$.$anonfun$isTablePartitioned$1(x$7)));
    }

    public Transform[] buildPartitionTransforms(SparkSession spark, String basePath) {
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(HadoopFSUtils.getStorageConf((Configuration)spark.sessionState().newHadoopConf())).setBasePath(basePath).build();
        HoodieMetadataConfig metadataConfig = HoodieMetadataConfig.newBuilder().enable(true).build();
        HoodieTableFileSystemView metadataFileSystemView = FileSystemViewManager.createInMemoryFileSystemView((HoodieEngineContext)new HoodieSparkEngineContext(JavaSparkContext$.MODULE$.fromSparkContext(spark.sparkContext())), (HoodieTableMetaClient)metaClient, (HoodieMetadataConfig)metadataConfig);
        List partitions = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(metadataFileSystemView.getPartitionPaths()).asScala()).toList();
        Set transforms = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        partitions.foreach((Function1 & Serializable & scala.Serializable)path -> {
            HoodieCatalog$.$anonfun$buildPartitionTransforms$1(transforms, path);
            return BoxedUnit.UNIT;
        });
        return (Transform[])transforms.toArray(ClassTag$.MODULE$.apply(Transform.class));
    }

    public static final /* synthetic */ boolean $anonfun$isTablePartitioned$1(CatalogTable x$7) {
        return x$7.partitionColumnNames().nonEmpty();
    }

    public static final /* synthetic */ void $anonfun$buildPartitionTransforms$1(Set transforms$1, StoragePath path) {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])path.toString().split("/"))).foreach((Function1 & Serializable & scala.Serializable)part -> {
            String[] stringArray = part.split("=");
            Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
            if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(2) == 0) {
                String key = (String)((SeqLike)option.get()).apply(0);
                return transforms$1.$plus$eq((Object)new IdentityTransform((NamedReference)new FieldReference((Seq)new .colon.colon((Object)key, (List)Nil$.MODULE$))));
            }
            return BoxedUnit.UNIT;
        });
    }

    private HoodieCatalog$() {
        MODULE$ = this;
    }
}

