/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command;

import java.io.Serializable;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.InstantComparison;
import org.apache.hudi.common.util.VisibleForTesting;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.execution.metric.SQLMetrics$;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class HoodieCommandMetrics$ {
    public static HoodieCommandMetrics$ MODULE$;
    @VisibleForTesting
    private final String NUM_PARTITION_KEY;
    @VisibleForTesting
    private final String NUM_INSERT_FILE_KEY;
    @VisibleForTesting
    private final String NUM_UPDATE_FILE_KEY;
    @VisibleForTesting
    private final String NUM_WRITE_ROWS_KEY;
    @VisibleForTesting
    private final String NUM_UPDATE_ROWS_KEY;
    @VisibleForTesting
    private final String NUM_INSERT_ROWS_KEY;
    @VisibleForTesting
    private final String NUM_DELETE_ROWS_KEY;
    @VisibleForTesting
    private final String NUM_OUTPUT_BYTES_KEY;
    @VisibleForTesting
    private final String INSERT_TIME;
    @VisibleForTesting
    private final String UPSERT_TIME;

    static {
        new HoodieCommandMetrics$();
    }

    public void updateCommitMetrics(Map<String, SQLMetric> metrics, HoodieTableMetaClient metaClient, String commitInstantTime) {
        HoodieTimeline timeline = metaClient.getActiveTimeline().reload().getCommitsTimeline();
        Buffer commitInstant = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(timeline.getInstants()).asScala()).filter((Function1 & Serializable & scala.Serializable)instant -> BoxesRunTime.boxToBoolean((boolean)InstantComparison.EQUALS.test(instant.requestedTime(), commitInstantTime)));
        commitInstant.map((Function1 & Serializable & scala.Serializable)commit -> {
            HoodieCommandMetrics$.$anonfun$updateCommitMetrics$2(timeline, metrics, commit);
            return BoxedUnit.UNIT;
        }, Buffer$.MODULE$.canBuildFrom());
    }

    public void updateCommitMetrics(Map<String, SQLMetric> metrics, HoodieCommitMetadata metadata) {
        this.updateCommitMetric(metrics, this.NUM_PARTITION_KEY(), metadata.fetchTotalPartitionsWritten());
        this.updateCommitMetric(metrics, this.NUM_INSERT_FILE_KEY(), metadata.fetchTotalFilesInsert());
        this.updateCommitMetric(metrics, this.NUM_UPDATE_FILE_KEY(), metadata.fetchTotalFilesUpdated());
        this.updateCommitMetric(metrics, this.NUM_WRITE_ROWS_KEY(), metadata.fetchTotalRecordsWritten());
        this.updateCommitMetric(metrics, this.NUM_UPDATE_ROWS_KEY(), metadata.fetchTotalUpdateRecordsWritten());
        this.updateCommitMetric(metrics, this.NUM_INSERT_ROWS_KEY(), metadata.fetchTotalInsertRecordsWritten());
        this.updateCommitMetric(metrics, this.NUM_DELETE_ROWS_KEY(), metadata.getTotalRecordsDeleted());
        this.updateCommitMetric(metrics, this.NUM_OUTPUT_BYTES_KEY(), metadata.fetchTotalBytesWritten());
        this.updateCommitMetric(metrics, this.INSERT_TIME(), Predef$.MODULE$.Long2long(metadata.getTotalCreateTime()));
        this.updateCommitMetric(metrics, this.UPSERT_TIME(), Predef$.MODULE$.Long2long(metadata.getTotalUpsertTime()));
    }

    private void updateCommitMetric(Map<String, SQLMetric> metrics, String name, long value) {
        Option metric = metrics.get((Object)name);
        metric.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.set(value);
            return BoxedUnit.UNIT;
        });
    }

    public String NUM_PARTITION_KEY() {
        return this.NUM_PARTITION_KEY;
    }

    public String NUM_INSERT_FILE_KEY() {
        return this.NUM_INSERT_FILE_KEY;
    }

    public String NUM_UPDATE_FILE_KEY() {
        return this.NUM_UPDATE_FILE_KEY;
    }

    public String NUM_WRITE_ROWS_KEY() {
        return this.NUM_WRITE_ROWS_KEY;
    }

    public String NUM_UPDATE_ROWS_KEY() {
        return this.NUM_UPDATE_ROWS_KEY;
    }

    public String NUM_INSERT_ROWS_KEY() {
        return this.NUM_INSERT_ROWS_KEY;
    }

    public String NUM_DELETE_ROWS_KEY() {
        return this.NUM_DELETE_ROWS_KEY;
    }

    public String NUM_OUTPUT_BYTES_KEY() {
        return this.NUM_OUTPUT_BYTES_KEY;
    }

    public String INSERT_TIME() {
        return this.INSERT_TIME;
    }

    public String UPSERT_TIME() {
        return this.UPSERT_TIME;
    }

    public Map<String, SQLMetric> metrics() {
        SparkContext sparkContext = (SparkContext)SparkContext$.MODULE$.getActive().get();
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.NUM_PARTITION_KEY()), (Object)SQLMetrics$.MODULE$.createMetric(sparkContext, this.NUM_PARTITION_KEY())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.NUM_INSERT_FILE_KEY()), (Object)SQLMetrics$.MODULE$.createMetric(sparkContext, this.NUM_INSERT_FILE_KEY())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.NUM_UPDATE_FILE_KEY()), (Object)SQLMetrics$.MODULE$.createMetric(sparkContext, this.NUM_UPDATE_FILE_KEY())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.NUM_WRITE_ROWS_KEY()), (Object)SQLMetrics$.MODULE$.createMetric(sparkContext, this.NUM_WRITE_ROWS_KEY())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.NUM_UPDATE_ROWS_KEY()), (Object)SQLMetrics$.MODULE$.createMetric(sparkContext, this.NUM_UPDATE_ROWS_KEY())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.NUM_INSERT_ROWS_KEY()), (Object)SQLMetrics$.MODULE$.createMetric(sparkContext, this.NUM_INSERT_ROWS_KEY())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.NUM_DELETE_ROWS_KEY()), (Object)SQLMetrics$.MODULE$.createMetric(sparkContext, this.NUM_DELETE_ROWS_KEY())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.NUM_OUTPUT_BYTES_KEY()), (Object)SQLMetrics$.MODULE$.createSizeMetric(sparkContext, this.NUM_OUTPUT_BYTES_KEY(), SQLMetrics$.MODULE$.createSizeMetric$default$3())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.INSERT_TIME()), (Object)SQLMetrics$.MODULE$.createTimingMetric(sparkContext, this.INSERT_TIME(), SQLMetrics$.MODULE$.createTimingMetric$default$3())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.UPSERT_TIME()), (Object)SQLMetrics$.MODULE$.createTimingMetric(sparkContext, this.UPSERT_TIME(), SQLMetrics$.MODULE$.createTimingMetric$default$3()))}));
    }

    public static final /* synthetic */ void $anonfun$updateCommitMetrics$2(HoodieTimeline timeline$1, Map metrics$1, HoodieInstant commit) {
        HoodieCommitMetadata metadata = timeline$1.readCommitMetadata(commit);
        MODULE$.updateCommitMetrics((Map<String, SQLMetric>)metrics$1, metadata);
    }

    private HoodieCommandMetrics$() {
        MODULE$ = this;
        this.NUM_PARTITION_KEY = "number of written partitions";
        this.NUM_INSERT_FILE_KEY = "number of inserted files";
        this.NUM_UPDATE_FILE_KEY = "number of updated files";
        this.NUM_WRITE_ROWS_KEY = "number of written rows";
        this.NUM_UPDATE_ROWS_KEY = "number of updated rows";
        this.NUM_INSERT_ROWS_KEY = "number of inserted rows";
        this.NUM_DELETE_ROWS_KEY = "number of deleted rows";
        this.NUM_OUTPUT_BYTES_KEY = "output size in bytes";
        this.INSERT_TIME = "total insert time";
        this.UPSERT_TIME = "total upsert time";
    }
}

