/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command;

import java.io.Serializable;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.HoodieSparkSqlWriter$;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.hive.HiveSyncConfig;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.HoodieStorageUtils;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.apache.spark.api.java.JavaSparkContext$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.catalyst.trees.HoodieLeafLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.hudi.HoodieSqlCommonUtils$;
import org.apache.spark.sql.hudi.ProvidesHoodieConfig;
import org.apache.spark.sql.hudi.command.HoodieLeafRunnableCommand;
import org.apache.spark.sql.hudi.command.TruncateHoodieTableCommand$;
import org.apache.spark.sql.hudi.command.exception.HoodieAnalysisException;
import org.apache.spark.sql.hudi.command.exception.HoodieAnalysisException$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple4;
import scala.Tuple6;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u00055f\u0001B\f\u0019\u0001\u0016B\u0001\"\u0011\u0001\u0003\u0016\u0004%\tA\u0011\u0005\t\u000f\u0002\u0011\t\u0012)A\u0005\u0007\"A\u0001\n\u0001BK\u0002\u0013\u0005\u0011\n\u0003\u0005f\u0001\tE\t\u0015!\u0003K\u0011\u00151\u0007\u0001\"\u0001h\u0011\u0015Y\u0007\u0001\"\u0011m\u0011!y\b!!A\u0005\u0002\u0005\u0005\u0001\"CA\u0004\u0001E\u0005I\u0011AA\u0005\u0011%\ty\u0002AI\u0001\n\u0003\t\t\u0003C\u0005\u0002&\u0001\t\t\u0011\"\u0011\u0002(!I\u0011\u0011\b\u0001\u0002\u0002\u0013\u0005\u00111\b\u0005\n\u0003\u0007\u0002\u0011\u0011!C\u0001\u0003\u000bB\u0011\"!\u0015\u0001\u0003\u0003%\t%a\u0015\t\u0013\u0005\u0005\u0004!!A\u0005\u0002\u0005\r\u0004\"CA7\u0001\u0005\u0005I\u0011IA8\u000f%\t\u0019\bGA\u0001\u0012\u0003\t)H\u0002\u0005\u00181\u0005\u0005\t\u0012AA<\u0011\u00191\u0017\u0003\"\u0001\u0002\u0006\"I\u0011qQ\t\u0002\u0002\u0013\u0015\u0013\u0011\u0012\u0005\n\u0003\u0017\u000b\u0012\u0011!CA\u0003\u001bC\u0011\"a%\u0012\u0003\u0003%\t)!&\t\u0013\u0005\r\u0016#!A\u0005\n\u0005\u0015&A\u0007+sk:\u001c\u0017\r^3I_>$\u0017.\u001a+bE2,7i\\7nC:$'BA\r\u001b\u0003\u001d\u0019w.\\7b]\u0012T!a\u0007\u000f\u0002\t!,H-\u001b\u0006\u0003;y\t1a]9m\u0015\ty\u0002%A\u0003ta\u0006\u00148N\u0003\u0002\"E\u00051\u0011\r]1dQ\u0016T\u0011aI\u0001\u0004_J<7\u0001A\n\u0007\u0001\u0019\u0002D\u0007\u000f \u0011\u0005\u001drS\"\u0001\u0015\u000b\u0005%R\u0013a\u00027pO&\u001c\u0017\r\u001c\u0006\u0003W1\nQ\u0001\u001d7b]NT!!\f\u000f\u0002\u0011\r\fG/\u00197zgRL!a\f\u0015\u0003\u00171{w-[2bYBc\u0017M\u001c\t\u0003cIj\u0011\u0001G\u0005\u0003ga\u0011\u0011\u0004S8pI&,G*Z1g%Vtg.\u00192mK\u000e{W.\\1oIB\u0011QGN\u0007\u00025%\u0011qG\u0007\u0002\u0015!J|g/\u001b3fg\"{w\u000eZ5f\u0007>tg-[4\u0011\u0005ebT\"\u0001\u001e\u000b\u0003m\nQa]2bY\u0006L!!\u0010\u001e\u0003\u000fA\u0013x\u000eZ;diB\u0011\u0011hP\u0005\u0003\u0001j\u0012AbU3sS\u0006d\u0017N_1cY\u0016\fq\u0002^1cY\u0016LE-\u001a8uS\u001aLWM]\u000b\u0002\u0007B\u0011A)R\u0007\u0002Y%\u0011a\t\f\u0002\u0010)\u0006\u0014G.Z%eK:$\u0018NZ5fe\u0006\u0001B/\u00192mK&#WM\u001c;jM&,'\u000fI\u0001\u000ea\u0006\u0014H/\u001b;j_:\u001c\u0006/Z2\u0016\u0003)\u00032!O&N\u0013\ta%H\u0001\u0004PaRLwN\u001c\t\u0003\u001d\nt!aT0\u000f\u0005AkfBA)]\u001d\t\u00116L\u0004\u0002T5:\u0011A+\u0017\b\u0003+bk\u0011A\u0016\u0006\u0003/\u0012\na\u0001\u0010:p_Rt\u0014\"A\u0012\n\u0005\u0005\u0012\u0013BA\u0010!\u0013\tib$\u0003\u0002.9%\u0011a\fL\u0001\bG\u0006$\u0018\r\\8h\u0013\t\u0001\u0017-\u0001\u0007DCR\fGn\\4UsB,7O\u0003\u0002_Y%\u00111\r\u001a\u0002\u0013)\u0006\u0014G.\u001a)beRLG/[8o'B,7M\u0003\u0002aC\u0006q\u0001/\u0019:uSRLwN\\*qK\u000e\u0004\u0013A\u0002\u001fj]&$h\bF\u0002iS*\u0004\"!\r\u0001\t\u000b\u0005+\u0001\u0019A\"\t\u000b!+\u0001\u0019\u0001&\u0002\u0007I,h\u000e\u0006\u0002nuB\u0019an\u001d<\u000f\u0005=\fhBA+q\u0013\u0005Y\u0014B\u0001:;\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001^;\u0003\u0007M+\u0017O\u0003\u0002suA\u0011q\u000f_\u0007\u00029%\u0011\u0011\u0010\b\u0002\u0004%><\b\"B>\u0007\u0001\u0004a\u0018\u0001D:qCJ\\7+Z:tS>t\u0007CA<~\u0013\tqHD\u0001\u0007Ta\u0006\u00148nU3tg&|g.\u0001\u0003d_BLH#\u00025\u0002\u0004\u0005\u0015\u0001bB!\b!\u0003\u0005\ra\u0011\u0005\b\u0011\u001e\u0001\n\u00111\u0001K\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a\u0003+\u0007\r\u000bia\u000b\u0002\u0002\u0010A!\u0011\u0011CA\u000e\u001b\t\t\u0019B\u0003\u0003\u0002\u0016\u0005]\u0011!C;oG\",7m[3e\u0015\r\tIBO\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u000f\u0003'\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!a\t+\u0007)\u000bi!A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003S\u0001B!a\u000b\u000265\u0011\u0011Q\u0006\u0006\u0005\u0003_\t\t$\u0001\u0003mC:<'BAA\u001a\u0003\u0011Q\u0017M^1\n\t\u0005]\u0012Q\u0006\u0002\u0007'R\u0014\u0018N\\4\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005u\u0002cA\u001d\u0002@%\u0019\u0011\u0011\t\u001e\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005\u001d\u0013Q\n\t\u0004s\u0005%\u0013bAA&u\t\u0019\u0011I\\=\t\u0013\u0005=C\"!AA\u0002\u0005u\u0012a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002VA1\u0011qKA/\u0003\u000fj!!!\u0017\u000b\u0007\u0005m#(\u0001\u0006d_2dWm\u0019;j_:LA!a\u0018\u0002Z\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\t)'a\u001b\u0011\u0007e\n9'C\u0002\u0002ji\u0012qAQ8pY\u0016\fg\u000eC\u0005\u0002P9\t\t\u00111\u0001\u0002H\u00051Q-];bYN$B!!\u001a\u0002r!I\u0011qJ\b\u0002\u0002\u0003\u0007\u0011qI\u0001\u001b)J,hnY1uK\"{w\u000eZ5f)\u0006\u0014G.Z\"p[6\fg\u000e\u001a\t\u0003cE\u0019B!EA=}A9\u00111PAA\u0007*CWBAA?\u0015\r\tyHO\u0001\beVtG/[7f\u0013\u0011\t\u0019)! \u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007\u0006\u0002\u0002v\u0005AAo\\*ue&tw\r\u0006\u0002\u0002*\u0005)\u0011\r\u001d9msR)\u0001.a$\u0002\u0012\")\u0011\t\u0006a\u0001\u0007\")\u0001\n\u0006a\u0001\u0015\u00069QO\\1qa2LH\u0003BAL\u0003?\u0003B!O&\u0002\u001aB)\u0011(a'D\u0015&\u0019\u0011Q\u0014\u001e\u0003\rQ+\b\u000f\\33\u0011!\t\t+FA\u0001\u0002\u0004A\u0017a\u0001=%a\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\t9\u000b\u0005\u0003\u0002,\u0005%\u0016\u0002BAV\u0003[\u0011aa\u00142kK\u000e$\b")
public class TruncateHoodieTableCommand
extends LogicalPlan
implements HoodieLeafRunnableCommand,
ProvidesHoodieConfig,
scala.Serializable {
    private final TableIdentifier tableIdentifier;
    private final Option<Map<String, String>> partitionSpec;
    private Map<String, SQLMetric> metrics;
    private final Seq<Enumeration.Value> nodePatterns;
    private volatile boolean bitmap$0;

    public static Option<Tuple2<TableIdentifier, Option<Map<String, String>>>> unapply(TruncateHoodieTableCommand truncateHoodieTableCommand) {
        return TruncateHoodieTableCommand$.MODULE$.unapply(truncateHoodieTableCommand);
    }

    public static Function1<Tuple2<TableIdentifier, Option<Map<String, String>>>, TruncateHoodieTableCommand> tupled() {
        return TruncateHoodieTableCommand$.MODULE$.tupled();
    }

    public static Function1<TableIdentifier, Function1<Option<Map<String, String>>, TruncateHoodieTableCommand>> curried() {
        return TruncateHoodieTableCommand$.MODULE$.curried();
    }

    @Override
    public Map<String, String> buildHoodieConfig(HoodieCatalogTable hoodieCatalogTable) {
        return ProvidesHoodieConfig.buildHoodieConfig$(this, hoodieCatalogTable);
    }

    @Override
    public Map<String, String> buildBucketRescaleHoodieConfig(HoodieCatalogTable hoodieCatalogTable) {
        return ProvidesHoodieConfig.buildBucketRescaleHoodieConfig$(this, hoodieCatalogTable);
    }

    @Override
    public Map<String, String> buildHoodieInsertConfig(HoodieCatalogTable hoodieCatalogTable, SparkSession sparkSession, boolean isOverwritePartition, boolean isOverwriteTable, Map<String, Option<String>> insertPartitions, Map<String, String> extraOptions, Option<String> staticOverwritePartitionPathOpt) {
        return ProvidesHoodieConfig.buildHoodieInsertConfig$(this, hoodieCatalogTable, sparkSession, isOverwritePartition, isOverwriteTable, insertPartitions, extraOptions, staticOverwritePartitionPathOpt);
    }

    @Override
    public Map<String, Option<String>> buildHoodieInsertConfig$default$5() {
        return ProvidesHoodieConfig.buildHoodieInsertConfig$default$5$(this);
    }

    @Override
    public Option<String> buildHoodieInsertConfig$default$7() {
        return ProvidesHoodieConfig.buildHoodieInsertConfig$default$7$(this);
    }

    @Override
    public Map<String, String> getDropDupsConfig(boolean useLegacyInsertModeFlow, Map<String, String> incomingParams) {
        return ProvidesHoodieConfig.getDropDupsConfig$(this, useLegacyInsertModeFlow, incomingParams);
    }

    @Override
    public Tuple4<SaveMode, Object, Object, Option<String>> deduceOverwriteConfig(SparkSession sparkSession, HoodieCatalogTable catalogTable, Map<String, Option<String>> partitionSpec, Map<String, String> extraOptions) {
        return ProvidesHoodieConfig.deduceOverwriteConfig$(this, sparkSession, catalogTable, partitionSpec, extraOptions);
    }

    @Override
    public Map<String, String> buildHoodieDropPartitionsConfig(SparkSession sparkSession, HoodieCatalogTable hoodieCatalogTable, String partitionsToDrop) {
        return ProvidesHoodieConfig.buildHoodieDropPartitionsConfig$(this, sparkSession, hoodieCatalogTable, partitionsToDrop);
    }

    @Override
    public Map<String, String> buildHoodieDeleteTableConfig(HoodieCatalogTable hoodieCatalogTable, SparkSession sparkSession) {
        return ProvidesHoodieConfig.buildHoodieDeleteTableConfig$(this, hoodieCatalogTable, sparkSession);
    }

    @Override
    public HiveSyncConfig buildHiveSyncConfig(SparkSession sparkSession, HoodieCatalogTable hoodieCatalogTable, HoodieTableConfig tableConfig, Map<String, String> extraOptions) {
        return ProvidesHoodieConfig.buildHiveSyncConfig$(this, sparkSession, hoodieCatalogTable, tableConfig, extraOptions);
    }

    @Override
    public Map<String, String> buildHiveSyncConfig$default$4() {
        return ProvidesHoodieConfig.buildHiveSyncConfig$default$4$(this);
    }

    @Override
    public final Seq<LogicalPlan> children() {
        return HoodieLeafLike.children$(this);
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return HoodieLeafLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return HoodieLeafLike.withNewChildrenInternal$(this, newChildren);
    }

    public Seq<Attribute> output() {
        return Command.output$((Command)this);
    }

    public AttributeSet producedAttributes() {
        return Command.producedAttributes$((Command)this);
    }

    public Statistics stats() {
        return Command.stats$((Command)this);
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        TruncateHoodieTableCommand truncateHoodieTableCommand = this;
        synchronized (truncateHoodieTableCommand) {
            if (!this.bitmap$0) {
                this.metrics = RunnableCommand.metrics$((RunnableCommand)this);
                this.bitmap$0 = true;
            }
        }
        return this.metrics;
    }

    public Map<String, SQLMetric> metrics() {
        if (!this.bitmap$0) {
            return this.metrics$lzycompute();
        }
        return this.metrics;
    }

    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    public final void org$apache$spark$sql$catalyst$plans$logical$Command$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public TableIdentifier tableIdentifier() {
        return this.tableIdentifier;
    }

    public Option<Map<String, String>> partitionSpec() {
        return this.partitionSpec;
    }

    public Seq<Row> run(SparkSession sparkSession) {
        String fullTableName = new StringBuilder(1).append(this.tableIdentifier().database()).append(".").append(this.tableIdentifier().table()).toString();
        this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("start execute truncate table command for ").append(fullTableName).toString());
        HoodieCatalogTable hoodieCatalogTable = HoodieCatalogTable$.MODULE$.apply(sparkSession, this.tableIdentifier());
        SessionCatalog catalog = sparkSession.sessionState().catalog();
        CatalogTable table = catalog.getTableMetadata(this.tableIdentifier());
        String tableId = table.identifier().quotedString();
        CatalogTableType catalogTableType = table.tableType();
        CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.VIEW();
        if (!(catalogTableType != null ? !catalogTableType.equals(catalogTableType2) : catalogTableType2 != null)) {
            throw new HoodieAnalysisException(new StringBuilder(48).append("Operation not allowed: TRUNCATE TABLE on views: ").append(tableId).toString(), HoodieAnalysisException$.MODULE$.$lessinit$greater$default$2(), HoodieAnalysisException$.MODULE$.$lessinit$greater$default$3());
        }
        if (table.partitionColumnNames().isEmpty() && this.partitionSpec().isDefined()) {
            throw new HoodieAnalysisException(new StringBuilder(106).append("Operation not allowed: TRUNCATE TABLE ... PARTITION is not supported ").append("for tables that are not partitioned: ").append(tableId).toString(), HoodieAnalysisException$.MODULE$.$lessinit$greater$default$2(), HoodieAnalysisException$.MODULE$.$lessinit$greater$default$3());
        }
        String basePath = hoodieCatalogTable.tableLocation();
        TypedProperties properties = hoodieCatalogTable.tableConfig().getProps();
        if (this.partitionSpec().isEmpty()) {
            StoragePath targetPath = new StoragePath(basePath);
            HoodieSparkEngineContext engineContext = new HoodieSparkEngineContext(JavaSparkContext$.MODULE$.fromSparkContext(sparkSession.sparkContext()));
            HoodieStorage storage = HoodieStorageUtils.getStorage((String)basePath, (StorageConfiguration)HadoopFSUtils.getStorageConf((Configuration)sparkSession.sessionState().newHadoopConf()));
            FSUtils.deleteDir((HoodieEngineContext)engineContext, (HoodieStorage)storage, (StoragePath)targetPath, (int)sparkSession.sparkContext().defaultParallelism());
            HoodieTableMetaClient metaClient = HoodieTableMetaClient.newTableBuilder().fromProperties((Properties)properties).initTable(HadoopFSUtils.getStorageConf((Configuration)sparkSession.sessionState().newHadoopConf()), hoodieCatalogTable.tableLocation());
            hoodieCatalogTable.tableConfig().clearMetadataPartitions(metaClient);
        } else {
            Seq normalizedSpecs = (Seq)new .colon.colon((Object)((Map)this.partitionSpec().map((Function1 & Serializable & scala.Serializable)spec -> HoodieSqlCommonUtils$.MODULE$.normalizePartitionSpec(spec, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])hoodieCatalogTable.partitionFields()), hoodieCatalogTable.tableName(), (Function2<String, String, Object>)sparkSession.sessionState().conf().resolver())).get()), (List)Nil$.MODULE$);
            String partitionsToDrop = HoodieSqlCommonUtils$.MODULE$.getPartitionPathToDrop(hoodieCatalogTable, (Seq<Map<String, String>>)normalizedSpecs);
            Map<String, String> parameters = this.buildHoodieDropPartitionsConfig(sparkSession, hoodieCatalogTable, partitionsToDrop);
            Tuple6<Object, org.apache.hudi.common.util.Option<String>, org.apache.hudi.common.util.Option<String>, org.apache.hudi.common.util.Option<String>, SparkRDDWriteClient<?>, HoodieTableConfig> tuple6 = HoodieSparkSqlWriter$.MODULE$.write(sparkSession.sqlContext(), SaveMode.Append, parameters, (Dataset<Row>)sparkSession.emptyDataFrame(), HoodieSparkSqlWriter$.MODULE$.write$default$5(), HoodieSparkSqlWriter$.MODULE$.write$default$6(), HoodieSparkSqlWriter$.MODULE$.write$default$7());
            if (tuple6 == null) {
                throw new MatchError(tuple6);
            }
            boolean success = BoxesRunTime.unboxToBoolean((Object)tuple6._1());
            boolean success2 = success;
            if (!success2) {
                throw new HoodieException("Truncate Hoodie Table command failed");
            }
        }
        sparkSession.catalog().refreshTable(table.identifier().quotedString());
        this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Finish execute truncate table command for ").append(fullTableName).toString());
        return (Seq)Nil$.MODULE$;
    }

    public TruncateHoodieTableCommand copy(TableIdentifier tableIdentifier, Option<Map<String, String>> partitionSpec) {
        return new TruncateHoodieTableCommand(tableIdentifier, partitionSpec);
    }

    public TableIdentifier copy$default$1() {
        return this.tableIdentifier();
    }

    public Option<Map<String, String>> copy$default$2() {
        return this.partitionSpec();
    }

    public String productPrefix() {
        return "TruncateHoodieTableCommand";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.tableIdentifier();
            }
            case 1: {
                return this.partitionSpec();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof TruncateHoodieTableCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof TruncateHoodieTableCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        TruncateHoodieTableCommand truncateHoodieTableCommand = (TruncateHoodieTableCommand)x$1;
        TableIdentifier tableIdentifier = this.tableIdentifier();
        TableIdentifier tableIdentifier2 = truncateHoodieTableCommand.tableIdentifier();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        Option<Map<String, String>> option = this.partitionSpec();
        Option<Map<String, String>> option2 = truncateHoodieTableCommand.partitionSpec();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!truncateHoodieTableCommand.canEqual(this)) return false;
        return true;
    }

    public TruncateHoodieTableCommand(TableIdentifier tableIdentifier, Option<Map<String, String>> partitionSpec) {
        this.tableIdentifier = tableIdentifier;
        this.partitionSpec = partitionSpec;
        Command.$init$((Command)this);
        RunnableCommand.$init$((RunnableCommand)this);
        HoodieLeafLike.$init$(this);
        ProvidesHoodieConfig.$init$(this);
    }
}

