/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.internal;

import java.io.IOException;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.internal.HoodieWriterCommitMessage;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.commit.BucketBulkInsertDataInternalWriterHelper;
import org.apache.hudi.table.action.commit.BulkInsertDataInternalWriterHelper;
import org.apache.hudi.table.action.commit.ConsistentBucketBulkInsertDataInternalWriterHelper;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.sources.v2.writer.DataWriter;
import org.apache.spark.sql.sources.v2.writer.WriterCommitMessage;
import org.apache.spark.sql.types.StructType;

public class HoodieBulkInsertDataInternalWriter
implements DataWriter<InternalRow> {
    private final BulkInsertDataInternalWriterHelper bulkInsertWriterHelper;

    public HoodieBulkInsertDataInternalWriter(HoodieTable hoodieTable, HoodieWriteConfig writeConfig, String instantTime, int taskPartitionId, long taskId, long taskEpochId, StructType structType, boolean populateMetaFields, boolean arePartitionRecordsSorted) {
        this.bulkInsertWriterHelper = writeConfig.getIndexType() == HoodieIndex.IndexType.BUCKET ? (writeConfig.getBucketIndexEngineType() == HoodieIndex.BucketIndexEngineType.SIMPLE ? new BucketBulkInsertDataInternalWriterHelper(hoodieTable, writeConfig, instantTime, taskPartitionId, taskId, 0L, structType, populateMetaFields, arePartitionRecordsSorted) : new ConsistentBucketBulkInsertDataInternalWriterHelper(hoodieTable, writeConfig, instantTime, taskPartitionId, taskId, 0L, structType, populateMetaFields, arePartitionRecordsSorted)) : new BulkInsertDataInternalWriterHelper(hoodieTable, writeConfig, instantTime, taskPartitionId, taskId, 0L, structType, populateMetaFields, arePartitionRecordsSorted);
    }

    public void write(InternalRow record) throws IOException {
        this.bulkInsertWriterHelper.write(record);
    }

    public WriterCommitMessage commit() throws IOException {
        return new HoodieWriterCommitMessage(this.bulkInsertWriterHelper.getWriteStatuses());
    }

    public void abort() {
        this.bulkInsertWriterHelper.abort();
    }
}

