/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.internal;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.DataSourceUtils;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.internal.DataSourceInternalWriterHelper;
import org.apache.hudi.internal.HoodieBulkInsertDataInternalWriterFactory;
import org.apache.hudi.internal.HoodieWriterCommitMessage;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.sources.v2.DataSourceOptions;
import org.apache.spark.sql.sources.v2.writer.DataSourceWriter;
import org.apache.spark.sql.sources.v2.writer.DataWriterFactory;
import org.apache.spark.sql.sources.v2.writer.WriterCommitMessage;
import org.apache.spark.sql.types.StructType;

public class HoodieDataSourceInternalWriter
implements DataSourceWriter {
    private final String instantTime;
    private final HoodieWriteConfig writeConfig;
    private final StructType structType;
    private final DataSourceInternalWriterHelper dataSourceInternalWriterHelper;
    private final boolean populateMetaFields;
    private final Boolean arePartitionRecordsSorted;

    public HoodieDataSourceInternalWriter(String instantTime, HoodieWriteConfig writeConfig, StructType structType, SparkSession sparkSession, Configuration configuration, DataSourceOptions dataSourceOptions, boolean populateMetaFields, boolean arePartitionRecordsSorted) {
        this.instantTime = instantTime;
        this.writeConfig = writeConfig;
        this.structType = structType;
        this.populateMetaFields = populateMetaFields;
        this.arePartitionRecordsSorted = arePartitionRecordsSorted;
        Map extraMetadataMap = DataSourceUtils.getExtraMetadata((Map)dataSourceOptions.asMap());
        this.dataSourceInternalWriterHelper = new DataSourceInternalWriterHelper(instantTime, writeConfig, structType, sparkSession, configuration, extraMetadataMap);
    }

    public DataWriterFactory<InternalRow> createWriterFactory() {
        this.dataSourceInternalWriterHelper.createInflightCommit();
        if (WriteOperationType.BULK_INSERT == this.dataSourceInternalWriterHelper.getWriteOperationType()) {
            return new HoodieBulkInsertDataInternalWriterFactory(this.dataSourceInternalWriterHelper.getHoodieTable(), this.writeConfig, this.instantTime, this.structType, this.populateMetaFields, this.arePartitionRecordsSorted);
        }
        throw new IllegalArgumentException("Write Operation Type + " + this.dataSourceInternalWriterHelper.getWriteOperationType() + " not supported ");
    }

    public boolean useCommitCoordinator() {
        return this.dataSourceInternalWriterHelper.useCommitCoordinator();
    }

    public void onDataWriterCommit(WriterCommitMessage message) {
        this.dataSourceInternalWriterHelper.onDataWriterCommit(message.toString());
    }

    public void commit(WriterCommitMessage[] messages) {
        List writeStatuses = Arrays.stream(messages).map(m -> (HoodieWriterCommitMessage)((Object)m)).flatMap(m -> m.getWriteStatuses().stream()).collect(Collectors.toList());
        this.dataSourceInternalWriterHelper.commit(writeStatuses);
    }

    public void abort(WriterCommitMessage[] messages) {
        this.dataSourceInternalWriterHelper.abort();
    }
}

