/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import org.apache.hudi.SparkHoodieTableFileIndex;
import org.apache.spark.sql.HoodieCatalystPlansUtils;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.SimpleAnalyzer$;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.optimizer.SimplifyCasts$;
import org.apache.spark.sql.catalyst.planning.PhysicalOperation$;
import org.apache.spark.sql.catalyst.plans.JoinType;
import org.apache.spark.sql.catalyst.plans.logical.InsertIntoTable;
import org.apache.spark.sql.catalyst.plans.logical.Join;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.MergeIntoTable;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.execution.command.AlterTableRecoverPartitionsCommand;
import org.apache.spark.sql.execution.command.ExplainCommand;
import org.apache.spark.sql.execution.command.ExplainCommand$;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.datasources.parquet.NewHoodieParquetFileFormat;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.sources.BaseRelation;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.Tuple5;
import scala.Tuple6;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.runtime.BoxesRunTime;

public final class HoodieSpark2CatalystPlanUtils$
implements HoodieCatalystPlansUtils {
    public static final HoodieSpark2CatalystPlanUtils$ MODULE$;

    static {
        new HoodieSpark2CatalystPlanUtils$();
    }

    public void failAnalysisForMIT(Attribute a, String cols) {
        HoodieCatalystPlansUtils.class.failAnalysisForMIT((HoodieCatalystPlansUtils)this, (Attribute)a, (String)cols);
    }

    public Option<Tuple3<LogicalPlan, LogicalPlan, Expression>> unapplyMergeIntoTable(LogicalPlan plan) {
        None$ none$;
        LogicalPlan logicalPlan = plan;
        if (logicalPlan instanceof MergeIntoTable) {
            MergeIntoTable mergeIntoTable = (MergeIntoTable)logicalPlan;
            LogicalPlan targetTable = mergeIntoTable.targetTable();
            LogicalPlan sourceTable = mergeIntoTable.sourceTable();
            Expression mergeCondition = mergeIntoTable.mergeCondition();
            none$ = new Some((Object)new Tuple3((Object)targetTable, (Object)sourceTable, (Object)mergeCondition));
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public LogicalPlan resolveOutputColumns(String tableName, Seq<Attribute> expected, LogicalPlan query, boolean byName, SQLConf conf) {
        return SimplifyCasts$.MODULE$.apply(SimpleAnalyzer$.MODULE$.ResolveUpCast().apply(SimpleAnalyzer$.MODULE$.ResolveOutputRelation().resolveOutputColumns(tableName, expected, query, byName)));
    }

    public LogicalPlan createExplainCommand(LogicalPlan plan, boolean extended) {
        return new ExplainCommand(plan, extended, ExplainCommand$.MODULE$.apply$default$3(), ExplainCommand$.MODULE$.apply$default$4());
    }

    public Join createJoin(LogicalPlan left, LogicalPlan right, JoinType joinType) {
        return new Join(left, right, joinType, (Option)None$.MODULE$);
    }

    public Option<Tuple5<LogicalPlan, Map<String, Option<String>>, LogicalPlan, Object, Object>> unapplyInsertIntoStatement(LogicalPlan plan) {
        None$ none$;
        LogicalPlan logicalPlan = plan;
        if (logicalPlan instanceof InsertIntoTable) {
            InsertIntoTable insertIntoTable = (InsertIntoTable)logicalPlan;
            LogicalPlan table = insertIntoTable.table();
            Map partition = insertIntoTable.partition();
            LogicalPlan query = insertIntoTable.query();
            boolean overwrite = insertIntoTable.overwrite();
            boolean ifPartitionNotExists = insertIntoTable.ifPartitionNotExists();
            none$ = new Some((Object)new Tuple5((Object)table, (Object)partition, (Object)query, (Object)BoxesRunTime.boxToBoolean((boolean)overwrite), (Object)BoxesRunTime.boxToBoolean((boolean)ifPartitionNotExists)));
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public Option<Tuple6<TableIdentifier, TableIdentifier, CatalogStorageFormat, Option<String>, Map<String, String>, Object>> unapplyCreateTableLikeCommand(LogicalPlan plan) {
        return None$.MODULE$;
    }

    public LogicalPlan rebaseInsertIntoStatement(LogicalPlan iis, LogicalPlan targetTable, LogicalPlan query) {
        InsertIntoTable qual$1 = (InsertIntoTable)iis;
        LogicalPlan x$1 = targetTable;
        LogicalPlan x$2 = query;
        Map x$3 = qual$1.copy$default$2();
        boolean x$4 = qual$1.copy$default$4();
        boolean x$5 = qual$1.copy$default$5();
        return qual$1.copy(x$1, x$3, x$2, x$4, x$5);
    }

    public boolean isRepairTable(LogicalPlan plan) {
        return plan instanceof AlterTableRecoverPartitionsCommand;
    }

    public Option<Tuple4<TableIdentifier, Object, Object, String>> getRepairTableChildren(LogicalPlan plan) {
        LogicalPlan logicalPlan = plan;
        if (logicalPlan instanceof AlterTableRecoverPartitionsCommand) {
            AlterTableRecoverPartitionsCommand alterTableRecoverPartitionsCommand = (AlterTableRecoverPartitionsCommand)logicalPlan;
            Some some = new Some((Object)new Tuple4((Object)alterTableRecoverPartitionsCommand.tableName(), (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)alterTableRecoverPartitionsCommand.cmd()));
            return some;
        }
        throw new MatchError((Object)logicalPlan);
    }

    public LogicalPlan createMITJoin(LogicalPlan left, LogicalPlan right, JoinType joinType, Option<Expression> condition, String hint) {
        return new Join(left, right, joinType, condition);
    }

    public LogicalPlan applyNewHoodieParquetFileFormatProjection(LogicalPlan plan) {
        LogicalPlan logicalPlan;
        HadoopFsRelation hadoopFsRelation;
        LogicalRelation logicalRelation;
        BaseRelation fs;
        LogicalPlan l;
        LogicalPlan logicalPlan2 = plan;
        Option option = PhysicalOperation$.MODULE$.unapply(logicalPlan2);
        if (!option.isEmpty() && (l = (LogicalPlan)((Tuple3)option.get())._3()) instanceof LogicalRelation && (fs = (logicalRelation = (LogicalRelation)l).relation()) instanceof HadoopFsRelation && (hadoopFsRelation = (HadoopFsRelation)fs).fileFormat() instanceof NewHoodieParquetFileFormat && !((NewHoodieParquetFileFormat)hadoopFsRelation.fileFormat()).isProjected()) {
            ((NewHoodieParquetFileFormat)hadoopFsRelation.fileFormat()).isProjected_$eq(true);
            logicalPlan = new Project(logicalRelation.resolve(((SparkHoodieTableFileIndex)hadoopFsRelation.location()).schema(), hadoopFsRelation.sparkSession().sessionState().analyzer().resolver()), logicalPlan2);
        } else {
            logicalPlan = plan;
        }
        return logicalPlan;
    }

    public Option<Tuple6<LogicalPlan, String, String, Object, Seq<Tuple2<Seq<String>, Map<String, String>>>, Map<String, String>>> unapplyCreateIndex(LogicalPlan plan) {
        return None$.MODULE$;
    }

    public Option<Tuple3<LogicalPlan, String, Object>> unapplyDropIndex(LogicalPlan plan) {
        return None$.MODULE$;
    }

    public Option<Tuple2<LogicalPlan, Seq<Attribute>>> unapplyShowIndexes(LogicalPlan plan) {
        return None$.MODULE$;
    }

    public Option<Tuple2<LogicalPlan, String>> unapplyRefreshIndex(LogicalPlan plan) {
        return None$.MODULE$;
    }

    private HoodieSpark2CatalystPlanUtils$() {
        MODULE$ = this;
        HoodieCatalystPlansUtils.class.$init$((HoodieCatalystPlansUtils)this);
    }
}

