/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.avro;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.avro.Conversions;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.util.Utf8;
import org.apache.spark.sql.avro.IncompatibleSchemaException;
import org.apache.spark.sql.avro.IncompatibleSchemaException$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.SpecializedGetters;
import org.apache.spark.sql.catalyst.expressions.SpecificInternalRow;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005=b\u0001B\b\u0011\u0001mA\u0001B\t\u0001\u0003\u0002\u0003\u0006Ia\t\u0005\tS\u0001\u0011\t\u0011)A\u0005U!Aq\u0006\u0001B\u0001B\u0003%\u0001\u0007C\u00034\u0001\u0011\u0005A\u0007C\u0003;\u0001\u0011\u00051\bC\u0004B\u0001\t\u0007I\u0011\u0002\"\t\r\u0019\u0003\u0001\u0015!\u0003D\u000b\u00119\u0005\u0001\u0002%\t\u0011Y\u0003\u0001R1A\u0005\n]CQ\u0001\u001b\u0001\u0005\n%DQ\u0001\u001d\u0001\u0005\nEDq!a\u0005\u0001\t\u0013\t)\u0002C\u0004\u0002 \u0001!I!!\t\t\u000f\u0005\u001d\u0002\u0001\"\u0003\u0002*\tq\u0011I\u001e:p'\u0016\u0014\u0018.\u00197ju\u0016\u0014(BA\t\u0013\u0003\u0011\tgO]8\u000b\u0005M!\u0012aA:rY*\u0011QCF\u0001\u0006gB\f'o\u001b\u0006\u0003/a\ta!\u00199bG\",'\"A\r\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001a\u0002CA\u000f!\u001b\u0005q\"\"A\u0010\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0005r\"AB!osJ+g-\u0001\ts_>$8)\u0019;bYf\u001cH\u000fV=qKB\u0011AeJ\u0007\u0002K)\u0011aEE\u0001\u0006if\u0004Xm]\u0005\u0003Q\u0015\u0012\u0001\u0002R1uCRK\b/Z\u0001\re>|G/\u0011<s_RK\b/\u001a\t\u0003W5j\u0011\u0001\f\u0006\u0003#YI!A\f\u0017\u0003\rM\u001b\u0007.Z7b\u0003!qW\u000f\u001c7bE2,\u0007CA\u000f2\u0013\t\u0011dDA\u0004C_>dW-\u00198\u0002\rqJg.\u001b;?)\u0011)t\u0007O\u001d\u0011\u0005Y\u0002Q\"\u0001\t\t\u000b\t\"\u0001\u0019A\u0012\t\u000b%\"\u0001\u0019\u0001\u0016\t\u000b=\"\u0001\u0019\u0001\u0019\u0002\u0013M,'/[1mSj,GC\u0001\u001f@!\tiR(\u0003\u0002?=\t\u0019\u0011I\\=\t\u000b\u0001+\u0001\u0019\u0001\u001f\u0002\u0019\r\fG/\u00197zgR$\u0015\r^1\u0002\u0013\r|gN^3si\u0016\u0014X#A\"\u0011\tu!E\bP\u0005\u0003\u000bz\u0011\u0011BR;oGRLwN\\\u0019\u0002\u0015\r|gN^3si\u0016\u0014\bEA\u0005D_:4XM\u001d;feB)Q$S&Ty%\u0011!J\b\u0002\n\rVt7\r^5p]J\u0002\"\u0001T)\u000e\u00035S!AT(\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003!J\t\u0001bY1uC2L8\u000f^\u0005\u0003%6\u0013!c\u00159fG&\fG.\u001b>fI\u001e+G\u000f^3sgB\u0011Q\u0004V\u0005\u0003+z\u00111!\u00138u\u0003I!WmY5nC2\u001cuN\u001c<feNLwN\\:\u0016\u0003a\u0003\"!W3\u000f\u0005i\u001bgBA.c\u001d\ta\u0016M\u0004\u0002^A6\taL\u0003\u0002`5\u00051AH]8pizJ\u0011!G\u0005\u0003/aI!!\u0005\f\n\u0005\u0011d\u0013aC\"p]Z,'o]5p]NL!AZ4\u0003#\u0011+7-[7bY\u000e{gN^3sg&|gN\u0003\u0002eY\u0005aa.Z<D_:4XM\u001d;feR\u0019!\u000e\u001c8\u0011\u0005-DQ\"\u0001\u0001\t\u000b5T\u0001\u0019A\u0012\u0002\u0019\r\fG/\u00197zgR$\u0016\u0010]3\t\u000b=T\u0001\u0019\u0001\u0016\u0002\u0011\u00054(o\u001c+za\u0016\f!C\\3x'R\u0014Xo\u0019;D_:4XM\u001d;feR)!/!\u0002\u0002\u0010A!Q\u0004R:x!\t!X/D\u0001P\u0013\t1xJA\u0006J]R,'O\\1m%><\bC\u0001=\u0000\u001d\tIHP\u0004\u0002[u&\u00111\u0010L\u0001\bO\u0016tWM]5d\u0013\tih0A\u0006HK:,'/[2ECR\f'BA>-\u0013\u0011\t\t!a\u0001\u0003\rI+7m\u001c:e\u0015\tih\u0010C\u0004\u0002\b-\u0001\r!!\u0003\u0002\u001d\r\fG/\u00197zgR\u001cFO];diB\u0019A%a\u0003\n\u0007\u00055QE\u0001\u0006TiJ,8\r\u001e+za\u0016Da!!\u0005\f\u0001\u0004Q\u0013AC1we>\u001cFO];di\u0006\tb.Z<V]&|gnQ8om\u0016\u0014H/\u001a:\u0015\r\u0005]\u0011\u0011DA\u000e!\u0011iBi\u001d\u001f\t\u000f\u0005\u001dA\u00021\u0001\u0002\n!1\u0011Q\u0004\u0007A\u0002)\n\u0011\"\u0019<s_Vs\u0017n\u001c8\u0002\u0017\r\fg.T1q+:LwN\u001c\u000b\u0006a\u0005\r\u0012Q\u0005\u0005\b\u0003\u000fi\u0001\u0019AA\u0005\u0011\u0019\t\t\"\u0004a\u0001U\u0005\u0019\"/Z:pYZ,g*\u001e7mC\ndW\rV=qKR)!&a\u000b\u0002.!)qN\u0004a\u0001U!)qF\u0004a\u0001a\u0001")
public class AvroSerializer {
    private Conversions.DecimalConversion decimalConversions;
    private final Function1<Object, Object> converter;
    private volatile boolean bitmap$0;

    public Object serialize(Object catalystData) {
        return this.converter().apply(catalystData);
    }

    private Function1<Object, Object> converter() {
        return this.converter;
    }

    private Conversions.DecimalConversion decimalConversions$lzycompute() {
        AvroSerializer avroSerializer = this;
        synchronized (avroSerializer) {
            if (!this.bitmap$0) {
                this.decimalConversions = new Conversions.DecimalConversion();
                this.bitmap$0 = true;
            }
        }
        return this.decimalConversions;
    }

    private Conversions.DecimalConversion decimalConversions() {
        return !this.bitmap$0 ? this.decimalConversions$lzycompute() : this.decimalConversions;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Function2<SpecializedGetters, Object, Object> newConverter(DataType catalystType, Schema avroType) {
        Tuple2 tuple2 = new Tuple2((Object)catalystType, (Object)avroType.getType());
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (NullType$.MODULE$.equals(dataType) && Schema.Type.NULL.equals(type)) {
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$1(getter, BoxesRunTime.unboxToInt((Object)ordinal));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (BooleanType$.MODULE$.equals(dataType) && Schema.Type.BOOLEAN.equals(type)) {
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> BoxesRunTime.boxToBoolean((boolean)getter.getBoolean(BoxesRunTime.unboxToInt((Object)ordinal)));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (ByteType$.MODULE$.equals(dataType) && Schema.Type.INT.equals(type)) {
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> BoxesRunTime.boxToInteger((int)getter.getByte(BoxesRunTime.unboxToInt((Object)ordinal)));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (ShortType$.MODULE$.equals(dataType) && Schema.Type.INT.equals(type)) {
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> BoxesRunTime.boxToInteger((int)getter.getShort(BoxesRunTime.unboxToInt((Object)ordinal)));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (IntegerType$.MODULE$.equals(dataType) && Schema.Type.INT.equals(type)) {
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> BoxesRunTime.boxToInteger((int)getter.getInt(BoxesRunTime.unboxToInt((Object)ordinal)));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (LongType$.MODULE$.equals(dataType) && Schema.Type.LONG.equals(type)) {
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> BoxesRunTime.boxToLong((long)getter.getLong(BoxesRunTime.unboxToInt((Object)ordinal)));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (FloatType$.MODULE$.equals(dataType) && Schema.Type.FLOAT.equals(type)) {
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> BoxesRunTime.boxToFloat((float)getter.getFloat(BoxesRunTime.unboxToInt((Object)ordinal)));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (DoubleType$.MODULE$.equals(dataType) && Schema.Type.DOUBLE.equals(type)) {
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> BoxesRunTime.boxToDouble((double)getter.getDouble(BoxesRunTime.unboxToInt((Object)ordinal)));
            }
        }
        if (tuple2 != null) {
            DataType d = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (d instanceof DecimalType) {
                DecimalType decimalType = (DecimalType)d;
                if (Schema.Type.FIXED.equals(type)) {
                    LogicalType logicalType = avroType.getLogicalType();
                    LogicalTypes.Decimal decimal = LogicalTypes.decimal((int)decimalType.precision(), (int)decimalType.scale());
                    if (logicalType == null) {
                        if (decimal == null) return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$9(this, decimalType, avroType, getter, BoxesRunTime.unboxToInt((Object)ordinal));
                    } else if (logicalType.equals(decimal)) {
                        return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$9(this, decimalType, avroType, getter, BoxesRunTime.unboxToInt((Object)ordinal));
                    }
                }
            }
        }
        if (tuple2 != null) {
            DataType d = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (d instanceof DecimalType) {
                DecimalType decimalType = (DecimalType)d;
                if (Schema.Type.BYTES.equals(type)) {
                    LogicalType logicalType = avroType.getLogicalType();
                    LogicalTypes.Decimal decimal = LogicalTypes.decimal((int)decimalType.precision(), (int)decimalType.scale());
                    if (logicalType == null) {
                        if (decimal == null) return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$10(this, decimalType, avroType, getter, BoxesRunTime.unboxToInt((Object)ordinal));
                    } else if (logicalType.equals(decimal)) {
                        return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$10(this, decimalType, avroType, getter, BoxesRunTime.unboxToInt((Object)ordinal));
                    }
                }
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (StringType$.MODULE$.equals(dataType) && Schema.Type.ENUM.equals(type)) {
                Set enumSymbols = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(avroType.getEnumSymbols()).asScala()).toSet();
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$11(enumSymbols, avroType, getter, BoxesRunTime.unboxToInt((Object)ordinal));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (StringType$.MODULE$.equals(dataType) && Schema.Type.STRING.equals(type)) {
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$12(getter, BoxesRunTime.unboxToInt((Object)ordinal));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (BinaryType$.MODULE$.equals(dataType) && Schema.Type.FIXED.equals(type)) {
                int size = avroType.getFixedSize();
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$13(size, avroType, getter, BoxesRunTime.unboxToInt((Object)ordinal));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (BinaryType$.MODULE$.equals(dataType) && Schema.Type.BYTES.equals(type)) {
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$14(getter, BoxesRunTime.unboxToInt((Object)ordinal));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (DateType$.MODULE$.equals(dataType) && Schema.Type.INT.equals(type)) {
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> BoxesRunTime.boxToInteger((int)getter.getInt(BoxesRunTime.unboxToInt((Object)ordinal)));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (TimestampType$.MODULE$.equals(dataType) && Schema.Type.LONG.equals(type)) {
                Function2 & Serializable & scala.Serializable intersect;
                LogicalType logicalType = avroType.getLogicalType();
                if (logicalType instanceof LogicalTypes.TimestampMillis) {
                    intersect = (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> BoxesRunTime.boxToLong((long)AvroSerializer.$anonfun$newConverter$16(getter, BoxesRunTime.unboxToInt((Object)ordinal)));
                    return intersect;
                } else if (logicalType instanceof LogicalTypes.TimestampMicros) {
                    intersect = (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> BoxesRunTime.boxToLong((long)getter.getLong(BoxesRunTime.unboxToInt((Object)ordinal)));
                    return intersect;
                } else {
                    if (logicalType != null) throw new IncompatibleSchemaException(new StringBuilder(60).append("Cannot convert Catalyst Timestamp type to Avro logical type ").append(logicalType).toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
                    intersect = (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> BoxesRunTime.boxToLong((long)AvroSerializer.$anonfun$newConverter$18(getter, BoxesRunTime.unboxToInt((Object)ordinal)));
                }
                return intersect;
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (dataType instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType;
                DataType et = arrayType.elementType();
                boolean containsNull = arrayType.containsNull();
                if (Schema.Type.ARRAY.equals(type)) {
                    Function2<SpecializedGetters, Object, Object> elementConverter = this.newConverter(et, this.resolveNullableType(avroType.getElementType(), containsNull));
                    return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$19(containsNull, elementConverter, getter, BoxesRunTime.unboxToInt((Object)ordinal));
                }
            }
        }
        if (tuple2 != null) {
            DataType st = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (st instanceof StructType) {
                StructType structType = (StructType)st;
                if (Schema.Type.RECORD.equals(type)) {
                    Function1<InternalRow, GenericData.Record> structConverter = this.newStructConverter(structType, avroType);
                    int numFields = structType.length();
                    return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$20(structConverter, numFields, getter, BoxesRunTime.unboxToInt((Object)ordinal));
                }
            }
        }
        if (tuple2 != null) {
            DataType st = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (st instanceof StructType) {
                StructType structType = (StructType)st;
                if (Schema.Type.UNION.equals(type)) {
                    Function1<InternalRow, Object> unionConverter = this.newUnionConverter(structType, avroType);
                    int numFields = structType.length();
                    return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> unionConverter.apply((Object)getter.getStruct(BoxesRunTime.unboxToInt((Object)ordinal), numFields));
                }
            }
        }
        if (tuple2 == null) throw new IncompatibleSchemaException(new StringBuilder(44).append("Cannot convert Catalyst type ").append(catalystType).append(" to ").append("Avro type ").append(avroType).append(".").toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
        DataType dataType = (DataType)tuple2._1();
        Schema.Type type = (Schema.Type)tuple2._2();
        if (!(dataType instanceof MapType)) throw new IncompatibleSchemaException(new StringBuilder(44).append("Cannot convert Catalyst type ").append(catalystType).append(" to ").append("Avro type ").append(avroType).append(".").toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
        MapType mapType = (MapType)dataType;
        DataType kt = mapType.keyType();
        DataType vt = mapType.valueType();
        boolean valueContainsNull = mapType.valueContainsNull();
        if (!Schema.Type.MAP.equals(type)) throw new IncompatibleSchemaException(new StringBuilder(44).append("Cannot convert Catalyst type ").append(catalystType).append(" to ").append("Avro type ").append(avroType).append(".").toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
        DataType dataType2 = kt;
        StringType$ stringType$ = StringType$.MODULE$;
        if (dataType2 == null) {
            if (stringType$ != null) {
                throw new IncompatibleSchemaException(new StringBuilder(44).append("Cannot convert Catalyst type ").append(catalystType).append(" to ").append("Avro type ").append(avroType).append(".").toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
            }
        } else if (!dataType2.equals(stringType$)) throw new IncompatibleSchemaException(new StringBuilder(44).append("Cannot convert Catalyst type ").append(catalystType).append(" to ").append("Avro type ").append(avroType).append(".").toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
        Function2<SpecializedGetters, Object, Object> valueConverter = this.newConverter(vt, this.resolveNullableType(avroType.getValueType(), valueContainsNull));
        return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$22(valueContainsNull, valueConverter, getter, BoxesRunTime.unboxToInt((Object)ordinal));
    }

    private Function1<InternalRow, GenericData.Record> newStructConverter(StructType catalystStruct, Schema avroStruct) {
        Schema.Type type = avroStruct.getType();
        Schema.Type type2 = Schema.Type.RECORD;
        if ((type != null ? !type.equals(type2) : type2 != null) || avroStruct.getFields().size() != catalystStruct.length()) {
            throw new IncompatibleSchemaException(new StringBuilder(44).append("Cannot convert Catalyst type ").append(catalystStruct).append(" to ").append("Avro type ").append(avroStruct).append(".").toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
        }
        Seq fieldConverters = (Seq)((TraversableLike)catalystStruct.zip((GenIterable)JavaConverters$.MODULE$.asScalaBufferConverter(avroStruct.getFields()).asScala(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            StructField f1 = (StructField)tuple2._1();
            Schema.Field f2 = (Schema.Field)tuple2._2();
            Function2<SpecializedGetters, Object, Object> function2 = this.newConverter(f1.dataType(), this.resolveNullableType(f2.schema(), f1.nullable()));
            return function2;
        }, Seq$.MODULE$.canBuildFrom());
        int numFields = catalystStruct.length();
        return (Function1 & Serializable & scala.Serializable)row -> {
            GenericData.Record result = new GenericData.Record(avroStruct);
            for (int i = 0; i < numFields; ++i) {
                if (row.isNullAt(i)) {
                    result.put(i, null);
                    continue;
                }
                result.put(i, ((Function2)fieldConverters.apply(i)).apply(row, (Object)BoxesRunTime.boxToInteger((int)i)));
            }
            return result;
        };
    }

    /*
     * Unable to fully structure code
     */
    private Function1<InternalRow, Object> newUnionConverter(StructType catalystStruct, Schema avroUnion) {
        v0 = avroUnion.getType();
        var3_3 = Schema.Type.UNION;
        if ((v0 != null ? v0.equals(var3_3) == false : var3_3 != null) || !this.canMapUnion(catalystStruct, avroUnion)) {
            throw new IncompatibleSchemaException(new StringBuilder(44).append("Cannot convert Catalyst type ").append(catalystStruct).append(" to ").append("Avro type ").append(avroUnion).append(".").toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
        }
        if (avroUnion.getTypes().size() <= 0) ** GOTO lbl-1000
        v1 = ((Schema)avroUnion.getTypes().get(0)).getType();
        var5_4 = Schema.Type.NULL;
        if (!(v1 != null ? v1.equals(var5_4) == false : var5_4 != null)) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = false;
        }
        nullable = v2;
        avroInnerTypes = nullable != false ? (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(avroUnion.getTypes()).asScala()).tail() : (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(avroUnion.getTypes()).asScala();
        fieldConverters = (Seq)((TraversableLike)catalystStruct.zip((GenIterable)avroInnerTypes, Seq$.MODULE$.canBuildFrom())).map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$newUnionConverter$1(org.apache.spark.sql.avro.AvroSerializer scala.Tuple2 ), (Lscala/Tuple2;)Lscala/Function2;)((AvroSerializer)this), Seq$.MODULE$.canBuildFrom());
        numFields = catalystStruct.length();
        return (Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$newUnionConverter$2(int org.apache.spark.sql.types.StructType org.apache.avro.Schema scala.collection.Seq boolean org.apache.spark.sql.catalyst.InternalRow ), (Lorg/apache/spark/sql/catalyst/InternalRow;)Ljava/lang/Object;)((int)numFields, (StructType)catalystStruct, (Schema)avroUnion, (Seq)fieldConverters, (boolean)nullable);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean canMapUnion(StructType catalystStruct, Schema avroStruct) {
        if (avroStruct.getTypes().size() > 0) {
            Schema.Type type = ((Schema)avroStruct.getTypes().get(0)).getType();
            Schema.Type type2 = Schema.Type.NULL;
            if (!(type != null ? !type.equals(type2) : type2 != null)) {
                if (avroStruct.getTypes().size() - 1 == catalystStruct.length()) return true;
            }
        }
        if (avroStruct.getTypes().size() != catalystStruct.length()) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Schema resolveNullableType(Schema avroType, boolean nullable) {
        Schema schema;
        if (nullable) {
            Schema.Type type = avroType.getType();
            Schema.Type type2 = Schema.Type.NULL;
            if (type == null ? type2 != null : !type.equals(type2)) {
                Buffer fields = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(avroType.getTypes()).asScala();
                Buffer actualType = (Buffer)fields.filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)AvroSerializer.$anonfun$resolveNullableType$1(x$1)));
                if (fields.length() == 2 && actualType.length() == 1) {
                    schema = (Schema)actualType.head();
                    return schema;
                }
                schema = avroType;
                return schema;
            }
        }
        schema = avroType;
        return schema;
    }

    public static final /* synthetic */ Null$ $anonfun$newConverter$1(SpecializedGetters getter, int ordinal) {
        return null;
    }

    public static final /* synthetic */ GenericFixed $anonfun$newConverter$9(AvroSerializer $this, DecimalType x56$1, Schema avroType$1, SpecializedGetters getter, int ordinal) {
        Decimal decimal = getter.getDecimal(ordinal, x56$1.precision(), x56$1.scale());
        return $this.decimalConversions().toFixed(decimal.toJavaBigDecimal(), avroType$1, (LogicalType)LogicalTypes.decimal((int)x56$1.precision(), (int)x56$1.scale()));
    }

    public static final /* synthetic */ ByteBuffer $anonfun$newConverter$10(AvroSerializer $this, DecimalType x58$1, Schema avroType$1, SpecializedGetters getter, int ordinal) {
        Decimal decimal = getter.getDecimal(ordinal, x58$1.precision(), x58$1.scale());
        return $this.decimalConversions().toBytes(decimal.toJavaBigDecimal(), avroType$1, (LogicalType)LogicalTypes.decimal((int)x58$1.precision(), (int)x58$1.scale()));
    }

    public static final /* synthetic */ GenericData.EnumSymbol $anonfun$newConverter$11(Set enumSymbols$1, Schema avroType$1, SpecializedGetters getter, int ordinal) {
        String data = getter.getUTF8String(ordinal).toString();
        if (!enumSymbols$1.contains((Object)data)) {
            throw new IncompatibleSchemaException(new StringBuilder(49).append("Cannot write \"").append(data).append("\" since it's not defined in enum \"").append(enumSymbols$1.mkString("\", \"")).append("\"").toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
        }
        return new GenericData.EnumSymbol(avroType$1, data);
    }

    public static final /* synthetic */ Utf8 $anonfun$newConverter$12(SpecializedGetters getter, int ordinal) {
        return new Utf8(getter.getUTF8String(ordinal).getBytes());
    }

    public static final /* synthetic */ GenericData.Fixed $anonfun$newConverter$13(int size$1, Schema avroType$1, SpecializedGetters getter, int ordinal) {
        byte[] data = getter.getBinary(ordinal);
        if (data.length != size$1) {
            throw new IncompatibleSchemaException(new StringBuilder(60).append("Cannot write ").append(data.length).append(" ").append((Object)(data.length > 1 ? "bytes" : "byte")).append(" of ").append("binary data into FIXED Type with size of ").append(size$1).append(" ").append((Object)(size$1 > 1 ? "bytes" : "byte")).toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
        }
        return new GenericData.Fixed(avroType$1, data);
    }

    public static final /* synthetic */ ByteBuffer $anonfun$newConverter$14(SpecializedGetters getter, int ordinal) {
        return ByteBuffer.wrap(getter.getBinary(ordinal));
    }

    public static final /* synthetic */ long $anonfun$newConverter$16(SpecializedGetters getter, int ordinal) {
        return getter.getLong(ordinal) / 1000L;
    }

    public static final /* synthetic */ long $anonfun$newConverter$18(SpecializedGetters getter, int ordinal) {
        return getter.getLong(ordinal) / 1000L;
    }

    public static final /* synthetic */ List $anonfun$newConverter$19(boolean containsNull$1, Function2 elementConverter$1, SpecializedGetters getter, int ordinal) {
        ArrayData arrayData = getter.getArray(ordinal);
        int len = arrayData.numElements();
        Object[] result = new Object[len];
        for (int i = 0; i < len; ++i) {
            result[i] = containsNull$1 && arrayData.isNullAt(i) ? null : elementConverter$1.apply((Object)arrayData, (Object)BoxesRunTime.boxToInteger((int)i));
        }
        return Arrays.asList(ScalaRunTime$.MODULE$.toObjectArray((Object)result));
    }

    public static final /* synthetic */ GenericData.Record $anonfun$newConverter$20(Function1 structConverter$1, int numFields$1, SpecializedGetters getter, int ordinal) {
        return (GenericData.Record)structConverter$1.apply((Object)getter.getStruct(ordinal, numFields$1));
    }

    public static final /* synthetic */ HashMap $anonfun$newConverter$22(boolean valueContainsNull$1, Function2 valueConverter$1, SpecializedGetters getter, int ordinal) {
        MapData mapData = getter.getMap(ordinal);
        int len = mapData.numElements();
        HashMap<String, Object> result = new HashMap<String, Object>(len);
        ArrayData keyArray = mapData.keyArray();
        ArrayData valueArray = mapData.valueArray();
        for (int i = 0; i < len; ++i) {
            String key = keyArray.getUTF8String(i).toString();
            Object object = valueContainsNull$1 && valueArray.isNullAt(i) ? result.put(key, null) : result.put(key, valueConverter$1.apply((Object)valueArray, (Object)BoxesRunTime.boxToInteger((int)i)));
        }
        return result;
    }

    public static final /* synthetic */ Function2 $anonfun$newUnionConverter$1(AvroSerializer $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        StructField f1 = (StructField)tuple2._1();
        Schema f2 = (Schema)tuple2._2();
        Function2<SpecializedGetters, Object, Object> function2 = $this.newConverter(f1.dataType(), f2);
        return function2;
    }

    public static final /* synthetic */ Object $anonfun$newUnionConverter$2(int numFields$4, StructType catalystStruct$1, Schema avroUnion$1, Seq fieldConverters$2, boolean nullable$1, InternalRow row) {
        Object result = null;
        for (int i = 0; i < numFields$4; ++i) {
            if (row.isNullAt(i)) continue;
            if (result != null) {
                throw new IncompatibleSchemaException(new StringBuilder(92).append("Cannot convert Catalyst record ").append(catalystStruct$1).append(" to ").append("Avro union ").append(avroUnion$1).append(". Record has more than one optional values set").toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
            }
            result = ((Function2)fieldConverters$2.apply(i)).apply((Object)row, (Object)BoxesRunTime.boxToInteger((int)i));
        }
        if (!nullable$1 && result == null) {
            throw new IncompatibleSchemaException(new StringBuilder(103).append("Cannot convert Catalyst record ").append(catalystStruct$1).append(" to ").append("Avro union ").append(avroUnion$1).append(". Record has no values set, while should have exactly one").toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
        }
        return result;
    }

    public static final /* synthetic */ boolean $anonfun$resolveNullableType$1(Schema x$1) {
        Schema.Type type = x$1.getType();
        Schema.Type type2 = Schema.Type.NULL;
        return type == null ? type2 != null : !type.equals(type2);
    }

    public AvroSerializer(DataType rootCatalystType, Schema rootAvroType, boolean nullable) {
        Function1 & Serializable & scala.Serializable intersect;
        Schema actualAvroType = this.resolveNullableType(rootAvroType, nullable);
        DataType dataType = rootCatalystType;
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            intersect = this.newStructConverter(structType, actualAvroType);
        } else {
            SpecificInternalRow tmpRow = new SpecificInternalRow((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DataType[]{rootCatalystType})));
            Function2<SpecializedGetters, Object, Object> converter = this.newConverter(rootCatalystType, actualAvroType);
            intersect = (Function1 & Serializable & scala.Serializable)data -> {
                tmpRow.update(0, data);
                return converter.apply((Object)tmpRow, (Object)BoxesRunTime.boxToInteger((int)0));
            };
        }
        Function1 & Serializable & scala.Serializable baseConverter = intersect;
        this.converter = nullable ? (Function1 & Serializable & scala.Serializable)data -> data == null ? null : baseConverter.apply(data) : baseConverter;
    }
}

