/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.com.fasterxml.jackson.module.afterburner.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import org.apache.hudi.com.fasterxml.jackson.module.afterburner.ser.BeanPropertyAccessor;
import org.apache.hudi.com.fasterxml.jackson.module.afterburner.ser.OptimizedBeanPropertyWriter;

public final class StringFieldPropertyWriter
extends OptimizedBeanPropertyWriter<StringFieldPropertyWriter> {
    private static final long serialVersionUID = 1L;

    public StringFieldPropertyWriter(BeanPropertyWriter src, BeanPropertyAccessor acc, int index, JsonSerializer<Object> ser) {
        super(src, acc, index, ser);
    }

    @Override
    public BeanPropertyWriter withSerializer(JsonSerializer<Object> ser) {
        return new StringFieldPropertyWriter(this, this._propertyAccessor, this._propertyIndex, ser);
    }

    @Override
    public StringFieldPropertyWriter withAccessor(BeanPropertyAccessor acc) {
        if (acc == null) {
            throw new IllegalArgumentException();
        }
        return new StringFieldPropertyWriter(this, acc, this._propertyIndex, (JsonSerializer<Object>)this._serializer);
    }

    @Override
    public final void serializeAsField(Object bean, JsonGenerator gen, SerializerProvider prov) throws Exception {
        String value;
        if (this.broken) {
            this.fallbackWriter.serializeAsField(bean, gen, prov);
            return;
        }
        try {
            value = this._propertyAccessor.stringField(bean, this._propertyIndex);
        }
        catch (Throwable t) {
            this._handleProblem(bean, gen, prov, t, false);
            return;
        }
        if (value == null) {
            if (this._suppressableValue != null && prov.includeFilterSuppressNulls(this._suppressableValue)) {
                return;
            }
            if (this._nullSerializer != null) {
                gen.writeFieldName(this._fastName);
                this._nullSerializer.serialize(null, gen, prov);
            }
            return;
        }
        if (this._suppressableValue != null && (MARKER_FOR_EMPTY == this._suppressableValue ? value.length() == 0 : this._suppressableValue.equals(value))) {
            return;
        }
        gen.writeFieldName(this._fastName);
        gen.writeString(value);
    }

    @Override
    public final void serializeAsElement(Object bean, JsonGenerator gen, SerializerProvider prov) throws Exception {
        String value;
        if (this.broken) {
            this.fallbackWriter.serializeAsElement(bean, gen, prov);
            return;
        }
        try {
            value = this._propertyAccessor.stringField(bean, this._propertyIndex);
        }
        catch (Throwable t) {
            this._handleProblem(bean, gen, prov, t, true);
            return;
        }
        if (this._suppressableValue != null) {
            if (MARKER_FOR_EMPTY == this._suppressableValue) {
                if (value.length() == 0) {
                    this.serializeAsPlaceholder(bean, gen, prov);
                    return;
                }
            } else if (this._suppressableValue.equals(value)) {
                this.serializeAsPlaceholder(bean, gen, prov);
                return;
            }
        }
        gen.writeString(value);
    }
}

