/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.model.HoodieAvroRecord;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieOperation;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordLocation;
import org.apache.hudi.common.model.MetadataValues;
import org.apache.hudi.common.model.RewriteAvroPayload;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.keygen.BaseKeyGenerator;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;

public class HoodieAvroIndexedRecord
extends HoodieRecord<IndexedRecord> {
    public HoodieAvroIndexedRecord(IndexedRecord data) {
        super(null, data);
    }

    public HoodieAvroIndexedRecord(HoodieKey key, IndexedRecord data) {
        super(key, data);
    }

    public HoodieAvroIndexedRecord(HoodieKey key, IndexedRecord data, HoodieRecordLocation currentLocation) {
        super(key, data, null, currentLocation, null);
    }

    public HoodieAvroIndexedRecord(IndexedRecord data, HoodieRecordLocation currentLocation) {
        super(null, data, null, currentLocation, null);
    }

    public HoodieAvroIndexedRecord(HoodieKey key, IndexedRecord data, HoodieOperation operation, Option<Map<String, String>> metaData) {
        super(key, data, operation, metaData);
    }

    public HoodieAvroIndexedRecord(HoodieRecord<IndexedRecord> record) {
        super(record);
    }

    public HoodieAvroIndexedRecord() {
    }

    @Override
    public HoodieRecord newInstance() {
        return new HoodieAvroIndexedRecord(this);
    }

    @Override
    public HoodieRecord<IndexedRecord> newInstance(HoodieKey key, HoodieOperation op) {
        return new HoodieAvroIndexedRecord(key, (IndexedRecord)this.data, op, (Option<Map<String, String>>)this.metaData);
    }

    @Override
    public HoodieRecord<IndexedRecord> newInstance(HoodieKey key) {
        return new HoodieAvroIndexedRecord(key, (IndexedRecord)this.data, this.operation, (Option<Map<String, String>>)this.metaData);
    }

    @Override
    public String getRecordKey(Schema recordSchema, Option<BaseKeyGenerator> keyGeneratorOpt) {
        return keyGeneratorOpt.isPresent() ? keyGeneratorOpt.get().getRecordKey((GenericRecord)this.data) : ((GenericRecord)this.data).get(HoodieRecord.RECORD_KEY_METADATA_FIELD).toString();
    }

    @Override
    public HoodieRecord.HoodieRecordType getRecordType() {
        return HoodieRecord.HoodieRecordType.AVRO;
    }

    @Override
    public String getRecordKey(Schema recordSchema, String keyFieldName) {
        return Option.ofNullable(((IndexedRecord)this.data).getSchema().getField(keyFieldName)).map(keyField -> ((IndexedRecord)this.data).get(keyField.pos())).map(Object::toString).orElse(null);
    }

    @Override
    public Object[] getColumnValues(Schema recordSchema, String[] columns, boolean consistentLogicalTimestampEnabled) {
        throw new UnsupportedOperationException();
    }

    @Override
    public HoodieRecord joinWith(HoodieRecord other, Schema targetSchema) {
        GenericRecord record = HoodieAvroUtils.stitchRecords((GenericRecord)this.data, (GenericRecord)other.getData(), targetSchema);
        return new HoodieAvroIndexedRecord(this.key, (IndexedRecord)record, this.operation, (Option<Map<String, String>>)this.metaData);
    }

    @Override
    public HoodieRecord prependMetaFields(Schema recordSchema, Schema targetSchema, MetadataValues metadataValues, Properties props) {
        GenericRecord newAvroRecord = HoodieAvroUtils.rewriteRecordWithNewSchema((IndexedRecord)this.data, targetSchema);
        HoodieAvroIndexedRecord.updateMetadataValuesInternal(newAvroRecord, metadataValues);
        return new HoodieAvroIndexedRecord(this.key, (IndexedRecord)newAvroRecord, this.operation, (Option<Map<String, String>>)this.metaData);
    }

    @Override
    public HoodieRecord rewriteRecordWithNewSchema(Schema recordSchema, Properties props, Schema newSchema, Map<String, String> renameCols) {
        GenericRecord record = HoodieAvroUtils.rewriteRecordWithNewSchema((IndexedRecord)this.data, newSchema, renameCols);
        return new HoodieAvroIndexedRecord(this.key, (IndexedRecord)record, this.operation, (Option<Map<String, String>>)this.metaData);
    }

    @Override
    public HoodieRecord truncateRecordKey(Schema recordSchema, Properties props, String keyFieldName) {
        ((GenericRecord)this.data).put(keyFieldName, (Object)"");
        return this;
    }

    @Override
    public boolean isDelete(Schema recordSchema, Properties props) {
        return false;
    }

    @Override
    public boolean shouldIgnore(Schema recordSchema, Properties props) throws IOException {
        return ((IndexedRecord)this.getData()).equals(SENTINEL);
    }

    @Override
    public HoodieRecord<IndexedRecord> copy() {
        return this;
    }

    @Override
    public HoodieRecord wrapIntoHoodieRecordPayloadWithParams(Schema recordSchema, Properties props, Option<Pair<String, String>> simpleKeyGenFieldsOpt, Boolean withOperation, Option<String> partitionNameOp, Boolean populateMetaFields, Option<Schema> schemaWithoutMetaFields) {
        String payloadClass = ConfigUtils.getPayloadClass(props);
        String preCombineField = ConfigUtils.getOrderingField(props);
        return HoodieAvroUtils.createHoodieRecordFromAvro((IndexedRecord)this.data, payloadClass, preCombineField, simpleKeyGenFieldsOpt, withOperation, partitionNameOp, populateMetaFields, schemaWithoutMetaFields);
    }

    @Override
    public HoodieRecord wrapIntoHoodieRecordPayloadWithKeyGen(Schema recordSchema, Properties props, Option<BaseKeyGenerator> keyGen) {
        String partition;
        String key;
        GenericRecord record = (GenericRecord)this.data;
        if (keyGen.isPresent() && !Boolean.parseBoolean(props.getOrDefault((Object)HoodieTableConfig.POPULATE_META_FIELDS.key(), HoodieTableConfig.POPULATE_META_FIELDS.defaultValue().toString()).toString())) {
            BaseKeyGenerator keyGeneratorOpt = keyGen.get();
            key = keyGeneratorOpt.getRecordKey(record);
            partition = keyGeneratorOpt.getPartitionPath(record);
        } else {
            key = record.get(HoodieRecord.RECORD_KEY_METADATA_FIELD).toString();
            partition = record.get(HoodieRecord.PARTITION_PATH_METADATA_FIELD).toString();
        }
        HoodieKey hoodieKey = new HoodieKey(key, partition);
        RewriteAvroPayload avroPayload = new RewriteAvroPayload(record);
        HoodieAvroRecord<RewriteAvroPayload> hoodieRecord = new HoodieAvroRecord<RewriteAvroPayload>(hoodieKey, avroPayload);
        return hoodieRecord;
    }

    @Override
    public Option<Map<String, String>> getMetadata() {
        return Option.empty();
    }

    @Override
    public Comparable<?> getOrderingValue(Schema recordSchema, Properties props) {
        String orderingField = ConfigUtils.getOrderingField(props);
        if (StringUtils.isNullOrEmpty(orderingField)) {
            return 0;
        }
        boolean consistentLogicalTimestampEnabled = Boolean.parseBoolean(props.getProperty(KeyGeneratorOptions.KEYGENERATOR_CONSISTENT_LOGICAL_TIMESTAMP_ENABLED.key(), KeyGeneratorOptions.KEYGENERATOR_CONSISTENT_LOGICAL_TIMESTAMP_ENABLED.defaultValue()));
        return (Comparable)HoodieAvroUtils.getNestedFieldVal((GenericRecord)this.data, orderingField, true, consistentLogicalTimestampEnabled);
    }

    @Override
    public Option<HoodieAvroIndexedRecord> toIndexedRecord(Schema recordSchema, Properties props) {
        return Option.of(this);
    }

    @Override
    protected final void writeRecordPayload(IndexedRecord payload, Kryo kryo, Output output) {
        Serializer avroSerializer = kryo.getSerializer(GenericRecord.class);
        kryo.writeObjectOrNull(output, (Object)payload, avroSerializer);
    }

    @Override
    protected final IndexedRecord readRecordPayload(Kryo kryo, Input input) {
        Serializer avroSerializer = kryo.getSerializer(GenericRecord.class);
        return (IndexedRecord)kryo.readObjectOrNull(input, GenericRecord.class, avroSerializer);
    }

    static void updateMetadataValuesInternal(GenericRecord avroRecord, MetadataValues metadataValues) {
        if (metadataValues.isEmpty()) {
            return;
        }
        String[] values2 = metadataValues.getValues();
        for (int pos = 0; pos < values2.length; ++pos) {
            String value = values2[pos];
            if (value == null) continue;
            avroRecord.put(HoodieRecord.HoodieMetadataField.values()[pos].getFieldName(), (Object)value);
        }
    }
}

