/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline.versioning.v2;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.hudi.avro.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieReplaceCommitMetadata;
import org.apache.hudi.common.table.timeline.CommitMetadataSerDe;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.MetadataConversionUtils;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.util.JsonUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;

public class CommitMetadataSerDeV2
implements CommitMetadataSerDe {
    @Override
    public <T> T deserialize(HoodieInstant instant, byte[] bytes, Class<T> clazz) throws IOException {
        try {
            if (bytes.length == 0) {
                return clazz.newInstance();
            }
            if (instant.isLegacy()) {
                try {
                    return CommitMetadataSerDeV2.fromJsonString(StringUtils.fromUTF8Bytes(bytes), clazz);
                }
                catch (Exception e) {
                    throw new IOException("unable to read legacy commit metadata for instant " + instant, e);
                }
            }
            return CommitMetadataSerDeV2.fromJsonString(StringUtils.fromUTF8Bytes(MetadataConversionUtils.convertCommitMetadataToJsonBytes(TimelineMetadataUtils.deserializeCommitMetadata(bytes), HoodieCommitMetadata.class)), clazz);
        }
        catch (Exception e) {
            throw new IOException("unable to read commit metadata for instant " + instant + " bytes length: " + bytes.length, e);
        }
    }

    public static <T> T fromJsonString(String jsonStr, Class<T> clazz) throws Exception {
        if (jsonStr == null || jsonStr.isEmpty()) {
            return clazz.newInstance();
        }
        return (T)JsonUtils.getObjectMapper().readValue(jsonStr, clazz);
    }

    @Override
    public Option<byte[]> serialize(org.apache.hudi.common.model.HoodieCommitMetadata commitMetadata) throws IOException {
        if (commitMetadata instanceof HoodieReplaceCommitMetadata) {
            return CommitMetadataSerDeV2.serializeAvroMetadata(MetadataConversionUtils.convertCommitMetadata(commitMetadata), org.apache.hudi.avro.model.HoodieReplaceCommitMetadata.class);
        }
        return CommitMetadataSerDeV2.serializeAvroMetadata(MetadataConversionUtils.convertCommitMetadata(commitMetadata), HoodieCommitMetadata.class);
    }

    public static <T extends SpecificRecordBase> Option<byte[]> serializeAvroMetadata(T metadata, Class<T> clazz) throws IOException {
        SpecificDatumWriter datumWriter = new SpecificDatumWriter(clazz);
        DataFileWriter fileWriter = new DataFileWriter((DatumWriter)datumWriter);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        fileWriter.create(metadata.getSchema(), (OutputStream)baos);
        fileWriter.append(metadata);
        fileWriter.flush();
        return Option.of(baos.toByteArray());
    }
}

