/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.config.HoodieReaderConfig;
import org.apache.hudi.common.config.PropertiesConfig;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.util.FileIOUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.exception.HoodieNotSupportedException;
import org.apache.hudi.exception.TableNotFoundException;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigUtils {
    public static final String STREAMER_CONFIG_PREFIX = "hoodie.streamer.";
    @Deprecated
    public static final String DELTA_STREAMER_CONFIG_PREFIX = "hoodie.deltastreamer.";
    public static final String SCHEMAPROVIDER_CONFIG_PREFIX = "hoodie.streamer.schemaprovider.";
    @Deprecated
    public static final String OLD_SCHEMAPROVIDER_CONFIG_PREFIX = "hoodie.deltastreamer.schemaprovider.";
    public static final String IS_QUERY_AS_RO_TABLE = "hoodie.query.as.ro.table";
    public static final String TABLE_SERDE_PATH = "path";
    public static final HoodieConfig DEFAULT_HUDI_CONFIG_FOR_READER = new HoodieConfig();
    private static final Logger LOG = LoggerFactory.getLogger(ConfigUtils.class);

    public static String getOrderingField(Properties properties) {
        String orderField = null;
        if (properties.containsKey("hoodie.payload.ordering.field")) {
            orderField = properties.getProperty("hoodie.payload.ordering.field");
        } else if (properties.containsKey("hoodie.datasource.write.precombine.field")) {
            orderField = properties.getProperty("hoodie.datasource.write.precombine.field");
        } else if (properties.containsKey(HoodieTableConfig.PRECOMBINE_FIELD.key())) {
            orderField = properties.getProperty(HoodieTableConfig.PRECOMBINE_FIELD.key());
        }
        return orderField;
    }

    public static String getPayloadClass(Properties properties) {
        return HoodieRecordPayload.getPayloadClassName(new HoodieConfig(properties));
    }

    public static List<String> split2List(String param) {
        return StringUtils.split(param, ",").stream().map(String::trim).distinct().collect(Collectors.toList());
    }

    public static Map<String, String> toMap(String keyValueConfig) {
        return ConfigUtils.toMap(keyValueConfig, "\n");
    }

    public static Map<String, String> toMap(String keyValueConfig, String separator) {
        if (StringUtils.isNullOrEmpty(keyValueConfig)) {
            return new HashMap<String, String>();
        }
        String[] keyvalues = keyValueConfig.split(separator);
        HashMap<String, String> tableProperties = new HashMap<String, String>();
        for (String keyValue : keyvalues) {
            if (keyValue.trim().isEmpty()) continue;
            String[] keyValueArray = keyValue.split("=");
            if (keyValueArray.length == 1 || keyValueArray.length == 2) {
                String key = keyValueArray[0].trim();
                String value = keyValueArray.length == 2 ? keyValueArray[1].trim() : "";
                tableProperties.put(key, value);
                continue;
            }
            throw new IllegalArgumentException("Bad key-value config: " + keyValue + ", must be the format 'key = value'");
        }
        return tableProperties;
    }

    public static String configToString(Map<String, String> config) {
        if (config == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : config.entrySet()) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(entry.getKey()).append("=").append(entry.getValue());
        }
        return sb.toString();
    }

    public static <T extends Enum<T>> T resolveEnum(Class<T> enumType, String name) {
        Enum[] enumConstants;
        for (Enum constant : enumConstants = (Enum[])enumType.getEnumConstants()) {
            if (!constant.name().equalsIgnoreCase(name)) continue;
            return (T)constant;
        }
        throw new IllegalArgumentException("No enum constant found " + enumType.getName() + "." + name);
    }

    public static <T extends Enum<T>> String[] enumNames(Class<T> enumType) {
        Enum[] enumConstants = (Enum[])enumType.getEnumConstants();
        return (String[])Arrays.stream(enumConstants).map(Enum::name).toArray(String[]::new);
    }

    public static Option<String> stripPrefix(String prop, ConfigProperty<String> prefixConfig) {
        if (prop.startsWith(prefixConfig.key())) {
            return Option.of(String.join((CharSequence)"", prop.split(prefixConfig.key())));
        }
        for (String altPrefix : prefixConfig.getAlternatives()) {
            if (!prop.startsWith(altPrefix)) continue;
            return Option.of(String.join((CharSequence)"", prop.split(altPrefix)));
        }
        return Option.empty();
    }

    public static boolean containsConfigProperty(TypedProperties props, ConfigProperty<?> configProperty) {
        if (!props.containsKey(configProperty.key())) {
            for (String alternative : configProperty.getAlternatives()) {
                if (!props.containsKey(alternative)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public static boolean containsConfigProperty(Map<String, Object> props, ConfigProperty<?> configProperty) {
        return ConfigUtils.containsConfigProperty(props::containsKey, configProperty);
    }

    public static boolean containsConfigProperty(Function<String, Boolean> keyExistsFn, ConfigProperty<?> configProperty) {
        if (!keyExistsFn.apply(configProperty.key()).booleanValue()) {
            for (String alternative : configProperty.getAlternatives()) {
                if (!keyExistsFn.apply(alternative).booleanValue()) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public static void checkRequiredProperties(TypedProperties props, List<String> checkPropNames) {
        checkPropNames.forEach(prop -> {
            if (!props.containsKey(prop)) {
                throw new HoodieNotSupportedException("Required property " + prop + " is missing");
            }
        });
    }

    public static void checkRequiredConfigProperties(TypedProperties props, List<ConfigProperty<?>> configPropertyList) {
        configPropertyList.forEach(configProperty -> {
            if (!ConfigUtils.containsConfigProperty(props, configProperty)) {
                throw new HoodieNotSupportedException("Required property " + configProperty.key() + " is missing");
            }
        });
    }

    public static Option<Object> getRawValueWithAltKeys(Properties props, ConfigProperty<?> configProperty) {
        if (props.containsKey(configProperty.key())) {
            return Option.ofNullable(props.get(configProperty.key()));
        }
        for (String alternative : configProperty.getAlternatives()) {
            if (!props.containsKey(alternative)) continue;
            LOG.warn(String.format("The configuration key '%s' has been deprecated and may be removed in the future. Please use the new key '%s' instead.", alternative, configProperty.key()));
            return Option.ofNullable(props.get(alternative));
        }
        return Option.empty();
    }

    public static String getStringWithAltKeys(Properties props, ConfigProperty<String> configProperty) {
        return ConfigUtils.getStringWithAltKeys(props, configProperty, false);
    }

    public static String getStringWithAltKeys(Properties props, ConfigProperty<String> configProperty, boolean useDefaultValue) {
        if (useDefaultValue) {
            return ConfigUtils.getStringWithAltKeys(props, configProperty, configProperty.hasDefaultValue() ? configProperty.defaultValue() : null);
        }
        Option<Object> rawValue = ConfigUtils.getRawValueWithAltKeys(props, configProperty);
        if (!rawValue.isPresent()) {
            throw new IllegalArgumentException("Property " + configProperty.key() + " not found");
        }
        return rawValue.get().toString();
    }

    public static String getStringWithAltKeys(Properties props, ConfigProperty<?> configProperty, String defaultValue) {
        Option<Object> rawValue = ConfigUtils.getRawValueWithAltKeys(props, configProperty);
        return rawValue.map(Object::toString).orElse(defaultValue);
    }

    public static String getStringWithAltKeys(Map<String, Object> props, ConfigProperty<?> configProperty) {
        return ConfigUtils.getStringWithAltKeys(props::get, configProperty);
    }

    public static String getStringWithAltKeys(Function<String, Object> keyMapper, ConfigProperty<?> configProperty) {
        Object value = keyMapper.apply(configProperty.key());
        if (value != null) {
            return value.toString();
        }
        for (String alternative : configProperty.getAlternatives()) {
            value = keyMapper.apply(alternative);
            if (value == null) continue;
            LOG.warn(String.format("The configuration key '%s' has been deprecated and may be removed in the future. Please use the new key '%s' instead.", alternative, configProperty.key()));
            return value.toString();
        }
        return configProperty.hasDefaultValue() ? configProperty.defaultValue().toString() : null;
    }

    public static String getStringWithAltKeys(TypedProperties props, String key, String altKey, String defaultValue) {
        if (props.containsKey(altKey)) {
            return props.getString(altKey);
        }
        if (props.containsKey(key)) {
            return props.getString(key);
        }
        return defaultValue;
    }

    public static boolean getBooleanWithAltKeys(Properties props, ConfigProperty<?> configProperty) {
        Option<Object> rawValue = ConfigUtils.getRawValueWithAltKeys(props, configProperty);
        boolean defaultValue = configProperty.hasDefaultValue() ? Boolean.parseBoolean(configProperty.defaultValue().toString()) : false;
        return rawValue.map(v -> Boolean.parseBoolean(v.toString())).orElse(defaultValue);
    }

    public static int getIntWithAltKeys(TypedProperties props, ConfigProperty<?> configProperty) {
        Option<Object> rawValue = ConfigUtils.getRawValueWithAltKeys(props, configProperty);
        int defaultValue = configProperty.hasDefaultValue() ? Integer.parseInt(configProperty.defaultValue().toString()) : 0;
        return rawValue.map(v -> Integer.parseInt(v.toString())).orElse(defaultValue);
    }

    public static long getLongWithAltKeys(TypedProperties props, ConfigProperty<Long> configProperty) {
        Option<Object> rawValue = ConfigUtils.getRawValueWithAltKeys(props, configProperty);
        long defaultValue = configProperty.hasDefaultValue() ? configProperty.defaultValue() : 0L;
        return rawValue.map(v -> Long.parseLong(v.toString())).orElse(defaultValue);
    }

    public static void removeConfigFromProps(TypedProperties props, ConfigProperty<?> configProperty) {
        props.remove(configProperty.key());
        for (String alternative : configProperty.getAlternatives()) {
            props.remove(alternative);
        }
    }

    public static Map<String, Object> filterProperties(TypedProperties props, List<ConfigProperty<String>> configPropertyList) {
        Set<String> persistedKeys = ConfigUtils.getAllConfigKeys(configPropertyList);
        return props.entrySet().stream().filter(p -> persistedKeys.contains(String.valueOf(p.getKey()))).collect(Collectors.toMap((? super T e) -> String.valueOf(e.getKey()), (? super T e) -> String.valueOf(e.getValue())));
    }

    public static Set<String> getAllConfigKeys(List<ConfigProperty<String>> configPropertyList) {
        return configPropertyList.stream().flatMap(configProperty -> {
            ArrayList<String> keys2 = new ArrayList<String>();
            keys2.add(configProperty.key());
            keys2.addAll(configProperty.getAlternatives());
            return keys2.stream();
        }).collect(Collectors.toSet());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static TypedProperties fetchConfigs(HoodieStorage storage, StoragePath metaPath, String propertiesFile, String propertiesBackupFile, int maxReadRetries, int maxReadRetryDelayInMs) throws IOException {
        StoragePath cfgPath = new StoragePath(metaPath, propertiesFile);
        StoragePath backupCfgPath = new StoragePath(metaPath, propertiesBackupFile);
        int readRetryCount = 0;
        boolean found = false;
        TypedProperties props = new TypedProperties();
        while (true) {
            Iterator<StoragePath> iterator2;
            if (readRetryCount++ < maxReadRetries) {
                iterator2 = Arrays.asList(cfgPath, backupCfgPath).iterator();
            } else {
                if (found) {
                    throw new IllegalArgumentException("hoodie.properties file seems invalid. Please check for left over `.updated` files if any, manually copy it to hoodie.properties and retry");
                }
                if (storage.exists(metaPath)) throw new HoodieIOException("Could not load Hoodie properties from " + cfgPath);
                throw new TableNotFoundException(metaPath.toString());
            }
            while (iterator2.hasNext()) {
                StoragePath path = iterator2.next();
                try (InputStream is = storage.open(path);){
                    props.clear();
                    props.load(is);
                    found = true;
                    if (props.containsKey(HoodieTableConfig.TABLE_CHECKSUM.key())) {
                        ValidationUtils.checkArgument(HoodieTableConfig.validateChecksum(props));
                    }
                    TypedProperties typedProperties = props;
                    return typedProperties;
                }
                catch (IOException e) {
                    LOG.warn(String.format("Could not read properties from %s: %s", path, e));
                }
                catch (IllegalArgumentException e) {
                    LOG.warn(String.format("Invalid properties file %s: %s", path, props));
                }
            }
            try {
                Thread.sleep(maxReadRetryDelayInMs);
            }
            catch (InterruptedException e) {
                LOG.warn("Interrupted while waiting");
                continue;
            }
            break;
        }
    }

    public static void recoverIfNeeded(HoodieStorage storage, StoragePath cfgPath, StoragePath backupCfgPath) throws IOException {
        if (!storage.exists(cfgPath)) {
            try (InputStream in = storage.open(backupCfgPath);
                 OutputStream out = storage.create(cfgPath, false);){
                FileIOUtils.copy(in, out);
            }
        }
        storage.deleteFile(backupCfgPath);
    }

    public static void upsertProperties(Properties current, Properties updated) {
        updated.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> current.setProperty(k.toString(), v.toString())));
    }

    public static void deleteProperties(Properties current, Properties deleted) {
        deleted.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> current.remove(k.toString())));
    }

    public static HoodieConfig getReaderConfigs(StorageConfiguration<?> storageConf) {
        HoodieConfig config = new HoodieConfig();
        config.setAll(DEFAULT_HUDI_CONFIG_FOR_READER.getProps());
        config.setValue(HoodieReaderConfig.USE_NATIVE_HFILE_READER, Boolean.toString(storageConf.getBoolean(HoodieReaderConfig.USE_NATIVE_HFILE_READER.key(), HoodieReaderConfig.USE_NATIVE_HFILE_READER.defaultValue())));
        return config;
    }

    public static TypedProperties loadGlobalProperties() {
        return ((PropertiesConfig)ReflectionUtils.loadClass("org.apache.hudi.common.config.DFSPropertiesConfiguration")).getGlobalProperties();
    }
}

