/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.execution.bulkinsert;

import java.util.Arrays;
import java.util.List;
import org.apache.hudi.config.HoodieClusteringConfig;
import org.apache.hudi.sort.SpaceCurveSortingHelper;
import org.apache.hudi.table.BulkInsertPartitioner;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;

public abstract class SpatialCurveSortPartitionerBase<T>
implements BulkInsertPartitioner<T> {
    private final String[] orderByColumns;
    private final HoodieClusteringConfig.LayoutOptimizationStrategy layoutOptStrategy;
    private final HoodieClusteringConfig.SpatialCurveCompositionStrategyType curveCompositionStrategyType;

    public SpatialCurveSortPartitionerBase(String orderByColumns, HoodieClusteringConfig.LayoutOptimizationStrategy layoutOptStrategy, HoodieClusteringConfig.SpatialCurveCompositionStrategyType curveCompositionStrategyType) {
        if (orderByColumns == null) {
            throw new IllegalArgumentException("The config " + HoodieClusteringConfig.PLAN_STRATEGY_SORT_COLUMNS.key() + " must be provided");
        }
        this.orderByColumns = (String[])Arrays.stream(orderByColumns.split(",")).map(String::trim).toArray(String[]::new);
        this.layoutOptStrategy = layoutOptStrategy;
        this.curveCompositionStrategyType = curveCompositionStrategyType;
    }

    public SpatialCurveSortPartitionerBase(String[] orderByColumns, HoodieClusteringConfig.LayoutOptimizationStrategy layoutOptStrategy, HoodieClusteringConfig.SpatialCurveCompositionStrategyType curveCompositionStrategyType) {
        this.orderByColumns = orderByColumns;
        this.layoutOptStrategy = layoutOptStrategy;
        this.curveCompositionStrategyType = curveCompositionStrategyType;
    }

    protected Dataset<Row> reorder(Dataset<Row> dataset, int numOutputGroups) {
        if (this.orderByColumns.length == 0) {
            return dataset;
        }
        List<String> orderedCols = Arrays.asList(this.orderByColumns);
        switch (this.curveCompositionStrategyType) {
            case DIRECT: {
                return SpaceCurveSortingHelper.orderDataFrameByMappingValues(dataset, this.layoutOptStrategy, orderedCols, numOutputGroups);
            }
            case SAMPLE: {
                return SpaceCurveSortingHelper.orderDataFrameBySamplingValues(dataset, this.layoutOptStrategy, orderedCols, numOutputGroups);
            }
        }
        throw new UnsupportedOperationException(String.format("Unsupported space-curve curve building strategy (%s)", new Object[]{this.curveCompositionStrategyType}));
    }

    @Override
    public boolean arePartitionRecordsSorted() {
        return false;
    }
}

