/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.hfile;

import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.io.hfile.HFileUtils;
import org.apache.hudi.io.util.IOUtils;

public class Key
implements Comparable<Key> {
    private static final int CONTENT_LENGTH_SIZE = 2;
    private final byte[] bytes;
    private final int offset;
    private final int length;

    public Key(byte[] bytes) {
        this(bytes, 0, bytes.length);
    }

    public Key(byte[] bytes, int offset, int length) {
        this.bytes = bytes;
        this.offset = offset;
        this.length = length;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public int getContentOffset() {
        return this.getOffset() + 2;
    }

    public int getContentLength() {
        return IOUtils.readShort(this.bytes, this.getOffset());
    }

    public String getContentInString() {
        return StringUtils.fromUTF8Bytes(this.getBytes(), this.getContentOffset(), this.getContentLength());
    }

    public int hashCode() {
        return IOUtils.hashCode(this.getBytes(), this.getContentOffset(), this.getContentLength());
    }

    public boolean equals(Object o) {
        if (!(o instanceof Key)) {
            return false;
        }
        return this.compareTo((Key)o) == 0;
    }

    @Override
    public int compareTo(Key o) {
        return HFileUtils.compareKeys(this, o);
    }

    public String toString() {
        return "Key{" + new String(this.getBytes(), this.getContentOffset(), this.getContentLength()) + "}";
    }
}

