/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metrics;

import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import org.apache.hudi.com.codahale.metrics.MetricFilter;
import org.apache.hudi.com.codahale.metrics.MetricRegistry;
import org.apache.hudi.com.codahale.metrics.graphite.Graphite;
import org.apache.hudi.com.codahale.metrics.graphite.GraphiteReporter;
import org.apache.hudi.config.metrics.HoodieMetricsConfig;
import org.apache.hudi.metrics.MetricsReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsGraphiteReporter
extends MetricsReporter {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsGraphiteReporter.class);
    private final MetricRegistry registry;
    private final GraphiteReporter graphiteReporter;
    private final HoodieMetricsConfig metricsConfig;
    private String serverHost;
    private int serverPort;
    private final int periodSeconds;

    public MetricsGraphiteReporter(HoodieMetricsConfig metricsConfig, MetricRegistry registry) {
        this.registry = registry;
        this.metricsConfig = metricsConfig;
        this.serverHost = metricsConfig.getGraphiteServerHost();
        this.serverPort = metricsConfig.getGraphiteServerPort();
        if (this.serverHost == null || this.serverPort == 0) {
            throw new RuntimeException(String.format("Graphite cannot be initialized with serverHost[%s] and serverPort[%s].", this.serverHost, this.serverPort));
        }
        this.graphiteReporter = this.createGraphiteReport();
        this.periodSeconds = metricsConfig.getGraphiteReportPeriodSeconds();
    }

    @Override
    public void start() {
        if (this.graphiteReporter != null) {
            this.graphiteReporter.start(this.periodSeconds, TimeUnit.SECONDS);
        } else {
            LOG.error("Cannot start as the graphiteReporter is null.");
        }
    }

    @Override
    public void report() {
        if (this.graphiteReporter != null) {
            this.graphiteReporter.report();
        } else {
            LOG.error("Cannot report metrics as the graphiteReporter is null.");
        }
    }

    private GraphiteReporter createGraphiteReport() {
        Graphite graphite = new Graphite(new InetSocketAddress(this.serverHost, this.serverPort));
        String reporterPrefix = this.metricsConfig.getGraphiteMetricPrefix();
        return GraphiteReporter.forRegistry(this.registry).prefixedWith(reporterPrefix).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).filter(MetricFilter.ALL).build(graphite);
    }

    @Override
    public void stop() {
        if (this.graphiteReporter != null) {
            this.graphiteReporter.stop();
        }
    }
}

