/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.master;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.SortedMap;
import java.util.concurrent.ThreadFactory;
import org.apache.hudi.org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hudi.org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hudi.org.apache.hadoop.hbase.master.RegionState;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hudi.org.apache.hadoop.hbase.types.CopyOnWriteArrayMap;
import org.apache.hudi.org.apache.hadoop.hbase.util.RetryCounter;
import org.apache.hudi.org.apache.hadoop.hbase.util.RetryCounterFactory;
import org.apache.hudi.org.apache.hadoop.hbase.zookeeper.ZKListener;
import org.apache.hudi.org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hudi.org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hudi.org.apache.hadoop.hbase.zookeeper.ZNodePaths;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class MetaRegionLocationCache
extends ZKListener {
    private static final Logger LOG = LoggerFactory.getLogger(MetaRegionLocationCache.class);
    private static final int MAX_ZK_META_FETCH_RETRIES = 10;
    private static final int SLEEP_INTERVAL_MS_BETWEEN_RETRIES = 1000;
    private static final int SLEEP_INTERVAL_MS_MAX = 10000;
    private final RetryCounterFactory retryCounterFactory = new RetryCounterFactory(10, 1000);
    private final CopyOnWriteArrayMap<Integer, HRegionLocation> cachedMetaLocations = new CopyOnWriteArrayMap();

    public MetaRegionLocationCache(ZKWatcher zkWatcher) {
        super(zkWatcher);
        this.watcher.registerListener((ZKListener)this);
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).build();
        RetryCounterFactory retryFactory = new RetryCounterFactory(Integer.MAX_VALUE, 1000, 10000);
        threadFactory.newThread(() -> this.loadMetaLocationsFromZk(retryFactory.create(), ZNodeOpType.INIT)).start();
    }

    private void loadMetaLocationsFromZk(RetryCounter retryCounter, ZNodeOpType opType) {
        List znodes = null;
        while (retryCounter.shouldRetry()) {
            try {
                znodes = this.watcher.getMetaReplicaNodesAndWatchChildren();
                break;
            }
            catch (KeeperException ke) {
                LOG.debug("Error populating initial meta locations", (Throwable)ke);
                if (!retryCounter.shouldRetry()) {
                    this.watcher.abort("Error populating meta locations", (Throwable)ke);
                    return;
                }
                try {
                    retryCounter.sleepUntilNextRetry();
                }
                catch (InterruptedException ie) {
                    LOG.error("Interrupted while loading meta locations from ZK", (Throwable)ie);
                    Thread.currentThread().interrupt();
                    return;
                }
            }
        }
        if (znodes == null || znodes.isEmpty()) {
            return;
        }
        if (znodes.size() == this.cachedMetaLocations.size()) {
            return;
        }
        for (String znode : znodes) {
            String path = ZNodePaths.joinZNode(this.watcher.getZNodePaths().baseZNode, znode);
            this.updateMetaLocation(path, opType);
        }
    }

    private HRegionLocation getMetaRegionLocation(int replicaId) throws KeeperException {
        RegionState metaRegionState;
        try {
            byte[] data = ZKUtil.getDataAndWatch((ZKWatcher)this.watcher, (String)this.watcher.getZNodePaths().getZNodeForReplica(replicaId));
            metaRegionState = ProtobufUtil.parseMetaRegionStateFrom(data, replicaId);
        }
        catch (DeserializationException e) {
            throw ZKUtil.convert((DeserializationException)e);
        }
        return new HRegionLocation(metaRegionState.getRegion(), metaRegionState.getServerName());
    }

    private void updateMetaLocation(String path, ZNodeOpType opType) {
        if (!this.isValidMetaPath(path)) {
            return;
        }
        LOG.debug("Updating meta znode for path {}: {}", (Object)path, (Object)opType.name());
        int replicaId = this.watcher.getZNodePaths().getMetaReplicaIdFromPath(path);
        RetryCounter retryCounter = this.retryCounterFactory.create();
        HRegionLocation location = null;
        while (retryCounter.shouldRetry()) {
            try {
                if (opType == ZNodeOpType.DELETED && !ZKUtil.watchAndCheckExists((ZKWatcher)this.watcher, (String)path)) break;
                location = this.getMetaRegionLocation(replicaId);
                break;
            }
            catch (KeeperException e) {
                LOG.debug("Error getting meta location for path {}", (Object)path, (Object)e);
                if (!retryCounter.shouldRetry()) {
                    LOG.warn("Error getting meta location for path {}. Retries exhausted.", (Object)path, (Object)e);
                    break;
                }
                try {
                    retryCounter.sleepUntilNextRetry();
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
        }
        if (location == null) {
            this.cachedMetaLocations.remove(replicaId);
            return;
        }
        this.cachedMetaLocations.put(replicaId, location);
    }

    public Optional<List<HRegionLocation>> getMetaRegionLocations() {
        SortedMap snapshot = this.cachedMetaLocations.tailMap((Object)this.cachedMetaLocations.firstKey());
        if (snapshot.isEmpty()) {
            return Optional.empty();
        }
        ArrayList result = new ArrayList();
        snapshot.values().forEach(location -> result.add(location));
        return Optional.of(result);
    }

    private boolean isValidMetaPath(String path) {
        return this.watcher.getZNodePaths().isMetaZNodePath(path);
    }

    public void nodeCreated(String path) {
        this.updateMetaLocation(path, ZNodeOpType.CREATED);
    }

    public void nodeDeleted(String path) {
        this.updateMetaLocation(path, ZNodeOpType.DELETED);
    }

    public void nodeDataChanged(String path) {
        this.updateMetaLocation(path, ZNodeOpType.CHANGED);
    }

    public void nodeChildrenChanged(String path) {
        if (!path.equals(this.watcher.getZNodePaths().baseZNode)) {
            return;
        }
        this.loadMetaLocationsFromZk(this.retryCounterFactory.create(), ZNodeOpType.CHANGED);
    }

    private static enum ZNodeOpType {
        INIT,
        CREATED,
        CHANGED,
        DELETED;

    }
}

