/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.storage;

import org.apache.hudi.common.config.HoodieStorageConfig;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;

public class HoodieStorageUtils {
    public static final String DEFAULT_URI = "file:///";

    public static HoodieStorage getStorage(StorageConfiguration<?> conf) {
        return HoodieStorageUtils.getStorage(DEFAULT_URI, conf);
    }

    public static HoodieStorage getStorage(String basePath, StorageConfiguration<?> conf) {
        return HoodieStorageUtils.getStorage(new StoragePath(basePath), conf);
    }

    public static HoodieStorage getStorage(StoragePath path, StorageConfiguration<?> conf) {
        String storageClass = conf.getString(HoodieStorageConfig.HOODIE_STORAGE_CLASS.key()).orElse(HoodieStorageConfig.HOODIE_STORAGE_CLASS.defaultValue());
        try {
            return (HoodieStorage)ReflectionUtils.loadClass(storageClass, new Class[]{StoragePath.class, StorageConfiguration.class}, new Object[]{path, conf});
        }
        catch (Exception e) {
            throw new HoodieException("Unable to create " + storageClass, e);
        }
    }
}

