/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.rollback;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.hudi.avro.model.HoodieRollbackRequest;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.model.IOType;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.exception.HoodieRollbackException;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.rollback.BaseRollbackPlanActionExecutor;
import org.apache.hudi.table.action.rollback.RollbackUtils;
import org.apache.hudi.table.marker.MarkerBasedRollbackUtils;
import org.apache.hudi.table.marker.WriteMarkers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarkerBasedRollbackStrategy<T, I, K, O>
implements BaseRollbackPlanActionExecutor.RollbackStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(MarkerBasedRollbackStrategy.class);
    protected final HoodieTable<?, ?, ?, ?> table;
    protected final transient HoodieEngineContext context;
    protected final HoodieWriteConfig config;
    protected final String basePath;
    protected final String instantTime;

    public MarkerBasedRollbackStrategy(HoodieTable<?, ?, ?, ?> table, HoodieEngineContext context, HoodieWriteConfig config, String instantTime) {
        this.table = table;
        this.context = context;
        this.basePath = table.getMetaClient().getBasePath().toString();
        this.config = config;
        this.instantTime = instantTime;
    }

    @Override
    public List<HoodieRollbackRequest> getRollbackRequests(HoodieInstant instantToRollback) {
        try {
            List<String> markerPaths = MarkerBasedRollbackUtils.getAllMarkerPaths(this.table, this.context, instantToRollback.requestedTime(), this.config.getRollbackParallelism());
            int parallelism = Math.max(Math.min(markerPaths.size(), this.config.getRollbackParallelism()), 1);
            List<HoodieRollbackRequest> rollbackRequestList = this.context.map(markerPaths, markerFilePath -> {
                String typeStr = markerFilePath.substring(markerFilePath.lastIndexOf(".") + 1);
                IOType type = IOType.valueOf(typeStr);
                String filePathStr = WriteMarkers.stripMarkerSuffix(markerFilePath);
                StoragePath filePath = new StoragePath(this.basePath, filePathStr);
                String partitionPath = FSUtils.getRelativePartitionPath(new StoragePath(this.basePath), filePath.getParent());
                String fileId = FSUtils.getFileIdFromFilePath(filePath);
                switch (type) {
                    case MERGE: 
                    case CREATE: {
                        return this.createRollbackRequestForCreateAndMerge(fileId, partitionPath, filePath, instantToRollback);
                    }
                    case APPEND: {
                        return this.createRollbackRequestForAppend(fileId, partitionPath, filePath, instantToRollback, filePathStr);
                    }
                }
                throw new HoodieRollbackException("Unknown marker type, during rollback of " + instantToRollback);
            }, parallelism);
            return this.table.version().greaterThanOrEquals(HoodieTableVersion.EIGHT) ? rollbackRequestList : RollbackUtils.groupRollbackRequestsBasedOnFileGroup(rollbackRequestList);
        }
        catch (Exception e) {
            throw new HoodieRollbackException("Error rolling back using marker files written for " + instantToRollback, e);
        }
    }

    protected HoodieRollbackRequest createRollbackRequestForCreateAndMerge(String fileId, String partitionPath, StoragePath filePath, HoodieInstant instantToRollback) {
        if (this.table.version().greaterThanOrEquals(HoodieTableVersion.EIGHT)) {
            return new HoodieRollbackRequest(partitionPath, fileId, instantToRollback.requestedTime(), Collections.singletonList(filePath.toString()), Collections.emptyMap());
        }
        String baseInstantTime = null;
        if (FSUtils.isBaseFile(filePath)) {
            HoodieBaseFile baseFileToDelete = new HoodieBaseFile(filePath.toString());
            fileId = baseFileToDelete.getFileId();
            baseInstantTime = baseFileToDelete.getCommitTime();
        } else if (FSUtils.isLogFile(filePath)) {
            throw new HoodieRollbackException("Log files should have only APPEND as IOTypes " + filePath);
        }
        Objects.requireNonNull(fileId, "Cannot find valid fileId from path: " + filePath);
        Objects.requireNonNull(baseInstantTime, "Cannot find valid base instant from path: " + filePath);
        return new HoodieRollbackRequest(partitionPath, fileId, baseInstantTime, Collections.singletonList(filePath.toString()), Collections.emptyMap());
    }

    protected HoodieRollbackRequest createRollbackRequestForAppend(String fileId, String relativePartitionPath, StoragePath filePath, HoodieInstant instantToRollback, String filePathToRollback) {
        if (this.table.version().greaterThanOrEquals(HoodieTableVersion.EIGHT)) {
            return new HoodieRollbackRequest(relativePartitionPath, fileId, instantToRollback.requestedTime(), Collections.emptyList(), Collections.singletonMap(filePath.toString(), 1L));
        }
        StoragePath fullFilePath = new StoragePath(this.basePath, filePathToRollback);
        Map<Object, Object> logBlocksToBeDeleted = new HashMap();
        if (FSUtils.isBaseFile(fullFilePath)) {
            LOG.warn("Find old marker type for log file: {}", (Object)filePathToRollback);
            String baseCommitTime = FSUtils.getCommitTime(fullFilePath.getName());
            StoragePath partitionPath = FSUtils.constructAbsolutePath(this.config.getBasePath(), relativePartitionPath);
            try {
                Option<HoodieLogFile> latestLogFileOption = FSUtils.getLatestLogFile(this.table.getMetaClient().getStorage(), partitionPath, fileId, HoodieFileFormat.HOODIE_LOG.getFileExtension(), baseCommitTime);
                if (latestLogFileOption.isPresent() && baseCommitTime.equals(instantToRollback.requestedTime())) {
                    StoragePath fullDeletePath = new StoragePath(partitionPath, latestLogFileOption.get().getFileName());
                    return new HoodieRollbackRequest(relativePartitionPath, "", "", Collections.singletonList(fullDeletePath.toString()), Collections.emptyMap());
                }
                if (latestLogFileOption.isPresent()) {
                    HoodieLogFile latestLogFile = latestLogFileOption.get();
                    logBlocksToBeDeleted = Collections.singletonMap(latestLogFile.getPathInfo().getPath().toString(), latestLogFile.getPathInfo().getLength());
                }
                return new HoodieRollbackRequest(relativePartitionPath, fileId, baseCommitTime, Collections.emptyList(), logBlocksToBeDeleted);
            }
            catch (IOException ioException) {
                throw new HoodieIOException("Failed to get latestLogFile for fileId: " + fileId + " in partition: " + partitionPath, ioException);
            }
        }
        HoodieLogFile logFileToRollback = new HoodieLogFile(fullFilePath);
        String baseCommitTime = logFileToRollback.getDeltaCommitTime();
        logBlocksToBeDeleted = Collections.singletonMap(logFileToRollback.getPath().getName(), 1L);
        return new HoodieRollbackRequest(relativePartitionPath, fileId, baseCommitTime, Collections.emptyList(), logBlocksToBeDeleted);
    }
}

