/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.IOException;
import java.lang.reflect.Field;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.Map;
import org.apache.hudi.client.utils.SparkInternalSchemaConverter;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.spark.memory.MemoryMode;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.datasources.parquet.VectorizedParquetRecordReader;
import org.apache.spark.sql.execution.vectorized.OffHeapColumnVector;
import org.apache.spark.sql.execution.vectorized.OnHeapColumnVector;
import org.apache.spark.sql.execution.vectorized.WritableColumnVector;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.ColumnarBatch;

public class Spark3HoodieVectorizedParquetRecordReader
extends VectorizedParquetRecordReader {
    private final Map<Integer, Pair<DataType, DataType>> typeChangeInfos;
    private ColumnarBatch columnarBatch;
    private Map<Integer, WritableColumnVector> idToColumnVectors;
    private ColumnVector[] columnVectors;
    private final int capacity;
    private boolean returnColumnarBatch;
    private final MemoryMode memoryMode;
    private Field batchIdxField;

    public Spark3HoodieVectorizedParquetRecordReader(ZoneId convertTz, String datetimeRebaseMode, String datetimeRebaseTz, String int96RebaseMode, String int96RebaseTz, boolean useOffHeap, int capacity, Map<Integer, Pair<DataType, DataType>> typeChangeInfos) {
        super(convertTz, datetimeRebaseMode, datetimeRebaseTz, int96RebaseMode, int96RebaseTz, useOffHeap, capacity);
        this.memoryMode = useOffHeap ? MemoryMode.OFF_HEAP : MemoryMode.ON_HEAP;
        this.typeChangeInfos = typeChangeInfos;
        this.capacity = capacity;
    }

    public void initBatch(StructType partitionColumns, InternalRow partitionValues) {
        super.initBatch(partitionColumns, partitionValues);
        if (this.columnVectors == null) {
            this.columnVectors = new ColumnVector[this.sparkSchema.length() + partitionColumns.length()];
        }
        if (this.idToColumnVectors == null) {
            this.idToColumnVectors = new HashMap<Integer, WritableColumnVector>();
            this.typeChangeInfos.entrySet().stream().forEach(f -> {
                OffHeapColumnVector vector = this.memoryMode == MemoryMode.OFF_HEAP ? new OffHeapColumnVector(this.capacity, (DataType)((Pair)f.getValue()).getLeft()) : new OnHeapColumnVector(this.capacity, (DataType)((Pair)f.getValue()).getLeft());
                this.idToColumnVectors.put((Integer)f.getKey(), (WritableColumnVector)vector);
            });
        }
    }

    public void close() throws IOException {
        super.close();
        for (Map.Entry<Integer, WritableColumnVector> e : this.idToColumnVectors.entrySet()) {
            e.getValue().close();
        }
        this.idToColumnVectors = null;
        this.columnarBatch = null;
        this.columnVectors = null;
    }

    public ColumnarBatch resultBatch() {
        ColumnarBatch currentColumnBatch = super.resultBatch();
        boolean changed = false;
        for (Map.Entry<Integer, Pair<DataType, DataType>> entry : this.typeChangeInfos.entrySet()) {
            boolean rewrite = SparkInternalSchemaConverter.convertColumnVectorType((WritableColumnVector)((WritableColumnVector)currentColumnBatch.column(entry.getKey().intValue())), (WritableColumnVector)this.idToColumnVectors.get(entry.getKey()), (int)currentColumnBatch.numRows());
            if (!rewrite) continue;
            changed = true;
            this.columnVectors[entry.getKey().intValue()] = (ColumnVector)this.idToColumnVectors.get(entry.getKey());
        }
        if (changed) {
            if (this.columnarBatch == null) {
                for (int i = 0; i < this.columnVectors.length; ++i) {
                    if (this.columnVectors[i] != null) continue;
                    this.columnVectors[i] = currentColumnBatch.column(i);
                }
                this.columnarBatch = new ColumnarBatch(this.columnVectors);
            }
            this.columnarBatch.setNumRows(currentColumnBatch.numRows());
            return this.columnarBatch;
        }
        return currentColumnBatch;
    }

    public boolean nextBatch() throws IOException {
        boolean result = super.nextBatch();
        if (this.idToColumnVectors != null) {
            this.idToColumnVectors.entrySet().stream().forEach(e -> ((WritableColumnVector)e.getValue()).reset());
        }
        this.resultBatch();
        return result;
    }

    public void enableReturningBatches() {
        this.returnColumnarBatch = true;
        super.enableReturningBatches();
    }

    public Object getCurrentValue() {
        if (this.typeChangeInfos == null || this.typeChangeInfos.isEmpty()) {
            return super.getCurrentValue();
        }
        if (this.returnColumnarBatch) {
            return this.columnarBatch == null ? super.getCurrentValue() : this.columnarBatch;
        }
        return this.columnarBatch == null ? super.getCurrentValue() : this.columnarBatch.getRow(this.batchIdxFromSuper() - 1);
    }

    private int batchIdxFromSuper() {
        try {
            if (this.batchIdxField == null) {
                this.batchIdxField = VectorizedParquetRecordReader.class.getDeclaredField("batchIdx");
                this.batchIdxField.setAccessible(true);
            }
            return (Integer)this.batchIdxField.get((Object)this);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

