/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.catalog;

import java.io.Serializable;
import java.net.URI;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.SparkAdapterSupport;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.hive.HiveSyncConfig;
import org.apache.hudi.sql.InsertMode;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier$;
import org.apache.spark.sql.catalyst.analysis.NoSuchNamespaceException;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.analysis.TableAlreadyExistsException;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTable$;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.CatalogUtils$;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.connector.catalog.Column;
import org.apache.spark.sql.connector.catalog.DelegatingCatalogExtension;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.StagedTable;
import org.apache.spark.sql.connector.catalog.StagingTableCatalog;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.catalog.TableChange;
import org.apache.spark.sql.connector.catalog.V1Table;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.hudi.HoodieSqlCommonUtils$;
import org.apache.spark.sql.hudi.ProvidesHoodieConfig;
import org.apache.spark.sql.hudi.ProvidesHoodieConfig$;
import org.apache.spark.sql.hudi.SparkAdapter;
import org.apache.spark.sql.hudi.analysis.HoodieSpark3Analysis$HoodieV1OrV2Table$;
import org.apache.spark.sql.hudi.catalog.BasicStagedTable;
import org.apache.spark.sql.hudi.catalog.HoodieCatalog$;
import org.apache.spark.sql.hudi.catalog.HoodieInternalV2Table;
import org.apache.spark.sql.hudi.catalog.HoodieInternalV2Table$;
import org.apache.spark.sql.hudi.catalog.HoodieStagedTable;
import org.apache.spark.sql.hudi.catalog.TableCreationMode;
import org.apache.spark.sql.hudi.command.AlterHoodieTableAddColumnsCommand;
import org.apache.spark.sql.hudi.command.AlterHoodieTableChangeColumnCommand;
import org.apache.spark.sql.hudi.command.AlterHoodieTableRenameCommand;
import org.apache.spark.sql.hudi.command.CreateHoodieTableCommand;
import org.apache.spark.sql.hudi.command.CreateHoodieTableCommand$;
import org.apache.spark.sql.hudi.command.DropHoodieTableCommand;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tmf\u0001\u0002\u000e\u001c\u0001!BQ\u0001\u0010\u0001\u0005\u0002uBqA\t\u0001C\u0002\u0013\u0005\u0001\t\u0003\u0004F\u0001\u0001\u0006I!\u0011\u0005\u0006\r\u0002!\te\u0012\u0005\u0006w\u0002!\t\u0005 \u0005\b\u0003\u0007\u0001A\u0011IA\u0003\u0011\u001d\ty\u0001\u0001C!\u0003#Aq!a\u0007\u0001\t\u0003\ni\u0002C\u0004\u0002(\u0001!\t%!\u000b\t\u000f\u0005M\u0002\u0001\"\u0011\u00026!9\u0011\u0011\b\u0001\u0005B\u0005m\u0002bBA \u0001\u0011\u0005\u0013\u0011\t\u0005\b\u0003g\u0003A\u0011IA[\u0011\u001d\tI\r\u0001C\u0005\u0003\u0017Dq!!<\u0001\t\u0003\ty\u000fC\u0004\u00038\u0001!IA!\u000f\t\u000f\t]\u0002\u0001\"\u0005\u0003>!9!1\n\u0001\u0005\n\t5\u0003b\u0002B.\u0001\u0011%!QL\u0004\b\u0005{Z\u0002\u0012\u0001B@\r\u0019Q2\u0004#\u0001\u0003\u0002\"1A(\u0006C\u0001\u0005\u0013CqAa#\u0016\t\u0003\u0011i\tC\u0004\u0003,V!\tA!,\t\u000f\tEV\u0003\"\u0001\u00034\ni\u0001j\\8eS\u0016\u001c\u0015\r^1m_\u001eT!\u0001H\u000f\u0002\u000f\r\fG/\u00197pO*\u0011adH\u0001\u0005QV$\u0017N\u0003\u0002!C\u0005\u00191/\u001d7\u000b\u0005\t\u001a\u0013!B:qCJ\\'B\u0001\u0013&\u0003\u0019\t\u0007/Y2iK*\ta%A\u0002pe\u001e\u001c\u0001aE\u0003\u0001SA\u001a\u0004\b\u0005\u0002+]5\t1F\u0003\u0002\u001dY)\u0011QfH\u0001\nG>tg.Z2u_JL!aL\u0016\u00035\u0011+G.Z4bi&twmQ1uC2|w-\u0012=uK:\u001c\u0018n\u001c8\u0011\u0005)\n\u0014B\u0001\u001a,\u0005M\u0019F/Y4j]\u001e$\u0016M\u00197f\u0007\u0006$\u0018\r\\8h!\t!d'D\u00016\u0015\tq2%\u0003\u00028k\t\u00192\u000b]1sW\u0006#\u0017\r\u001d;feN+\b\u000f]8siB\u0011\u0011HO\u0007\u0002;%\u00111(\b\u0002\u0015!J|g/\u001b3fg\"{w\u000eZ5f\u0007>tg-[4\u0002\rqJg.\u001b;?)\u0005q\u0004CA \u0001\u001b\u0005YR#A!\u0011\u0005\t\u001bU\"A\u0010\n\u0005\u0011{\"\u0001D*qCJ\\7+Z:tS>t\u0017AB:qCJ\\\u0007%A\u0006ti\u0006<Wm\u0011:fCR,G#\u0002%L!b3\u0007C\u0001\u0016J\u0013\tQ5FA\u0006Ti\u0006<W\r\u001a+bE2,\u0007\"\u0002'\u0005\u0001\u0004i\u0015!B5eK:$\bC\u0001\u0016O\u0013\ty5F\u0001\u0006JI\u0016tG/\u001b4jKJDQ!\u0015\u0003A\u0002I\u000baa]2iK6\f\u0007CA*W\u001b\u0005!&BA+ \u0003\u0015!\u0018\u0010]3t\u0013\t9FK\u0001\u0006TiJ,8\r\u001e+za\u0016DQ!\u0017\u0003A\u0002i\u000b!\u0002]1si&$\u0018n\u001c8t!\rYf\fY\u0007\u00029*\tQ,A\u0003tG\u0006d\u0017-\u0003\u0002`9\n)\u0011I\u001d:bsB\u0011\u0011\rZ\u0007\u0002E*\u00111\rL\u0001\fKb\u0004(/Z:tS>t7/\u0003\u0002fE\nIAK]1og\u001a|'/\u001c\u0005\u0006O\u0012\u0001\r\u0001[\u0001\u000baJ|\u0007/\u001a:uS\u0016\u001c\b\u0003B5oaBl\u0011A\u001b\u0006\u0003W2\fA!\u001e;jY*\tQ.\u0001\u0003kCZ\f\u0017BA8k\u0005\ri\u0015\r\u001d\t\u0003cbt!A\u001d<\u0011\u0005MdV\"\u0001;\u000b\u0005U<\u0013A\u0002\u001fs_>$h(\u0003\u0002x9\u00061\u0001K]3eK\u001aL!!\u001f>\u0003\rM#(/\u001b8h\u0015\t9H,\u0001\u0007ti\u0006<WMU3qY\u0006\u001cW\r\u0006\u0004I{z|\u0018\u0011\u0001\u0005\u0006\u0019\u0016\u0001\r!\u0014\u0005\u0006#\u0016\u0001\rA\u0015\u0005\u00063\u0016\u0001\rA\u0017\u0005\u0006O\u0016\u0001\r\u0001[\u0001\u0015gR\fw-Z\"sK\u0006$Xm\u0014:SKBd\u0017mY3\u0015\u0013!\u000b9!!\u0003\u0002\f\u00055\u0001\"\u0002'\u0007\u0001\u0004i\u0005\"B)\u0007\u0001\u0004\u0011\u0006\"B-\u0007\u0001\u0004Q\u0006\"B4\u0007\u0001\u0004A\u0017!\u00037pC\u0012$\u0016M\u00197f)\u0011\t\u0019\"!\u0007\u0011\u0007)\n)\"C\u0002\u0002\u0018-\u0012Q\u0001V1cY\u0016DQ\u0001T\u0004A\u00025\u000b1b\u0019:fCR,G+\u00192mKRQ\u00111CA\u0010\u0003C\t\u0019#!\n\t\u000b1C\u0001\u0019A'\t\u000bEC\u0001\u0019\u0001*\t\u000beC\u0001\u0019\u0001.\t\u000b\u001dD\u0001\u0019\u00015\u0002\u0017Q\f'\r\\3Fq&\u001cHo\u001d\u000b\u0005\u0003W\t\t\u0004E\u0002\\\u0003[I1!a\f]\u0005\u001d\u0011un\u001c7fC:DQ\u0001T\u0005A\u00025\u000b\u0011\u0002\u001a:paR\u000b'\r\\3\u0015\t\u0005-\u0012q\u0007\u0005\u0006\u0019*\u0001\r!T\u0001\u000baV\u0014x-\u001a+bE2,G\u0003BA\u0016\u0003{AQ\u0001T\u0006A\u00025\u000b1B]3oC6,G+\u00192mKR1\u00111IA%\u0003\u001b\u00022aWA#\u0013\r\t9\u0005\u0018\u0002\u0005+:LG\u000f\u0003\u0004\u0002L1\u0001\r!T\u0001\t_2$\u0017\nZ3oi\"1\u0011q\n\u0007A\u00025\u000b\u0001B\\3x\u0013\u0012,g\u000e\u001e\u0015\u0006\u0019\u0005M\u0013\u0011\u000e\t\u00067\u0006U\u0013\u0011L\u0005\u0004\u0003/b&A\u0002;ie><8\u000f\u0005\u0003\u0002\\\u0005\u0015TBAA/\u0015\u0011\ty&!\u0019\u0002\u0011\u0005t\u0017\r\\=tSNT1!a\u0019 \u0003!\u0019\u0017\r^1msN$\u0018\u0002BA4\u0003;\u00121\u0004V1cY\u0016\fEN]3bIf,\u00050[:ug\u0016C8-\u001a9uS>t\u0017G\u0002\u0010q\u0003W\ni*M\u0005$\u0003[\n)(a%\u0002xU!\u0011qNA9+\u0005\u0001HaBA:O\t\u0007\u0011Q\u0010\u0002\u0002)&!\u0011qOA=\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%c)\u0019\u00111\u0010/\u0002\rQD'o\\<t#\u0011\ty(!\"\u0011\u0007m\u000b\t)C\u0002\u0002\u0004r\u0013qAT8uQ&tw\r\u0005\u0003\u0002\b\u00065ebA.\u0002\n&\u0019\u00111\u0012/\u0002\u000fA\f7m[1hK&!\u0011qRAI\u0005%!\u0006N]8xC\ndWMC\u0002\u0002\fr\u000b\u0014bIAK\u0003/\u000bI*a\u001f\u000f\u0007m\u000b9*C\u0002\u0002|q\u000bTAI.]\u00037\u0013Qa]2bY\u0006\f4AJA-Q\u0015a\u0011\u0011UAU!\u0015Y\u0016QKAR!\u0011\tY&!*\n\t\u0005\u001d\u0016Q\f\u0002\u0015\u001d>\u001cVo\u00195UC\ndW-\u0012=dKB$\u0018n\u001c82\ry\u0001\u00181VAYc%\u0019\u0013QNA;\u0003[\u000b9(M\u0005$\u0003+\u000b9*a,\u0002|E*!e\u0017/\u0002\u001cF\u001aa%a)\u0002\u0015\u0005dG/\u001a:UC\ndW\r\u0006\u0004\u0002\u0014\u0005]\u0016\u0011\u0018\u0005\u0006\u00196\u0001\r!\u0014\u0005\b\u0003wk\u0001\u0019AA_\u0003\u001d\u0019\u0007.\u00198hKN\u0004RaWA`\u0003\u0007L1!!1]\u0005)a$/\u001a9fCR,GM\u0010\t\u0004U\u0005\u0015\u0017bAAdW\tYA+\u00192mK\u000eC\u0017M\\4f\u0003\t\"W\rZ;dKR\u000b'\r\\3M_\u000e\fG/[8o+JK\u0015I\u001c3UC\ndW\rV=qKR1\u0011QZAu\u0003W\u0004raWAh\u0003'\fy.C\u0002\u0002Rr\u0013a\u0001V;qY\u0016\u0014\u0004\u0003BAk\u00037l!!a6\u000b\u0007\u0005eG.A\u0002oKRLA!!8\u0002X\n\u0019QKU%\u0011\t\u0005\u0005\u0018Q]\u0007\u0003\u0003GT1\u0001HA1\u0013\u0011\t9/a9\u0003!\r\u000bG/\u00197pOR\u000b'\r\\3UsB,\u0007\"\u0002'\u000f\u0001\u0004i\u0005\"B4\u000f\u0001\u0004A\u0017!E2sK\u0006$X\rS8pI&,G+\u00192mKR\u0011\u00121CAy\u0003g\f)0!?\u0002|\u0006}(q\u0001B\u0017\u0011\u0015au\u00021\u0001N\u0011\u0015\tv\u00021\u0001S\u0011\u001d\t9p\u0004a\u0001\u0003\u001b\f!\u0003\\8d+JL\u0017I\u001c3UC\ndW\rV=qK\")\u0011l\u0004a\u00015\"1\u0011Q`\bA\u0002!\f!#\u00197m)\u0006\u0014G.\u001a)s_B,'\u000f^5fg\"9!\u0011A\bA\u0002\t\r\u0011\u0001D<sSR,w\n\u001d;j_:\u001c\b#B9\u0003\u0006A\u0004\u0018BA8{\u0011\u001d\u0011Ia\u0004a\u0001\u0005\u0017\t1b]8ve\u000e,\u0017+^3ssB)1L!\u0004\u0003\u0012%\u0019!q\u0002/\u0003\r=\u0003H/[8o!\u0011\u0011\u0019Ba\n\u000f\t\tU!Q\u0005\b\u0005\u0005/\u0011\u0019C\u0004\u0003\u0003\u001a\t\u0005b\u0002\u0002B\u000e\u0005?q1a\u001dB\u000f\u0013\u00051\u0013B\u0001\u0013&\u0013\t\u00113%\u0003\u0002!C%\u0019\u00111R\u0010\n\t\t%\"1\u0006\u0002\n\t\u0006$\u0018M\u0012:b[\u0016T1!a# \u0011\u001d\u0011yc\u0004a\u0001\u0005c\t\u0011b\u001c9fe\u0006$\u0018n\u001c8\u0011\u0007}\u0012\u0019$C\u0002\u00036m\u0011\u0011\u0003V1cY\u0016\u001c%/Z1uS>tWj\u001c3f\u0003AI7\u000fU1uQ&#WM\u001c;jM&,'\u000f\u0006\u0003\u0002,\tm\u0002\"\u0002'\u0011\u0001\u0004iE\u0003BA\u0016\u0005\u007fAqA!\u0011\u0012\u0001\u0004\u0011\u0019%A\buC\ndW-\u00133f]RLg-[3s!\u0011\u0011)Ea\u0012\u000e\u0005\u0005\u0005\u0014\u0002\u0002B%\u0003C\u0012q\u0002V1cY\u0016LE-\u001a8uS\u001aLWM]\u0001\u0019O\u0016$X\t_5ti&tw\rV1cY\u0016Le-\u0012=jgR\u001cH\u0003\u0002B(\u0005/\u0002Ra\u0017B\u0007\u0005#\u0002B!!9\u0003T%!!QKAr\u00051\u0019\u0015\r^1m_\u001e$\u0016M\u00197f\u0011\u001d\u0011IF\u0005a\u0001\u0005\u0007\nQ\u0001^1cY\u0016\fAb]1wKN{WO]2f\t\u001a#b!a\u0011\u0003`\tm\u0004b\u0002B\u0005'\u0001\u0007!\u0011\r\t\u00067\n5!1\r\u0019\u0005\u0005K\u0012y\u0007E\u0003C\u0005O\u0012Y'C\u0002\u0003j}\u0011q\u0001R1uCN,G\u000f\u0005\u0003\u0003n\t=D\u0002\u0001\u0003\r\u0005c\u0012y&!A\u0001\u0002\u000b\u0005!1\u000f\u0002\u0004?\u0012\n\u0014\u0003BA@\u0005k\u00022a\u0017B<\u0013\r\u0011I\b\u0018\u0002\u0004\u0003:L\bBB4\u0014\u0001\u0004\u0011\u0019!A\u0007I_>$\u0017.Z\"bi\u0006dwn\u001a\t\u0003\u007fU\u00192!\u0006BB!\rY&QQ\u0005\u0004\u0005\u000fc&AB!osJ+g\r\u0006\u0002\u0003\u0000\u0005\t2m\u001c8wKJ$HK]1og\u001a|'/\\:\u0015\t\t=%Q\u0015\t\b7\u0006='\u0011\u0013BO!\u0015\u0011\u0019J!'q\u001d\u0011\u0011)*!#\u000f\u0007M\u00149*C\u0001^\u0013\u0011\u0011Y*!%\u0003\u0007M+\u0017\u000fE\u0003\\\u0005\u001b\u0011y\n\u0005\u0003\u0002b\n\u0005\u0016\u0002\u0002BR\u0003G\u0014!BQ;dW\u0016$8\u000b]3d\u0011\u001d\u00119k\u0006a\u0001\u0005S\u000b!\u0002\u001e:b]N4wN]7t!\u0015\u0011\u0019J!'a\u0003II7\u000fV1cY\u0016\u0004\u0016M\u001d;ji&|g.\u001a3\u0015\t\u0005-\"q\u0016\u0005\b\u00053B\u0002\u0019\u0001B(\u0003a\u0011W/\u001b7e!\u0006\u0014H/\u001b;j_:$&/\u00198tM>\u0014Xn\u001d\u000b\u00065\nU&q\u0017\u0005\u0006Ee\u0001\r!\u0011\u0005\u0007\u0005sK\u0002\u0019\u00019\u0002\u0011\t\f7/\u001a)bi\"\u0004")
public class HoodieCatalog
extends DelegatingCatalogExtension
implements StagingTableCatalog,
SparkAdapterSupport,
ProvidesHoodieConfig {
    private final SparkSession spark;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private SparkAdapter sparkAdapter;
    private volatile boolean bitmap$0;

    public static Transform[] buildPartitionTransforms(SparkSession sparkSession, String string) {
        return HoodieCatalog$.MODULE$.buildPartitionTransforms(sparkSession, string);
    }

    public static boolean isTablePartitioned(Option<CatalogTable> option) {
        return HoodieCatalog$.MODULE$.isTablePartitioned(option);
    }

    public static Tuple2<Seq<String>, Option<BucketSpec>> convertTransforms(Seq<Transform> seq) {
        return HoodieCatalog$.MODULE$.convertTransforms(seq);
    }

    public scala.collection.immutable.Map<String, String> buildHoodieConfig(HoodieCatalogTable hoodieCatalogTable) {
        return ProvidesHoodieConfig.buildHoodieConfig$((ProvidesHoodieConfig)this, (HoodieCatalogTable)hoodieCatalogTable);
    }

    public scala.collection.immutable.Map<String, String> buildHoodieInsertConfig(HoodieCatalogTable hoodieCatalogTable, SparkSession sparkSession, boolean isOverwritePartition, boolean isOverwriteTable, scala.collection.immutable.Map<String, Option<String>> insertPartitions, scala.collection.immutable.Map<String, String> extraOptions, Option<String> staticOverwritePartitionPathOpt) {
        return ProvidesHoodieConfig.buildHoodieInsertConfig$((ProvidesHoodieConfig)this, (HoodieCatalogTable)hoodieCatalogTable, (SparkSession)sparkSession, (boolean)isOverwritePartition, (boolean)isOverwriteTable, insertPartitions, extraOptions, staticOverwritePartitionPathOpt);
    }

    public scala.collection.immutable.Map<String, Option<String>> buildHoodieInsertConfig$default$5() {
        return ProvidesHoodieConfig.buildHoodieInsertConfig$default$5$((ProvidesHoodieConfig)this);
    }

    public Option<String> buildHoodieInsertConfig$default$7() {
        return ProvidesHoodieConfig.buildHoodieInsertConfig$default$7$((ProvidesHoodieConfig)this);
    }

    public scala.collection.immutable.Map<String, String> getDropDupsConfig(boolean useLegacyInsertModeFlow, scala.collection.immutable.Map<String, String> incomingParams) {
        return ProvidesHoodieConfig.getDropDupsConfig$((ProvidesHoodieConfig)this, (boolean)useLegacyInsertModeFlow, incomingParams);
    }

    public Tuple4<SaveMode, Object, Object, Option<String>> deduceOverwriteConfig(SparkSession sparkSession, HoodieCatalogTable catalogTable, scala.collection.immutable.Map<String, Option<String>> partitionSpec, scala.collection.immutable.Map<String, String> extraOptions) {
        return ProvidesHoodieConfig.deduceOverwriteConfig$((ProvidesHoodieConfig)this, (SparkSession)sparkSession, (HoodieCatalogTable)catalogTable, partitionSpec, extraOptions);
    }

    public scala.collection.immutable.Map<String, String> buildHoodieDropPartitionsConfig(SparkSession sparkSession, HoodieCatalogTable hoodieCatalogTable, String partitionsToDrop) {
        return ProvidesHoodieConfig.buildHoodieDropPartitionsConfig$((ProvidesHoodieConfig)this, (SparkSession)sparkSession, (HoodieCatalogTable)hoodieCatalogTable, (String)partitionsToDrop);
    }

    public scala.collection.immutable.Map<String, String> buildHoodieDeleteTableConfig(HoodieCatalogTable hoodieCatalogTable, SparkSession sparkSession) {
        return ProvidesHoodieConfig.buildHoodieDeleteTableConfig$((ProvidesHoodieConfig)this, (HoodieCatalogTable)hoodieCatalogTable, (SparkSession)sparkSession);
    }

    public HiveSyncConfig buildHiveSyncConfig(SparkSession sparkSession, HoodieCatalogTable hoodieCatalogTable, HoodieTableConfig tableConfig, scala.collection.immutable.Map<String, String> extraOptions) {
        return ProvidesHoodieConfig.buildHiveSyncConfig$((ProvidesHoodieConfig)this, (SparkSession)sparkSession, (HoodieCatalogTable)hoodieCatalogTable, (HoodieTableConfig)tableConfig, extraOptions);
    }

    public scala.collection.immutable.Map<String, String> buildHiveSyncConfig$default$4() {
        return ProvidesHoodieConfig.buildHiveSyncConfig$default$4$((ProvidesHoodieConfig)this);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public StagedTable stageCreate(Identifier x$1, Column[] x$2, Transform[] x$3, java.util.Map<String, String> x$4) throws TableAlreadyExistsException, NoSuchNamespaceException {
        return super.stageCreate(x$1, x$2, x$3, x$4);
    }

    public StagedTable stageReplace(Identifier x$1, Column[] x$2, Transform[] x$3, java.util.Map<String, String> x$4) throws NoSuchNamespaceException, NoSuchTableException {
        return super.stageReplace(x$1, x$2, x$3, x$4);
    }

    public StagedTable stageCreateOrReplace(Identifier x$1, Column[] x$2, Transform[] x$3, java.util.Map<String, String> x$4) throws NoSuchNamespaceException {
        return super.stageCreateOrReplace(x$1, x$2, x$3, x$4);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private SparkAdapter sparkAdapter$lzycompute() {
        HoodieCatalog hoodieCatalog = this;
        synchronized (hoodieCatalog) {
            if (!this.bitmap$0) {
                this.sparkAdapter = SparkAdapterSupport.sparkAdapter$((SparkAdapterSupport)this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkAdapter;
    }

    public SparkAdapter sparkAdapter() {
        if (!this.bitmap$0) {
            return this.sparkAdapter$lzycompute();
        }
        return this.sparkAdapter;
    }

    public SparkSession spark() {
        return this.spark;
    }

    public StagedTable stageCreate(Identifier ident, StructType schema, Transform[] partitions, java.util.Map<String, String> properties) {
        if (this.sparkAdapter().isHoodieTable(properties)) {
            Tuple2<URI, CatalogTableType> locUriAndTableType = this.deduceTableLocationURIAndTableType(ident, properties);
            Transform[] partitionTransforms = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitions)).isEmpty() && HoodieCatalog$.MODULE$.isTablePartitioned(this.getExistingTableIfExists(CatalogV2Implicits$.MODULE$.IdentifierHelper(ident).asTableIdentifier())) ? HoodieCatalog$.MODULE$.buildPartitionTransforms(this.spark(), ((URI)locUriAndTableType._1()).getPath()) : partitions;
            return new HoodieStagedTable(ident, locUriAndTableType, this, schema, partitionTransforms, properties, TableCreationMode.STAGE_CREATE);
        }
        return new BasicStagedTable(ident, super.createTable(ident, schema, partitions, properties), (TableCatalog)this);
    }

    public StagedTable stageReplace(Identifier ident, StructType schema, Transform[] partitions, java.util.Map<String, String> properties) {
        if (this.sparkAdapter().isHoodieTable(properties)) {
            Tuple2<URI, CatalogTableType> locUriAndTableType = this.deduceTableLocationURIAndTableType(ident, properties);
            Transform[] partitionTransforms = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitions)).isEmpty() && HoodieCatalog$.MODULE$.isTablePartitioned(this.getExistingTableIfExists(CatalogV2Implicits$.MODULE$.IdentifierHelper(ident).asTableIdentifier())) ? HoodieCatalog$.MODULE$.buildPartitionTransforms(this.spark(), ((URI)locUriAndTableType._1()).getPath()) : partitions;
            return new HoodieStagedTable(ident, locUriAndTableType, this, schema, partitionTransforms, properties, TableCreationMode.STAGE_REPLACE);
        }
        super.dropTable(ident);
        return new BasicStagedTable(ident, super.createTable(ident, schema, partitions, properties), (TableCatalog)this);
    }

    public StagedTable stageCreateOrReplace(Identifier ident, StructType schema, Transform[] partitions, java.util.Map<String, String> properties) {
        Object object;
        if (this.sparkAdapter().isHoodieTable(properties)) {
            Tuple2<URI, CatalogTableType> locUriAndTableType = this.deduceTableLocationURIAndTableType(ident, properties);
            Transform[] partitionTransforms = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitions)).isEmpty() && HoodieCatalog$.MODULE$.isTablePartitioned(this.getExistingTableIfExists(CatalogV2Implicits$.MODULE$.IdentifierHelper(ident).asTableIdentifier())) ? HoodieCatalog$.MODULE$.buildPartitionTransforms(this.spark(), ((URI)locUriAndTableType._1()).getPath()) : partitions;
            return new HoodieStagedTable(ident, locUriAndTableType, this, schema, partitionTransforms, properties, TableCreationMode.CREATE_OR_REPLACE);
        }
        try {
            object = BoxesRunTime.boxToBoolean((boolean)super.dropTable(ident));
        }
        catch (NoSuchTableException noSuchTableException) {
            object = BoxedUnit.UNIT;
        }
        return new BasicStagedTable(ident, super.createTable(ident, schema, partitions, properties), (TableCatalog)this);
    }

    public Table loadTable(Identifier ident) {
        Table table = super.loadTable(ident);
        if (table instanceof V1Table) {
            V1Table v1Table = (V1Table)table;
            CatalogTable catalogTable0 = v1Table.v1Table();
            if (this.sparkAdapter().isHoodieTable(catalogTable0)) {
                CatalogTable catalogTable;
                Option option = catalogTable0.comment();
                if (option instanceof Some) {
                    scala.collection.immutable.Map newProps;
                    Some some = (Some)option;
                    String v = (String)some.value();
                    scala.collection.immutable.Map x$1 = newProps = catalogTable0.properties().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"comment"), (Object)v));
                    TableIdentifier x$2 = catalogTable0.copy$default$1();
                    CatalogTableType x$3 = catalogTable0.copy$default$2();
                    CatalogStorageFormat x$4 = catalogTable0.copy$default$3();
                    StructType x$5 = catalogTable0.copy$default$4();
                    Option x$6 = catalogTable0.copy$default$5();
                    Seq x$7 = catalogTable0.copy$default$6();
                    Option x$8 = catalogTable0.copy$default$7();
                    String x$9 = catalogTable0.copy$default$8();
                    long x$10 = catalogTable0.copy$default$9();
                    long x$11 = catalogTable0.copy$default$10();
                    String x$12 = catalogTable0.copy$default$11();
                    Option x$13 = catalogTable0.copy$default$13();
                    Option x$14 = catalogTable0.copy$default$14();
                    Option x$15 = catalogTable0.copy$default$15();
                    Seq x$16 = catalogTable0.copy$default$16();
                    boolean x$17 = catalogTable0.copy$default$17();
                    boolean x$18 = catalogTable0.copy$default$18();
                    scala.collection.immutable.Map x$19 = catalogTable0.copy$default$19();
                    Option x$20 = catalogTable0.copy$default$20();
                    catalogTable = catalogTable0.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$1, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
                } else {
                    catalogTable = catalogTable0;
                }
                CatalogTable catalogTable2 = catalogTable;
                HoodieInternalV2Table v2Table = new HoodieInternalV2Table(this.spark(), catalogTable2.location().toString(), (Option<CatalogTable>)new Some((Object)catalogTable2), (Option<String>)new Some((Object)ident.toString()), HoodieInternalV2Table$.MODULE$.apply$default$5());
                boolean schemaEvolutionEnabled = ProvidesHoodieConfig$.MODULE$.isSchemaEvolutionEnabled(this.spark());
                if (schemaEvolutionEnabled) {
                    return v2Table;
                }
                return v2Table.v1TableWrapper();
            }
        }
        return table;
    }

    public Table createTable(Identifier ident, StructType schema, Transform[] partitions, java.util.Map<String, String> properties) {
        if (this.sparkAdapter().isHoodieTable(properties)) {
            Tuple2<URI, CatalogTableType> locUriAndTableType = this.deduceTableLocationURIAndTableType(ident, properties);
            Transform[] partitionTransforms = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitions)).isEmpty() && HoodieCatalog$.MODULE$.isTablePartitioned(this.getExistingTableIfExists(CatalogV2Implicits$.MODULE$.IdentifierHelper(ident).asTableIdentifier())) ? HoodieCatalog$.MODULE$.buildPartitionTransforms(this.spark(), ((URI)locUriAndTableType._1()).getPath()) : partitions;
            return this.createHoodieTable(ident, schema, locUriAndTableType, partitionTransforms, properties, (scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty(), (Option<Dataset<Row>>)Option$.MODULE$.empty(), TableCreationMode.CREATE);
        }
        return super.createTable(ident, schema, partitions, properties);
    }

    public boolean tableExists(Identifier ident) {
        return super.tableExists(ident);
    }

    public boolean dropTable(Identifier ident) {
        Table table = this.loadTable(ident);
        Table table2 = table;
        Option<CatalogTable> option = HoodieSpark3Analysis$HoodieV1OrV2Table$.MODULE$.unapply(table2);
        if (!option.isEmpty()) {
            new DropHoodieTableCommand(CatalogV2Implicits$.MODULE$.IdentifierHelper(ident).asTableIdentifier(), true, false, false).run(this.spark());
            return true;
        }
        return super.dropTable(ident);
    }

    public boolean purgeTable(Identifier ident) {
        Table table = this.loadTable(ident);
        Table table2 = table;
        Option<CatalogTable> option = HoodieSpark3Analysis$HoodieV1OrV2Table$.MODULE$.unapply(table2);
        if (!option.isEmpty()) {
            new DropHoodieTableCommand(CatalogV2Implicits$.MODULE$.IdentifierHelper(ident).asTableIdentifier(), true, false, true).run(this.spark());
            return true;
        }
        return super.purgeTable(ident);
    }

    public void renameTable(Identifier oldIdent, Identifier newIdent) throws NoSuchTableException, TableAlreadyExistsException {
        Table table = this.loadTable(oldIdent);
        Option<CatalogTable> option = HoodieSpark3Analysis$HoodieV1OrV2Table$.MODULE$.unapply(table);
        if (!option.isEmpty()) {
            new AlterHoodieTableRenameCommand(CatalogV2Implicits$.MODULE$.IdentifierHelper(oldIdent).asTableIdentifier(), CatalogV2Implicits$.MODULE$.IdentifierHelper(newIdent).asTableIdentifier(), false).run(this.spark());
            return;
        }
        super.renameTable(oldIdent, newIdent);
    }

    public Table alterTable(Identifier ident, Seq<TableChange> changes) {
        Table table = this.loadTable(ident);
        Option<CatalogTable> option = HoodieSpark3Analysis$HoodieV1OrV2Table$.MODULE$.unapply(table);
        if (!option.isEmpty()) {
            CatalogTable table2 = (CatalogTable)option.get();
            TableIdentifier tableIdent = TableIdentifier$.MODULE$.apply(ident.name(), new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ident.namespace())).lastOption());
            changes.groupBy((Function1 & Serializable & scala.Serializable)c -> c.getClass()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    Class t = (Class)tuple2._1();
                    Seq newColumns = (Seq)tuple2._2();
                    Class clazz = t;
                    Class<TableChange.AddColumn> clazz2 = TableChange.AddColumn.class;
                    if (!(clazz != null ? !clazz.equals(clazz2) : clazz2 != null)) {
                        return new AlterHoodieTableAddColumnsCommand(tableIdent, (Seq)newColumns.map((Function1 & Serializable & scala.Serializable)col -> new StructField(col.fieldNames()[0], col.dataType(), col.isNullable(), StructField$.MODULE$.apply$default$4()), Seq$.MODULE$.canBuildFrom())).run(this.spark());
                    }
                }
                if (tuple2 != null) {
                    Class t = (Class)tuple2._1();
                    Seq columnChanges = (Seq)tuple2._2();
                    if (TableChange.ColumnChange.class.isAssignableFrom(t)) {
                        columnChanges.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                            TableChange tableChange = x0$2;
                            if (tableChange instanceof TableChange.UpdateColumnType) {
                                TableChange.UpdateColumnType updateColumnType = (TableChange.UpdateColumnType)tableChange;
                                String colName = new UnresolvedAttribute((Seq)Predef$.MODULE$.wrapRefArray((Object[])updateColumnType.fieldNames())).name();
                                DataType newDataType = updateColumnType.newDataType();
                                StructField structField = new StructField(colName, newDataType, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                                return new AlterHoodieTableChangeColumnCommand(tableIdent, colName, structField).run(this.spark());
                            }
                            if (tableChange instanceof TableChange.UpdateColumnComment) {
                                TableChange.UpdateColumnComment updateColumnComment = (TableChange.UpdateColumnComment)tableChange;
                                String newComment = updateColumnComment.newComment();
                                String colName = new UnresolvedAttribute((Seq)Predef$.MODULE$.wrapRefArray((Object[])updateColumnComment.fieldNames())).name();
                                Option fieldOpt = table2.schema().findNestedField((Seq)Predef$.MODULE$.wrapRefArray((Object[])updateColumnComment.fieldNames()), true, this.spark().sessionState().conf().resolver(), table2.schema().findNestedField$default$4()).map((Function1 & Serializable & scala.Serializable)x$1 -> (StructField)x$1._2());
                                StructField field = (StructField)fieldOpt.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                                    throw new AnalysisException(new StringBuilder(26).append("Couldn't find column ").append(colName).append(" in:\n").append(table2.schema().treeString()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
                                });
                                return new AlterHoodieTableChangeColumnCommand(tableIdent, colName, field.withComment(newComment)).run(this.spark());
                            }
                            throw new MatchError((Object)tableChange);
                        });
                        return BoxedUnit.UNIT;
                    }
                }
                if (tuple2 != null) {
                    Class t = (Class)tuple2._1();
                    throw new UnsupportedOperationException(new StringBuilder(28).append("not supported table change: ").append(t.getClass()).toString());
                }
                throw new MatchError((Object)tuple2);
            });
            return this.loadTable(ident);
        }
        return super.alterTable(ident, (TableChange[])changes.toArray(ClassTag$.MODULE$.apply(TableChange.class)));
    }

    private Tuple2<URI, CatalogTableType> deduceTableLocationURIAndTableType(Identifier ident, java.util.Map<String, String> properties) {
        Option locOpt = this.isPathIdentifier(ident) ? Option$.MODULE$.apply((Object)ident.name()) : Option$.MODULE$.apply((Object)properties.get("location"));
        CatalogTableType tableType = locOpt.nonEmpty() ? CatalogTableType$.MODULE$.EXTERNAL() : CatalogTableType$.MODULE$.MANAGED();
        Option locUriOpt = locOpt.map((Function1 & Serializable & scala.Serializable)str -> CatalogUtils$.MODULE$.stringToURI(str));
        TableIdentifier tableIdent = CatalogV2Implicits$.MODULE$.IdentifierHelper(ident).asTableIdentifier();
        Option<CatalogTable> existingTableOpt = this.getExistingTableIfExists(tableIdent);
        URI locURI = (URI)locUriOpt.orElse((Function0 & Serializable & scala.Serializable)() -> existingTableOpt.flatMap((Function1 & Serializable & scala.Serializable)x$2 -> x$2.storage().locationUri())).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.spark().sessionState().catalog().defaultTablePath(tableIdent));
        return new Tuple2((Object)locURI, (Object)tableType);
    }

    public Table createHoodieTable(Identifier ident, StructType schema, Tuple2<URI, CatalogTableType> locUriAndTableType, Transform[] partitions, java.util.Map<String, String> allTableProperties, scala.collection.immutable.Map<String, String> writeOptions, Option<Dataset<Row>> sourceQuery, TableCreationMode operation) {
        Seq seq;
        Tuple2<Seq<String>, Option<BucketSpec>> tuple2 = HoodieCatalog$.MODULE$.convertTransforms((Seq<Transform>)Predef$.MODULE$.wrapRefArray((Object[])partitions));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq partitionColumns = (Seq)tuple2._1();
        Option maybeBucketSpec = (Option)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)partitionColumns, (Object)maybeBucketSpec);
        Seq partitionColumns2 = (Seq)tuple22._1();
        Option maybeBucketSpec2 = (Option)tuple22._2();
        StructType newSchema = schema;
        Seq newPartitionColumns = partitionColumns2;
        Option newBucketSpec = maybeBucketSpec2;
        CatalogStorageFormat qual$1 = DataSource$.MODULE$.buildStorageFormatFromOptions((scala.collection.immutable.Map)writeOptions.$minus$minus((GenTraversableOnce)HoodieCatalogTable$.MODULE$.needFilterProps()));
        Option x$1 = Option$.MODULE$.apply(locUriAndTableType._1());
        Option x$2 = qual$1.copy$default$2();
        Option x$3 = qual$1.copy$default$3();
        Option x$4 = qual$1.copy$default$4();
        boolean x$5 = qual$1.copy$default$5();
        scala.collection.immutable.Map x$6 = qual$1.copy$default$6();
        CatalogStorageFormat storage = qual$1.copy(x$1, x$2, x$3, x$4, x$5, x$6);
        Option commentOpt = Option$.MODULE$.apply((Object)allTableProperties.get("comment"));
        HashMap<String, String> tablePropertiesNew = new HashMap<String, String>(allTableProperties);
        tablePropertiesNew.put("path", ((URI)locUriAndTableType._1()).getPath());
        TableIdentifier x$7 = CatalogV2Implicits$.MODULE$.IdentifierHelper(ident).asTableIdentifier();
        CatalogTableType x$8 = (CatalogTableType)locUriAndTableType._2();
        CatalogStorageFormat x$9 = storage;
        StructType x$10 = newSchema;
        Option x$11 = Option$.MODULE$.apply((Object)"hudi");
        Seq x$12 = newPartitionColumns;
        Option x$13 = newBucketSpec;
        scala.collection.immutable.Map x$14 = (scala.collection.immutable.Map)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(tablePropertiesNew).asScala()).toMap(Predef$.MODULE$.$conforms()).$minus$minus((GenTraversableOnce)HoodieCatalogTable$.MODULE$.needFilterProps());
        Option x$15 = commentOpt;
        String x$16 = CatalogTable$.MODULE$.$lessinit$greater$default$8();
        long x$17 = CatalogTable$.MODULE$.$lessinit$greater$default$9();
        long x$18 = CatalogTable$.MODULE$.$lessinit$greater$default$10();
        String x$19 = CatalogTable$.MODULE$.$lessinit$greater$default$11();
        Option x$20 = CatalogTable$.MODULE$.$lessinit$greater$default$13();
        Option x$21 = CatalogTable$.MODULE$.$lessinit$greater$default$14();
        Seq x$22 = CatalogTable$.MODULE$.$lessinit$greater$default$16();
        boolean x$23 = CatalogTable$.MODULE$.$lessinit$greater$default$17();
        boolean x$24 = CatalogTable$.MODULE$.$lessinit$greater$default$18();
        scala.collection.immutable.Map x$25 = CatalogTable$.MODULE$.$lessinit$greater$default$19();
        Option x$26 = CatalogTable$.MODULE$.$lessinit$greater$default$20();
        CatalogTable tableDesc = new CatalogTable(x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$16, x$17, x$18, x$19, x$14, x$20, x$21, x$15, x$22, x$23, x$24, x$25, x$26);
        HoodieCatalogTable hoodieCatalogTable = HoodieCatalogTable$.MODULE$.apply(this.spark(), tableDesc);
        TableCreationMode tableCreationMode = operation;
        TableCreationMode tableCreationMode2 = TableCreationMode.STAGE_CREATE;
        if (!(tableCreationMode != null ? !((Object)((Object)tableCreationMode)).equals((Object)tableCreationMode2) : tableCreationMode2 != null)) {
            String tablePath = hoodieCatalogTable.tableLocation();
            Configuration hadoopConf = this.spark().sessionState().newHadoopConf();
            Predef$.MODULE$.assert(HoodieSqlCommonUtils$.MODULE$.isEmptyPath(tablePath, hadoopConf), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Path '").append(tablePath).append("' should be empty for CTAS").toString());
            hoodieCatalogTable.initHoodieTable();
            scala.collection.immutable.Map tblProperties = hoodieCatalogTable.catalogProperties();
            Tuple2[] tuple2Array = new Tuple2[5];
            CatalogTableType catalogTableType = tableDesc.tableType();
            CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.MANAGED();
            tuple2Array[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.HIVE_CREATE_MANAGED_TABLE().key()), (Object)Boolean.toString(!(catalogTableType != null ? !catalogTableType.equals(catalogTableType2) : catalogTableType2 != null)));
            tuple2Array[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.HIVE_TABLE_SERDE_PROPERTIES().key()), (Object)ConfigUtils.configToString((java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)tblProperties).asJava())));
            tuple2Array[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.HIVE_TABLE_PROPERTIES().key()), (Object)ConfigUtils.configToString((java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)tableDesc.properties()).asJava())));
            tuple2Array[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.SQL_INSERT_MODE().key()), (Object)InsertMode.NON_STRICT.value());
            tuple2Array[4] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.SQL_ENABLE_BULK_INSERT().key()), (Object)"true");
            scala.collection.immutable.Map options = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
            this.saveSourceDF(sourceQuery, (scala.collection.immutable.Map<String, String>)tableDesc.properties().$plus$plus(this.buildHoodieInsertConfig(hoodieCatalogTable, this.spark(), false, false, (scala.collection.immutable.Map<String, Option<String>>)Predef$.MODULE$.Map().empty(), (scala.collection.immutable.Map<String, String>)options, this.buildHoodieInsertConfig$default$7())));
            CreateHoodieTableCommand$.MODULE$.createTableInCatalog(this.spark(), hoodieCatalogTable, false, CreateHoodieTableCommand$.MODULE$.createTableInCatalog$default$4());
            seq = BoxedUnit.UNIT;
        } else if (sourceQuery.isEmpty()) {
            this.saveSourceDF(sourceQuery, (scala.collection.immutable.Map<String, String>)tableDesc.properties());
            seq = new CreateHoodieTableCommand(tableDesc, false).run(this.spark());
        } else {
            this.saveSourceDF(sourceQuery, (scala.collection.immutable.Map<String, String>)tableDesc.properties().$plus$plus(this.buildHoodieInsertConfig(hoodieCatalogTable, this.spark(), false, false, (scala.collection.immutable.Map<String, Option<String>>)Predef$.MODULE$.Map().empty(), (scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty(), this.buildHoodieInsertConfig$default$7())));
            seq = new CreateHoodieTableCommand(tableDesc, false).run(this.spark());
        }
        return this.loadTable(ident);
    }

    private boolean isPathIdentifier(Identifier ident) {
        return new Path(ident.name()).isAbsolute();
    }

    public boolean isPathIdentifier(TableIdentifier tableIdentifier) {
        return this.isPathIdentifier(Identifier.of((String[])((String[])Option$.MODULE$.option2Iterable(tableIdentifier.database()).toArray(ClassTag$.MODULE$.apply(String.class))), (String)tableIdentifier.table()));
    }

    private Option<CatalogTable> getExistingTableIfExists(TableIdentifier table) {
        SessionCatalog catalog = this.spark().sessionState().catalog();
        if (this.isPathIdentifier(table)) {
            return None$.MODULE$;
        }
        boolean tableExists = catalog.tableExists(table);
        if (tableExists) {
            CatalogTable oldTable = catalog.getTableMetadata(table);
            CatalogTableType catalogTableType = oldTable.tableType();
            CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.VIEW();
            if (!(catalogTableType != null ? !catalogTableType.equals(catalogTableType2) : catalogTableType2 != null)) {
                throw new HoodieException(new StringBuilder(47).append(table).append(" is a view. You may not write data into a view.").toString());
            }
            if (!this.sparkAdapter().isHoodieTable(oldTable)) {
                throw new HoodieException(new StringBuilder(23).append(table).append(" is not a Hoodie table.").toString());
            }
            return new Some((Object)oldTable);
        }
        return None$.MODULE$;
    }

    private void saveSourceDF(Option<Dataset<?>> sourceQuery, scala.collection.immutable.Map<String, String> properties) {
        sourceQuery.map((Function1 & Serializable & scala.Serializable)df -> {
            df.write().format("org.apache.hudi").options((Map)properties).mode(SaveMode.Append).save();
            return df;
        });
    }

    public Table alterTable(Identifier ident, TableChange[] changes) {
        return this.alterTable(ident, (Seq<TableChange>)Predef$.MODULE$.wrapRefArray((Object[])changes));
    }

    public HoodieCatalog() {
        SparkAdapterSupport.$init$((SparkAdapterSupport)this);
        Logging.$init$((Logging)this);
        ProvidesHoodieConfig.$init$((ProvidesHoodieConfig)this);
        this.spark = SparkSession$.MODULE$.active();
    }
}

