/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import org.apache.hudi.HoodieUnsafeRDD;
import org.apache.hudi.SparkAdapterSupport$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.HoodieUnsafeUtils;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.physical.Partitioning;
import org.apache.spark.sql.catalyst.plans.physical.UnknownPartitioning;
import org.apache.spark.sql.execution.LogicalRDD;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.MutablePair;
import scala.Function1;
import scala.Serializable;
import scala.collection.Seq;
import scala.reflect.ClassTag$;

public final class Spark3HoodieUnsafeUtils$
implements HoodieUnsafeUtils {
    public static Spark3HoodieUnsafeUtils$ MODULE$;

    static {
        new Spark3HoodieUnsafeUtils$();
    }

    public int getNumPartitions(Dataset<Row> df) {
        LogicalPlan logicalPlan = df.queryExecution().logical();
        if (logicalPlan instanceof LogicalRDD) {
            LogicalRDD logicalRDD = (LogicalRDD)logicalPlan;
            RDD rdd = logicalRDD.rdd();
            Partitioning outputPartitioning = logicalRDD.outputPartitioning();
            Partitioning partitioning = outputPartitioning;
            if (partitioning instanceof UnknownPartitioning) {
                return rdd.getNumPartitions();
            }
            return outputPartitioning.numPartitions();
        }
        return df.queryExecution().executedPlan().outputPartitioning().numPartitions();
    }

    public Dataset<Row> createDataFrameFrom(SparkSession spark, LogicalPlan plan) {
        return Dataset$.MODULE$.ofRows(spark, plan);
    }

    public Dataset<Row> createDataFrameFromRows(SparkSession spark, Seq<Row> rows, StructType schema) {
        return Dataset$.MODULE$.ofRows(spark, (LogicalPlan)LocalRelation$.MODULE$.fromExternalRows(SparkAdapterSupport$.MODULE$.sparkAdapter().getSchemaUtils().toAttributes(schema), rows));
    }

    public Dataset<Row> createDataFrameFromInternalRows(SparkSession spark, Seq<InternalRow> rows, StructType schema) {
        return Dataset$.MODULE$.ofRows(spark, (LogicalPlan)new LocalRelation(SparkAdapterSupport$.MODULE$.sparkAdapter().getSchemaUtils().toAttributes(schema), rows, LocalRelation$.MODULE$.apply$default$3()));
    }

    public Dataset<Row> createDataFrameFromRDD(SparkSession spark, RDD<InternalRow> rdd, StructType schema) {
        return spark.internalCreateDataFrame(rdd, schema, spark.internalCreateDataFrame$default$3());
    }

    public InternalRow[] collect(HoodieUnsafeRDD rdd) {
        return (InternalRow[])((RDD)rdd).mapPartitionsInternal((Function1 & java.io.Serializable & Serializable)iter -> {
            MutablePair pair = new MutablePair();
            return iter.map((Function1 & java.io.Serializable & Serializable)row -> pair.update((Object)row.copy(), null));
        }, ((RDD)rdd).mapPartitionsInternal$default$2(), ClassTag$.MODULE$.apply(MutablePair.class)).map((Function1 & java.io.Serializable & Serializable)p -> (InternalRow)p._1(), ClassTag$.MODULE$.apply(InternalRow.class)).collect();
    }

    private Spark3HoodieUnsafeUtils$() {
        MODULE$ = this;
    }
}

