/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command;

import java.io.Serializable;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.SparkAdapterSupport;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.HoodieCatalystExpressionUtils$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable$;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Alias$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.plans.logical.Assignment;
import org.apache.spark.sql.catalyst.plans.logical.Filter;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.plans.logical.UpdateTable;
import org.apache.spark.sql.hudi.HoodieSqlCommonUtils$;
import org.apache.spark.sql.hudi.SparkAdapter;
import org.apache.spark.sql.hudi.command.UpdateHoodieTableCommand;
import org.apache.spark.sql.hudi.command.exception.HoodieAnalysisException;
import org.apache.spark.sql.hudi.command.exception.HoodieAnalysisException$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class UpdateHoodieTableCommand$
implements SparkAdapterSupport,
Logging,
scala.Serializable {
    public static UpdateHoodieTableCommand$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private SparkAdapter sparkAdapter;
    private volatile boolean bitmap$0;

    static {
        new UpdateHoodieTableCommand$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private SparkAdapter sparkAdapter$lzycompute() {
        UpdateHoodieTableCommand$ updateHoodieTableCommand$ = this;
        synchronized (updateHoodieTableCommand$) {
            if (!this.bitmap$0) {
                this.sparkAdapter = SparkAdapterSupport.sparkAdapter$((SparkAdapterSupport)this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkAdapter;
    }

    public SparkAdapter sparkAdapter() {
        if (!this.bitmap$0) {
            return this.sparkAdapter$lzycompute();
        }
        return this.sparkAdapter;
    }

    private void validateNoAssignmentsToTargetTableAttr(Function2<String, String, Object> resolver, Seq<String> fields, String tableId, String fieldType, Seq<Tuple2<AttributeReference, Expression>> assignments) {
        fields.foreach((Function1 & Serializable & scala.Serializable)field -> {
            UpdateHoodieTableCommand$.$anonfun$validateNoAssignmentsToTargetTableAttr$1(assignments, resolver, fieldType, tableId, field);
            return BoxedUnit.UNIT;
        });
    }

    public HoodieCatalogTable org$apache$spark$sql$hudi$command$UpdateHoodieTableCommand$$catalogTable(SparkSession sparkSession, UpdateTable ut) {
        Option option = this.sparkAdapter().resolveHoodieTable(ut.table());
        if (option instanceof Some) {
            Some some = (Some)option;
            CatalogTable catalogTable = (CatalogTable)some.value();
            return HoodieCatalogTable$.MODULE$.apply(sparkSession, catalogTable);
        }
        throw new HoodieAnalysisException(new StringBuilder(69).append("Failed to resolve update statement into the Hudi table. Got instead: ").append(ut.table()).toString(), HoodieAnalysisException$.MODULE$.$lessinit$greater$default$2(), HoodieAnalysisException$.MODULE$.$lessinit$greater$default$3());
    }

    public LogicalPlan inputPlan(SparkSession sparkSession, UpdateTable ut) {
        HoodieCatalogTable hoodieCatalogTable = this.org$apache$spark$sql$hudi$command$UpdateHoodieTableCommand$$catalogTable(sparkSession, ut);
        String tableId = hoodieCatalogTable.table().qualifiedName();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Executing 'UPDATE' command for ").append(tableId).toString());
        Seq assignedAttributes = (Seq)ut.assignments().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Assignment assignment = x0$1;
            if (assignment != null) {
                Expression attr = assignment.key();
                Expression value = assignment.value();
                if (attr instanceof AttributeReference) {
                    AttributeReference attributeReference = (AttributeReference)attr;
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)attributeReference), (Object)value);
                }
            }
            throw new MatchError((Object)assignment);
        }, Seq$.MODULE$.canBuildFrom());
        this.validateNoAssignmentsToTargetTableAttr((Function2<String, String, Object>)sparkSession.sessionState().conf().resolver(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])hoodieCatalogTable.tableConfig().getPartitionFields().orElse(Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)))), tableId, "partition field", (Seq<Tuple2<AttributeReference, Expression>>)assignedAttributes);
        this.validateNoAssignmentsToTargetTableAttr((Function2<String, String, Object>)sparkSession.sessionState().conf().resolver(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])hoodieCatalogTable.tableConfig().getRecordKeyFields().orElse(Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)))), tableId, "record key field", (Seq<Tuple2<AttributeReference, Expression>>)assignedAttributes);
        String string = sparkSession.sessionState().conf().getConfString(DataSourceWriteOptions$.MODULE$.SPARK_SQL_OPTIMIZED_WRITES().key(), (String)DataSourceWriteOptions$.MODULE$.SPARK_SQL_OPTIMIZED_WRITES().defaultValue());
        String string2 = "true";
        Seq filteredOutput = !(string != null ? !string.equals(string2) : string2 != null) ? ut.table().output() : HoodieSqlCommonUtils$.MODULE$.removeMetaFields(ut.table().output());
        Seq targetExprs = (Seq)filteredOutput.map((Function1 & Serializable & scala.Serializable)targetAttr -> (NamedExpression)assignedAttributes.find((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)HoodieCatalystExpressionUtils$.MODULE$.attributeEquals((Attribute)p._1(), targetAttr))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                Expression expr = (Expression)tuple2._2();
                Expression x$1 = HoodieSqlCommonUtils$.MODULE$.castIfNeeded(expr, targetAttr.dataType());
                String x$2 = targetAttr.name();
                ExprId x$3 = Alias$.MODULE$.apply$default$3(x$1, x$2);
                Seq x$4 = Alias$.MODULE$.apply$default$4(x$1, x$2);
                Option x$5 = Alias$.MODULE$.apply$default$5(x$1, x$2);
                Seq x$6 = Alias$.MODULE$.apply$default$6(x$1, x$2);
                return new Alias(x$1, x$2, x$3, x$4, x$5, x$6);
            }
            throw new MatchError((Object)tuple2);
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> targetAttr), Seq$.MODULE$.canBuildFrom());
        Expression condition = (Expression)ut.condition().getOrElse((Function0 & Serializable & scala.Serializable)() -> Literal$.MODULE$.TrueLiteral());
        return new Project(targetExprs, (LogicalPlan)new Filter(condition, ut.table()));
    }

    public UpdateHoodieTableCommand apply(UpdateTable ut, LogicalPlan query) {
        return new UpdateHoodieTableCommand(ut, query);
    }

    public Option<Tuple2<UpdateTable, LogicalPlan>> unapply(UpdateHoodieTableCommand x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple2((Object)x$0.ut(), (Object)x$0.query()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$validateNoAssignmentsToTargetTableAttr$2(Function2 resolver$1, String field$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            AttributeReference attr = (AttributeReference)tuple2._1();
            return BoxesRunTime.unboxToBoolean((Object)resolver$1.apply((Object)attr.name(), (Object)field$1));
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$validateNoAssignmentsToTargetTableAttr$1(Seq assignments$1, Function2 resolver$1, String fieldType$1, String tableId$2, String field) {
        if (assignments$1.exists((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)UpdateHoodieTableCommand$.$anonfun$validateNoAssignmentsToTargetTableAttr$2(resolver$1, field, x0$1)))) {
            throw new HoodieAnalysisException(new StringBuilder(135).append("Detected disallowed assignment clause in UPDATE statement for ").append(fieldType$1).append(" ").append("`").append(field).append("` for table `").append(tableId$2).append("`. Please remove the assignment clause to avoid the error.").toString(), HoodieAnalysisException$.MODULE$.$lessinit$greater$default$2(), HoodieAnalysisException$.MODULE$.$lessinit$greater$default$3());
        }
    }

    private UpdateHoodieTableCommand$() {
        MODULE$ = this;
        SparkAdapterSupport.$init$((SparkAdapterSupport)this);
        Logging.$init$((Logging)this);
    }
}

