/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.utils;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.apache.hudi.com.google.common.util.concurrent.ThreadFactoryBuilder;

public class ThreadUtils {
    public static ExecutorService newSingleThreadExecutor(String processName) {
        return Executors.newSingleThreadExecutor(ThreadUtils.newThreadFactory(processName));
    }

    public static ExecutorService newFixedThreadPool(int qty, String processName) {
        return Executors.newFixedThreadPool(qty, ThreadUtils.newThreadFactory(processName));
    }

    public static ScheduledExecutorService newSingleThreadScheduledExecutor(String processName) {
        return Executors.newSingleThreadScheduledExecutor(ThreadUtils.newThreadFactory(processName));
    }

    public static ScheduledExecutorService newFixedThreadScheduledPool(int qty, String processName) {
        return Executors.newScheduledThreadPool(qty, ThreadUtils.newThreadFactory(processName));
    }

    public static ThreadFactory newThreadFactory(String processName) {
        return ThreadUtils.newGenericThreadFactory("Curator-" + processName);
    }

    public static ThreadFactory newGenericThreadFactory(String processName) {
        return new ThreadFactoryBuilder().setNameFormat(processName + "-%d").setDaemon(true).build();
    }

    public static String getProcessName(Class<?> clazz) {
        if (clazz.isAnonymousClass()) {
            return ThreadUtils.getProcessName(clazz.getEnclosingClass());
        }
        return clazz.getSimpleName();
    }
}

