/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.io.Serializable;
import java.util.List;
import java.util.Properties;
import org.apache.avro.Conversions;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.AvroConversionUtils$;
import org.apache.hudi.ColumnStatsIndexSupport$;
import org.apache.hudi.HoodieCatalystUtils$;
import org.apache.hudi.HoodieConversionUtils$;
import org.apache.hudi.HoodieFileIndex;
import org.apache.hudi.avro.model.HoodieMetadataColumnStats;
import org.apache.hudi.avro.model.HoodieMetadataRecord;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.view.FileSystemViewStorageConfig;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.common.util.hash.ColumnIndexID;
import org.apache.hudi.data.HoodieJavaRDD;
import org.apache.hudi.metadata.HoodieMetadataPayload;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.apache.hudi.util.JFunction$;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaRDD$;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.HoodieUnsafeUtils$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.storage.StorageLevel$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.TreeSet;
import scala.collection.immutable.TreeSet$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.parallel.mutable.ParHashMap;
import scala.collection.parallel.mutable.ParHashMap$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tEh\u0001B\u0017/\u0001UB\u0001\u0002\u0010\u0001\u0003\u0002\u0003\u0006I!\u0010\u0005\t\t\u0002\u0011\t\u0011)A\u0005\u000b\"A1\n\u0001B\u0001B\u0003%A\n\u0003\u0005Y\u0001\t\u0005\t\u0015!\u0003Z\u0011!\u0001\u0007A!A!\u0002\u0013\t\u0007\"\u00023\u0001\t\u0003)\u0007\u0002C7\u0001\u0011\u000b\u0007I\u0011\u00028\t\u0011]\u0004\u0001R1A\u0005\naD!\"!\u0001\u0001\u0011\u000b\u0007I\u0011BA\u0002\u0011%\ty\u0006\u0001b\u0001\n\u0013\t\t\u0007\u0003\u0005\u0002t\u0001\u0001\u000b\u0011BA2\u0011)\t)\b\u0001EC\u0002\u0013%\u0011q\u000f\u0005\b\u0003\u007f\u0002A\u0011AAA\u0011\u001d\t\u0019\t\u0001C\u0001\u0003\u000bCq!!&\u0001\t\u0003\t9\nC\u0004\u0002D\u0002!\t!!2\t\u0013\u0005-\u0007!%A\u0005\u0002\u00055\u0007\"CAr\u0001E\u0005I\u0011AAs\u0011\u001d\tI\u000f\u0001C\u0001\u0003WDq!a=\u0001\t\u0013\t)\u0010C\u0004\u0003*\u0001!IAa\u000b\t\u000f\tE\u0002\u0001\"\u0003\u00034!9!\u0011\b\u0001\u0005\n\tmra\u0002B\u001f]!\u0005!q\b\u0004\u0007[9B\tA!\u0011\t\r\u0011LB\u0011\u0001B\"\u0011%\u0011)%\u0007b\u0001\n\u0013\u00119\u0005\u0003\u0005\u0003Xe\u0001\u000b\u0011\u0002B%\u0011%\u0011I&\u0007b\u0001\n\u0013\u0011Y\u0006\u0003\u0005\u0003de\u0001\u000b\u0011\u0002B/\u0011%\u0011)'\u0007b\u0001\n\u0013\u00119\u0007C\u0004\u0003je\u0001\u000b\u0011B#\t\u000f\t-\u0014\u0004\"\u0001\u0003n!9!QO\r\u0005\u0002\t]\u0004b\u0002BC3\u0011\u0005!q\u0011\u0005\b\u0005\u001bKB\u0011\u0001BH\u0011\u001d\u0011)*\u0007C\u0001\u0005/CaBa'\u001a\t\u0003\u0005)\u0011!A\u0001\n\u0013\u0011i\nC\u0004\u0003*f!IAa+\t\u000f\t\r\u0017\u0004\"\u0003\u0003F\"I!1Z\rC\u0002\u0013\u0005!Q\u001a\u0005\t\u0005GL\u0002\u0015!\u0003\u0003P\"9!Q]\r\u0005\n\t\u001d\b\"\u0003Bx3E\u0005I\u0011AAs\u0005]\u0019u\u000e\\;n]N#\u0018\r^:J]\u0012,\u0007pU;qa>\u0014HO\u0003\u00020a\u0005!\u0001.\u001e3j\u0015\t\t$'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002g\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\u000e\t\u0003oij\u0011\u0001\u000f\u0006\u0002s\u0005)1oY1mC&\u00111\b\u000f\u0002\u0007\u0003:L(+\u001a4\u0002\u000bM\u0004\u0018M]6\u0011\u0005y\u0012U\"A \u000b\u0005\u0001\u000b\u0015aA:rY*\u0011A\bM\u0005\u0003\u0007~\u0012Ab\u00159be.\u001cVm]:j_:\f1\u0002^1cY\u0016\u001c6\r[3nCB\u0011a)S\u0007\u0002\u000f*\u0011\u0001jP\u0001\u0006if\u0004Xm]\u0005\u0003\u0015\u001e\u0013!b\u0015;sk\u000e$H+\u001f9f\u00039iW\r^1eCR\f7i\u001c8gS\u001e\u0004\"!\u0014*\u000e\u00039S!a\u0014)\u0002\r\r|gNZ5h\u0015\t\tf&\u0001\u0004d_6lwN\\\u0005\u0003':\u0013A\u0003S8pI&,W*\u001a;bI\u0006$\u0018mQ8oM&<\u0007FA\u0002V!\t9d+\u0003\u0002Xq\tIAO]1og&,g\u000e^\u0001\u000b[\u0016$\u0018m\u00117jK:$\bC\u0001.^\u001b\u0005Y&B\u0001/Q\u0003\u0015!\u0018M\u00197f\u0013\tq6LA\u000bI_>$\u0017.\u001a+bE2,W*\u001a;b\u00072LWM\u001c;)\u0005\u0011)\u0016\u0001D1mY><8)Y2iS:<\u0007CA\u001cc\u0013\t\u0019\u0007HA\u0004C_>dW-\u00198\u0002\rqJg.\u001b;?)\u00191\u0007.\u001b6lYB\u0011q\rA\u0007\u0002]!)AH\u0002a\u0001{!)AI\u0002a\u0001\u000b\")1J\u0002a\u0001\u0019\")\u0001L\u0002a\u00013\"9\u0001M\u0002I\u0001\u0002\u0004\t\u0017!C3oO&tWm\u0011;y+\u0005y\u0007C\u00019u\u001b\u0005\t(BA)s\u0015\t\u0019h&\u0001\u0004dY&,g\u000e^\u0005\u0003kF\u0014\u0001\u0004S8pI&,7\u000b]1sW\u0016sw-\u001b8f\u0007>tG/\u001a=uQ\t9Q+A\u0007nKR\fG-\u0019;b)\u0006\u0014G.Z\u000b\u0002sB\u0011!0`\u0007\u0002w*\u0011APL\u0001\t[\u0016$\u0018\rZ1uC&\u0011ap\u001f\u0002\u0014\u0011>|G-[3UC\ndW-T3uC\u0012\fG/\u0019\u0015\u0003\u0011U\u000b1dY1dQ\u0016$7i\u001c7v[:\u001cF/\u0019;t\u0013:$W\r\u001f,jK^\u001cXCAA\u0003!!\t9!!\u0006\u0002\u001a\u0005\u0005SBAA\u0005\u0015\u0011\tY!!\u0004\u0002\u000f5,H/\u00192mK*!\u0011qBA\t\u0003!\u0001\u0018M]1mY\u0016d'bAA\nq\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005]\u0011\u0011\u0002\u0002\u000b!\u0006\u0014\b*Y:i\u001b\u0006\u0004\bCBA\u000e\u0003W\t\tD\u0004\u0003\u0002\u001e\u0005\u001db\u0002BA\u0010\u0003Ki!!!\t\u000b\u0007\u0005\rB'\u0001\u0004=e>|GOP\u0005\u0002s%\u0019\u0011\u0011\u0006\u001d\u0002\u000fA\f7m[1hK&!\u0011QFA\u0018\u0005\r\u0019V-\u001d\u0006\u0004\u0003SA\u0004\u0003BA\u001a\u0003wqA!!\u000e\u00028A\u0019\u0011q\u0004\u001d\n\u0007\u0005e\u0002(\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003{\tyD\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003sA\u0004\u0003BA\"\u0003/rA!!\u0012\u0002V9!\u0011qIA*\u001d\u0011\tI%!\u0015\u000f\t\u0005-\u0013q\n\b\u0005\u0003?\ti%C\u00014\u0013\t\t$'\u0003\u0002=a%\u0011\u0001)Q\u0005\u0004\u0003Sy\u0014\u0002BA-\u00037\u0012\u0011\u0002R1uC\u001a\u0013\u0018-\\3\u000b\u0007\u0005%r\b\u000b\u0002\n+\u0006Y\u0012N\\'f[>\u0014\u0018\u0010\u0015:pU\u0016\u001cG/[8o)\"\u0014Xm\u001d5pY\u0012,\"!a\u0019\u0011\t\u0005\u0015\u0014qN\u0007\u0003\u0003ORA!!\u001b\u0002l\u0005!A.\u00198h\u0015\t\ti'\u0001\u0003kCZ\f\u0017\u0002BA9\u0003O\u0012q!\u00138uK\u001e,'/\u0001\u000fj]6+Wn\u001c:z!J|'.Z2uS>tG\u000b\u001b:fg\"|G\u000e\u001a\u0011\u0002\u001d%tG-\u001a=fI\u000e{G.^7ogV\u0011\u0011\u0011\u0010\t\u0007\u0003g\tY(!\r\n\t\u0005u\u0014q\b\u0002\u0004'\u0016$\u0018\u0001E5t\u0013:$W\r_!wC&d\u0017M\u00197f+\u0005\t\u0017AE:i_VdGMU3bI&sW*Z7pef$R!YAD\u0003#Cq!!#\u000f\u0001\u0004\tY)A\u0005gS2,\u0017J\u001c3fqB\u0019q-!$\n\u0007\u0005=eFA\bI_>$\u0017.\u001a$jY\u0016Le\u000eZ3y\u0011\u001d\t\u0019J\u0004a\u0001\u00033\ta#];fef\u0014VMZ3sK:\u001cW\rZ\"pYVlgn]\u0001\u000fY>\fG\r\u0016:b]N\u0004xn]3e+\u0011\tI*!)\u0015\r\u0005m\u0015QXAa)\u0011\ti*a-\u0011\t\u0005}\u0015\u0011\u0015\u0007\u0001\t\u001d\t\u0019k\u0004b\u0001\u0003K\u0013\u0011\u0001V\t\u0005\u0003O\u000bi\u000bE\u00028\u0003SK1!a+9\u0005\u001dqu\u000e\u001e5j]\u001e\u00042aNAX\u0013\r\t\t\f\u000f\u0002\u0004\u0003:L\bbBA[\u001f\u0001\u0007\u0011qW\u0001\u0006E2|7m\u001b\t\bo\u0005e\u0016\u0011IAO\u0013\r\tY\f\u000f\u0002\n\rVt7\r^5p]FBq!a0\u0010\u0001\u0004\tI\"A\u0007uCJ<W\r^\"pYVlgn\u001d\u0005\u0007\u0003\u0007{\u0001\u0019A1\u0002\t1|\u0017\r\u001a\u000b\u0007\u0003\u0003\n9-!3\t\u0013\u0005}\u0006\u0003%AA\u0002\u0005e\u0001\u0002CAB!A\u0005\t\u0019A1\u0002\u001d1|\u0017\r\u001a\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011q\u001a\u0016\u0005\u00033\t\tn\u000b\u0002\u0002TB!\u0011Q[Ap\u001b\t\t9N\u0003\u0003\u0002Z\u0006m\u0017!C;oG\",7m[3e\u0015\r\ti\u000eO\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAq\u0003/\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039aw.\u00193%I\u00164\u0017-\u001e7uII*\"!a:+\u0007\u0005\f\t.\u0001\tj]Z\fG.\u001b3bi\u0016\u001c\u0015m\u00195fgR\u0011\u0011Q\u001e\t\u0004o\u0005=\u0018bAAyq\t!QK\\5u\u0003%!(/\u00198ta>\u001cX\r\u0006\u0004\u0002x\n=!Q\u0005\t\u0007o\u0005e\u0018Q`#\n\u0007\u0005m\bH\u0001\u0004UkBdWM\r\t\u0007\u0003\u007f\u0014)A!\u0003\u000e\u0005\t\u0005!b\u0001B\u0002!\u0006!A-\u0019;b\u0013\u0011\u00119A!\u0001\u0003\u0015!{w\u000eZ5f\t\u0006$\u0018\rE\u0002?\u0005\u0017I1A!\u0004@\u0005\r\u0011vn\u001e\u0005\b\u0005#!\u0002\u0019\u0001B\n\u0003=\u0019w\u000e\\*uCR\u001c(+Z2pe\u0012\u001c\bCBA\u0000\u0005\u000b\u0011)\u0002\u0005\u0003\u0003\u0018\t\u0005RB\u0001B\r\u0015\u0011\u0011YB!\b\u0002\u000b5|G-\u001a7\u000b\u0007\t}a&\u0001\u0003bmJ|\u0017\u0002\u0002B\u0012\u00053\u0011\u0011\u0004S8pI&,W*\u001a;bI\u0006$\u0018mQ8mk6t7\u000b^1ug\"9!q\u0005\u000bA\u0002\u0005e\u0011\u0001D9vKJL8i\u001c7v[:\u001c\u0018A\n7pC\u0012\u001cu\u000e\\;n]N#\u0018\r^:J]\u0012,\u0007PR8s\u0007>dW/\u001c8t\u0013:$XM\u001d8bYR1\u0011\u0011\tB\u0017\u0005_Aq!a0\u0016\u0001\u0004\tI\u0002\u0003\u0004\u0002\u0004V\u0001\r!Y\u0001\u001cY>\fGmQ8mk6t7\u000b^1ug&sG-\u001a=SK\u000e|'\u000fZ:\u0015\r\tM!Q\u0007B\u001c\u0011\u001d\tyL\u0006a\u0001\u00033Aa!a!\u0017\u0001\u0004\t\u0017\u0001\t7pC\u00124U\u000f\u001c7D_2,XN\\*uCR\u001c\u0018J\u001c3fq&sG/\u001a:oC2$\"!!\u0011\u0002/\r{G.^7o'R\fGo]%oI\u0016D8+\u001e9q_J$\bCA4\u001a'\tIb\u0007\u0006\u0002\u0003@\u0005AR\r\u001f9fGR,G-\u0011<s_N\u001b\u0007.Z7b-\u0006dW/Z:\u0016\u0005\t%\u0003C\u0002B&\u0005#\u0012\u0019&\u0004\u0002\u0003N)!!qJA\t\u0003%IW.\\;uC\ndW-\u0003\u0003\u0002~\t5\u0003\u0003BA3\u0005+JA!!\u0010\u0002h\u0005IR\r\u001f9fGR,G-\u0011<s_N\u001b\u0007.Z7b-\u0006dW/Z:!\u0003u!\u0018M]4fi\u000e{G.^7o'R\fGo]%oI\u0016D8i\u001c7v[:\u001cXC\u0001B/!\u0019\u0011yF!\u0019\u0003T5\u0011\u0011\u0011C\u0005\u0005\u0003[\t\t\"\u0001\u0010uCJ<W\r^\"pYVlgn\u0015;biNLe\u000eZ3y\u0007>dW/\u001c8tA\u0005Y2m\u001c7v[:\u001cF/\u0019;t%\u0016\u001cwN\u001d3TiJ,8\r\u001e+za\u0016,\u0012!R\u0001\u001dG>dW/\u001c8Ti\u0006$8OU3d_J$7\u000b\u001e:vGR$\u0016\u0010]3!\u0003I\u0019w.\u001c9pg\u0016Le\u000eZ3y'\u000eDW-\\1\u0015\u000b\u0015\u0013yGa\u001d\t\u000f\tE\u0014\u00051\u0001\u0002\u001a\u0005\tB/\u0019:hKR\u001cu\u000e\\;n]:\u000bW.Z:\t\u000b\u0011\u000b\u0003\u0019A#\u0002'\u001d,G/T5o\u0007>dW/\u001c8OC6,gi\u001c:\u0015\t\u0005E\"\u0011\u0010\u0005\b\u0005w\u0012\u0003\u0019AA\u0019\u0003\u001d\u0019w\u000e\u001c(b[\u0016D3A\tB@!\r9$\u0011Q\u0005\u0004\u0005\u0007C$AB5oY&tW-A\nhKRl\u0015\r_\"pYVlgNT1nK\u001a{'\u000f\u0006\u0003\u00022\t%\u0005b\u0002B>G\u0001\u0007\u0011\u0011\u0007\u0015\u0004G\t}\u0014!G4fi:+H\u000e\\\"pk:$8i\u001c7v[:t\u0015-\\3G_J$B!!\r\u0003\u0012\"9!1\u0010\u0013A\u0002\u0005E\u0002f\u0001\u0013\u0003\u0000\u0005Qr-\u001a;WC2,XmQ8v]R\u001cu\u000e\\;n]:\u000bW.\u001a$peV\u0011\u0011\u0011\u0007\u0015\u0004K\t}\u0014AN8sO\u0012\n\u0007/Y2iK\u0012BW\u000fZ5%\u0007>dW/\u001c8Ti\u0006$8/\u00138eKb\u001cV\u000f\u001d9peR$CEZ8s[\u0006$8i\u001c7OC6,GC\u0002B*\u0005?\u0013\u0019\u000bC\u0004\u0003\"\u001a\u0002\r!!\r\u0002\u0007\r|G\u000eC\u0004\u0003&\u001a\u0002\r!!\r\u0002\u0011M$\u0018\r\u001e(b[\u0016D3A\nB@\u0003m\u0019w.\u001c9pg\u0016\u001cu\u000e\\;n]N#\u0018\r^*ueV\u001cG\u000fV=qKRA!Q\u0016BZ\u0005k\u00139\fE\u0002G\u0005_K1A!-H\u0005-\u0019FO];di\u001aKW\r\u001c3\t\u000f\t\u0005v\u00051\u0001\u00022!9!QU\u0014A\u0002\u0005E\u0002b\u0002B]O\u0001\u0007!1X\u0001\tI\u0006$\u0018\rV=qKB\u0019aI!0\n\u0007\t}vI\u0001\u0005ECR\fG+\u001f9fQ\r9#qP\u0001\u0016iJLXK\u001c9bG.4\u0016\r\\;f/J\f\u0007\u000f]3s)\u0011\tiKa2\t\r\t%\u0007\u00061\u00017\u000311\u0018\r\\;f/J\f\u0007\u000f]3s\u0003\u001d!WmY\"p]Z,\"Aa4\u0011\t\tE'Q\u001c\b\u0005\u0005'\u00149N\u0004\u0003\u0002J\tU\u0017b\u0001B\u0010a%!!\u0011\u001cBn\u0003-\u0019uN\u001c<feNLwN\\:\u000b\u0007\t}\u0001'\u0003\u0003\u0003`\n\u0005(!\u0005#fG&l\u0017\r\\\"p]Z,'o]5p]*!!\u0011\u001cBn\u0003!!WmY\"p]Z\u0004\u0013a\u00033fg\u0016\u0014\u0018.\u00197ju\u0016$b!!,\u0003j\n5\bb\u0002BvW\u0001\u0007\u0011QV\u0001\u0006m\u0006dW/\u001a\u0005\b\u0005s[\u0003\u0019\u0001B^\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%k\u0001")
public class ColumnStatsIndexSupport {
    private transient HoodieSparkEngineContext engineCtx;
    private transient HoodieTableMetadata metadataTable;
    private transient ParHashMap<Seq<String>, Dataset<Row>> cachedColumnStatsIndexViews;
    private Set<String> indexedColumns;
    private final SparkSession spark;
    private final StructType tableSchema;
    private final transient HoodieMetadataConfig metadataConfig;
    private final transient HoodieTableMetaClient metaClient;
    private final boolean allowCaching;
    private final Integer inMemoryProjectionThreshold;
    private volatile transient byte bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static boolean $lessinit$greater$default$5() {
        return ColumnStatsIndexSupport$.MODULE$.$lessinit$greater$default$5();
    }

    public static Conversions.DecimalConversion decConv() {
        return ColumnStatsIndexSupport$.MODULE$.decConv();
    }

    public static String getValueCountColumnNameFor() {
        return ColumnStatsIndexSupport$.MODULE$.getValueCountColumnNameFor();
    }

    public static String getNullCountColumnNameFor(String string) {
        return ColumnStatsIndexSupport$.MODULE$.getNullCountColumnNameFor(string);
    }

    public static String getMaxColumnNameFor(String string) {
        return ColumnStatsIndexSupport$.MODULE$.getMaxColumnNameFor(string);
    }

    public static String getMinColumnNameFor(String string) {
        return ColumnStatsIndexSupport$.MODULE$.getMinColumnNameFor(string);
    }

    public static StructType composeIndexSchema(Seq<String> seq, StructType structType) {
        return ColumnStatsIndexSupport$.MODULE$.composeIndexSchema(seq, structType);
    }

    private HoodieSparkEngineContext engineCtx$lzycompute() {
        ColumnStatsIndexSupport columnStatsIndexSupport = this;
        synchronized (columnStatsIndexSupport) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.engineCtx = new HoodieSparkEngineContext(new JavaSparkContext(this.spark.sparkContext()));
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.engineCtx;
    }

    private HoodieSparkEngineContext engineCtx() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.engineCtx$lzycompute() : this.engineCtx;
    }

    private HoodieTableMetadata metadataTable$lzycompute() {
        ColumnStatsIndexSupport columnStatsIndexSupport = this;
        synchronized (columnStatsIndexSupport) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.metadataTable = HoodieTableMetadata.create(this.engineCtx(), this.metadataConfig, this.metaClient.getBasePathV2().toString(), FileSystemViewStorageConfig.SPILLABLE_DIR.defaultValue());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.metadataTable;
    }

    private HoodieTableMetadata metadataTable() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.metadataTable$lzycompute() : this.metadataTable;
    }

    private ParHashMap<Seq<String>, Dataset<Row>> cachedColumnStatsIndexViews$lzycompute() {
        ColumnStatsIndexSupport columnStatsIndexSupport = this;
        synchronized (columnStatsIndexSupport) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.cachedColumnStatsIndexViews = (ParHashMap)ParHashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.cachedColumnStatsIndexViews;
    }

    private ParHashMap<Seq<String>, Dataset<Row>> cachedColumnStatsIndexViews() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.cachedColumnStatsIndexViews$lzycompute() : this.cachedColumnStatsIndexViews;
    }

    private Integer inMemoryProjectionThreshold() {
        return this.inMemoryProjectionThreshold;
    }

    private Set<String> indexedColumns$lzycompute() {
        ColumnStatsIndexSupport columnStatsIndexSupport = this;
        synchronized (columnStatsIndexSupport) {
            if (!this.bitmap$0) {
                List<String> customIndexedColumns = this.metadataConfig.getColumnsEnabledForColumnStatsIndex();
                this.indexedColumns = customIndexedColumns.isEmpty() ? new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.tableSchema.fieldNames())).toSet() : ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(customIndexedColumns).asScala()).toSet();
                this.bitmap$0 = true;
            }
        }
        return this.indexedColumns;
    }

    private Set<String> indexedColumns() {
        return !this.bitmap$0 ? this.indexedColumns$lzycompute() : this.indexedColumns;
    }

    public boolean isIndexAvailable() {
        ValidationUtils.checkState(this.metadataConfig.enabled(), "Metadata Table support has to be enabled");
        return this.metaClient.getTableConfig().getMetadataPartitions().contains("column_stats");
    }

    public boolean shouldReadInMemory(HoodieFileIndex fileIndex, Seq<String> queryReferencedColumns) {
        boolean bl;
        Option option = Option$.MODULE$.apply((Object)this.metadataConfig.getColumnStatsIndexProcessingModeOverride());
        if (option instanceof Some) {
            String mode;
            Some some = (Some)option;
            String string = mode = (String)some.value();
            String string2 = "in-memory";
            bl = !(string != null ? !string.equals(string2) : string2 != null);
        } else if (None$.MODULE$.equals(option)) {
            bl = fileIndex.getFileSlicesCount() * queryReferencedColumns.length() < Predef$.MODULE$.Integer2int(this.inMemoryProjectionThreshold());
        } else {
            throw new MatchError((Object)option);
        }
        return bl;
    }

    public <T> T loadTransposed(Seq<String> targetColumns, boolean shouldReadInMemory, Function1<Dataset<Row>, T> block) {
        Object object;
        Option option = this.cachedColumnStatsIndexViews().get(targetColumns);
        if (option instanceof Some) {
            Some some = (Some)option;
            Dataset cachedDF = (Dataset)some.value();
            object = block.apply((Object)cachedDF);
        } else if (None$.MODULE$.equals(option)) {
            HoodieData<HoodieMetadataColumnStats> colStatsRecords = this.loadColumnStatsIndexRecords(targetColumns, shouldReadInMemory);
            object = HoodieCatalystUtils$.MODULE$.withPersistedData(colStatsRecords, StorageLevel$.MODULE$.MEMORY_ONLY(), (Function0 & Serializable & scala.Serializable)() -> {
                Object object;
                Dataset<Row> df;
                Dataset<Row> dataset;
                Tuple2<HoodieData<Row>, StructType> tuple2 = this.transpose(colStatsRecords, targetColumns);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                HoodieData transposedRows = (HoodieData)tuple2._1();
                StructType indexSchema = (StructType)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)transposedRows, (Object)indexSchema);
                Tuple2 tuple23 = tuple22;
                HoodieData transposedRows2 = (HoodieData)tuple23._1();
                StructType indexSchema2 = (StructType)tuple23._2();
                if (shouldReadInMemory) {
                    dataset = HoodieUnsafeUtils$.MODULE$.createDataFrameFromRows($this.spark, (Seq<Row>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(transposedRows2.collectAsList()).asScala()), indexSchema2);
                } else {
                    JavaRDD rdd = HoodieJavaRDD.getJavaRDD(transposedRows2);
                    dataset = df = $this.spark.createDataFrame(rdd, indexSchema2);
                }
                if ($this.allowCaching) {
                    this.cachedColumnStatsIndexViews().put((Object)targetColumns, df);
                    df.persist(StorageLevel$.MODULE$.MEMORY_ONLY());
                    object = block.apply(df);
                } else {
                    object = HoodieCatalystUtils$.MODULE$.withPersistedDataset(df, HoodieCatalystUtils$.MODULE$.withPersistedDataset$default$2(), (Function0 & Serializable & scala.Serializable)() -> block.apply((Object)df));
                }
                return object;
            });
        } else {
            throw new MatchError((Object)option);
        }
        return (T)object;
    }

    public Dataset<Row> load(Seq<String> targetColumns, boolean shouldReadInMemory) {
        return targetColumns.nonEmpty() ? this.loadColumnStatsIndexForColumnsInternal(targetColumns, shouldReadInMemory) : this.loadFullColumnStatsIndexInternal();
    }

    public Seq<String> load$default$1() {
        return (Seq)Seq$.MODULE$.empty();
    }

    public boolean load$default$2() {
        return false;
    }

    public void invalidateCaches() {
        this.cachedColumnStatsIndexViews().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Dataset df = (Dataset)tuple2._2();
            Dataset dataset = df.unpersist();
            return dataset;
        });
        this.cachedColumnStatsIndexViews().clear();
    }

    private Tuple2<HoodieData<Row>, StructType> transpose(HoodieData<HoodieMetadataColumnStats> colStatsRecords, Seq<String> queryColumns) {
        scala.collection.immutable.Map tableSchemaFieldMap = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.tableSchema.fields())).map((Function1 & Serializable & scala.Serializable)f -> new Tuple2((Object)f.name(), f), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
        TreeSet sortedTargetColumnsSet = (TreeSet)TreeSet$.MODULE$.apply(queryColumns, (Ordering)Ordering.String$.MODULE$);
        Seq sortedTargetColumns = sortedTargetColumnsSet.toSeq();
        Set<String> indexedColumns = this.indexedColumns();
        HoodieData transposedRows = colStatsRecords.filter(JFunction$.MODULE$.toJavaSerializableFunction((Function1 & Serializable & scala.Serializable)r -> Predef$.MODULE$.boolean2Boolean(sortedTargetColumnsSet.contains((Object)r.getColumnName())))).mapToPair(JFunction$.MODULE$.toJavaSerializablePairFunction((Function1 & Serializable & scala.Serializable)r -> {
            Pair<String, HoodieMetadataColumnStats> pair;
            if (r.getMinValue() == null && r.getMaxValue() == null) {
                pair = Pair.of(r.getFileName(), r);
            } else {
                Object minValueWrapper = r.getMinValue();
                Object maxValueWrapper = r.getMaxValue();
                ValidationUtils.checkState(minValueWrapper != null && maxValueWrapper != null, "Invalid Column Stats record: either both min/max have to be null, or both have to be non-null");
                String colName = r.getColumnName();
                DataType colType = ((StructField)tableSchemaFieldMap.apply((Object)colName)).dataType();
                Object minValue = ColumnStatsIndexSupport$.MODULE$.org$apache$hudi$ColumnStatsIndexSupport$$deserialize(ColumnStatsIndexSupport$.MODULE$.org$apache$hudi$ColumnStatsIndexSupport$$tryUnpackValueWrapper(minValueWrapper), colType);
                Object maxValue = ColumnStatsIndexSupport$.MODULE$.org$apache$hudi$ColumnStatsIndexSupport$$deserialize(ColumnStatsIndexSupport$.MODULE$.org$apache$hudi$ColumnStatsIndexSupport$$tryUnpackValueWrapper(maxValueWrapper), colType);
                r.setMinValue(minValue);
                r.setMaxValue(maxValue);
                pair = Pair.of(r.getFileName(), r);
            }
            return pair;
        })).groupByKey().map(JFunction$.MODULE$.toJavaSerializableFunction((Function1 & Serializable & scala.Serializable)p -> {
            Seq columnRecordsSeq = ((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)p.getValue()).asScala()).toSeq();
            String fileName = (String)p.getKey();
            long valueCount = Predef$.MODULE$.Long2long(((HoodieMetadataColumnStats)((Object)((Object)columnRecordsSeq.head()))).getValueCount());
            scala.collection.immutable.Map columnRecordsMap = ((TraversableOnce)columnRecordsSeq.map((Function1 & Serializable & scala.Serializable)r -> new Tuple2((Object)r.getColumnName(), (Object)r), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            Seq alignedColStatRecordsSeq = (Seq)sortedTargetColumns.map((Function1 & Serializable & scala.Serializable)key -> columnRecordsMap.get(key), Seq$.MODULE$.canBuildFrom());
            ListBuffer coalescedRowValuesSeq = (ListBuffer)alignedColStatRecordsSeq.foldLeft((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fileName, BoxesRunTime.boxToLong((long)valueCount)})), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
                ListBuffer listBuffer;
                Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                if (tuple2 == null) throw new MatchError((Object)tuple2);
                ListBuffer acc = (ListBuffer)tuple2._1();
                Option opt = (Option)tuple2._2();
                Option option = opt;
                if (option instanceof Some) {
                    Some some = (Some)option;
                    HoodieMetadataColumnStats colStatRecord = (HoodieMetadataColumnStats)((Object)((Object)((Object)some.value())));
                    listBuffer = acc.$plus$plus$eq((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray(new Object[]{colStatRecord.getMinValue(), colStatRecord.getMaxValue(), colStatRecord.getNullCount()})));
                    return listBuffer;
                } else {
                    if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                    int idx = acc.length() / 3;
                    String colName = (String)sortedTargetColumns.apply(idx);
                    boolean indexed = indexedColumns.contains((Object)colName);
                    Long nullCount = indexed ? BoxesRunTime.boxToLong((long)valueCount) : null;
                    listBuffer = acc.$plus$plus$eq((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, null, nullCount})));
                }
                return listBuffer;
            });
            return Row$.MODULE$.apply((Seq)coalescedRowValuesSeq);
        }));
        StructType indexSchema = ColumnStatsIndexSupport$.MODULE$.composeIndexSchema((Seq<String>)sortedTargetColumns, this.tableSchema);
        return new Tuple2(transposedRows, (Object)indexSchema);
    }

    private Dataset<Row> loadColumnStatsIndexForColumnsInternal(Seq<String> targetColumns, boolean shouldReadInMemory) {
        HoodieData<HoodieMetadataColumnStats> colStatsRecords = this.loadColumnStatsIndexRecords(targetColumns, shouldReadInMemory);
        HoodieData catalystRows = colStatsRecords.mapPartitions(JFunction$.MODULE$.toJavaSerializableFunction((Function1 & Serializable & scala.Serializable)it -> {
            Function1<GenericRecord, Option<InternalRow>> converter = AvroConversionUtils$.MODULE$.createAvroToInternalRowConverter(HoodieMetadataColumnStats.SCHEMA$, ColumnStatsIndexSupport$.MODULE$.org$apache$hudi$ColumnStatsIndexSupport$$columnStatsRecordStructType());
            return (java.util.Iterator)JavaConverters$.MODULE$.asJavaIteratorConverter(((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(it).asScala()).map((Function1 & Serializable & scala.Serializable)r -> (InternalRow)((Option)converter.apply((Object)r)).orNull(Predef$.MODULE$.$conforms()))).asJava();
        }), false);
        Dataset<Row> colStatsDF = shouldReadInMemory ? HoodieUnsafeUtils$.MODULE$.createDataFrameFromInternalRows(this.spark, (Seq<InternalRow>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(catalystRows.collectAsList()).asScala()), ColumnStatsIndexSupport$.MODULE$.org$apache$hudi$ColumnStatsIndexSupport$$columnStatsRecordStructType()) : HoodieUnsafeUtils$.MODULE$.createDataFrameFromRDD(this.spark, (RDD<InternalRow>)JavaRDD$.MODULE$.toRDD(HoodieJavaRDD.getJavaRDD(catalystRows)), ColumnStatsIndexSupport$.MODULE$.org$apache$hudi$ColumnStatsIndexSupport$$columnStatsRecordStructType());
        return colStatsDF.select((Seq)ColumnStatsIndexSupport$.MODULE$.org$apache$hudi$ColumnStatsIndexSupport$$targetColumnStatsIndexColumns().map((Function1 & Serializable & scala.Serializable)colName -> functions$.MODULE$.col(colName), Seq$.MODULE$.canBuildFrom()));
    }

    private HoodieData<HoodieMetadataColumnStats> loadColumnStatsIndexRecords(Seq<String> targetColumns, boolean shouldReadInMemory) {
        ValidationUtils.checkState(targetColumns.nonEmpty());
        Seq encodedTargetColumnNames = (Seq)targetColumns.map((Function1 & Serializable & scala.Serializable)colName -> new ColumnIndexID((String)colName).asBase64EncodedString(), Seq$.MODULE$.canBuildFrom());
        HoodieData<HoodieRecord<HoodieMetadataPayload>> metadataRecords = this.metadataTable().getRecordsByKeyPrefixes((List)JavaConverters$.MODULE$.seqAsJavaListConverter(encodedTargetColumnNames).asJava(), "column_stats", shouldReadInMemory);
        HoodieData<HoodieMetadataColumnStats> columnStatsRecords = metadataRecords.map(JFunction$.MODULE$.toJavaSerializableFunction((Function1 & Serializable & scala.Serializable)record -> (HoodieMetadataColumnStats)((Object)((Object)HoodieConversionUtils$.MODULE$.toScalaOption(((HoodieMetadataPayload)record.getData()).getInsertValue(null, null)).map((Function1 & Serializable & scala.Serializable)metadataRecord -> ((HoodieMetadataRecord)((Object)((Object)metadataRecord))).getColumnStatsMetadata()).orNull(Predef$.MODULE$.$conforms()))))).filter(JFunction$.MODULE$.toJavaSerializableFunction((Function1 & Serializable & scala.Serializable)columnStatsRecord -> Predef$.MODULE$.boolean2Boolean(columnStatsRecord != null)));
        return columnStatsRecords;
    }

    private Dataset<Row> loadFullColumnStatsIndexInternal() {
        String metadataTablePath = HoodieTableMetadata.getMetadataTableBasePath(this.metaClient.getBasePathV2().toString());
        Dataset colStatsDF = this.spark.read().format("org.apache.hudi").options((Map)JavaConverters$.MODULE$.propertiesAsScalaMapConverter((Properties)this.metadataConfig.getProps()).asScala()).load(new StringBuilder(1).append(metadataTablePath).append("/").append(MetadataPartitionType.COLUMN_STATS.getPartitionPath()).toString());
        Seq requiredIndexColumns = (Seq)ColumnStatsIndexSupport$.MODULE$.org$apache$hudi$ColumnStatsIndexSupport$$targetColumnStatsIndexColumns().map((Function1 & Serializable & scala.Serializable)colName -> functions$.MODULE$.col(new StringBuilder(20).append("ColumnStatsMetadata").append(".").append((String)colName).toString()), Seq$.MODULE$.canBuildFrom());
        return colStatsDF.where(functions$.MODULE$.col("ColumnStatsMetadata").isNotNull()).select(requiredIndexColumns);
    }

    public ColumnStatsIndexSupport(SparkSession spark, StructType tableSchema, HoodieMetadataConfig metadataConfig, HoodieTableMetaClient metaClient, boolean allowCaching) {
        this.spark = spark;
        this.tableSchema = tableSchema;
        this.metadataConfig = metadataConfig;
        this.metaClient = metaClient;
        this.allowCaching = allowCaching;
        this.inMemoryProjectionThreshold = metadataConfig.getColumnStatsIndexInMemoryProjectionThreshold();
    }
}

