/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.io.Serializable;
import java.util.Properties;
import org.apache.hudi.DataSourceReadOptions$;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.HoodieConversionUtils$;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.DFSPropertiesConfiguration;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.fs.ConsistencyGuardConfig;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.keygen.ComplexKeyGenerator;
import org.apache.hudi.keygen.NonpartitionedKeyGenerator;
import org.apache.hudi.keygen.SimpleKeyGenerator;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.generic.Growable;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;

public final class DataSourceOptionsHelper$ {
    public static DataSourceOptionsHelper$ MODULE$;
    private final Logger log;
    private final List<ConfigProperty<? extends Object>> allConfigsWithAlternatives;
    private final Set<String> allDeprecatedConfigs;
    private final Map<String, String> allAlternatives;
    private final Map<String, String> viewTypeValueMap;

    static {
        new DataSourceOptionsHelper$();
    }

    private Logger log() {
        return this.log;
    }

    public List<ConfigProperty<? extends Object>> allConfigsWithAlternatives() {
        return this.allConfigsWithAlternatives;
    }

    public Set<String> allDeprecatedConfigs() {
        return this.allDeprecatedConfigs;
    }

    public Map<String, String> allAlternatives() {
        return this.allAlternatives;
    }

    public Map<String, String> viewTypeValueMap() {
        return this.viewTypeValueMap;
    }

    public Map<String, String> translateConfigurations(Map<String, String> optParams) {
        scala.collection.mutable.Map translatedOpt = (scala.collection.mutable.Map)((Growable)Map$.MODULE$.apply((Seq)Nil$.MODULE$)).$plus$plus$eq(optParams);
        optParams.keySet().foreach((Function1 & Serializable & scala.Serializable)opt -> {
            DataSourceOptionsHelper$.$anonfun$translateConfigurations$1(optParams, translatedOpt, opt);
            return BoxedUnit.UNIT;
        });
        return translatedOpt.toMap(Predef$.MODULE$.$conforms());
    }

    public Map<String, String> parametersWithReadDefaults(Map<String, String> parameters) {
        Map paramsWithGlobalProps = ((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter((Properties)DFSPropertiesConfiguration.getGlobalProps()).asScala()).toMap(Predef$.MODULE$.$conforms()).$plus$plus(parameters);
        String queryType = (String)paramsWithGlobalProps.get((Object)"hoodie.query.as.ro.table").map((Function1 & Serializable & scala.Serializable)is -> new StringOps(Predef$.MODULE$.augmentString(is)).toBoolean() ? DataSourceReadOptions$.MODULE$.QUERY_TYPE_READ_OPTIMIZED_OPT_VAL() : DataSourceReadOptions$.MODULE$.QUERY_TYPE_SNAPSHOT_OPT_VAL()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (String)paramsWithGlobalProps.getOrElse((Object)DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), (Function0 & Serializable & scala.Serializable)() -> DataSourceReadOptions$.MODULE$.QUERY_TYPE().defaultValue()));
        return ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.QUERY_TYPE().key()), (Object)queryType)}))).$plus$plus(this.translateConfigurations((Map<String, String>)paramsWithGlobalProps));
    }

    public String inferKeyGenClazz(TypedProperties props) {
        String partitionFields = props.getString(DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key(), null);
        String recordsKeyFields = props.getString(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key(), DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().defaultValue());
        return this.inferKeyGenClazz(recordsKeyFields, partitionFields);
    }

    public String inferKeyGenClazz(String recordsKeyFields, String partitionFields) {
        String string;
        if (!StringUtils.isNullOrEmpty(partitionFields)) {
            int numPartFields = partitionFields.split(",").length;
            int numRecordKeyFields = recordsKeyFields.split(",").length;
            string = numPartFields == 1 && numRecordKeyFields == 1 ? SimpleKeyGenerator.class.getName() : ComplexKeyGenerator.class.getName();
        } else {
            string = NonpartitionedKeyGenerator.class.getName();
        }
        return string;
    }

    public <T, U> ConfigProperty<U> convert(ConfigProperty<T> prop, Function1<T, U> converter) {
        ConfigProperty<Object> configProperty;
        ConfigProperty<Object> configProperty2;
        ValidationUtils.checkState(prop.hasDefaultValue());
        ConfigProperty<Object> newProp = ConfigProperty.key(prop.key()).defaultValue(converter.apply(prop.defaultValue())).withDocumentation(prop.doc()).withAlternatives((String[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(prop.getAlternatives()).asScala()).toArray(ClassTag$.MODULE$.apply(String.class)));
        Option<String> option = HoodieConversionUtils$.MODULE$.toScalaOption(prop.getSinceVersion());
        if (option instanceof Some) {
            Some some = (Some)option;
            String version = (String)some.value();
            configProperty2 = newProp.sinceVersion(version);
        } else if (None$.MODULE$.equals(option)) {
            configProperty2 = newProp;
        } else {
            throw new MatchError(option);
        }
        newProp = configProperty2;
        Option<String> option2 = HoodieConversionUtils$.MODULE$.toScalaOption(prop.getDeprecatedVersion());
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            String version = (String)some.value();
            configProperty = newProp.deprecatedAfter(version);
        } else if (None$.MODULE$.equals(option2)) {
            configProperty = newProp;
        } else {
            throw new MatchError(option2);
        }
        newProp = configProperty;
        return newProp;
    }

    public static final /* synthetic */ void $anonfun$allAlternatives$1(scala.collection.mutable.Map alterMap$1, ConfigProperty cfg) {
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(cfg.getAlternatives()).asScala()).foreach((Function1 & Serializable & scala.Serializable)alternative -> {
            alterMap$1.update((Object)alternative, (Object)cfg.key());
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$translateConfigurations$1(Map optParams$1, scala.collection.mutable.Map translatedOpt$1, String opt) {
        block2: {
            BoxedUnit boxedUnit;
            if (MODULE$.allAlternatives().contains((Object)opt) && !optParams$1.contains(MODULE$.allAlternatives().apply((Object)opt))) {
                MODULE$.log().warn((Object)new StringBuilder(66).append(opt).append(" is deprecated and will be removed in a later release; Please use ").append(MODULE$.allAlternatives().apply((Object)opt)).toString());
                String string = opt;
                String string2 = DataSourceReadOptions$.MODULE$.VIEW_TYPE_OPT_KEY();
                boxedUnit = !(string != null ? !string.equals(string2) : string2 != null) ? translatedOpt$1.$plus$plus$eq((TraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(MODULE$.allAlternatives().apply((Object)opt)), MODULE$.viewTypeValueMap().apply(optParams$1.apply((Object)opt)))}))) : translatedOpt$1.$plus$plus$eq((TraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(MODULE$.allAlternatives().apply((Object)opt)), optParams$1.apply((Object)opt))})));
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            if (!MODULE$.allDeprecatedConfigs().contains((Object)opt)) break block2;
            MODULE$.log().warn((Object)new StringBuilder(47).append(opt).append(" is deprecated and should never be used anymore").toString());
        }
    }

    private DataSourceOptionsHelper$() {
        MODULE$ = this;
        this.log = LogManager.getLogger(this.getClass());
        this.allConfigsWithAlternatives = new .colon.colon(DataSourceReadOptions$.MODULE$.QUERY_TYPE(), (List)new .colon.colon(DataSourceWriteOptions$.MODULE$.TABLE_TYPE(), (List)new .colon.colon(HoodieTableConfig.BASE_FILE_FORMAT, (List)new .colon.colon(HoodieTableConfig.LOG_FILE_FORMAT, (List)Nil$.MODULE$))));
        this.allDeprecatedConfigs = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{ConsistencyGuardConfig.ENABLE.key()}));
        scala.collection.mutable.Map alterMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.allConfigsWithAlternatives().foreach((Function1 & Serializable & scala.Serializable)cfg -> {
            DataSourceOptionsHelper$.$anonfun$allAlternatives$1(alterMap, cfg);
            return BoxedUnit.UNIT;
        });
        this.allAlternatives = alterMap.toMap(Predef$.MODULE$.$conforms());
        this.viewTypeValueMap = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.VIEW_TYPE_READ_OPTIMIZED_OPT_VAL()), (Object)DataSourceReadOptions$.MODULE$.QUERY_TYPE_SNAPSHOT_OPT_VAL()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.VIEW_TYPE_INCREMENTAL_OPT_VAL()), (Object)DataSourceReadOptions$.MODULE$.QUERY_TYPE_INCREMENTAL_OPT_VAL()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.VIEW_TYPE_REALTIME_OPT_VAL()), (Object)DataSourceReadOptions$.MODULE$.QUERY_TYPE_SNAPSHOT_OPT_VAL())}));
    }
}

