/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.io.Serializable;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.HoodieSinkCheckpoint$;
import org.apache.hudi.HoodieSparkSqlWriter$;
import org.apache.hudi.async.AsyncClusteringService;
import org.apache.hudi.async.AsyncCompactService;
import org.apache.hudi.async.SparkStreamingAsyncClusteringService;
import org.apache.hudi.async.SparkStreamingAsyncCompactService;
import org.apache.hudi.client.BaseHoodieWriteClient;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.marker.MarkerType;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.ClusteringUtils;
import org.apache.hudi.common.util.CommitUtils;
import org.apache.hudi.common.util.CompactionUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieCorruptedDataException;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.TableNotFoundException;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.connector.catalog.TableCapability;
import org.apache.spark.sql.execution.streaming.Sink;
import org.apache.spark.sql.execution.streaming.StreamExecution$;
import org.apache.spark.sql.streaming.OutputMode;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple6;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\t\rf\u0001B\u001a5\u0001mB\u0001B\u0016\u0001\u0003\u0002\u0003\u0006Ia\u0016\u0005\t7\u0002\u0011\t\u0011)A\u00059\"A!\u000e\u0001B\u0001B\u0003%1\u000e\u0003\u0005u\u0001\t\u0005\t\u0015!\u0003v\u0011\u0015Q\b\u0001\"\u0001|\u0011%\t)\u0001\u0001a\u0001\n\u0013\t9\u0001C\u0005\u0002\u0010\u0001\u0001\r\u0011\"\u0003\u0002\u0012!A\u0011Q\u0004\u0001!B\u0013\tI\u0001C\u0005\u0002(\u0001\u0011\r\u0011\"\u0003\u0002*!A\u0011q\u0007\u0001!\u0002\u0013\tY\u0003C\u0005\u0002:\u0001\u0011\r\u0011\"\u0003\u0002<!A\u00111\t\u0001!\u0002\u0013\ti\u0004C\u0005\u0002F\u0001\u0001\r\u0011\"\u0003\u0002H!I\u00111\f\u0001A\u0002\u0013%\u0011Q\f\u0005\t\u0003C\u0002\u0001\u0015)\u0003\u0002J!I\u00111\r\u0001C\u0002\u0013%\u0011Q\r\u0005\t\u0003[\u0002\u0001\u0015!\u0003\u0002h!I\u0011q\u000e\u0001C\u0002\u0013%\u0011q\u0001\u0005\t\u0003c\u0002\u0001\u0015!\u0003\u0002\n!I\u00111\u000f\u0001C\u0002\u0013%\u0011Q\u000f\u0005\t\u0003{\u0002\u0001\u0015!\u0003\u0002x!I\u0011q\u0010\u0001C\u0002\u0013%\u0011\u0011\u0011\u0005\t\u0003\u000f\u0003\u0001\u0015!\u0003\u0002\u0004\"I\u0011\u0011\u0012\u0001A\u0002\u0013%\u0011Q\u000f\u0005\n\u0003\u0017\u0003\u0001\u0019!C\u0005\u0003\u001bC\u0001\"!%\u0001A\u0003&\u0011q\u000f\u0005\n\u0003'\u0003\u0001\u0019!C\u0005\u0003kB\u0011\"!&\u0001\u0001\u0004%I!a&\t\u0011\u0005m\u0005\u0001)Q\u0005\u0003oB\u0011\"!(\u0001\u0005\u0004%I!a(\t\u0011\u0005\u001d\u0006\u0001)A\u0005\u0003CC1\"!+\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002,\"Y\u0011\u0011\u0018\u0001A\u0002\u0003\u0007I\u0011BA^\u0011-\ty\f\u0001a\u0001\u0002\u0003\u0006K!!,\t\u0017\u0005\u0005\u0007\u00011AA\u0002\u0013%\u00111\u0019\u0005\f\u0003\u0017\u0004\u0001\u0019!a\u0001\n\u0013\ti\rC\u0006\u0002R\u0002\u0001\r\u0011!Q!\n\u0005\u0015\u0007\"CAj\u0001\u0001\u0007I\u0011BAk\u0011%\t9\u0010\u0001a\u0001\n\u0013\tI\u0010\u0003\u0005\u0002~\u0002\u0001\u000b\u0015BAl\u0011%\ty\u0010\u0001a\u0001\n\u0013\u0011\t\u0001C\u0005\u0003\f\u0001\u0001\r\u0011\"\u0003\u0003\u000e!A!\u0011\u0003\u0001!B\u0013\u0011\u0019\u0001C\u0004\u0003\u0014\u0001!\tE!\u0006\t\u000f\tm\u0002\u0001\"\u0011\u0003>!9!q\b\u0001\u0005\n\t\u0005\u0003b\u0002BB\u0001\u0011E!Q\u0011\u0005\b\u0005\u0013\u0003A\u0011\u0003BF\u0011\u001d\u0011y\t\u0001C\u0005\u0005#CqAa&\u0001\t\u0013\u0011IJA\nI_>$\u0017.Z*ue\u0016\fW.\u001b8h'&t7N\u0003\u00026m\u0005!\u0001.\u001e3j\u0015\t9\u0004(\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002s\u0005\u0019qN]4\u0004\u0001M!\u0001\u0001\u0010#Q!\ti$)D\u0001?\u0015\ty\u0004)\u0001\u0003mC:<'\"A!\u0002\t)\fg/Y\u0005\u0003\u0007z\u0012aa\u00142kK\u000e$\bCA#O\u001b\u00051%BA$I\u0003%\u0019HO]3b[&twM\u0003\u0002J\u0015\u0006IQ\r_3dkRLwN\u001c\u0006\u0003\u00172\u000b1a]9m\u0015\tie'A\u0003ta\u0006\u00148.\u0003\u0002P\r\n!1+\u001b8l!\t\tF+D\u0001S\u0015\u0005\u0019\u0016!B:dC2\f\u0017BA+S\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003)\u0019\u0018\u000f\\\"p]R,\u0007\u0010\u001e\t\u00031fk\u0011AS\u0005\u00035*\u0013!bU)M\u0007>tG/\u001a=u\u0003\u001dy\u0007\u000f^5p]N\u0004B!\u00183hO:\u0011aL\u0019\t\u0003?Jk\u0011\u0001\u0019\u0006\u0003Cj\na\u0001\u0010:p_Rt\u0014BA2S\u0003\u0019\u0001&/\u001a3fM&\u0011QM\u001a\u0002\u0004\u001b\u0006\u0004(BA2S!\ti\u0006.\u0003\u0002jM\n11\u000b\u001e:j]\u001e\f\u0001\u0003]1si&$\u0018n\u001c8D_2,XN\\:\u0011\u00071\fxM\u0004\u0002n_:\u0011qL\\\u0005\u0002'&\u0011\u0001OU\u0001\ba\u0006\u001c7.Y4f\u0013\t\u00118OA\u0002TKFT!\u0001\u001d*\u0002\u0015=,H\u000f];u\u001b>$W\r\u0005\u0002wq6\tqO\u0003\u0002H\u0015&\u0011\u0011p\u001e\u0002\u000b\u001fV$\b/\u001e;N_\u0012,\u0017A\u0002\u001fj]&$h\bF\u0004}}~\f\t!a\u0001\u0011\u0005u\u0004Q\"\u0001\u001b\t\u000bY+\u0001\u0019A,\t\u000bm+\u0001\u0019\u0001/\t\u000b),\u0001\u0019A6\t\u000bQ,\u0001\u0019A;\u0002-1\fG/Z:u\u0007>lW.\u001b;uK\u0012\u0014\u0015\r^2i\u0013\u0012,\"!!\u0003\u0011\u0007E\u000bY!C\u0002\u0002\u000eI\u0013A\u0001T8oO\u0006QB.\u0019;fgR\u001cu.\\7jiR,GMQ1uG\"LEm\u0018\u0013fcR!\u00111CA\r!\r\t\u0016QC\u0005\u0004\u0003/\u0011&\u0001B+oSRD\u0011\"a\u0007\b\u0003\u0003\u0005\r!!\u0003\u0002\u0007a$\u0013'A\fmCR,7\u000f^\"p[6LG\u000f^3e\u0005\u0006$8\r[%eA!\u001a\u0001\"!\t\u0011\u0007E\u000b\u0019#C\u0002\u0002&I\u0013\u0001B^8mCRLG.Z\u0001\u0004Y><WCAA\u0016!\u0011\ti#a\r\u000e\u0005\u0005=\"bAA\u0019m\u0005)An\\45U&!\u0011QGA\u0018\u0005\u0019aunZ4fe\u0006!An\\4!\u0003%!\u0018M\u00197f!\u0006$\b.\u0006\u0002\u0002>A!\u0011+a\u0010h\u0013\r\t\tE\u0015\u0002\u0007\u001fB$\u0018n\u001c8\u0002\u0015Q\f'\r\\3QCRD\u0007%\u0001\u0006nKR\f7\t\\5f]R,\"!!\u0013\u0011\u000bE\u000by$a\u0013\u0011\t\u00055\u0013qK\u0007\u0003\u0003\u001fRA!!\u0015\u0002T\u0005)A/\u00192mK*\u0019\u0011Q\u000b\u001b\u0002\r\r|W.\\8o\u0013\u0011\tI&a\u0014\u0003+!{w\u000eZ5f)\u0006\u0014G.Z'fi\u0006\u001cE.[3oi\u0006qQ.\u001a;b\u00072LWM\u001c;`I\u0015\fH\u0003BA\n\u0003?B\u0011\"a\u0007\u000f\u0003\u0003\u0005\r!!\u0013\u0002\u00175,G/Y\"mS\u0016tG\u000fI\u0001\te\u0016$(/_\"oiV\u0011\u0011q\r\t\u0004#\u0006%\u0014bAA6%\n\u0019\u0011J\u001c;\u0002\u0013I,GO]=D]R\u0004\u0013a\u0004:fiJL\u0018J\u001c;feZ\fG.T:\u0002!I,GO]=J]R,'O^1m\u001bN\u0004\u0013!E5h]>\u0014XMR1jY\u0016$')\u0019;dQV\u0011\u0011q\u000f\t\u0004#\u0006e\u0014bAA>%\n9!i\\8mK\u0006t\u0017AE5h]>\u0014XMR1jY\u0016$')\u0019;dQ\u0002\n1cU%O\u0017~\u001b\u0005*R\"L!>Ke\nV0L\u000bf+\"!a!\u0011\u0007u\n))\u0003\u0002j}\u0005!2+\u0013(L?\u000eCUiQ&Q\u001f&sEkX&F3\u0002\n\u0011&[:Bgft7mQ8na\u0006\u001cGo\u001c:TKJ4\u0018nY3TQV$Hm\\<o\u0003\ntwN]7bY2L\u0018!L5t\u0003NLhnY\"p[B\f7\r^8s'\u0016\u0014h/[2f'\",H\u000fZ8x]\u0006\u0013gn\u001c:nC2d\u0017p\u0018\u0013fcR!\u00111CAH\u0011%\tY\"GA\u0001\u0002\u0004\t9(\u0001\u0016jg\u0006\u001b\u0018P\\2D_6\u0004\u0018m\u0019;peN+'O^5dKNCW\u000f\u001e3po:\f%M\\8s[\u0006dG.\u001f\u0011\u0002U%\u001c\u0018i]=oG\u000ecWo\u001d;fe&twmU3sm&\u001cWm\u00155vi\u0012|wO\\!c]>\u0014X.\u00197ms\u0006q\u0013n]!ts:\u001c7\t\\;ti\u0016\u0014\u0018N\\4TKJ4\u0018nY3TQV$Hm\\<o\u0003\ntwN]7bY2Lx\fJ3r)\u0011\t\u0019\"!'\t\u0013\u0005mA$!AA\u0002\u0005]\u0014aK5t\u0003NLhnY\"mkN$XM]5oON+'O^5dKNCW\u000f\u001e3po:\f%M\\8s[\u0006dG.\u001f\u0011\u0002\t5|G-Z\u000b\u0003\u0003C\u00032\u0001WAR\u0013\r\t)K\u0013\u0002\t'\u00064X-T8eK\u0006)Qn\u001c3fA\u0005)\u0012m]=oG\u000e{W\u000e]1di>\u00148+\u001a:wS\u000e,WCAAW!\u0011\ty+!.\u000e\u0005\u0005E&bAAZi\u0005)\u0011m]=oG&!\u0011qWAY\u0005M\t5/\u001f8d\u0007>l\u0007/Y2u'\u0016\u0014h/[2f\u0003e\t7/\u001f8d\u0007>l\u0007/Y2u_J\u001cVM\u001d<jG\u0016|F%Z9\u0015\t\u0005M\u0011Q\u0018\u0005\n\u00037\t\u0013\u0011!a\u0001\u0003[\u000ba#Y:z]\u000e\u001cu.\u001c9bGR|'oU3sm&\u001cW\rI\u0001\u0017CNLhnY\"mkN$XM]5oON+'O^5dKV\u0011\u0011Q\u0019\t\u0005\u0003_\u000b9-\u0003\u0003\u0002J\u0006E&AF!ts:\u001c7\t\\;ti\u0016\u0014\u0018N\\4TKJ4\u0018nY3\u00025\u0005\u001c\u0018P\\2DYV\u001cH/\u001a:j]\u001e\u001cVM\u001d<jG\u0016|F%Z9\u0015\t\u0005M\u0011q\u001a\u0005\n\u00037!\u0013\u0011!a\u0001\u0003\u000b\fq#Y:z]\u000e\u001cE.^:uKJLgnZ*feZL7-\u001a\u0011\u0002\u0017]\u0014\u0018\u000e^3DY&,g\u000e^\u000b\u0003\u0003/\u0004R!UA \u00033\u0004b!a7\u0002b\u0006\u0015XBAAo\u0015\r\ty\u000eN\u0001\u0007G2LWM\u001c;\n\t\u0005\r\u0018Q\u001c\u0002\u0014'B\f'o\u001b*E\t^\u0013\u0018\u000e^3DY&,g\u000e\u001e\t\u0007\u0003O\fi/!=\u000e\u0005\u0005%(\u0002BAv\u0003'\nQ!\\8eK2LA!a<\u0002j\n\u0019\u0002j\\8eS\u0016\u0014VmY8sIB\u000b\u0017\u0010\\8bIB\u0019\u0011+a=\n\u0007\u0005U(KA\u0004O_RD\u0017N\\4\u0002\u001f]\u0014\u0018\u000e^3DY&,g\u000e^0%KF$B!a\u0005\u0002|\"I\u00111D\u0014\u0002\u0002\u0003\u0007\u0011q[\u0001\roJLG/Z\"mS\u0016tG\u000fI\u0001\u0012Q>|G-[3UC\ndWmQ8oM&<WC\u0001B\u0002!\u0015\t\u0016q\bB\u0003!\u0011\tiEa\u0002\n\t\t%\u0011q\n\u0002\u0012\u0011>|G-[3UC\ndWmQ8oM&<\u0017!\u00065p_\u0012LW\rV1cY\u0016\u001cuN\u001c4jO~#S-\u001d\u000b\u0005\u0003'\u0011y\u0001C\u0005\u0002\u001c)\n\t\u00111\u0001\u0003\u0004\u0005\u0011\u0002n\\8eS\u0016$\u0016M\u00197f\u0007>tg-[4!\u0003!\tG\r\u001a\"bi\u000eDGCBA\n\u0005/\u0011Y\u0002C\u0004\u0003\u001a1\u0002\r!!\u0003\u0002\u000f\t\fGo\u00195JI\"9!Q\u0004\u0017A\u0002\t}\u0011\u0001\u00023bi\u0006\u0004BA!\t\u000369!!1\u0005B\u001a\u001d\u0011\u0011)C!\r\u000f\t\t\u001d\"q\u0006\b\u0005\u0005S\u0011iCD\u0002`\u0005WI\u0011!O\u0005\u0003oaJ!!\u0014\u001c\n\u0005-c\u0015B\u00019K\u0013\u0011\u00119D!\u000f\u0003\u0013\u0011\u000bG/\u0019$sC6,'B\u00019K\u0003!!xn\u0015;sS:<G#A4\u0002\u000bI,GO]=\u0016\t\t\r#q\u000b\u000b\u0007\u0005\u000b\u0012iG!\u001d\u0015\t\t\u001d#1\r\t\u0007\u0005\u0013\u0012yEa\u0015\u000e\u0005\t-#b\u0001B'%\u0006!Q\u000f^5m\u0013\u0011\u0011\tFa\u0013\u0003\u0007Q\u0013\u0018\u0010\u0005\u0003\u0003V\t]C\u0002\u0001\u0003\b\u00053r#\u0019\u0001B.\u0005\u0005!\u0016\u0003BAy\u0005;\u00022!\u0015B0\u0013\r\u0011\tG\u0015\u0002\u0004\u0003:L\b\u0002\u0003B3]\u0011\u0005\rAa\u001a\u0002\u0005\u0019t\u0007#B)\u0003j\t\u001d\u0013b\u0001B6%\nAAHY=oC6,g\bC\u0004\u0003p9\u0002\r!a\u001a\u0002\u00039DqAa\u001d/\u0001\u0004\tI!\u0001\u0007xC&$\u0018J\\'jY2L7\u000fK\u0002/\u0005o\u0002BA!\u001f\u0003\u00005\u0011!1\u0010\u0006\u0004\u0005{\u0012\u0016AC1o]>$\u0018\r^5p]&!!\u0011\u0011B>\u0005\u001d!\u0018-\u001b7sK\u000e\fQ\u0003\u001e:jO\u001e,'/Q:z]\u000e\u001cu.\u001c9bGR|'\u000f\u0006\u0003\u0002\u0014\t\u001d\u0005bBAp_\u0001\u0007\u0011\u0011\\\u0001\u0017iJLwmZ3s\u0003NLhnY\"mkN$XM]5oOR!\u00111\u0003BG\u0011\u001d\ty\u000e\ra\u0001\u00033\fQA]3tKR$B!a\u0005\u0003\u0014\"9!QS\u0019A\u0002\u0005]\u0014!\u00024pe\u000e,\u0017\u0001D2b]N[\u0017\u000e\u001d\"bi\u000eDGCBA<\u00057\u0013y\nC\u0004\u0003\u001eJ\u0002\r!!\u0003\u0002\u001f%t7m\\7j]\u001e\u0014\u0015\r^2i\u0013\u0012DaA!)3\u0001\u00049\u0017!D8qKJ\fG/[8o)f\u0004X\r")
public class HoodieStreamingSink
implements Sink,
scala.Serializable {
    private final SQLContext sqlContext;
    private final Map<String, String> options;
    private volatile long latestCommittedBatchId;
    private final Logger org$apache$hudi$HoodieStreamingSink$$log;
    private final scala.Option<String> tablePath;
    private scala.Option<HoodieTableMetaClient> metaClient;
    private final int retryCnt;
    private final long retryIntervalMs;
    private final boolean ignoreFailedBatch;
    private final String SINK_CHECKPOINT_KEY;
    private boolean org$apache$hudi$HoodieStreamingSink$$isAsyncCompactorServiceShutdownAbnormally;
    private boolean org$apache$hudi$HoodieStreamingSink$$isAsyncClusteringServiceShutdownAbnormally;
    private final SaveMode mode;
    private AsyncCompactService asyncCompactorService;
    private AsyncClusteringService asyncClusteringService;
    private scala.Option<SparkRDDWriteClient<HoodieRecordPayload<Nothing$>>> writeClient;
    private scala.Option<HoodieTableConfig> hoodieTableConfig;

    public String name() {
        return Sink.name$((Sink)this);
    }

    public StructType schema() {
        return Sink.schema$((Sink)this);
    }

    public Set<TableCapability> capabilities() {
        return Sink.capabilities$((Sink)this);
    }

    private long latestCommittedBatchId() {
        return this.latestCommittedBatchId;
    }

    private void latestCommittedBatchId_$eq(long x$1) {
        this.latestCommittedBatchId = x$1;
    }

    public Logger org$apache$hudi$HoodieStreamingSink$$log() {
        return this.org$apache$hudi$HoodieStreamingSink$$log;
    }

    private scala.Option<String> tablePath() {
        return this.tablePath;
    }

    private scala.Option<HoodieTableMetaClient> metaClient() {
        return this.metaClient;
    }

    private void metaClient_$eq(scala.Option<HoodieTableMetaClient> x$1) {
        this.metaClient = x$1;
    }

    private int retryCnt() {
        return this.retryCnt;
    }

    private long retryIntervalMs() {
        return this.retryIntervalMs;
    }

    private boolean ignoreFailedBatch() {
        return this.ignoreFailedBatch;
    }

    private String SINK_CHECKPOINT_KEY() {
        return this.SINK_CHECKPOINT_KEY;
    }

    private boolean org$apache$hudi$HoodieStreamingSink$$isAsyncCompactorServiceShutdownAbnormally() {
        return this.org$apache$hudi$HoodieStreamingSink$$isAsyncCompactorServiceShutdownAbnormally;
    }

    public void org$apache$hudi$HoodieStreamingSink$$isAsyncCompactorServiceShutdownAbnormally_$eq(boolean x$1) {
        this.org$apache$hudi$HoodieStreamingSink$$isAsyncCompactorServiceShutdownAbnormally = x$1;
    }

    private boolean org$apache$hudi$HoodieStreamingSink$$isAsyncClusteringServiceShutdownAbnormally() {
        return this.org$apache$hudi$HoodieStreamingSink$$isAsyncClusteringServiceShutdownAbnormally;
    }

    public void org$apache$hudi$HoodieStreamingSink$$isAsyncClusteringServiceShutdownAbnormally_$eq(boolean x$1) {
        this.org$apache$hudi$HoodieStreamingSink$$isAsyncClusteringServiceShutdownAbnormally = x$1;
    }

    private SaveMode mode() {
        return this.mode;
    }

    private AsyncCompactService asyncCompactorService() {
        return this.asyncCompactorService;
    }

    private void asyncCompactorService_$eq(AsyncCompactService x$1) {
        this.asyncCompactorService = x$1;
    }

    private AsyncClusteringService asyncClusteringService() {
        return this.asyncClusteringService;
    }

    private void asyncClusteringService_$eq(AsyncClusteringService x$1) {
        this.asyncClusteringService = x$1;
    }

    private scala.Option<SparkRDDWriteClient<HoodieRecordPayload<Nothing$>>> writeClient() {
        return this.writeClient;
    }

    private void writeClient_$eq(scala.Option<SparkRDDWriteClient<HoodieRecordPayload<Nothing$>>> x$1) {
        this.writeClient = x$1;
    }

    private scala.Option<HoodieTableConfig> hoodieTableConfig() {
        return this.hoodieTableConfig;
    }

    private void hoodieTableConfig_$eq(scala.Option<HoodieTableConfig> x$1) {
        this.hoodieTableConfig = x$1;
    }

    public synchronized void addBatch(long batchId, Dataset<Row> data) {
        if (this.org$apache$hudi$HoodieStreamingSink$$isAsyncCompactorServiceShutdownAbnormally()) {
            throw new IllegalStateException("Async Compactor shutdown unexpectedly");
        }
        if (this.org$apache$hudi$HoodieStreamingSink$$isAsyncClusteringServiceShutdownAbnormally()) {
            this.org$apache$hudi$HoodieStreamingSink$$log().error((Object)"Async clustering service shutdown unexpectedly");
            throw new IllegalStateException("Async clustering service shutdown unexpectedly");
        }
        String queryId = this.sqlContext.sparkContext().getLocalProperty(StreamExecution$.MODULE$.QUERY_ID_KEY());
        ValidationUtils.checkArgument(queryId != null, "queryId is null");
        if (this.metaClient().isDefined() && this.canSkipBatch(batchId, JavaConversions$.MODULE$.deprecated$u0020mapAsJavaMap(this.options).getOrDefault(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL()))) {
            this.org$apache$hudi$HoodieStreamingSink$$log().warn((Object)new StringBuilder(43).append("Skipping already completed batch ").append(batchId).append(" in query ").append(queryId).toString());
            return;
        }
        ObjectRef updatedOptions = ObjectRef.create((Object)this.options.updated((Object)HoodieWriteConfig.MARKERS_TYPE.key(), (Object)MarkerType.DIRECT.name()));
        updatedOptions.elem = ((Map)updatedOptions.elem).updated((Object)HoodieWriteConfig.AUTO_ADJUST_LOCK_CONFIGS.key(), (Object)"true");
        Map checkpointMap = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)((Object)BoxesRunTime.boxToLong((long)batchId)).toString()), (Object)new StringBuilder(1).append(this.sqlContext.sparkContext().applicationId()).append("-").append(queryId).toString())}));
        updatedOptions.elem = ((Map)updatedOptions.elem).updated((Object)this.SINK_CHECKPOINT_KEY(), (Object)HoodieSinkCheckpoint$.MODULE$.toJson((Map<String, String>)checkpointMap));
        Try try_ = this.retry(this.retryCnt(), this.retryIntervalMs(), (Function0 & Serializable & scala.Serializable)() -> {
            Failure failure;
            boolean bl = false;
            Success success = null;
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> HoodieSparkSqlWriter$.MODULE$.write($this.sqlContext, this.mode(), (Map<String, String>)((Map)updatedOptions$1.elem), data, this.hoodieTableConfig(), this.writeClient(), (scala.Option<Function1<SparkRDDWriteClient<HoodieRecordPayload<Nothing$>>, BoxedUnit>>)new Some((Function1 & Serializable & scala.Serializable)client -> {
                this.triggerAsyncCompactor(client);
                return BoxedUnit.UNIT;
            }), (scala.Option<Function1<SparkRDDWriteClient<HoodieRecordPayload<Nothing$>>, BoxedUnit>>)new Some((Function1 & Serializable & scala.Serializable)client -> {
                this.triggerAsyncClustering(client);
                return BoxedUnit.UNIT;
            })));
            if (try_ instanceof Success) {
                bl = true;
                success = (Success)try_;
                Tuple6 tuple6 = (Tuple6)success.value();
                if (tuple6 != null) {
                    boolean bl2 = BoxesRunTime.unboxToBoolean((Object)tuple6._1());
                    Option commitOps = (Option)tuple6._2();
                    Option compactionInstantOps = (Option)tuple6._3();
                    Option clusteringInstant = (Option)tuple6._4();
                    SparkRDDWriteClient client = (SparkRDDWriteClient)tuple6._5();
                    HoodieTableConfig tableConfig = (HoodieTableConfig)tuple6._6();
                    if (bl2) {
                        boolean bl3 = commitOps.isPresent();
                        String string = true == bl3 ? new StringBuilder(12).append(" for commit=").append(commitOps.get()).toString() : " with no new commits";
                        this.org$apache$hudi$HoodieStreamingSink$$log().info((Object)new StringBuilder(25).append("Micro batch id=").append(batchId).append(" succeeded").append((Object)string).toString());
                        this.org$apache$hudi$HoodieStreamingSink$$log().info((Object)new StringBuilder(86).append("Current value of latestCommittedBatchId: ").append(this.latestCommittedBatchId()).append(". Setting latestCommittedBatchId to batchId ").append(batchId).append(".").toString());
                        this.latestCommittedBatchId_$eq(batchId);
                        this.writeClient_$eq((scala.Option<SparkRDDWriteClient<HoodieRecordPayload<Nothing$>>>)new Some((Object)client));
                        this.hoodieTableConfig_$eq((scala.Option<HoodieTableConfig>)new Some((Object)tableConfig));
                        if (client != null) {
                            this.metaClient_$eq((scala.Option<HoodieTableMetaClient>)new Some((Object)HoodieTableMetaClient.builder().setConf($this.sqlContext.sparkContext().hadoopConfiguration()).setBasePath(client.getConfig().getBasePath()).build()));
                        }
                        if (compactionInstantOps.isPresent()) {
                            this.asyncCompactorService().enqueuePendingAsyncServiceInstant(new HoodieInstant(HoodieInstant.State.REQUESTED, "compaction", (String)compactionInstantOps.get()));
                        }
                        if (!clusteringInstant.isPresent()) return new Success((Object)new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)commitOps, (Object)compactionInstantOps));
                        this.asyncClusteringService().enqueuePendingAsyncServiceInstant(new HoodieInstant(HoodieInstant.State.REQUESTED, "replacecommit", (String)clusteringInstant.get()));
                        return new Success((Object)new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)commitOps, (Object)compactionInstantOps));
                    }
                }
            }
            if (try_ instanceof Failure) {
                Failure failure2;
                Failure failure3 = (Failure)try_;
                Throwable e = failure3.exception();
                data.sparkSession().sparkContext().getPersistentRDDs().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    RDD rDD;
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        RDD rdd = (RDD)tuple2._2();
                        try {
                            rDD = rdd.unpersist(rdd.unpersist$default$1());
                        }
                        catch (Exception t) {
                            this.org$apache$hudi$HoodieStreamingSink$$log().warn((Object)"Got excepting trying to unpersist rdd", (Throwable)t);
                            rDD = BoxedUnit.UNIT;
                        }
                    } else {
                        throw new MatchError((Object)tuple2);
                    }
                    RDD rDD2 = rDD;
                    return rDD2;
                });
                this.org$apache$hudi$HoodieStreamingSink$$log().error((Object)new StringBuilder(43).append("Micro batch id=").append(batchId).append(" threw following exception: ").toString(), e);
                if (this.ignoreFailedBatch()) {
                    this.org$apache$hudi$HoodieStreamingSink$$log().warn((Object)new StringBuilder(64).append("Ignore the exception and move on streaming as per ").append(DataSourceWriteOptions$.MODULE$.STREAMING_IGNORE_FAILED_BATCH().key()).append(" configuration").toString());
                    failure2 = new Success((Object)new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)None$.MODULE$, (Object)None$.MODULE$));
                    return failure2;
                } else {
                    if (this.retryCnt() > 1) {
                        this.org$apache$hudi$HoodieStreamingSink$$log().info((Object)new StringBuilder(39).append("Retrying the failed micro batch id=").append(batchId).append(" ...").toString());
                    }
                    failure2 = new Failure(e);
                }
                return failure2;
            }
            if (!bl) throw new MatchError((Object)try_);
            Tuple6 tuple6 = (Tuple6)success.value();
            if (tuple6 == null) throw new MatchError((Object)try_);
            boolean bl4 = BoxesRunTime.unboxToBoolean((Object)tuple6._1());
            Option commitOps = (Option)tuple6._2();
            if (false != bl4) throw new MatchError((Object)try_);
            boolean bl5 = commitOps.isPresent();
            String string = true == bl5 ? new StringBuilder(12).append(" for commit=").append(commitOps.get()).toString() : "";
            this.org$apache$hudi$HoodieStreamingSink$$log().error((Object)new StringBuilder(36).append("Micro batch id=").append(batchId).append(" ended up with errors").append((Object)string).toString());
            if (this.ignoreFailedBatch()) {
                this.org$apache$hudi$HoodieStreamingSink$$log().info((Object)new StringBuilder(61).append("Ignore the errors and move on streaming as per ").append(DataSourceWriteOptions$.MODULE$.STREAMING_IGNORE_FAILED_BATCH().key()).append(" configuration").toString());
                failure = new Success((Object)new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)None$.MODULE$, (Object)None$.MODULE$));
                return failure;
            } else {
                if (this.retryCnt() > 1) {
                    this.org$apache$hudi$HoodieStreamingSink$$log().warn((Object)new StringBuilder(39).append("Retrying the failed micro batch id=").append(batchId).append(" ...").toString());
                }
                failure = new Failure((Throwable)new HoodieCorruptedDataException(new StringBuilder(36).append("Micro batch id=").append(batchId).append(" ended up with errors").toString()));
            }
            return failure;
        });
        if (try_ instanceof Failure) {
            BoxedUnit boxedUnit;
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            if (!this.ignoreFailedBatch()) {
                this.org$apache$hudi$HoodieStreamingSink$$log().error((Object)new StringBuilder(86).append("Micro batch id=").append(batchId).append(" threw following expections,").append("aborting streaming app to avoid data loss: ").toString(), e);
                this.org$apache$hudi$HoodieStreamingSink$$reset(true);
                System.exit(1);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (try_ instanceof Success) {
            this.org$apache$hudi$HoodieStreamingSink$$log().info((Object)new StringBuilder(25).append("Micro batch id=").append(batchId).append(" succeeded").toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(try_);
        }
    }

    public String toString() {
        return new StringBuilder(21).append("HoodieStreamingSink[").append(this.options.apply((Object)"path")).append("]").toString();
    }

    private <T> Try<T> retry(int n, long waitInMillis, Function0<Try<T>> fn) {
        Success success;
        block2: {
            Try try_;
            while (true) {
                if ((try_ = (Try)fn.apply()) instanceof Success) {
                    Success success2;
                    success = success2 = (Success)try_;
                    break block2;
                }
                if (n <= 1) break;
                Thread.sleep(waitInMillis);
                waitInMillis *= 2L;
                --n;
            }
            this.org$apache$hudi$HoodieStreamingSink$$reset(false);
            success = try_;
        }
        return success;
    }

    public void triggerAsyncCompactor(SparkRDDWriteClient<HoodieRecordPayload<Nothing$>> client) {
        block0: {
            if (this.asyncCompactorService() != null) break block0;
            this.org$apache$hudi$HoodieStreamingSink$$log().info((Object)"Triggering Async compaction !!");
            this.asyncCompactorService_$eq(new SparkStreamingAsyncCompactService(new HoodieSparkEngineContext(new JavaSparkContext(this.sqlContext.sparkContext())), client));
            this.asyncCompactorService().start(new Function<Boolean, Boolean>(this){
                private final /* synthetic */ HoodieStreamingSink $outer;

                public <V> Function<V, Boolean> compose(Function<? super V, ? extends Boolean> x$1) {
                    return Function.super.compose(x$1);
                }

                public <V> Function<Boolean, V> andThen(Function<? super Boolean, ? extends V> x$1) {
                    return Function.super.andThen(x$1);
                }

                public Boolean apply(Boolean errored) {
                    this.$outer.org$apache$hudi$HoodieStreamingSink$$log().info((Object)new StringBuilder(36).append("Async Compactor shutdown. Errored ? ").append(errored).toString());
                    this.$outer.org$apache$hudi$HoodieStreamingSink$$isAsyncCompactorServiceShutdownAbnormally_$eq(Predef$.MODULE$.Boolean2boolean(errored));
                    this.$outer.org$apache$hudi$HoodieStreamingSink$$reset(false);
                    this.$outer.org$apache$hudi$HoodieStreamingSink$$log().info((Object)"Done resetting write client.");
                    return Predef$.MODULE$.boolean2Boolean(true);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(this){
                private final /* synthetic */ HoodieStreamingSink $outer;

                public void run() {
                    this.$outer.org$apache$hudi$HoodieStreamingSink$$reset(true);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }));
            HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(this.sqlContext.sparkContext().hadoopConfiguration()).setBasePath(client.getConfig().getBasePath()).build();
            List<HoodieInstant> pendingInstants = CompactionUtils.getPendingCompactionInstantTimes(metaClient);
            JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(pendingInstants).foreach((Function1 & Serializable & scala.Serializable)h -> {
                HoodieStreamingSink.$anonfun$triggerAsyncCompactor$1(this, h);
                return BoxedUnit.UNIT;
            });
        }
    }

    public void triggerAsyncClustering(SparkRDDWriteClient<HoodieRecordPayload<Nothing$>> client) {
        block0: {
            if (this.asyncClusteringService() != null) break block0;
            this.org$apache$hudi$HoodieStreamingSink$$log().info((Object)"Triggering async clustering!");
            this.asyncClusteringService_$eq(new SparkStreamingAsyncClusteringService(new HoodieSparkEngineContext(new JavaSparkContext(this.sqlContext.sparkContext())), client));
            this.asyncClusteringService().start(new Function<Boolean, Boolean>(this){
                private final /* synthetic */ HoodieStreamingSink $outer;

                public <V> Function<V, Boolean> compose(Function<? super V, ? extends Boolean> x$1) {
                    return Function.super.compose(x$1);
                }

                public <V> Function<Boolean, V> andThen(Function<? super Boolean, ? extends V> x$1) {
                    return Function.super.andThen(x$1);
                }

                public Boolean apply(Boolean errored) {
                    this.$outer.org$apache$hudi$HoodieStreamingSink$$log().info((Object)new StringBuilder(45).append("Async clustering service shutdown. Errored ? ").append(errored).toString());
                    this.$outer.org$apache$hudi$HoodieStreamingSink$$isAsyncClusteringServiceShutdownAbnormally_$eq(Predef$.MODULE$.Boolean2boolean(errored));
                    this.$outer.org$apache$hudi$HoodieStreamingSink$$reset(false);
                    return Predef$.MODULE$.boolean2Boolean(true);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(this){
                private final /* synthetic */ HoodieStreamingSink $outer;

                public void run() {
                    this.$outer.org$apache$hudi$HoodieStreamingSink$$reset(true);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }));
            HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(this.sqlContext.sparkContext().hadoopConfiguration()).setBasePath(client.getConfig().getBasePath()).build();
            List<HoodieInstant> pendingInstants = ClusteringUtils.getPendingClusteringInstantTimes(metaClient);
            JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(pendingInstants).foreach((Function1 & Serializable & scala.Serializable)h -> {
                HoodieStreamingSink.$anonfun$triggerAsyncClustering$1(this, h);
                return BoxedUnit.UNIT;
            });
        }
    }

    public synchronized void org$apache$hudi$HoodieStreamingSink$$reset(boolean force) {
        block2: {
            if (this.asyncCompactorService() != null) {
                this.asyncCompactorService().shutdown(force);
                this.asyncCompactorService_$eq(null);
            }
            if (this.asyncClusteringService() != null) {
                this.asyncClusteringService().shutdown(force);
                this.asyncClusteringService_$eq(null);
            }
            if (!this.writeClient().isDefined()) break block2;
            ((BaseHoodieWriteClient)this.writeClient().get()).close();
            this.writeClient_$eq((scala.Option<SparkRDDWriteClient<HoodieRecordPayload<Nothing$>>>)Option$.MODULE$.empty());
        }
    }

    private boolean canSkipBatch(long incomingBatchId, String operationType) {
        boolean bl;
        if (!DataSourceWriteOptions$.MODULE$.DELETE_OPERATION_OPT_VAL().equals(operationType)) {
            String lastCheckpoint;
            Option<HoodieCommitMetadata> commitMetadata = CommitUtils.getLatestCommitMetadataWithValidCheckpointInfo(((HoodieTableMetaClient)this.metaClient().get()).getActiveTimeline().getCommitsTimeline(), this.SINK_CHECKPOINT_KEY());
            if (commitMetadata.isPresent() && !StringUtils.isNullOrEmpty(lastCheckpoint = commitMetadata.get().getMetadata(this.SINK_CHECKPOINT_KEY()))) {
                this.latestCommittedBatchId_$eq(new StringOps(Predef$.MODULE$.augmentString((String)HoodieSinkCheckpoint$.MODULE$.fromJson(lastCheckpoint).keys().head())).toLong());
            }
            bl = this.latestCommittedBatchId() >= incomingBatchId;
        } else {
            bl = false;
        }
        return bl;
    }

    private final scala.Option liftedTree1$1() {
        Some some;
        try {
            some = new Some((Object)HoodieTableMetaClient.builder().setConf(this.sqlContext.sparkContext().hadoopConfiguration()).setBasePath((String)this.tablePath().get()).build());
        }
        catch (TableNotFoundException tableNotFoundException) {
            this.org$apache$hudi$HoodieStreamingSink$$log().warn((Object)"Ignore TableNotFoundException as it is first microbatch.");
            some = Option$.MODULE$.empty();
        }
        return some;
    }

    public static final /* synthetic */ void $anonfun$triggerAsyncCompactor$1(HoodieStreamingSink $this, HoodieInstant h) {
        $this.asyncCompactorService().enqueuePendingAsyncServiceInstant(h);
    }

    public static final /* synthetic */ void $anonfun$triggerAsyncClustering$1(HoodieStreamingSink $this, HoodieInstant h) {
        $this.asyncClusteringService().enqueuePendingAsyncServiceInstant(h);
    }

    public HoodieStreamingSink(SQLContext sqlContext, Map<String, String> options, Seq<String> partitionColumns, OutputMode outputMode) {
        this.sqlContext = sqlContext;
        this.options = options;
        Sink.$init$((Sink)this);
        this.latestCommittedBatchId = -1L;
        this.org$apache$hudi$HoodieStreamingSink$$log = LogManager.getLogger(HoodieStreamingSink.class);
        this.tablePath = options.get((Object)"path");
        if (this.tablePath().isEmpty() || this.tablePath().get() == null) {
            throw new HoodieException("'path'  must be specified.");
        }
        this.metaClient = this.liftedTree1$1();
        this.retryCnt = new StringOps(Predef$.MODULE$.augmentString(JavaConversions$.MODULE$.deprecated$u0020mapAsJavaMap(options).getOrDefault(DataSourceWriteOptions$.MODULE$.STREAMING_RETRY_CNT().key(), DataSourceWriteOptions$.MODULE$.STREAMING_RETRY_CNT().defaultValue()))).toInt();
        this.retryIntervalMs = new StringOps(Predef$.MODULE$.augmentString(JavaConversions$.MODULE$.deprecated$u0020mapAsJavaMap(options).getOrDefault(DataSourceWriteOptions$.MODULE$.STREAMING_RETRY_INTERVAL_MS().key(), DataSourceWriteOptions$.MODULE$.STREAMING_RETRY_INTERVAL_MS().defaultValue()))).toLong();
        this.ignoreFailedBatch = new StringOps(Predef$.MODULE$.augmentString(JavaConversions$.MODULE$.deprecated$u0020mapAsJavaMap(options).getOrDefault(DataSourceWriteOptions$.MODULE$.STREAMING_IGNORE_FAILED_BATCH().key(), DataSourceWriteOptions$.MODULE$.STREAMING_IGNORE_FAILED_BATCH().defaultValue()))).toBoolean();
        this.SINK_CHECKPOINT_KEY = "_hudi_streaming_sink_checkpoint";
        this.org$apache$hudi$HoodieStreamingSink$$isAsyncCompactorServiceShutdownAbnormally = false;
        this.org$apache$hudi$HoodieStreamingSink$$isAsyncClusteringServiceShutdownAbnormally = false;
        OutputMode outputMode2 = outputMode;
        OutputMode outputMode3 = OutputMode.Append();
        this.mode = !(outputMode2 != null ? !outputMode2.equals(outputMode3) : outputMode3 != null) ? SaveMode.Append : SaveMode.Overwrite;
        this.writeClient = Option$.MODULE$.empty();
        this.hoodieTableConfig = Option$.MODULE$.empty();
    }
}

