/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.transaction.lock;

import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.config.LockConfiguration;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.lock.LockProvider;
import org.apache.hudi.common.lock.LockState;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.exception.HoodieLockException;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class FileSystemBasedLockProvider
implements LockProvider<String>,
Serializable {
    private static final Logger LOG = LogManager.getLogger(FileSystemBasedLockProvider.class);
    private static final String LOCK_FILE_NAME = "lock";
    private final int lockTimeoutMinutes;
    private final transient FileSystem fs;
    private final transient Path lockFile;
    protected LockConfiguration lockConfiguration;

    public FileSystemBasedLockProvider(LockConfiguration lockConfiguration, Configuration configuration) {
        this.checkRequiredProps(lockConfiguration);
        this.lockConfiguration = lockConfiguration;
        String lockDirectory = lockConfiguration.getConfig().getString("hoodie.write.lock.filesystem.path", null);
        if (StringUtils.isNullOrEmpty(lockDirectory)) {
            lockDirectory = lockConfiguration.getConfig().getString(HoodieWriteConfig.BASE_PATH.key()) + "/" + ".hoodie";
        }
        this.lockTimeoutMinutes = lockConfiguration.getConfig().getInteger("hoodie.write.lock.filesystem.expire");
        this.lockFile = new Path(lockDirectory + "/" + LOCK_FILE_NAME);
        this.fs = FSUtils.getFs(this.lockFile.toString(), configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        String string = LOCK_FILE_NAME;
        synchronized (LOCK_FILE_NAME) {
            try {
                this.fs.delete(this.lockFile, true);
            }
            catch (IOException e) {
                throw new HoodieLockException(this.generateLogStatement(LockState.FAILED_TO_RELEASE), e);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tryLock(long time, TimeUnit unit) {
        try {
            String string = LOCK_FILE_NAME;
            synchronized (LOCK_FILE_NAME) {
                if (this.fs.exists(this.lockFile)) {
                    if (this.checkIfExpired()) {
                        this.fs.delete(this.lockFile, true);
                        LOG.warn((Object)("Delete expired lock file: " + this.lockFile));
                    } else {
                        // ** MonitorExit[var4_3] (shouldn't be in output)
                        return false;
                    }
                }
                this.acquireLock();
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return this.fs.exists(this.lockFile);
            }
        }
        catch (IOException | HoodieIOException e) {
            LOG.info((Object)this.generateLogStatement(LockState.FAILED_TO_ACQUIRE), (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlock() {
        String string = LOCK_FILE_NAME;
        synchronized (LOCK_FILE_NAME) {
            try {
                if (this.fs.exists(this.lockFile)) {
                    this.fs.delete(this.lockFile, true);
                }
            }
            catch (IOException io) {
                throw new HoodieIOException(this.generateLogStatement(LockState.FAILED_TO_RELEASE), io);
            }
            return;
        }
    }

    @Override
    public String getLock() {
        return this.lockFile.toString();
    }

    private boolean checkIfExpired() {
        if (this.lockTimeoutMinutes == 0) {
            return false;
        }
        try {
            long modificationTime = this.fs.getFileStatus(this.lockFile).getModificationTime();
            if (System.currentTimeMillis() - modificationTime > (long)(this.lockTimeoutMinutes * 60) * 1000L) {
                return true;
            }
        }
        catch (IOException | HoodieIOException e) {
            LOG.error((Object)(this.generateLogStatement(LockState.ALREADY_RELEASED) + " failed to get lockFile's modification time"), (Throwable)e);
        }
        return false;
    }

    private void acquireLock() {
        try {
            this.fs.create(this.lockFile, false).close();
        }
        catch (IOException e) {
            throw new HoodieIOException(this.generateLogStatement(LockState.FAILED_TO_ACQUIRE), e);
        }
    }

    protected String generateLogStatement(LockState state) {
        return StringUtils.join(state.name(), " lock at: ", this.getLock());
    }

    private void checkRequiredProps(LockConfiguration config) {
        ValidationUtils.checkArgument(config.getConfig().getString("hoodie.write.lock.filesystem.path", null) != null || config.getConfig().getString(HoodieWriteConfig.BASE_PATH.key(), null) != null);
        ValidationUtils.checkArgument(config.getConfig().getInteger("hoodie.write.lock.filesystem.expire") >= 0);
    }
}

