/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.config.SerializableConfiguration;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.table.marker.MarkerType;
import org.apache.hudi.common.util.FileIOUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class MarkerUtils {
    public static final String MARKERS_FILENAME_PREFIX = "MARKERS";
    public static final String MARKER_TYPE_FILENAME = "MARKERS.type";
    private static final Logger LOG = LogManager.getLogger(MarkerUtils.class);

    public static String stripMarkerFolderPrefix(String fullMarkerPath, String basePath, String instantTime) {
        ValidationUtils.checkArgument(fullMarkerPath.contains(".marker"), String.format("Using DIRECT markers but marker path does not contain extension: %s", ".marker"));
        String markerRootPath = Path.getPathWithoutSchemeAndAuthority((Path)new Path(String.format("%s/%s/%s", basePath, ".hoodie/.temp", instantTime))).toString();
        return MarkerUtils.stripMarkerFolderPrefix(fullMarkerPath, markerRootPath);
    }

    public static String stripMarkerFolderPrefix(String fullMarkerPath, String markerDir) {
        int begin = fullMarkerPath.indexOf(markerDir);
        ValidationUtils.checkArgument(begin >= 0, "Not in marker dir. Marker Path=" + fullMarkerPath + ", Expected Marker Root=" + markerDir);
        return fullMarkerPath.substring(begin + markerDir.length() + 1);
    }

    public static boolean doesMarkerTypeFileExist(FileSystem fileSystem2, String markerDir) throws IOException {
        return fileSystem2.exists(new Path(markerDir, MARKER_TYPE_FILENAME));
    }

    public static Option<MarkerType> readMarkerType(FileSystem fileSystem2, String markerDir) {
        Path markerTypeFilePath = new Path(markerDir, MARKER_TYPE_FILENAME);
        FSDataInputStream fsDataInputStream = null;
        Option<MarkerType> content = Option.empty();
        try {
            if (!MarkerUtils.doesMarkerTypeFileExist(fileSystem2, markerDir)) {
                Option<MarkerType> option = Option.empty();
                return option;
            }
            fsDataInputStream = fileSystem2.open(markerTypeFilePath);
            content = Option.of(MarkerType.valueOf(FileIOUtils.readAsUTFString((InputStream)fsDataInputStream)));
            FileIOUtils.closeQuietly((Closeable)fsDataInputStream);
        }
        catch (IOException e) {
            throw new HoodieIOException("Cannot read marker type file " + markerTypeFilePath.toString() + "; " + e.getMessage(), e);
        }
        finally {
            FileIOUtils.closeQuietly(fsDataInputStream);
        }
        return content;
    }

    public static void writeMarkerTypeToFile(MarkerType markerType, FileSystem fileSystem2, String markerDir) {
        Path markerTypeFilePath = new Path(markerDir, MARKER_TYPE_FILENAME);
        FSDataOutputStream fsDataOutputStream = null;
        BufferedWriter bufferedWriter = null;
        try {
            fsDataOutputStream = fileSystem2.create(markerTypeFilePath, false);
            bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)fsDataOutputStream, StandardCharsets.UTF_8));
            bufferedWriter.write(markerType.toString());
        }
        catch (IOException e) {
            try {
                throw new HoodieException("Failed to create marker type file " + markerTypeFilePath.toString() + "; " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                FileIOUtils.closeQuietly(bufferedWriter);
                FileIOUtils.closeQuietly((Closeable)fsDataOutputStream);
                throw throwable;
            }
        }
        FileIOUtils.closeQuietly(bufferedWriter);
        FileIOUtils.closeQuietly((Closeable)fsDataOutputStream);
    }

    public static void deleteMarkerTypeFile(FileSystem fileSystem2, String markerDir) {
        Path markerTypeFilePath = new Path(markerDir, MARKER_TYPE_FILENAME);
        try {
            fileSystem2.delete(markerTypeFilePath, false);
        }
        catch (IOException e) {
            throw new HoodieIOException("Cannot delete marker type file " + markerTypeFilePath.toString() + "; " + e.getMessage(), e);
        }
    }

    public static Map<String, Set<String>> readTimelineServerBasedMarkersFromFileSystem(String markerDir, FileSystem fileSystem2, HoodieEngineContext context, int parallelism) {
        Path dirPath = new Path(markerDir);
        try {
            if (fileSystem2.exists(dirPath)) {
                Predicate<FileStatus> prefixFilter = fileStatus -> fileStatus.getPath().getName().startsWith(MARKERS_FILENAME_PREFIX);
                Predicate<FileStatus> markerTypeFilter = fileStatus -> !fileStatus.getPath().getName().equals(MARKER_TYPE_FILENAME);
                return FSUtils.parallelizeSubPathProcess(context, fileSystem2, dirPath, parallelism, prefixFilter.and(markerTypeFilter), pairOfSubPathAndConf -> {
                    String markersFilePathStr = (String)pairOfSubPathAndConf.getKey();
                    SerializableConfiguration conf = (SerializableConfiguration)pairOfSubPathAndConf.getValue();
                    return MarkerUtils.readMarkersFromFile(new Path(markersFilePathStr), conf);
                });
            }
            return new HashMap<String, Set<String>>();
        }
        catch (IOException ioe) {
            throw new HoodieIOException(ioe.getMessage(), ioe);
        }
    }

    public static Set<String> readMarkersFromFile(Path markersFilePath, SerializableConfiguration conf) {
        FSDataInputStream fsDataInputStream = null;
        HashSet<String> markers = new HashSet();
        try {
            LOG.debug((Object)("Read marker file: " + markersFilePath));
            FileSystem fs = markersFilePath.getFileSystem(conf.get());
            fsDataInputStream = fs.open(markersFilePath);
            markers = new HashSet<String>(FileIOUtils.readAsUTFStringLines((InputStream)fsDataInputStream));
        }
        catch (IOException e) {
            try {
                throw new HoodieIOException("Failed to read MARKERS file " + markersFilePath, e);
            }
            catch (Throwable throwable) {
                FileIOUtils.closeQuietly(fsDataInputStream);
                throw throwable;
            }
        }
        FileIOUtils.closeQuietly((Closeable)fsDataInputStream);
        return markers;
    }
}

