/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.config.metrics;

import java.util.Map;
import java.util.Properties;
import javax.annotation.concurrent.Immutable;
import org.apache.hudi.common.config.ConfigClassProperty;
import org.apache.hudi.common.config.ConfigGroups;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.HoodieConfig;

@ConfigClassProperty(name="Metrics Configurations for Datadog reporter", groupName=ConfigGroups.Names.METRICS, description="Enables reporting on Hudi metrics using the Datadog reporter type. Hudi publishes metrics on every commit, clean, rollback etc.")
@Immutable
public class HoodieMetricsDatadogConfig
extends HoodieConfig {
    public static final String DATADOG_PREFIX = "hoodie.metrics.datadog";
    public static final ConfigProperty<Integer> REPORT_PERIOD_IN_SECONDS = ConfigProperty.key("hoodie.metrics.datadog.report.period.seconds").defaultValue(30).sinceVersion("0.6.0").withDocumentation("Datadog reporting period in seconds. Default to 30.");
    public static final ConfigProperty<String> API_SITE_VALUE = ConfigProperty.key("hoodie.metrics.datadog.api.site").noDefaultValue().sinceVersion("0.6.0").withDocumentation("Datadog API site: EU or US");
    public static final ConfigProperty<String> API_KEY = ConfigProperty.key("hoodie.metrics.datadog.api.key").noDefaultValue().sinceVersion("0.6.0").withDocumentation("Datadog API key");
    public static final ConfigProperty<Boolean> API_KEY_SKIP_VALIDATION = ConfigProperty.key("hoodie.metrics.datadog.api.key.skip.validation").defaultValue(false).sinceVersion("0.6.0").withDocumentation("Before sending metrics via Datadog API, whether to skip validating Datadog API key or not. Default to false.");
    public static final ConfigProperty<String> API_KEY_SUPPLIER = ConfigProperty.key("hoodie.metrics.datadog.api.key.supplier").noDefaultValue().sinceVersion("0.6.0").withDocumentation("Datadog API key supplier to supply the API key at runtime. This will take effect if hoodie.metrics.datadog.api.key is not set.");
    public static final ConfigProperty<Integer> API_TIMEOUT_IN_SECONDS = ConfigProperty.key("hoodie.metrics.datadog.api.timeout.seconds").defaultValue(3).sinceVersion("0.6.0").withDocumentation("Datadog API timeout in seconds. Default to 3.");
    public static final ConfigProperty<String> METRIC_PREFIX_VALUE = ConfigProperty.key("hoodie.metrics.datadog.metric.prefix").noDefaultValue().sinceVersion("0.6.0").withDocumentation("Datadog metric prefix to be prepended to each metric name with a dot as delimiter. For example, if it is set to foo, foo. will be prepended.");
    public static final ConfigProperty<String> METRIC_HOST_NAME = ConfigProperty.key("hoodie.metrics.datadog.metric.host").noDefaultValue().sinceVersion("0.6.0").withDocumentation("Datadog metric host to be sent along with metrics data.");
    public static final ConfigProperty<String> METRIC_TAG_VALUES = ConfigProperty.key("hoodie.metrics.datadog.metric.tags").noDefaultValue().sinceVersion("0.6.0").withDocumentation("Datadog metric tags (comma-delimited) to be sent along with metrics data.");
    @Deprecated
    public static final String DATADOG_REPORT_PERIOD_SECONDS = REPORT_PERIOD_IN_SECONDS.key();
    @Deprecated
    public static final int DEFAULT_DATADOG_REPORT_PERIOD_SECONDS = REPORT_PERIOD_IN_SECONDS.defaultValue();
    @Deprecated
    public static final String DATADOG_API_SITE = API_SITE_VALUE.key();
    @Deprecated
    public static final String DATADOG_API_KEY = API_KEY.key();
    @Deprecated
    public static final String DATADOG_API_KEY_SKIP_VALIDATION = API_KEY_SKIP_VALIDATION.key();
    @Deprecated
    public static final boolean DEFAULT_DATADOG_API_KEY_SKIP_VALIDATION = API_KEY_SKIP_VALIDATION.defaultValue();
    @Deprecated
    public static final String DATADOG_API_KEY_SUPPLIER = API_KEY_SUPPLIER.key();
    @Deprecated
    public static final String DATADOG_API_TIMEOUT_SECONDS = API_TIMEOUT_IN_SECONDS.key();
    @Deprecated
    public static final int DEFAULT_DATADOG_API_TIMEOUT_SECONDS = API_TIMEOUT_IN_SECONDS.defaultValue();
    @Deprecated
    public static final String DATADOG_METRIC_PREFIX = METRIC_PREFIX_VALUE.key();
    @Deprecated
    public static final String DATADOG_METRIC_HOST = METRIC_HOST_NAME.key();
    @Deprecated
    public static final String DATADOG_METRIC_TAGS = METRIC_TAG_VALUES.key();

    private HoodieMetricsDatadogConfig() {
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private final HoodieMetricsDatadogConfig metricsDatadogConfig = new HoodieMetricsDatadogConfig();

        public Builder fromProperties(Properties props) {
            this.metricsDatadogConfig.getProps().putAll((Map<?, ?>)props);
            return this;
        }

        public Builder withDatadogReportPeriodSeconds(int period) {
            this.metricsDatadogConfig.setValue(REPORT_PERIOD_IN_SECONDS, String.valueOf(period));
            return this;
        }

        public Builder withDatadogApiSite(String apiSite) {
            this.metricsDatadogConfig.setValue(API_SITE_VALUE, apiSite);
            return this;
        }

        public Builder withDatadogApiKey(String apiKey) {
            this.metricsDatadogConfig.setValue(API_KEY, apiKey);
            return this;
        }

        public Builder withDatadogApiKeySkipValidation(boolean skip) {
            this.metricsDatadogConfig.setValue(API_KEY_SKIP_VALIDATION, String.valueOf(skip));
            return this;
        }

        public Builder withDatadogApiKeySupplier(String apiKeySupplier) {
            this.metricsDatadogConfig.setValue(API_KEY_SUPPLIER, apiKeySupplier);
            return this;
        }

        public Builder withDatadogApiTimeoutSeconds(int timeout) {
            this.metricsDatadogConfig.setValue(API_TIMEOUT_IN_SECONDS, String.valueOf(timeout));
            return this;
        }

        public Builder withDatadogPrefix(String prefix) {
            this.metricsDatadogConfig.setValue(METRIC_PREFIX_VALUE, prefix);
            return this;
        }

        public Builder withDatadogHost(String host2) {
            this.metricsDatadogConfig.setValue(METRIC_HOST_NAME, host2);
            return this;
        }

        public Builder withDatadogTags(String tags) {
            this.metricsDatadogConfig.setValue(METRIC_TAG_VALUES, tags);
            return this;
        }

        public HoodieMetricsDatadogConfig build() {
            this.metricsDatadogConfig.setDefaults(HoodieMetricsDatadogConfig.class.getName());
            return this.metricsDatadogConfig;
        }
    }
}

