/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.index.simple;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.data.HoodiePairData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.EmptyHoodieRecordPayload;
import org.apache.hudi.common.model.HoodieAvroRecord;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordLocation;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.ImmutablePair;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.index.HoodieIndexUtils;
import org.apache.hudi.index.simple.HoodieSimpleIndex;
import org.apache.hudi.keygen.BaseKeyGenerator;
import org.apache.hudi.table.HoodieTable;

public class HoodieGlobalSimpleIndex
extends HoodieSimpleIndex {
    public HoodieGlobalSimpleIndex(HoodieWriteConfig config, Option<BaseKeyGenerator> keyGeneratorOpt) {
        super(config, keyGeneratorOpt);
    }

    @Override
    public <R> HoodieData<HoodieRecord<R>> tagLocation(HoodieData<HoodieRecord<R>> records, HoodieEngineContext context, HoodieTable hoodieTable) {
        return this.tagLocationInternal(records, context, hoodieTable);
    }

    @Override
    protected <R> HoodieData<HoodieRecord<R>> tagLocationInternal(HoodieData<HoodieRecord<R>> inputRecords, HoodieEngineContext context, HoodieTable hoodieTable) {
        HoodiePairData<String, HoodieRecord<R>> keyedInputRecords = inputRecords.mapToPair(entry -> new ImmutablePair<String, HoodieRecord>(entry.getRecordKey(), (HoodieRecord)entry));
        HoodiePairData<HoodieKey, HoodieRecordLocation> allRecordLocationsInTable = this.fetchAllRecordLocations(context, hoodieTable, this.config.getGlobalSimpleIndexParallelism());
        return this.getTaggedRecords(keyedInputRecords, allRecordLocationsInTable);
    }

    protected HoodiePairData<HoodieKey, HoodieRecordLocation> fetchAllRecordLocations(HoodieEngineContext context, HoodieTable hoodieTable, int parallelism) {
        List<Pair<String, HoodieBaseFile>> latestBaseFiles = this.getAllBaseFilesInTable(context, hoodieTable);
        return this.fetchRecordLocations(context, hoodieTable, parallelism, latestBaseFiles);
    }

    protected List<Pair<String, HoodieBaseFile>> getAllBaseFilesInTable(HoodieEngineContext context, HoodieTable hoodieTable) {
        HoodieTableMetaClient metaClient = hoodieTable.getMetaClient();
        List<String> allPartitionPaths = FSUtils.getAllPartitionPaths(context, this.config.getMetadataConfig(), metaClient.getBasePath());
        return HoodieIndexUtils.getLatestBaseFilesForAllPartitions(allPartitionPaths, context, hoodieTable);
    }

    private <R> HoodieData<HoodieRecord<R>> getTaggedRecords(HoodiePairData<String, HoodieRecord<R>> incomingRecords, HoodiePairData<HoodieKey, HoodieRecordLocation> existingRecords) {
        HoodiePairData existingRecordByRecordKey = existingRecords.mapToPair(entry -> new ImmutablePair(((HoodieKey)entry.getLeft()).getRecordKey(), Pair.of(((HoodieKey)entry.getLeft()).getPartitionPath(), entry.getRight())));
        return incomingRecords.leftOuterJoin(existingRecordByRecordKey).values().flatMap(entry -> {
            List<HoodieRecord> taggedRecords;
            HoodieRecord inputRecord = (HoodieRecord)entry.getLeft();
            Option<Object> partitionPathLocationPair = Option.ofNullable(((Option)entry.getRight()).orElse(null));
            if (partitionPathLocationPair.isPresent()) {
                String partitionPath = (String)((Pair)partitionPathLocationPair.get()).getKey();
                HoodieRecordLocation location = (HoodieRecordLocation)((Pair)partitionPathLocationPair.get()).getRight();
                if (this.config.getGlobalSimpleIndexUpdatePartitionPath() && !inputRecord.getPartitionPath().equals(partitionPath)) {
                    HoodieAvroRecord<EmptyHoodieRecordPayload> deleteRecord = new HoodieAvroRecord<EmptyHoodieRecordPayload>(new HoodieKey(inputRecord.getRecordKey(), partitionPath), new EmptyHoodieRecordPayload());
                    deleteRecord.setCurrentLocation(location);
                    deleteRecord.seal();
                    HoodieRecord insertRecord = HoodieIndexUtils.getTaggedRecord(inputRecord, Option.empty());
                    taggedRecords = Arrays.asList(deleteRecord, insertRecord);
                } else {
                    HoodieAvroRecord<HoodieRecordPayload> newRecord = new HoodieAvroRecord<HoodieRecordPayload>(new HoodieKey(inputRecord.getRecordKey(), partitionPath), (HoodieRecordPayload)inputRecord.getData());
                    taggedRecords = Collections.singletonList(HoodieIndexUtils.getTaggedRecord(newRecord, Option.ofNullable(location)));
                }
            } else {
                taggedRecords = Collections.singletonList(HoodieIndexUtils.getTaggedRecord(inputRecord, Option.empty()));
            }
            return taggedRecords.iterator();
        });
    }

    @Override
    public boolean isGlobal() {
        return true;
    }
}

