/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.internal;

import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.CommitUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.table.HoodieSparkTable;
import org.apache.hudi.table.HoodieTable;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.StructType;

public class DataSourceInternalWriterHelper {
    private static final Logger LOG = LogManager.getLogger(DataSourceInternalWriterHelper.class);
    public static final String INSTANT_TIME_OPT_KEY = "hoodie.instant.time";
    private final String instantTime;
    private final HoodieTableMetaClient metaClient;
    private final SparkRDDWriteClient writeClient;
    private final HoodieTable hoodieTable;
    private final WriteOperationType operationType;
    private Map<String, String> extraMetadata;

    public DataSourceInternalWriterHelper(String instantTime, HoodieWriteConfig writeConfig, StructType structType, SparkSession sparkSession, Configuration configuration, Map<String, String> extraMetadata) {
        this.instantTime = instantTime;
        this.operationType = WriteOperationType.BULK_INSERT;
        this.extraMetadata = extraMetadata;
        this.writeClient = new SparkRDDWriteClient(new HoodieSparkEngineContext(new JavaSparkContext(sparkSession.sparkContext())), writeConfig);
        this.writeClient.setOperationType(this.operationType);
        this.writeClient.startCommitWithTime(instantTime);
        this.metaClient = HoodieTableMetaClient.builder().setConf(configuration).setBasePath(writeConfig.getBasePath()).build();
        this.metaClient.validateTableProperties(writeConfig.getProps());
        this.hoodieTable = HoodieSparkTable.create(writeConfig, new HoodieSparkEngineContext(new JavaSparkContext(sparkSession.sparkContext())), this.metaClient);
        this.writeClient.preWrite(instantTime, WriteOperationType.BULK_INSERT, this.metaClient);
    }

    public boolean useCommitCoordinator() {
        return true;
    }

    public void onDataWriterCommit(String message) {
        LOG.info((Object)("Received commit of a data writer = " + message));
    }

    public void commit(List<HoodieWriteStat> writeStatList) {
        try {
            this.writeClient.commitStats(this.instantTime, writeStatList, Option.of(this.extraMetadata), CommitUtils.getCommitActionType(this.operationType, this.metaClient.getTableType()));
        }
        catch (Exception ioe) {
            throw new HoodieException(ioe.getMessage(), ioe);
        }
        finally {
            this.writeClient.close();
        }
    }

    public void abort() {
        LOG.error((Object)("Commit " + this.instantTime + " aborted "));
        this.writeClient.rollback(this.instantTime);
        this.writeClient.close();
    }

    public void createInflightCommit() {
        this.metaClient.getActiveTimeline().transitionRequestedToInflight(new HoodieInstant(HoodieInstant.State.REQUESTED, CommitUtils.getCommitActionType(this.operationType, this.metaClient.getTableType()), this.instantTime), Option.empty());
    }

    public HoodieTable getHoodieTable() {
        return this.hoodieTable;
    }

    public WriteOperationType getWriteOperationType() {
        return this.operationType;
    }
}

