/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.keygen;

import java.io.IOException;
import java.util.Objects;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.exception.HoodieKeyGeneratorException;
import org.apache.hudi.keygen.SimpleKeyGenerator;
import org.apache.hudi.keygen.TimestampBasedAvroKeyGenerator;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;

public class TimestampBasedKeyGenerator
extends SimpleKeyGenerator {
    private final TimestampBasedAvroKeyGenerator timestampBasedAvroKeyGenerator;

    public TimestampBasedKeyGenerator(TypedProperties config) throws IOException {
        this(config, config.getString(KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key()), config.getString(KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key()));
    }

    TimestampBasedKeyGenerator(TypedProperties config, String partitionPathField) throws IOException {
        this(config, null, partitionPathField);
    }

    TimestampBasedKeyGenerator(TypedProperties config, String recordKeyField, String partitionPathField) throws IOException {
        super(config, recordKeyField, partitionPathField);
        this.timestampBasedAvroKeyGenerator = new TimestampBasedAvroKeyGenerator(config, recordKeyField, partitionPathField);
    }

    @Override
    public String getPartitionPath(GenericRecord record) {
        return this.timestampBasedAvroKeyGenerator.getPartitionPath(record);
    }

    @Override
    public String getRecordKey(Row row) {
        this.tryInitRowAccessor(row.schema());
        return this.combineRecordKey(this.rowAccessor.getRecordKeyParts(row));
    }

    @Override
    public UTF8String getRecordKey(InternalRow internalRow, StructType schema) {
        this.tryInitRowAccessor(schema);
        return this.combineRecordKeyUnsafe(this.rowAccessor.getRecordKeyParts(internalRow));
    }

    @Override
    public String getPartitionPath(Row row) {
        this.tryInitRowAccessor(row.schema());
        Object[] partitionPathValues = this.rowAccessor.getRecordPartitionPathValues(row);
        return this.getFormattedPartitionPath(partitionPathValues[0]);
    }

    @Override
    public UTF8String getPartitionPath(InternalRow row, StructType schema) {
        this.tryInitRowAccessor(schema);
        Object[] partitionPathValues = this.rowAccessor.getRecordPartitionPathValues(row);
        return UTF8String.fromString((String)this.getFormattedPartitionPath(partitionPathValues[0]));
    }

    private String getFormattedPartitionPath(Object partitionPathPart) {
        Object fieldVal = partitionPathPart == null || Objects.equals(partitionPathPart, "__HIVE_DEFAULT_PARTITION__") ? this.timestampBasedAvroKeyGenerator.getDefaultPartitionVal() : (partitionPathPart instanceof UTF8String ? partitionPathPart.toString() : partitionPathPart);
        try {
            return this.timestampBasedAvroKeyGenerator.getPartitionPath(fieldVal);
        }
        catch (Exception e) {
            throw new HoodieKeyGeneratorException(String.format("Failed to properly format partition-path (%s)", fieldVal), e);
        }
    }
}

