/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.rollback;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.hudi.avro.model.HoodieRollbackMetadata;
import org.apache.hudi.avro.model.HoodieRollbackPlan;
import org.apache.hudi.client.heartbeat.HoodieHeartbeatClient;
import org.apache.hudi.client.transaction.TransactionManager;
import org.apache.hudi.common.HoodieRollbackStat;
import org.apache.hudi.common.bootstrap.index.BootstrapIndex;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.util.ClusteringUtils;
import org.apache.hudi.common.util.HoodieTimer;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.exception.HoodieRollbackException;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.BaseActionExecutor;
import org.apache.hudi.table.action.rollback.BaseRollbackHelper;
import org.apache.hudi.table.action.rollback.RollbackUtils;
import org.apache.hudi.table.marker.WriteMarkersFactory;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public abstract class BaseRollbackActionExecutor<T extends HoodieRecordPayload, I, K, O>
extends BaseActionExecutor<T, I, K, O, HoodieRollbackMetadata> {
    private static final Logger LOG = LogManager.getLogger(BaseRollbackActionExecutor.class);
    protected final HoodieInstant instantToRollback;
    protected final boolean deleteInstants;
    protected final boolean skipTimelinePublish;
    private final TransactionManager txnManager;
    private final boolean skipLocking;
    protected HoodieInstant resolvedInstant;

    public BaseRollbackActionExecutor(HoodieEngineContext context, HoodieWriteConfig config, HoodieTable<T, I, K, O> table, String instantTime, HoodieInstant instantToRollback, boolean deleteInstants, boolean skipLocking) {
        this(context, config, table, instantTime, instantToRollback, deleteInstants, false, skipLocking);
    }

    public BaseRollbackActionExecutor(HoodieEngineContext context, HoodieWriteConfig config, HoodieTable<T, I, K, O> table, String instantTime, HoodieInstant instantToRollback, boolean deleteInstants, boolean skipTimelinePublish, boolean skipLocking) {
        super(context, config, table, instantTime);
        this.instantToRollback = instantToRollback;
        this.resolvedInstant = instantToRollback;
        this.deleteInstants = deleteInstants;
        this.skipTimelinePublish = skipTimelinePublish;
        this.skipLocking = skipLocking;
        this.txnManager = new TransactionManager(config, table.getMetaClient().getFs());
    }

    protected abstract List<HoodieRollbackStat> executeRollback(HoodieRollbackPlan var1) throws IOException;

    private HoodieRollbackMetadata runRollback(HoodieTable<T, I, K, O> table, HoodieInstant rollbackInstant, HoodieRollbackPlan rollbackPlan) {
        ValidationUtils.checkArgument(rollbackInstant.getState().equals((Object)HoodieInstant.State.REQUESTED) || rollbackInstant.getState().equals((Object)HoodieInstant.State.INFLIGHT));
        HoodieInstant inflightInstant = rollbackInstant.isRequested() ? table.getActiveTimeline().transitionRollbackRequestedToInflight(rollbackInstant) : rollbackInstant;
        HoodieTimer rollbackTimer = new HoodieTimer().startTimer();
        List<HoodieRollbackStat> stats = this.doRollbackAndGetStats(rollbackPlan);
        HoodieRollbackMetadata rollbackMetadata = TimelineMetadataUtils.convertRollbackMetadata(this.instantTime, Option.of(rollbackTimer.endTimer()), Collections.singletonList(this.instantToRollback), stats);
        this.finishRollback(inflightInstant, rollbackMetadata);
        WriteMarkersFactory.get(this.config.getMarkersType(), table, this.instantToRollback.getTimestamp()).quietDeleteMarkerDir(this.context, this.config.getMarkersDeleteParallelism());
        return rollbackMetadata;
    }

    @Override
    public HoodieRollbackMetadata execute() {
        this.table.getMetaClient().reloadActiveTimeline();
        Option<HoodieInstant> rollbackInstant = this.table.getRollbackTimeline().filterInflightsAndRequested().filter(instant -> instant.getTimestamp().equals(this.instantTime)).firstInstant();
        if (!rollbackInstant.isPresent()) {
            throw new HoodieRollbackException("No pending rollback instants found to execute rollback");
        }
        try {
            HoodieRollbackPlan rollbackPlan = RollbackUtils.getRollbackPlan(this.table.getMetaClient(), rollbackInstant.get());
            return this.runRollback(this.table, rollbackInstant.get(), rollbackPlan);
        }
        catch (IOException e) {
            throw new HoodieIOException("Failed to fetch rollback plan for commit " + this.instantTime, e);
        }
    }

    private void validateSavepointRollbacks() {
        List<String> savepoints = this.table.getCompletedSavepointTimeline().getInstants().map(HoodieInstant::getTimestamp).collect(Collectors.toList());
        savepoints.forEach(s -> {
            if (s.contains(this.instantToRollback.getTimestamp())) {
                throw new HoodieRollbackException("Could not rollback a savepointed commit. Delete savepoint first before rolling back" + s);
            }
        });
    }

    private void validateRollbackCommitSequence() {
        if (this.config.getFailedWritesCleanPolicy().isEager()) {
            String instantTimeToRollback = this.instantToRollback.getTimestamp();
            HoodieTimeline commitTimeline = this.table.getCompletedCommitsTimeline();
            HoodieTimeline inflightAndRequestedCommitTimeline = this.table.getPendingCommitTimeline();
            if (instantTimeToRollback != null && !commitTimeline.empty() && !commitTimeline.findInstantsAfter(instantTimeToRollback, Integer.MAX_VALUE).empty()) {
                try {
                    if (!HoodieHeartbeatClient.heartbeatExists(this.table.getMetaClient().getFs(), this.config.getBasePath(), instantTimeToRollback).booleanValue()) {
                        throw new HoodieRollbackException("Found commits after time :" + instantTimeToRollback + ", please rollback greater commits first");
                    }
                }
                catch (IOException io) {
                    throw new HoodieRollbackException("Unable to rollback commits ", io);
                }
            }
            List inflights = inflightAndRequestedCommitTimeline.getInstants().filter(instant -> {
                if (!instant.getAction().equals("replacecommit")) {
                    return true;
                }
                return !ClusteringUtils.isPendingClusteringInstant(this.table.getMetaClient(), instant);
            }).map(HoodieInstant::getTimestamp).collect(Collectors.toList());
            if (instantTimeToRollback != null && !inflights.isEmpty() && inflights.indexOf(instantTimeToRollback) != inflights.size() - 1) {
                throw new HoodieRollbackException("Found in-flight commits after time :" + instantTimeToRollback + ", please rollback greater commits first");
            }
        }
    }

    private void rollBackIndex() {
        if (!this.table.getIndex().rollbackCommit(this.instantToRollback.getTimestamp())) {
            throw new HoodieRollbackException("Rollback index changes failed, for time :" + this.instantToRollback);
        }
        LOG.info((Object)("Index rolled back for commits " + this.instantToRollback));
    }

    public List<HoodieRollbackStat> doRollbackAndGetStats(HoodieRollbackPlan hoodieRollbackPlan) {
        String instantTimeToRollback = this.instantToRollback.getTimestamp();
        boolean isPendingCompaction = Objects.equals("compaction", this.instantToRollback.getAction()) && !this.instantToRollback.isCompleted();
        boolean isPendingClustering = Objects.equals("replacecommit", this.instantToRollback.getAction()) && !this.instantToRollback.isCompleted() && ClusteringUtils.getClusteringPlan(this.table.getMetaClient(), this.instantToRollback).isPresent();
        this.validateSavepointRollbacks();
        if (!isPendingCompaction && !isPendingClustering) {
            this.validateRollbackCommitSequence();
        }
        try {
            List<HoodieRollbackStat> stats = this.executeRollback(hoodieRollbackPlan);
            LOG.info((Object)("Rolled back inflight instant " + instantTimeToRollback));
            if (!isPendingCompaction) {
                this.rollBackIndex();
            }
            return stats;
        }
        catch (IOException e) {
            throw new HoodieIOException("Unable to execute rollback ", e);
        }
    }

    protected List<HoodieRollbackStat> executeRollback(HoodieInstant instantToRollback, HoodieRollbackPlan rollbackPlan) {
        return new BaseRollbackHelper(this.table.getMetaClient(), this.config).performRollback(this.context, instantToRollback, rollbackPlan.getRollbackRequests());
    }

    protected void finishRollback(HoodieInstant inflightInstant, HoodieRollbackMetadata rollbackMetadata) throws HoodieIOException {
        boolean enableLocking = !this.skipLocking && !this.skipTimelinePublish;
        try {
            if (enableLocking) {
                this.txnManager.beginTransaction(Option.of(inflightInstant), Option.empty());
            }
            if (!this.skipTimelinePublish) {
                this.writeTableMetadata(rollbackMetadata);
            }
            this.deleteInflightAndRequestedInstant(this.deleteInstants, this.table.getActiveTimeline(), this.resolvedInstant);
            if (!this.skipTimelinePublish) {
                this.table.getActiveTimeline().transitionRollbackInflightToComplete(inflightInstant, TimelineMetadataUtils.serializeRollbackMetadata(rollbackMetadata));
                LOG.info((Object)("Rollback of Commits " + rollbackMetadata.getCommitsRollback() + " is complete"));
            }
        }
        catch (IOException e) {
            throw new HoodieIOException("Error executing rollback at instant " + this.instantTime, e);
        }
        finally {
            if (enableLocking) {
                this.txnManager.endTransaction(Option.of(inflightInstant));
            }
        }
    }

    protected void deleteInflightAndRequestedInstant(boolean deleteInstant, HoodieActiveTimeline activeTimeline, HoodieInstant instantToBeDeleted) {
        if (deleteInstant) {
            LOG.info((Object)("Deleting instant=" + instantToBeDeleted));
            activeTimeline.deletePending(instantToBeDeleted);
            if (instantToBeDeleted.isInflight() && !this.table.getMetaClient().getTimelineLayoutVersion().isNullVersion()) {
                instantToBeDeleted = new HoodieInstant(HoodieInstant.State.REQUESTED, instantToBeDeleted.getAction(), instantToBeDeleted.getTimestamp());
                activeTimeline.deletePending(instantToBeDeleted);
            }
            LOG.info((Object)("Deleted pending commit " + instantToBeDeleted));
        } else {
            LOG.warn((Object)("Rollback finished without deleting inflight instant file. Instant=" + instantToBeDeleted));
        }
    }

    protected void dropBootstrapIndexIfNeeded(HoodieInstant instantToRollback) {
        if (HoodieTimeline.compareTimestamps(instantToRollback.getTimestamp(), HoodieTimeline.EQUALS, "00000000000001")) {
            LOG.info((Object)"Dropping bootstrap index as metadata bootstrap commit is getting rolled back !!");
            BootstrapIndex.getBootstrapIndex(this.table.getMetaClient()).dropIndex();
        }
    }
}

