/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.timeline.service.handlers;

import io.javalin.http.Context;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.metrics.Registry;
import org.apache.hudi.common.model.IOType;
import org.apache.hudi.common.table.view.FileSystemViewManager;
import org.apache.hudi.timeline.service.TimelineService;
import org.apache.hudi.timeline.service.handlers.Handler;
import org.apache.hudi.timeline.service.handlers.marker.MarkerCreationDispatchingRunnable;
import org.apache.hudi.timeline.service.handlers.marker.MarkerCreationFuture;
import org.apache.hudi.timeline.service.handlers.marker.MarkerDirState;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class MarkerHandler
extends Handler {
    private static final Logger LOG = LogManager.getLogger(MarkerHandler.class);
    private final Registry metricsRegistry;
    private final ScheduledExecutorService dispatchingExecutorService;
    private final ExecutorService batchingExecutorService;
    private final int parallelism;
    private final Map<String, MarkerDirState> markerDirStateMap = new ConcurrentHashMap<String, MarkerDirState>();
    private final MarkerCreationDispatchingRunnable markerCreationDispatchingRunnable;
    private final Object firstCreationRequestSeenLock = new Object();
    private transient HoodieEngineContext hoodieEngineContext;
    private ScheduledFuture<?> dispatchingThreadFuture;
    private boolean firstCreationRequestSeen;

    public MarkerHandler(Configuration conf, TimelineService.Config timelineServiceConfig, HoodieEngineContext hoodieEngineContext, FileSystem fileSystem2, FileSystemViewManager viewManager, Registry metricsRegistry) throws IOException {
        super(conf, timelineServiceConfig, fileSystem2, viewManager);
        LOG.debug((Object)("MarkerHandler FileSystem: " + this.fileSystem.getScheme()));
        LOG.debug((Object)("MarkerHandler batching params: batchNumThreads=" + timelineServiceConfig.markerBatchNumThreads + " batchIntervalMs=" + timelineServiceConfig.markerBatchIntervalMs + "ms"));
        this.hoodieEngineContext = hoodieEngineContext;
        this.metricsRegistry = metricsRegistry;
        this.parallelism = timelineServiceConfig.markerParallelism;
        this.dispatchingExecutorService = Executors.newSingleThreadScheduledExecutor();
        this.batchingExecutorService = Executors.newFixedThreadPool(timelineServiceConfig.markerBatchNumThreads);
        this.markerCreationDispatchingRunnable = new MarkerCreationDispatchingRunnable(this.markerDirStateMap, this.batchingExecutorService);
        this.firstCreationRequestSeen = false;
    }

    public void stop() {
        if (this.dispatchingThreadFuture != null) {
            this.dispatchingThreadFuture.cancel(true);
        }
        this.dispatchingExecutorService.shutdown();
        this.batchingExecutorService.shutdown();
    }

    public Set<String> getAllMarkers(String markerDir) {
        MarkerDirState markerDirState = this.getMarkerDirState(markerDir);
        return markerDirState.getAllMarkers();
    }

    public Set<String> getCreateAndMergeMarkers(String markerDir) {
        return this.getAllMarkers(markerDir).stream().filter(markerName -> !markerName.endsWith(IOType.APPEND.name())).collect(Collectors.toSet());
    }

    public boolean doesMarkerDirExist(String markerDir) {
        MarkerDirState markerDirState = this.getMarkerDirState(markerDir);
        return markerDirState.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<String> createMarker(Context context, String markerDir, String markerName) {
        LOG.info((Object)("Request: create marker " + markerDir + " " + markerName));
        MarkerCreationFuture future = new MarkerCreationFuture(context, markerDir, markerName);
        MarkerDirState markerDirState = this.getMarkerDirState(markerDir);
        markerDirState.addMarkerCreationFuture(future);
        if (!this.firstCreationRequestSeen) {
            Object object = this.firstCreationRequestSeenLock;
            synchronized (object) {
                if (!this.firstCreationRequestSeen) {
                    this.dispatchingThreadFuture = this.dispatchingExecutorService.scheduleAtFixedRate(this.markerCreationDispatchingRunnable, this.timelineServiceConfig.markerBatchIntervalMs, this.timelineServiceConfig.markerBatchIntervalMs, TimeUnit.MILLISECONDS);
                    this.firstCreationRequestSeen = true;
                }
            }
        }
        return future;
    }

    public Boolean deleteMarkers(String markerDir) {
        boolean result = this.getMarkerDirState(markerDir).deleteAllMarkers();
        this.markerDirStateMap.remove(markerDir);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MarkerDirState getMarkerDirState(String markerDir) {
        MarkerDirState markerDirState = this.markerDirStateMap.get(markerDir);
        if (markerDirState == null) {
            Map<String, MarkerDirState> map = this.markerDirStateMap;
            synchronized (map) {
                if (this.markerDirStateMap.get(markerDir) == null) {
                    markerDirState = new MarkerDirState(markerDir, this.timelineServiceConfig.markerBatchNumThreads, this.fileSystem, this.metricsRegistry, this.hoodieEngineContext, this.parallelism);
                    this.markerDirStateMap.put(markerDir, markerDirState);
                } else {
                    markerDirState = this.markerDirStateMap.get(markerDir);
                }
            }
        }
        return markerDirState;
    }
}

