/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.util.BaseFileUtils;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001i4AAC\u0006\u0001-!AQ\u0004\u0001B\u0001B\u0003%a\u0004\u0003\u0005#\u0001\t\u0005\t\u0015!\u0003$\u0011\u0015Q\u0003\u0001\"\u0001,\u0011\u0015\u0001\u0004\u0001\"\u00012\u0011\u0015\u0011\u0005\u0001\"\u0001D\u0011\u0015!\u0006\u0001\"\u0001V\u0011\u0015a\u0006\u0001\"\u0001^\u0011\u0015\u0019\u0007\u0001\"\u0001e\u0011\u0015q\u0007\u0001\"\u0001p\u0005-\u0019\u0006/\u0019:l\u0011\u0016d\u0007/\u001a:\u000b\u00051i\u0011\u0001\u00025vI&T!AD\b\u0002\u0007M\fHN\u0003\u0002\u0011#\u0005)1\u000f]1sW*\u0011!cE\u0001\u0007CB\f7\r[3\u000b\u0003Q\t1a\u001c:h\u0007\u0001\u0019\"\u0001A\f\u0011\u0005aYR\"A\r\u000b\u0003i\tQa]2bY\u0006L!\u0001H\r\u0003\r\u0005s\u0017PU3g\u0003)\u0019\u0018\u000f\\\"p]R,\u0007\u0010\u001e\t\u0003?\u0001j\u0011!D\u0005\u0003C5\u0011!bU)M\u0007>tG/\u001a=u\u0003\t17\u000f\u0005\u0002%Q5\tQE\u0003\u0002#M)\u0011q%E\u0001\u0007Q\u0006$wn\u001c9\n\u0005%*#A\u0003$jY\u0016\u001c\u0016p\u001d;f[\u00061A(\u001b8jiz\"2\u0001\f\u00180!\ti\u0003!D\u0001\f\u0011\u0015i2\u00011\u0001\u001f\u0011\u0015\u00113\u00011\u0001$\u0003E\u0001(/\u001b8u\u0017\u0016L8O\u0012:p[\u001aKG.\u001a\u000b\u0003eU\u0002\"\u0001G\u001a\n\u0005QJ\"\u0001B+oSRDQA\u000e\u0003A\u0002]\nAAZ5mKB\u0011\u0001h\u0010\b\u0003su\u0002\"AO\r\u000e\u0003mR!\u0001P\u000b\u0002\rq\u0012xn\u001c;?\u0013\tq\u0014$\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0001\u0006\u0013aa\u0015;sS:<'B\u0001 \u001a\u0003-9W\r\u001e*po.+\u0017\u0010\u0012$\u0015\u0005\u0011\u001b\u0006CA#Q\u001d\t1eJ\u0004\u0002H\u001b:\u0011\u0001\n\u0014\b\u0003\u0013.s!A\u000f&\n\u0003QI!AE\n\n\u0005A\t\u0012B\u0001\b\u0010\u0013\tyU\"A\u0004qC\u000e\\\u0017mZ3\n\u0005E\u0013&!\u0003#bi\u00064%/Y7f\u0015\tyU\u0002C\u00037\u000b\u0001\u0007q'A\tjg\u001aKG.Z\"p]R\f\u0017N\\:LKf$2AV-\\!\tAr+\u0003\u0002Y3\t9!i\\8mK\u0006t\u0007\"\u0002.\u0007\u0001\u00049\u0014A\u0002:po.+\u0017\u0010C\u00037\r\u0001\u0007q'A\u0006hKR\\U-_\"pk:$Hc\u00010bEB\u0011\u0001dX\u0005\u0003Af\u00111!\u00138u\u0011\u00151t\u00011\u00018\u0011\u0015ir\u00011\u0001\u001f\u0003E1\u0017\u000e\\3LKf\u001c\u0018iZ1j]N$(I\u0012\u000b\u0005-\u0016dW\u000eC\u0003g\u0011\u0001\u0007q-\u0001\u0003d_:4\u0007C\u00015k\u001b\u0005I'B\u00014'\u0013\tY\u0017NA\u0007D_:4\u0017nZ;sCRLwN\u001c\u0005\u0006;!\u0001\rA\b\u0005\u0006m!\u0001\raN\u0001\u0011O\u0016$H)[:uS:\u001cGoS3z\t\u001a#\"\u0001\u00129\t\u000bEL\u0001\u0019\u0001:\u0002\u000bA\fG\u000f[:\u0011\u0007M<xG\u0004\u0002um:\u0011!(^\u0005\u00025%\u0011q*G\u0005\u0003qf\u0014A\u0001T5ti*\u0011q*\u0007")
public class SparkHelper {
    private final SQLContext sqlContext;

    public void printKeysFromFile(String file) {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.getRowKeyDF(file).collect())).foreach((Function1 & java.io.Serializable & Serializable)x$1 -> {
            Predef$.MODULE$.println((Object)x$1);
            return BoxedUnit.UNIT;
        });
    }

    public Dataset<Row> getRowKeyDF(String file) {
        return this.sqlContext.read().parquet(file).select(new StringBuilder(20).append("`").append("_hoodie_record_key").append("`").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
    }

    public boolean isFileContainsKey(String rowKey, String file) {
        Predef$.MODULE$.println((Object)new StringBuilder(18).append("Checking ").append(file).append(" for key ").append(rowKey).toString());
        Dataset ff = this.getRowKeyDF(file).filter(new StringBuilder(25).append("`").append("_hoodie_record_key").append("` = '").append(rowKey).append("'").toString());
        return ff.count() > 0L;
    }

    /*
     * WARNING - void declaration
     */
    public int getKeyCount(String file, SQLContext sqlContext) {
        void var3_3;
        int keyCount = ((Row[])this.getRowKeyDF(file).collect()).length;
        Predef$.MODULE$.println((Object)BoxesRunTime.boxToInteger((int)keyCount));
        return (int)var3_3;
    }

    public boolean fileKeysAgainstBF(Configuration conf, SQLContext sqlContext, String file) {
        BloomFilter bf = BaseFileUtils.getInstance(HoodieFileFormat.PARQUET).readBloomFilterFromMetadata(conf, new Path(file));
        int foundCount = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sqlContext.parquetFile((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{file})).select(new StringBuilder(20).append("`").append("_hoodie_record_key").append("`").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).collect())).count((Function1 & java.io.Serializable & Serializable)r -> BoxesRunTime.boxToBoolean((boolean)SparkHelper.$anonfun$fileKeysAgainstBF$1(bf, r)));
        int totalCount = this.getKeyCount(file, sqlContext);
        Predef$.MODULE$.println((Object)new StringBuilder(26).append("totalCount: ").append(totalCount).append(", foundCount: ").append(foundCount).toString());
        return totalCount == foundCount;
    }

    public Dataset<Row> getDistinctKeyDF(List<String> paths) {
        return this.sqlContext.read().parquet(paths).select(new StringBuilder(20).append("`").append("_hoodie_record_key").append("`").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).distinct();
    }

    public static final /* synthetic */ boolean $anonfun$fileKeysAgainstBF$1(BloomFilter bf$1, Row r) {
        return !bf$1.mightContain(r.getString(0));
    }

    public SparkHelper(SQLContext sqlContext, FileSystem fs) {
        this.sqlContext = sqlContext;
    }
}

