/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.execution;

import java.io.Serializable;
import org.apache.spark.rdd.PartitionPruningRDD;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection$;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.hudi.execution.RangeSample$;
import org.apache.spark.util.random.SamplingUtils$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product2;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.collection.mutable.SetLike;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t\u0015a\u0001\u0002\u000b\u0016\u0001\tB\u0001\"\f\u0001\u0003\u0002\u0003\u0006IA\f\u0005\tc\u0001\u0011\t\u0011)A\u0005e!AQ\n\u0001BA\u0002\u0013%a\n\u0003\u0005S\u0001\t\u0005\r\u0011\"\u0003T\u0011!I\u0006A!A!B\u0013y\u0005\u0002\u0003.\u0001\u0005\u000b\u0007I\u0011A.\t\u0011q\u0003!\u0011!Q\u0001\n9B\u0001\"\u0018\u0001\u0003\u0004\u0003\u0006YA\u0018\u0005\u0006I\u0002!\t!\u001a\u0005\u0006e\u0002!\ta\u001d\u0005\b\u0003\u000b\u0001A\u0011AA\u0004\u0011\u001d\tI\u0005\u0001C\u0001\u0003\u0017Bq!a%\u0001\t\u0003\t)jB\u0005\u0002@V\t\t\u0011#\u0001\u0002B\u001aAA#FA\u0001\u0012\u0003\t\u0019\r\u0003\u0004e\u001f\u0011\u0005\u0011Q\u0019\u0005\n\u0003\u000f|\u0011\u0013!C\u0001\u0003\u0013D\u0011\"!:\u0010#\u0003%\t!a:\t\u0013\u0005Ex\"!A\u0005\n\u0005M(a\u0003*b]\u001e,7+Y7qY\u0016T!AF\f\u0002\u0013\u0015DXmY;uS>t'B\u0001\r\u001a\u0003\u0011AW\u000fZ5\u000b\u0005iY\u0012aA:rY*\u0011A$H\u0001\u0006gB\f'o\u001b\u0006\u0003=}\ta!\u00199bG\",'\"\u0001\u0011\u0002\u0007=\u0014xm\u0001\u0001\u0016\u0007\r\"5jE\u0002\u0001I)\u0002\"!\n\u0015\u000e\u0003\u0019R\u0011aJ\u0001\u0006g\u000e\fG.Y\u0005\u0003S\u0019\u0012a!\u00118z%\u00164\u0007CA\u0013,\u0013\tacE\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0006{\u000b:\u001cw\u000eZ3Ok6\u0004\"!J\u0018\n\u0005A2#aA%oi\u0006\u0019!\u000f\u001a31\u0005MR\u0004c\u0001\u001b7q5\tQG\u0003\u000227%\u0011q'\u000e\u0002\u0004%\u0012#\u0005CA\u001d;\u0019\u0001!\u0011b\u000f\u0002\u0002\u0002\u0003\u0005)\u0011\u0001\u001f\u0003\u0007}#\u0013'\u0005\u0002>\u0001B\u0011QEP\u0005\u0003\u007f\u0019\u0012qAT8uQ&tw\r\u0005\u0003&\u0003\u000eS\u0015B\u0001\"'\u0005!\u0001&o\u001c3vGR\u0014\u0004CA\u001dE\t\u0015)\u0005A1\u0001G\u0005\u0005Y\u0015CA\u001fH!\t)\u0003*\u0003\u0002JM\t\u0019\u0011I\\=\u0011\u0005eZE!\u0002'\u0001\u0005\u00041%!\u0001,\u0002\r\u0005\u001c8-\u001a8e+\u0005y\u0005CA\u0013Q\u0013\t\tfEA\u0004C_>dW-\u00198\u0002\u0015\u0005\u001c8-\u001a8e?\u0012*\u0017\u000f\u0006\u0002U/B\u0011Q%V\u0005\u0003-\u001a\u0012A!\u00168ji\"9\u0001\fBA\u0001\u0002\u0004y\u0015a\u0001=%c\u00059\u0011m]2f]\u0012\u0004\u0013\u0001H:b[BdW\rU8j]R\u001c\b+\u001a:QCJ$\u0018\u000e^5p]\"Kg\u000e^\u000b\u0002]\u0005i2/Y7qY\u0016\u0004v.\u001b8ugB+'\u000fU1si&$\u0018n\u001c8IS:$\b%\u0001\u0006fm&$WM\\2fIE\u00022a\u00182D\u001b\u0005\u0001'BA1'\u0003\u001d\u0011XM\u001a7fGRL!a\u00191\u0003\u0011\rc\u0017m]:UC\u001e\fa\u0001P5oSRtD#\u00024kWB\fHCA4j!\u0011A\u0007a\u0011&\u000e\u0003UAQ!X\u0005A\u0004yCQ!L\u0005A\u00029BQ!M\u0005A\u00021\u0004$!\\8\u0011\u0007Q2d\u000e\u0005\u0002:_\u0012I1h[A\u0001\u0002\u0003\u0015\t\u0001\u0010\u0005\b\u001b&\u0001\n\u00111\u0001P\u0011\u001dQ\u0016\u0002%AA\u00029\nabZ3u%\u0006tw-\u001a\"pk:$7\u000fF\u0001u!\r)(\u0010`\u0007\u0002m*\u0011q\u000f_\u0001\b[V$\u0018M\u00197f\u0015\tIh%\u0001\u0006d_2dWm\u0019;j_:L!a\u001f<\u0003\u0017\u0005\u0013(/Y=Ck\u001a4WM\u001d\t\u0005Ku\u001cu0\u0003\u0002\u007fM\t1A+\u001e9mKJ\u00022!JA\u0001\u0013\r\t\u0019A\n\u0002\u0006\r2|\u0017\r^\u0001\u000fI\u0016$XM]7j]\u0016\u0014u.\u001e8e+\u0011\tI!!\u0006\u0015\u0011\u0005-\u0011\u0011HA!\u0003\u000b\"b!!\u0004\u0002\u0018\u0005M\u0002#B\u0013\u0002\u0010\u0005M\u0011bAA\tM\t)\u0011I\u001d:bsB\u0019\u0011(!\u0006\u0005\u000b\u0015[!\u0019\u0001$\t\u0013\u0005e1\"!AA\u0004\u0005m\u0011AC3wS\u0012,gnY3%eA1\u0011QDA\u0017\u0003'qA!a\b\u0002*9!\u0011\u0011EA\u0014\u001b\t\t\u0019CC\u0002\u0002&\u0005\na\u0001\u0010:p_Rt\u0014\"A\u0014\n\u0007\u0005-b%A\u0004qC\u000e\\\u0017mZ3\n\t\u0005=\u0012\u0011\u0007\u0002\t\u001fJ$WM]5oO*\u0019\u00111\u0006\u0014\t\u0013\u0005U2\"!AA\u0004\u0005]\u0012AC3wS\u0012,gnY3%gA!qLYA\n\u0011\u001d\tYd\u0003a\u0001\u0003{\t!bY1oI&$\u0017\r^3t!\u0011)(0a\u0010\u0011\u000b\u0015j\u00181C@\t\r\u0005\r3\u00021\u0001/\u0003)\u0001\u0018M\u001d;ji&|gn\u001d\u0005\b\u0003\u000fZ\u0001\u0019AA\u000e\u0003!y'\u000fZ3sS:<\u0017A\u00053fi\u0016\u0014X.\u001b8f%><(i\\;oIN,B!!\u0014\u0002nQQ\u0011qJA;\u0003w\ni(a\"\u0015\r\u0005E\u0013QMA8!\u0015)\u0013qBA*!\u0015)\u0013qBA+!\u0011\t9&!\u0019\u000e\u0005\u0005e#\u0002BA.\u0003;\n1\"\u001a=qe\u0016\u001c8/[8og*\u0019\u0011qL\r\u0002\u0011\r\fG/\u00197zgRLA!a\u0019\u0002Z\tIQK\\:bM\u0016\u0014vn\u001e\u0005\n\u0003Ob\u0011\u0011!a\u0002\u0003S\n!\"\u001a<jI\u0016t7-\u001a\u00135!\u0019\ti\"!\f\u0002lA\u0019\u0011(!\u001c\u0005\u000b\u0015c!\u0019\u0001$\t\u0013\u0005ED\"!AA\u0004\u0005M\u0014AC3wS\u0012,gnY3%kA!qLYA6\u0011\u001d\tY\u0004\u0004a\u0001\u0003o\u0002B!\u001e>\u0002zA)Q%`A6\u007f\"1\u00111\t\u0007A\u00029Bq!a \r\u0001\u0004\t\t)A\u0005pe\u0012,'/\u001b8hgB1\u0011QDAB\u0003SJA!!\"\u00022\t\u00191+Z9\t\u000f\u0005%E\u00021\u0001\u0002\f\u0006Q\u0011\r\u001e;sS\n,H/Z:\u0011\r\u0005u\u00111QAG!\u0011\t9&a$\n\t\u0005E\u0015\u0011\f\u0002\n\u0003R$(/\u001b2vi\u0016\faa]6fi\u000eDW\u0003BAL\u0003_#b!!'\u00028\u0006mF\u0003BAN\u0003c\u0003b!J?\u0002\u001e\u0006\r\u0006cA\u0013\u0002 &\u0019\u0011\u0011\u0015\u0014\u0003\t1{gn\u001a\t\u0006K\u0005=\u0011Q\u0015\t\tK\u0005\u001df&!(\u0002,&\u0019\u0011\u0011\u0016\u0014\u0003\rQ+\b\u000f\\34!\u0015)\u0013qBAW!\rI\u0014q\u0016\u0003\u0006\u000b6\u0011\rA\u0012\u0005\n\u0003gk\u0011\u0011!a\u0002\u0003k\u000b!\"\u001a<jI\u0016t7-\u001a\u00137!\u0011y&-!,\t\rEj\u0001\u0019AA]!\u0011!d'!,\t\r\u0005uV\u00021\u0001/\u0003Y\u0019\u0018-\u001c9mKNK'0\u001a)feB\u000b'\u000f^5uS>t\u0017a\u0003*b]\u001e,7+Y7qY\u0016\u0004\"\u0001[\b\u0014\u0007=!#\u0006\u0006\u0002\u0002B\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM*b!a3\u0002b\u0006\rXCAAgU\ry\u0015qZ\u0016\u0003\u0003#\u0004B!a5\u0002^6\u0011\u0011Q\u001b\u0006\u0005\u0003/\fI.A\u0005v]\u000eDWmY6fI*\u0019\u00111\u001c\u0014\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002`\u0006U'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0012)Q)\u0005b\u0001\r\u0012)A*\u0005b\u0001\r\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIQ*b!!;\u0002n\u0006=XCAAvU\rq\u0013q\u001a\u0003\u0006\u000bJ\u0011\rA\u0012\u0003\u0006\u0019J\u0011\rAR\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002vB!\u0011q\u001fB\u0001\u001b\t\tIP\u0003\u0003\u0002|\u0006u\u0018\u0001\u00027b]\u001eT!!a@\u0002\t)\fg/Y\u0005\u0005\u0005\u0007\tIP\u0001\u0004PE*,7\r\u001e")
public class RangeSample<K, V>
implements scala.Serializable {
    private final int zEncodeNum;
    private final RDD<? extends Product2<K, V>> rdd;
    private boolean ascend;
    private final int samplePointsPerPartitionHint;
    private final ClassTag<K> evidence$1;

    public static <K, V> int $lessinit$greater$default$4() {
        return RangeSample$.MODULE$.$lessinit$greater$default$4();
    }

    public static <K, V> boolean $lessinit$greater$default$3() {
        return RangeSample$.MODULE$.$lessinit$greater$default$3();
    }

    private boolean ascend() {
        return this.ascend;
    }

    private void ascend_$eq(boolean x$1) {
        this.ascend = x$1;
    }

    public int samplePointsPerPartitionHint() {
        return this.samplePointsPerPartitionHint;
    }

    public ArrayBuffer<Tuple2<K, Object>> getRangeBounds() {
        ArrayBuffer arrayBuffer;
        if (this.zEncodeNum <= 1) {
            arrayBuffer = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        } else {
            double sampleSize = scala.math.package$.MODULE$.min((double)this.samplePointsPerPartitionHint() * (double)this.zEncodeNum, 1000000.0);
            int sampleSizePerPartition = (int)scala.math.package$.MODULE$.ceil(3.0 * sampleSize / (double)this.rdd.partitions().length);
            Tuple2<Object, Tuple3<Object, Object, Object>[]> tuple2 = this.sketch(this.rdd.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1._1(), this.evidence$1), sampleSizePerPartition, this.evidence$1);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            long numItems = tuple2._1$mcJ$sp();
            Tuple3[] sketched = (Tuple3[])tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)numItems), (Object)sketched);
            Tuple2 tuple23 = tuple22;
            long numItems2 = tuple23._1$mcJ$sp();
            Tuple3[] sketched2 = (Tuple3[])tuple23._2();
            if (numItems2 == 0L) {
                arrayBuffer = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
            } else {
                BoxedUnit boxedUnit;
                double fraction = scala.math.package$.MODULE$.min(sampleSize / (double)scala.math.package$.MODULE$.max(numItems2, 1L), 1.0);
                ArrayBuffer candidates = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
                Set imbalancedPartitions = Set$.MODULE$.empty();
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sketched2)).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    SetLike setLike;
                    Tuple3 tuple3 = x0$1;
                    if (tuple3 != null) {
                        int idx = BoxesRunTime.unboxToInt((Object)tuple3._1());
                        long n = BoxesRunTime.unboxToLong((Object)tuple3._2());
                        Object sample = tuple3._3();
                        if (fraction * (double)n > (double)sampleSizePerPartition) {
                            setLike = imbalancedPartitions.$plus$eq((Object)BoxesRunTime.boxToInteger((int)idx));
                        } else {
                            float weight = (float)((double)n / (double)ScalaRunTime$.MODULE$.array_length(sample));
                            Predef$.MODULE$.genericArrayOps(sample).foreach((Function1 & Serializable & scala.Serializable)key -> candidates.$plus$eq((Object)new Tuple2(key, (Object)BoxesRunTime.boxToFloat((float)weight))));
                            setLike = BoxedUnit.UNIT;
                        }
                    } else {
                        throw new MatchError((Object)tuple3);
                    }
                    SetLike setLike2 = setLike;
                    return setLike2;
                });
                if (imbalancedPartitions.nonEmpty()) {
                    PartitionPruningRDD imbalanced = new PartitionPruningRDD(this.rdd.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3._1(), this.evidence$1), (Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)elem -> imbalancedPartitions.contains((Object)BoxesRunTime.boxToInteger((int)elem)), this.evidence$1);
                    int seed = scala.util.hashing.package$.MODULE$.byteswap32(-this.rdd.id() - 1);
                    Object reSampled = imbalanced.sample(false, fraction, (long)seed).collect();
                    float weight = (float)(1.0 / fraction);
                    boxedUnit = candidates.$plus$plus$eq((TraversableOnce)Predef$.MODULE$.genericArrayOps(reSampled).map((Function1 & Serializable & scala.Serializable)x -> new Tuple2(x, (Object)BoxesRunTime.boxToFloat((float)weight)), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit())));
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                arrayBuffer = candidates;
            }
        }
        return arrayBuffer;
    }

    public <K> Object determineBound(ArrayBuffer<Tuple2<K, Object>> candidates, int partitions, Ordering<K> ordering, Ordering<K> evidence$2, ClassTag<K> evidence$3) {
        ArrayBuffer ordered = (ArrayBuffer)candidates.sortBy((Function1 & Serializable & scala.Serializable)x$4 -> x$4._1(), ordering);
        int numCandidates = ordered.size();
        double sumWeights = BoxesRunTime.unboxToDouble((Object)((TraversableOnce)ordered.map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToDouble((double)RangeSample.$anonfun$determineBound$2(x$5)), ArrayBuffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        double step = sumWeights / (double)partitions;
        double cumWeight = 0.0;
        double target = step;
        ArrayBuffer bounds = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        int j = 0;
        Option previousBound = Option$.MODULE$.empty();
        for (int i = 0; i < numCandidates && j < partitions - 1; ++i) {
            Tuple2 tuple2 = (Tuple2)ordered.apply(i);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Object key = tuple2._1();
            float weight = BoxesRunTime.unboxToFloat((Object)tuple2._2());
            Tuple2 tuple22 = new Tuple2(key, (Object)BoxesRunTime.boxToFloat((float)weight));
            Tuple2 tuple23 = tuple22;
            Object key2 = tuple23._1();
            float weight2 = BoxesRunTime.unboxToFloat((Object)tuple23._2());
            cumWeight += (double)weight2;
            if (!(cumWeight >= target) || !previousBound.isEmpty() && !ordering.gt(key2, previousBound.get())) continue;
            bounds.$plus$eq(key2);
            target += step;
            ++j;
            previousBound = new Some(key2);
        }
        return bounds.toArray(evidence$3);
    }

    public <K> UnsafeRow[][] determineRowBounds(ArrayBuffer<Tuple2<K, Object>> candidates, int partitions, Seq<Ordering<K>> orderings, Seq<Attribute> attributes, Ordering<K> evidence$4, ClassTag<K> evidence$5) {
        return (UnsafeRow[][])((TraversableOnce)((TraversableLike)orderings.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ArrayBuffer bounds;
            int index;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Ordering ordering = (Ordering)tuple2._1();
                index = tuple2._2$mcI$sp();
                ArrayBuffer ordered = (ArrayBuffer)candidates.sortBy((Function1 & Serializable & scala.Serializable)x$7 -> x$7._1(), ordering);
                int numCandidates = ordered.size();
                double sumWeights = BoxesRunTime.unboxToDouble((Object)((TraversableOnce)ordered.map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToDouble((double)RangeSample.$anonfun$determineRowBounds$3(x$8)), ArrayBuffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
                double step = sumWeights / (double)partitions;
                double cumWeight = 0.0;
                double target = step;
                bounds = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
                int j = 0;
                Option previousBound = Option$.MODULE$.empty();
                for (int i = 0; i < numCandidates && j < partitions - 1; ++i) {
                    Tuple2 tuple22 = (Tuple2)ordered.apply(i);
                    if (tuple22 == null) {
                        throw new MatchError((Object)tuple22);
                    }
                    Object key = tuple22._1();
                    float weight = BoxesRunTime.unboxToFloat((Object)tuple22._2());
                    Tuple2 tuple23 = new Tuple2(key, (Object)BoxesRunTime.boxToFloat((float)weight));
                    Tuple2 tuple24 = tuple23;
                    Object key2 = tuple24._1();
                    float weight2 = BoxesRunTime.unboxToFloat((Object)tuple24._2());
                    cumWeight += (double)weight2;
                    if (!(cumWeight >= target) || !previousBound.isEmpty() && !ordering.gt(key2, previousBound.get())) continue;
                    bounds.$plus$eq(key2);
                    target += step;
                    ++j;
                    previousBound = new Some(key2);
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            UnsafeProjection project = UnsafeProjection$.MODULE$.create((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Attribute[]{(Attribute)attributes.apply(index)})), attributes);
            UnsafeRow[] unsafeRowArray = (UnsafeRow[])((TraversableOnce)bounds.map((Function1 & Serializable & scala.Serializable)bound -> {
                UnsafeRow row = (UnsafeRow)bound;
                return project.apply((InternalRow)row).copy();
            }, ArrayBuffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(UnsafeRow.class));
            return unsafeRowArray;
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(UnsafeRow.class)));
    }

    public <K> Tuple2<Object, Tuple3<Object, Object, Object>[]> sketch(RDD<K> rdd, int sampleSizePerPartition, ClassTag<K> evidence$6) {
        int shift = rdd.id();
        Tuple3[] sketched = (Tuple3[])rdd.mapPartitionsWithIndex((Function2 & Serializable & scala.Serializable)(idx, iter) -> RangeSample.$anonfun$sketch$1(shift, sampleSizePerPartition, evidence$6, BoxesRunTime.unboxToInt((Object)idx), iter), rdd.mapPartitionsWithIndex$default$2(), ClassTag$.MODULE$.apply(Tuple3.class)).collect();
        long numItems = BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sketched)).map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToLong((long)RangeSample.$anonfun$sketch$2(x$11)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)numItems), (Object)sketched);
    }

    public static final /* synthetic */ double $anonfun$determineBound$2(Tuple2 x$5) {
        return BoxesRunTime.unboxToFloat((Object)x$5._2());
    }

    public static final /* synthetic */ double $anonfun$determineRowBounds$3(Tuple2 x$8) {
        return BoxesRunTime.unboxToFloat((Object)x$8._2());
    }

    public static final /* synthetic */ Iterator $anonfun$sketch$1(int shift$1, int sampleSizePerPartition$2, ClassTag evidence$6$1, int idx, Iterator iter) {
        int seed = scala.util.hashing.package$.MODULE$.byteswap32(idx ^ shift$1 << 16);
        Tuple2 tuple2 = SamplingUtils$.MODULE$.reservoirSampleAndCount(iter, sampleSizePerPartition$2, (long)seed, evidence$6$1);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Object sample = tuple2._1();
        long n = tuple2._2$mcJ$sp();
        Tuple2 tuple22 = new Tuple2(sample, (Object)BoxesRunTime.boxToLong((long)n));
        Tuple2 tuple23 = tuple22;
        Object sample2 = tuple23._1();
        long n2 = tuple23._2$mcJ$sp();
        return package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)idx), (Object)BoxesRunTime.boxToLong((long)n2), sample2)}));
    }

    public static final /* synthetic */ long $anonfun$sketch$2(Tuple3 x$11) {
        return BoxesRunTime.unboxToLong((Object)x$11._2());
    }

    public RangeSample(int zEncodeNum, RDD<? extends Product2<K, V>> rdd, boolean ascend, int samplePointsPerPartitionHint, ClassTag<K> evidence$1) {
        this.zEncodeNum = zEncodeNum;
        this.rdd = rdd;
        this.ascend = ascend;
        this.samplePointsPerPartitionHint = samplePointsPerPartitionHint;
        this.evidence$1 = evidence$1;
        Predef$.MODULE$.require(zEncodeNum >= 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Number of zEncodeNum cannot be negative but found ").append($this.zEncodeNum).append(".").toString());
        Predef$.MODULE$.require(samplePointsPerPartitionHint > 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Sample points per partition must be greater than 0 but found ").append(this.samplePointsPerPartitionHint()).toString());
    }
}

