/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.io.Serializable;
import org.apache.hudi.DataSourceUtils;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.HoodieWriterUtils$;
import org.apache.hudi.avro.model.HoodieClusteringGroup;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.spark.SparkException;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier$;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable$;
import org.apache.spark.sql.hudi.HoodieSqlCommonUtils$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.WrappedArray;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;

public final class HoodieCLIUtils$ {
    public static HoodieCLIUtils$ MODULE$;

    static {
        new HoodieCLIUtils$();
    }

    public SparkRDDWriteClient<?> createHoodieWriteClient(SparkSession sparkSession, String basePath, Map<String, String> conf, Option<String> tableName) {
        Map<String, String> map;
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setBasePath(basePath).setConf(sparkSession.sessionState().newHadoopConf()).build();
        TableSchemaResolver schemaUtil = new TableSchemaResolver(metaClient);
        String schemaStr = schemaUtil.getTableAvroSchemaWithoutMetadataFields().toString();
        Option<String> option = tableName;
        if (option instanceof Some) {
            Some some = (Some)option;
            String value = (String)some.value();
            map = this.getHoodieCatalogTable(sparkSession, value).catalogProperties();
        } else if (None$.MODULE$.equals(option)) {
            map = Predef$.MODULE$.Map().empty();
        } else {
            throw new MatchError(option);
        }
        Map<String, String> catalogProps = map;
        Map<String, String> finalParameters = HoodieWriterUtils$.MODULE$.parametersWithWriteDefaults(HoodieSqlCommonUtils$.MODULE$.withSparkConf(sparkSession, (Map<String, String>)Predef$.MODULE$.Map().empty(), (Map<String, String>)((Map)catalogProps.$plus$plus(conf, Map$.MODULE$.canBuildFrom())).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)metaClient.getTableType().name()))));
        JavaSparkContext jsc = new JavaSparkContext(sparkSession.sparkContext());
        return DataSourceUtils.createHoodieClient(jsc, schemaStr, basePath, metaClient.getTableConfig().getTableName(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(finalParameters).asJava());
    }

    public String extractPartitions(Seq<HoodieClusteringGroup> clusteringGroups) {
        ObjectRef partitionPaths = ObjectRef.create((Object)((Seq)Seq$.MODULE$.empty()));
        clusteringGroups.foreach((Function1 & Serializable & scala.Serializable)g -> {
            HoodieCLIUtils$.$anonfun$extractPartitions$1(partitionPaths, g);
            return BoxedUnit.UNIT;
        });
        return ((TraversableOnce)((Seq)partitionPaths.elem).sorted((Ordering)Ordering.String$.MODULE$)).mkString(",");
    }

    public HoodieCatalogTable getHoodieCatalogTable(SparkSession sparkSession, String table) {
        HoodieCatalogTable hoodieCatalogTable;
        WrappedArray seq = Predef$.MODULE$.wrapRefArray((Object[])new StringOps(Predef$.MODULE$.augmentString(table)).split('.'));
        WrappedArray wrappedArray = seq;
        Some some = Seq$.MODULE$.unapplySeq((Seq)wrappedArray);
        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0) {
            String tableName = (String)((SeqLike)some.get()).apply(0);
            hoodieCatalogTable = HoodieCatalogTable$.MODULE$.apply(sparkSession, TableIdentifier$.MODULE$.apply(tableName));
        } else {
            Some some2 = Seq$.MODULE$.unapplySeq((Seq)wrappedArray);
            if (!some2.isEmpty() && some2.get() != null && ((SeqLike)some2.get()).lengthCompare(2) == 0) {
                String database = (String)((SeqLike)some2.get()).apply(0);
                String tableName = (String)((SeqLike)some2.get()).apply(1);
                hoodieCatalogTable = HoodieCatalogTable$.MODULE$.apply(sparkSession, new TableIdentifier(tableName, (Option)new Some((Object)database)));
            } else {
                throw new SparkException(new StringBuilder(23).append("Unsupported identifier ").append(table).toString());
            }
        }
        return hoodieCatalogTable;
    }

    public static final /* synthetic */ void $anonfun$extractPartitions$1(ObjectRef partitionPaths$1, HoodieClusteringGroup g) {
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(g.getSlices()).asScala()).foreach((Function1 & Serializable & scala.Serializable)slice -> {
            partitionPaths$1.elem = (Seq)((Seq)partitionPaths$1.elem).$colon$plus((Object)slice.getPartitionPath(), Seq$.MODULE$.canBuildFrom());
            return BoxedUnit.UNIT;
        });
    }

    private HoodieCLIUtils$() {
        MODULE$ = this;
    }
}

