/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordMerger;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.Pair;

public class HoodieSparkRecordMerger
implements HoodieRecordMerger {
    @Override
    public String getMergingStrategy() {
        return "eeb8d96f-b1e4-49fd-bbf8-28ac514178e5";
    }

    @Override
    public Option<Pair<HoodieRecord, Schema>> merge(HoodieRecord older, Schema oldSchema, HoodieRecord newer, Schema newSchema, TypedProperties props) throws IOException {
        ValidationUtils.checkArgument(older.getRecordType() == HoodieRecord.HoodieRecordType.SPARK);
        ValidationUtils.checkArgument(newer.getRecordType() == HoodieRecord.HoodieRecordType.SPARK);
        if (newer.getData() == null) {
            return Option.empty();
        }
        if (older.getData() == null) {
            return Option.of(Pair.of(newer, newSchema));
        }
        if (older.getOrderingValue(oldSchema, props).compareTo(newer.getOrderingValue(newSchema, props)) > 0) {
            return Option.of(Pair.of(older, oldSchema));
        }
        return Option.of(Pair.of(newer, newSchema));
    }

    @Override
    public HoodieRecord.HoodieRecordType getRecordType() {
        return HoodieRecord.HoodieRecordType.SPARK;
    }
}

