/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.AvroConversionUtils$;
import org.apache.hudi.DataSourceOptionsHelper$;
import org.apache.hudi.DataSourceReadOptions$;
import org.apache.hudi.DataSourceUtils;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.HoodieConversionUtils$;
import org.apache.hudi.HoodieDatasetBulkInsertHelper$;
import org.apache.hudi.HoodieSparkSqlWriter;
import org.apache.hudi.HoodieSparkUtils$;
import org.apache.hudi.HoodieWriterUtils$;
import org.apache.hudi.SparkConfigs$;
import org.apache.hudi.avro.AvroSchemaUtils;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.client.BaseHoodieWriteClient;
import org.apache.hudi.client.HoodieWriteResult;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.HoodieCommonConfig;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieSparkRecord;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.HoodieTimelineTimeZone;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.util.CommitUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.config.HoodieBootstrapConfig;
import org.apache.hudi.config.HoodieInternalConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.SchemaCompatibilityException;
import org.apache.hudi.execution.bulkinsert.BulkInsertInternalPartitionerWithRowsFactory;
import org.apache.hudi.execution.bulkinsert.NonSortPartitionerWithRows;
import org.apache.hudi.hive.HiveSyncConfigHolder;
import org.apache.hudi.hive.HiveSyncTool;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.internal.schema.convert.AvroInternalSchemaConverter;
import org.apache.hudi.internal.schema.utils.AvroSchemaEvolutionUtils;
import org.apache.hudi.internal.schema.utils.SerDeHelper;
import org.apache.hudi.keygen.KeyGenerator;
import org.apache.hudi.keygen.SparkKeyGeneratorInterface;
import org.apache.hudi.keygen.TimestampBasedAvroKeyGenerator;
import org.apache.hudi.keygen.TimestampBasedKeyGenerator;
import org.apache.hudi.keygen.factory.HoodieSparkKeyGeneratorFactory;
import org.apache.hudi.metrics.Metrics;
import org.apache.hudi.sync.common.HoodieSyncConfig;
import org.apache.hudi.sync.common.util.SyncUtilHelpers;
import org.apache.hudi.table.BulkInsertPartitioner;
import org.apache.hudi.util.SparkKeyGenUtils$;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.package$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.HoodieInternalRowUtils$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.internal.StaticSQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple6;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.Traversable;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class HoodieSparkSqlWriter$ {
    public static HoodieSparkSqlWriter$ MODULE$;
    private final ConfigProperty<Object> CANONICALIZE_NULLABLE;
    private final ConfigProperty<Object> SQL_MERGE_INTO_WRITES;
    private final String SPARK_STREAMING_BATCH_ID;
    private final Logger log;
    private boolean tableExists;
    private boolean asyncCompactionTriggerFnDefined;
    private boolean asyncClusteringTriggerFnDefined;

    static {
        new HoodieSparkSqlWriter$();
    }

    public ConfigProperty<Object> CANONICALIZE_NULLABLE() {
        return this.CANONICALIZE_NULLABLE;
    }

    public ConfigProperty<Object> SQL_MERGE_INTO_WRITES() {
        return this.SQL_MERGE_INTO_WRITES;
    }

    public String SPARK_STREAMING_BATCH_ID() {
        return this.SPARK_STREAMING_BATCH_ID;
    }

    private Logger log() {
        return this.log;
    }

    private boolean tableExists() {
        return this.tableExists;
    }

    private void tableExists_$eq(boolean x$1) {
        this.tableExists = x$1;
    }

    private boolean asyncCompactionTriggerFnDefined() {
        return this.asyncCompactionTriggerFnDefined;
    }

    private void asyncCompactionTriggerFnDefined_$eq(boolean x$1) {
        this.asyncCompactionTriggerFnDefined = x$1;
    }

    private boolean asyncClusteringTriggerFnDefined() {
        return this.asyncClusteringTriggerFnDefined;
    }

    private void asyncClusteringTriggerFnDefined_$eq(boolean x$1) {
        this.asyncClusteringTriggerFnDefined = x$1;
    }

    public Tuple6<Object, Option<String>, Option<String>, Option<String>, SparkRDDWriteClient<?>, HoodieTableConfig> write(SQLContext sqlContext, SaveMode mode, scala.collection.immutable.Map<String, String> optParams, Dataset<Row> df, scala.Option<HoodieTableConfig> hoodieTableConfigOpt, scala.Option<SparkRDDWriteClient<?>> hoodieWriteClient, scala.Option<Function1<SparkRDDWriteClient<?>, BoxedUnit>> asyncCompactionTriggerFn, scala.Option<Function1<SparkRDDWriteClient<?>, BoxedUnit>> asyncClusteringTriggerFn, scala.Option<BiConsumer<HoodieTableMetaClient, HoodieCommitMetadata>> extraPreCommitFn) {
        Tuple6 tuple6;
        block28: {
            SparkRDDWriteClient writeClient;
            HoodieWriteResult writeResult;
            String commitActionType;
            String instantTime;
            JavaSparkContext jsc;
            WriteOperationType operation;
            scala.collection.immutable.Map parameters;
            HoodieTableConfig tableConfig;
            Path basePath;
            block37: {
                Tuple2 tuple2;
                block36: {
                    Tuple2 tuple22;
                    block31: {
                        Schema schema;
                        Boolean shouldDropPartitionColumns;
                        Schema writerSchema;
                        scala.Option internalSchemaOpt;
                        String avroRecordNamespace;
                        String avroRecordName;
                        String partitionColumns;
                        HoodieTableType tableType;
                        String tblName;
                        HoodieConfig hoodieConfig;
                        SparkContext sparkContext;
                        String path;
                        block33: {
                            Option commitTime;
                            boolean success;
                            block35: {
                                Tuple2<Object, Option<String>> tuple23;
                                block34: {
                                    Schema sourceSchema;
                                    scala.Option<Schema> latestTableSchemaOpt;
                                    block32: {
                                        java.util.List<Object> list;
                                        WriteOperationType writeOperationType;
                                        KeyGenerator keyGenerator;
                                        block30: {
                                            HoodieTableMetaClient hoodieTableMetaClient;
                                            TableIdentifier tableIdentifier;
                                            String databaseName;
                                            scala.collection.immutable.Map<String, String> timestampKeyGeneratorConfigs;
                                            FileSystem fs;
                                            SparkSession spark;
                                            block29: {
                                                Some some;
                                                String ser;
                                                Predef$.MODULE$.assert(optParams.get((Object)"path").exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)HoodieSparkSqlWriter$.$anonfun$write$1(x$1))), (Function0 & Serializable & scala.Serializable)() -> "'path' must be set");
                                                path = (String)optParams.apply((Object)"path");
                                                basePath = new Path(path);
                                                spark = sqlContext.sparkSession();
                                                sparkContext = sqlContext.sparkContext();
                                                fs = basePath.getFileSystem(sparkContext.hadoopConfiguration());
                                                this.tableExists_$eq(fs.exists(new Path(basePath, ".hoodie")));
                                                tableConfig = this.getHoodieTableConfig(sparkContext, path, mode, hoodieTableConfigOpt);
                                                scala.collection.immutable.Map<String, String> paramsWithoutDefaults = HoodieWriterUtils$.MODULE$.getParamsWithAlternatives(optParams);
                                                String originKeyGeneratorClassName = HoodieWriterUtils$.MODULE$.getOriginKeyGenerator(paramsWithoutDefaults);
                                                timestampKeyGeneratorConfigs = this.extractConfigsRelatedToTimestampBasedKeyGenerator(originKeyGeneratorClassName, paramsWithoutDefaults);
                                                HoodieWriterUtils$.MODULE$.validateKeyGeneratorConfig(originKeyGeneratorClassName, tableConfig);
                                                SaveMode saveMode = mode;
                                                SaveMode saveMode2 = SaveMode.Overwrite;
                                                HoodieWriterUtils$.MODULE$.validateTableConfig(sqlContext.sparkSession(), optParams, tableConfig, !(saveMode != null ? !saveMode.equals(saveMode2) : saveMode2 != null));
                                                Tuple2<scala.collection.immutable.Map<String, String>, HoodieConfig> tuple24 = this.mergeParamsAndGetHoodieConfig(optParams, tableConfig, mode);
                                                if (tuple24 == null) {
                                                    throw new MatchError(tuple24);
                                                }
                                                scala.collection.immutable.Map parameters2 = (scala.collection.immutable.Map)tuple24._1();
                                                HoodieConfig hoodieConfig2 = (HoodieConfig)tuple24._2();
                                                Tuple2 tuple25 = new Tuple2((Object)parameters2, (Object)hoodieConfig2);
                                                Tuple2 tuple26 = tuple25;
                                                parameters = (scala.collection.immutable.Map)tuple26._1();
                                                hoodieConfig = (HoodieConfig)tuple26._2();
                                                databaseName = hoodieConfig.getStringOrDefault(HoodieTableConfig.DATABASE_NAME, "");
                                                tblName = hoodieConfig.getStringOrThrow(HoodieWriteConfig.TBL_NAME, new StringBuilder(15).append("'").append(HoodieWriteConfig.TBL_NAME.key()).append("' must be set.").toString()).trim();
                                                tableIdentifier = new TableIdentifier(tblName, (scala.Option)(databaseName.isEmpty() ? None$.MODULE$ : new Some((Object)databaseName)));
                                                Predef$.MODULE$.assert(!StringUtils.isNullOrEmpty(hoodieConfig.getString(HoodieWriteConfig.TBL_NAME)), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(15).append("'").append(HoodieWriteConfig.TBL_NAME.key()).append("' must be set.").toString());
                                                this.asyncCompactionTriggerFnDefined_$eq(asyncCompactionTriggerFn.isDefined());
                                                this.asyncClusteringTriggerFnDefined_$eq(asyncClusteringTriggerFn.isDefined());
                                                scala.Option option = sparkContext.getConf().getOption("spark.serializer");
                                                if (!(option instanceof Some) || !(ser = (String)(some = (Some)option).value()).equals("org.apache.spark.serializer.KryoSerializer")) {
                                                    throw new HoodieException("hoodie only support org.apache.spark.serializer.KryoSerializer as spark.serializer");
                                                }
                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                tableType = HoodieTableType.valueOf(hoodieConfig.getString(DataSourceWriteOptions$.MODULE$.TABLE_TYPE()));
                                                operation = WriteOperationType.fromValue(hoodieConfig.getString(DataSourceWriteOptions$.MODULE$.OPERATION()));
                                                if (Predef$.MODULE$.Boolean2boolean(hoodieConfig.getBoolean(DataSourceWriteOptions$.MODULE$.INSERT_DROP_DUPS()))) {
                                                    WriteOperationType writeOperationType2 = operation;
                                                    WriteOperationType writeOperationType3 = WriteOperationType.UPSERT;
                                                    if (!(writeOperationType2 != null ? !((Object)((Object)writeOperationType2)).equals((Object)writeOperationType3) : writeOperationType3 != null)) {
                                                        this.log().warn((Object)new StringBuilder(66).append(DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL()).append(" is not applicable ").append("when ").append(DataSourceWriteOptions$.MODULE$.INSERT_DROP_DUPS()).append(" is set to be true, ").append("overriding the ").append(DataSourceWriteOptions$.MODULE$.OPERATION()).append(" to be ").append(DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).toString());
                                                        operation = WriteOperationType.INSERT;
                                                    }
                                                }
                                                jsc = new JavaSparkContext(sparkContext);
                                                if (asyncCompactionTriggerFn.isDefined() && jsc.getConf().getOption(SparkConfigs$.MODULE$.SPARK_SCHEDULER_ALLOCATION_FILE_KEY()).isDefined()) {
                                                    jsc.setLocalProperty("spark.scheduler.pool", SparkConfigs$.MODULE$.SPARK_DATASOURCE_WRITER_POOL_NAME());
                                                }
                                                instantTime = HoodieActiveTimeline.createNewInstantTime();
                                                keyGenerator = HoodieSparkKeyGeneratorFactory.createKeyGenerator(new TypedProperties(hoodieConfig.getProps()));
                                                SaveMode saveMode3 = mode;
                                                SaveMode saveMode4 = SaveMode.Ignore;
                                                if ((saveMode3 != null ? !saveMode3.equals(saveMode4) : saveMode4 != null) || !this.tableExists()) break block29;
                                                this.log().warn((Object)new StringBuilder(73).append("hoodie table at ").append(basePath).append(" already exists. Ignoring & not performing actual writes.").toString());
                                                tuple6 = new Tuple6((Object)BoxesRunTime.boxToBoolean((boolean)false), Option.empty(), Option.empty(), Option.empty(), hoodieWriteClient.orNull(Predef$.MODULE$.$conforms()), (Object)tableConfig);
                                                break block28;
                                            }
                                            this.handleSaveModes(sqlContext.sparkSession(), mode, basePath, tableConfig, tblName, operation, fs);
                                            partitionColumns = SparkKeyGenUtils$.MODULE$.getPartitionColumns(keyGenerator, HoodieConversionUtils$.MODULE$.toProperties((scala.collection.immutable.Map<String, String>)parameters));
                                            if (this.tableExists()) {
                                                hoodieTableMetaClient = HoodieTableMetaClient.builder().setConf(sparkContext.hadoopConfiguration()).setBasePath(path).build();
                                            } else {
                                                String baseFileFormat = hoodieConfig.getStringOrDefault(HoodieTableConfig.BASE_FILE_FORMAT);
                                                String archiveLogFolder = hoodieConfig.getStringOrDefault(HoodieTableConfig.ARCHIVELOG_FOLDER);
                                                boolean populateMetaFields = hoodieConfig.getBooleanOrDefault(HoodieTableConfig.POPULATE_META_FIELDS);
                                                boolean useBaseFormatMetaFile = hoodieConfig.getBooleanOrDefault(HoodieTableConfig.PARTITION_METAFILE_USE_BASE_FORMAT);
                                                hoodieTableMetaClient = HoodieTableMetaClient.withPropertyBuilder().setTableType(tableType).setDatabaseName(databaseName).setTableName(tblName).setBaseFileFormat(baseFileFormat).setArchiveLogFolder(archiveLogFolder).setPayloadClassName(hoodieConfig.getString(DataSourceWriteOptions$.MODULE$.PAYLOAD_CLASS_NAME())).setPreCombineField((String)optParams.getOrElse((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key(), (Function0 & Serializable & scala.Serializable)() -> null)).setPartitionFields(partitionColumns).setPopulateMetaFields(populateMetaFields).setRecordKeyFields(hoodieConfig.getString(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD())).setCDCEnabled(hoodieConfig.getBooleanOrDefault(HoodieTableConfig.CDC_ENABLED)).setCDCSupplementalLoggingMode(hoodieConfig.getStringOrDefault(HoodieTableConfig.CDC_SUPPLEMENTAL_LOGGING_MODE)).setKeyGeneratorClassProp(hoodieConfig.getString(DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CLASS_NAME().key())).set(JavaConversions$.MODULE$.deprecated$u0020mapAsJavaMap(timestampKeyGeneratorConfigs)).setHiveStylePartitioningEnable(hoodieConfig.getBoolean(DataSourceWriteOptions$.MODULE$.HIVE_STYLE_PARTITIONING())).setUrlEncodePartitioning(hoodieConfig.getBoolean(DataSourceWriteOptions$.MODULE$.URL_ENCODE_PARTITIONING())).setPartitionMetafileUseBaseFormat(Predef$.MODULE$.boolean2Boolean(useBaseFormatMetaFile)).setShouldDropPartitionColumns(Predef$.MODULE$.boolean2Boolean(hoodieConfig.getBooleanOrDefault(HoodieTableConfig.DROP_PARTITION_COLUMNS))).setCommitTimezone(HoodieTimelineTimeZone.valueOf(hoodieConfig.getStringOrDefault(HoodieTableConfig.TIMELINE_TIMEZONE))).initTable(sparkContext.hadoopConfiguration(), path);
                                            }
                                            HoodieTableMetaClient tableMetaClient = hoodieTableMetaClient;
                                            tableConfig = tableMetaClient.getTableConfig();
                                            commitActionType = CommitUtils.getCommitActionType(operation, tableConfig.getTableType());
                                            sparkContext.getConf().registerKryoClasses((Class[])((Object[])new Class[]{GenericData.class, Schema.class}));
                                            boolean shouldReconcileSchema = new StringOps(Predef$.MODULE$.augmentString((String)parameters.apply((Object)DataSourceWriteOptions$.MODULE$.RECONCILE_SCHEMA().key()))).toBoolean();
                                            latestTableSchemaOpt = this.getLatestTableSchema(spark, tableIdentifier, tableMetaClient);
                                            Tuple2 tuple27 = (Tuple2)latestTableSchemaOpt.map((Function1 & Serializable & scala.Serializable)s -> new Tuple2((Object)s.getName(), (Object)s.getNamespace())).getOrElse((Function0 & Serializable & scala.Serializable)() -> AvroConversionUtils$.MODULE$.getAvroRecordNameAndNamespace(tblName));
                                            if (tuple27 == null) {
                                                throw new MatchError((Object)tuple27);
                                            }
                                            String avroRecordName2 = (String)tuple27._1();
                                            String avroRecordNamespace2 = (String)tuple27._2();
                                            Tuple2 tuple28 = new Tuple2((Object)avroRecordName2, (Object)avroRecordNamespace2);
                                            Tuple2 tuple29 = tuple28;
                                            avroRecordName = (String)tuple29._1();
                                            avroRecordNamespace = (String)tuple29._2();
                                            sourceSchema = AvroConversionUtils$.MODULE$.convertStructTypeToAvroSchema((DataType)df.schema(), avroRecordName, avroRecordNamespace);
                                            internalSchemaOpt = this.getLatestTableInternalSchema(hoodieConfig, tableMetaClient).orElse((Function0 & Serializable & scala.Serializable)() -> {
                                                None$ none$;
                                                if (shouldReconcileSchema && hoodieConfig.getBooleanOrDefault(DataSourceReadOptions$.MODULE$.SCHEMA_EVOLUTION_ENABLED())) {
                                                    boolean allowOperationMetaDataField = new StringOps(Predef$.MODULE$.augmentString((String)parameters.getOrElse((Object)HoodieWriteConfig.ALLOW_OPERATION_METADATA_FIELD.key(), (Function0 & Serializable & scala.Serializable)() -> "false"))).toBoolean();
                                                    none$ = new Some((Object)AvroInternalSchemaConverter.convert(HoodieAvroUtils.addMetadataFields((Schema)latestTableSchemaOpt.getOrElse((Function0 & Serializable & scala.Serializable)() -> sourceSchema), allowOperationMetaDataField)));
                                                } else {
                                                    none$ = None$.MODULE$;
                                                }
                                                return none$;
                                            });
                                            writeOperationType = operation;
                                            if (!((Object)((Object)WriteOperationType.DELETE)).equals((Object)writeOperationType)) break block30;
                                            RDD<GenericRecord> genericRecords = HoodieSparkUtils$.MODULE$.createRdd(df, avroRecordName, avroRecordNamespace);
                                            JavaRDD hoodieKeysToDelete = genericRecords.map((Function1 & Serializable & scala.Serializable)gr -> keyGenerator.getKey((GenericRecord)gr), ClassTag$.MODULE$.apply(HoodieKey.class)).toJavaRDD();
                                            if (!this.tableExists()) {
                                                throw new HoodieException(new StringBuilder(31).append("hoodie table at ").append(basePath).append(" does not exist").toString());
                                            }
                                            scala.Option<InternalSchema> internalSchemaOpt2 = this.getLatestTableInternalSchema(hoodieConfig, tableMetaClient);
                                            SparkRDDWriteClient client = (SparkRDDWriteClient)hoodieWriteClient.getOrElse((Function0 & Serializable & scala.Serializable)() -> DataSourceUtils.createHoodieClient(jsc, null, path, tblName, JavaConversions$.MODULE$.mapAsJavaMap(MODULE$.addSchemaEvolutionParameters((scala.collection.immutable.Map<String, String>)parameters, internalSchemaOpt2, MODULE$.addSchemaEvolutionParameters$default$3()).$minus((Object)HoodieWriteConfig.AUTO_COMMIT_ENABLE.key()))));
                                            Object object = this.isAsyncCompactionEnabled(client, tableConfig, (scala.collection.immutable.Map<String, String>)parameters, jsc.hadoopConfiguration()) ? ((Function1)asyncCompactionTriggerFn.get()).apply((Object)client) : BoxedUnit.UNIT;
                                            Object object2 = this.isAsyncClusteringEnabled(client, (scala.collection.immutable.Map<String, String>)parameters) ? ((Function1)asyncClusteringTriggerFn.get()).apply((Object)client) : BoxedUnit.UNIT;
                                            client.startCommitWithTime(instantTime, commitActionType);
                                            HoodieWriteResult writeStatuses = DataSourceUtils.doDeleteOperation(client, (JavaRDD<HoodieKey>)hoodieKeysToDelete, instantTime);
                                            tuple22 = new Tuple2((Object)writeStatuses, (Object)client);
                                            break block31;
                                        }
                                        if (!((Object)((Object)WriteOperationType.DELETE_PARTITION)).equals((Object)writeOperationType)) break block32;
                                        if (!this.tableExists()) {
                                            throw new HoodieException(new StringBuilder(31).append("hoodie table at ").append(basePath).append(" does not exist").toString());
                                        }
                                        if (JavaConversions$.MODULE$.deprecated$u0020mapAsJavaMap((Map)parameters).containsKey(DataSourceWriteOptions$.MODULE$.PARTITIONS_TO_DELETE().key())) {
                                            String[] partitionColsToDelete = ((String)parameters.apply((Object)DataSourceWriteOptions$.MODULE$.PARTITIONS_TO_DELETE().key())).split(",");
                                            list = Arrays.asList((Object[])this.resolvePartitionWildcards((List<String>)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(Arrays.asList((Object[])partitionColsToDelete)).toList(), jsc, hoodieConfig, basePath.toString()).toArray(ClassTag$.MODULE$.apply(String.class)));
                                        } else {
                                            RDD<GenericRecord> genericRecords = HoodieSparkUtils$.MODULE$.createRdd(df, avroRecordName, avroRecordNamespace);
                                            list = genericRecords.map((Function1 & Serializable & scala.Serializable)gr -> keyGenerator.getKey((GenericRecord)gr).getPartitionPath(), ClassTag$.MODULE$.apply(String.class)).toJavaRDD().distinct().collect();
                                        }
                                        java.util.List<Object> partitionsToDelete = list;
                                        HoodieTableMetaClient tableMetaClient = HoodieTableMetaClient.builder().setConf(sparkContext.hadoopConfiguration()).setBasePath(basePath.toString()).build();
                                        String schemaStr = new TableSchemaResolver(tableMetaClient).getTableAvroSchema().toString();
                                        SparkRDDWriteClient client = (SparkRDDWriteClient)hoodieWriteClient.getOrElse((Function0 & Serializable & scala.Serializable)() -> DataSourceUtils.createHoodieClient(jsc, schemaStr, path, tblName, JavaConversions$.MODULE$.mapAsJavaMap(parameters.$minus((Object)HoodieWriteConfig.AUTO_COMMIT_ENABLE.key()))));
                                        client.startCommitWithTime(instantTime, commitActionType);
                                        HoodieWriteResult writeStatuses = DataSourceUtils.doDeletePartitionsOperation(client, partitionsToDelete, instantTime);
                                        tuple22 = new Tuple2((Object)writeStatuses, (Object)client);
                                        break block31;
                                    }
                                    writerSchema = this.deduceWriterSchema(sourceSchema, latestTableSchemaOpt, (scala.Option<InternalSchema>)internalSchemaOpt, (scala.collection.immutable.Map<String, String>)parameters);
                                    this.validateSchemaForHoodieIsDeleted(writerSchema);
                                    if (!Predef$.MODULE$.Boolean2boolean(hoodieConfig.getBoolean(DataSourceWriteOptions$.MODULE$.ENABLE_ROW_WRITER()))) break block33;
                                    WriteOperationType writeOperationType = operation;
                                    WriteOperationType writeOperationType4 = WriteOperationType.BULK_INSERT;
                                    if (writeOperationType != null ? !((Object)((Object)writeOperationType)).equals((Object)writeOperationType4) : writeOperationType4 != null) break block33;
                                    tuple23 = this.bulkInsertAsRow(sqlContext, hoodieConfig, df, tblName, basePath, path, instantTime, writerSchema, tableConfig.isTablePartitioned());
                                    if (tuple23 == null) break block34;
                                    success = tuple23._1$mcZ$sp();
                                    commitTime = (Option)tuple23._2();
                                    if (commitTime != null) break block35;
                                }
                                throw new MatchError(tuple23);
                            }
                            Option option = commitTime;
                            Tuple2 tuple210 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)success), (Object)option);
                            Tuple2 tuple211 = tuple210;
                            boolean success2 = tuple211._1$mcZ$sp();
                            Option commitTime2 = (Option)tuple211._2();
                            return new Tuple6((Object)BoxesRunTime.boxToBoolean((boolean)success2), (Object)commitTime2, Option.empty(), Option.empty(), hoodieWriteClient.orNull(Predef$.MODULE$.$conforms()), (Object)tableConfig);
                        }
                        if (Predef$.MODULE$.Boolean2boolean(shouldDropPartitionColumns = hoodieConfig.getBoolean(DataSourceWriteOptions$.MODULE$.DROP_PARTITION_COLUMNS()))) {
                            Schema truncatedSchema = this.generateSchemaWithoutPartitionColumns(partitionColumns, writerSchema);
                            this.registerAvroSchemasWithKryo(sparkContext, (Seq<Schema>)Predef$.MODULE$.wrapRefArray((Object[])new Schema[]{truncatedSchema}));
                            schema = truncatedSchema;
                        } else {
                            schema = writerSchema;
                        }
                        Schema dataFileSchema = schema;
                        SparkRDDWriteClient client = (SparkRDDWriteClient)hoodieWriteClient.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                            scala.collection.immutable.Map finalOpts = (scala.collection.immutable.Map)MODULE$.addSchemaEvolutionParameters((scala.collection.immutable.Map<String, String>)parameters, (scala.Option<InternalSchema>)internalSchemaOpt, (scala.Option<Schema>)new Some((Object)writerSchema)).$minus((Object)HoodieWriteConfig.AUTO_COMMIT_ENABLE.key());
                            return DataSourceUtils.createHoodieClient(jsc, dataFileSchema.toString(), path, tblName, JavaConversions$.MODULE$.mapAsJavaMap((Map)finalOpts));
                        });
                        HoodieWriteConfig writeConfig = client.getConfig();
                        HoodieRecord.HoodieRecordType hoodieRecordType = writeConfig.getRecordMerger().getRecordType();
                        HoodieRecord.HoodieRecordType hoodieRecordType2 = HoodieRecord.HoodieRecordType.SPARK;
                        if (!(hoodieRecordType != null ? !((Object)((Object)hoodieRecordType)).equals((Object)hoodieRecordType2) : hoodieRecordType2 != null)) {
                            HoodieTableType hoodieTableType = tableType;
                            HoodieTableType hoodieTableType2 = HoodieTableType.MERGE_ON_READ;
                            if (!(hoodieTableType != null ? !((Object)((Object)hoodieTableType)).equals((Object)hoodieTableType2) : hoodieTableType2 != null)) {
                                HoodieLogBlock.HoodieLogBlockType hoodieLogBlockType = writeConfig.getLogDataBlockFormat().orElse(HoodieLogBlock.HoodieLogBlockType.AVRO_DATA_BLOCK);
                                HoodieLogBlock.HoodieLogBlockType hoodieLogBlockType2 = HoodieLogBlock.HoodieLogBlockType.PARQUET_DATA_BLOCK;
                                if (hoodieLogBlockType == null ? hoodieLogBlockType2 != null : !((Object)((Object)hoodieLogBlockType)).equals((Object)hoodieLogBlockType2)) {
                                    throw new UnsupportedOperationException(new StringBuilder(26).append(writeConfig.getRecordMerger().getClass().getName()).append(" only support parquet log.").toString());
                                }
                            }
                        }
                        JavaRDD<HoodieRecord<?>> hoodieRecords = this.createHoodieRecordRdd(df, writeConfig, (scala.collection.immutable.Map<String, String>)parameters, avroRecordName, avroRecordNamespace, writerSchema, dataFileSchema, operation);
                        Object object = this.isAsyncCompactionEnabled(client, tableConfig, (scala.collection.immutable.Map<String, String>)parameters, jsc.hadoopConfiguration()) ? ((Function1)asyncCompactionTriggerFn.get()).apply((Object)client) : BoxedUnit.UNIT;
                        Object object3 = this.isAsyncClusteringEnabled(client, (scala.collection.immutable.Map<String, String>)parameters) ? ((Function1)asyncClusteringTriggerFn.get()).apply((Object)client) : BoxedUnit.UNIT;
                        JavaRDD<HoodieRecord<?>> dedupedHoodieRecords = Predef$.MODULE$.Boolean2boolean(hoodieConfig.getBoolean(DataSourceWriteOptions$.MODULE$.INSERT_DROP_DUPS())) ? DataSourceUtils.dropDuplicates(jsc, hoodieRecords, JavaConversions$.MODULE$.mapAsJavaMap((Map)parameters)) : hoodieRecords;
                        client.startCommitWithTime(instantTime, commitActionType);
                        HoodieWriteResult writeResult2 = DataSourceUtils.doWriteOperation(client, dedupedHoodieRecords, instantTime, operation);
                        tuple22 = new Tuple2((Object)writeResult2, (Object)client);
                    }
                    tuple2 = tuple22;
                    if (tuple2 == null) break block36;
                    writeResult = (HoodieWriteResult)tuple2._1();
                    writeClient = (SparkRDDWriteClient)tuple2._2();
                    if (writeClient != null) break block37;
                }
                throw new MatchError((Object)tuple2);
            }
            SparkRDDWriteClient sparkRDDWriteClient = writeClient;
            Tuple2 tuple2 = new Tuple2((Object)writeResult, (Object)sparkRDDWriteClient);
            Tuple2 tuple212 = tuple2;
            HoodieWriteResult writeResult3 = (HoodieWriteResult)tuple212._1();
            SparkRDDWriteClient writeClient2 = (SparkRDDWriteClient)tuple212._2();
            try {
                Tuple3<Object, Option<String>, Option<String>> tuple3 = this.commitAndPerformPostOperations(sqlContext.sparkSession(), df.schema(), writeResult3, (scala.collection.immutable.Map<String, String>)parameters, writeClient2, tableConfig, jsc, new HoodieSparkSqlWriter.TableInstantInfo(basePath, instantTime, commitActionType, operation), extraPreCommitFn);
                if (tuple3 == null) {
                    throw new MatchError(tuple3);
                }
                boolean writeSuccessful = BoxesRunTime.unboxToBoolean((Object)tuple3._1());
                Option compactionInstant = (Option)tuple3._2();
                Option clusteringInstant = (Option)tuple3._3();
                Tuple3 tuple32 = new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)writeSuccessful), (Object)compactionInstant, (Object)clusteringInstant);
                Tuple3 tuple33 = tuple32;
                boolean writeSuccessful2 = BoxesRunTime.unboxToBoolean((Object)tuple33._1());
                Option compactionInstant2 = (Option)tuple33._2();
                Option clusteringInstant2 = (Option)tuple33._3();
                tuple6 = new Tuple6((Object)BoxesRunTime.boxToBoolean((boolean)writeSuccessful2), Option.ofNullable(instantTime), (Object)compactionInstant2, (Object)clusteringInstant2, (Object)writeClient2, (Object)tableConfig);
            }
            finally {
                boolean asyncCompactionEnabled = this.isAsyncCompactionEnabled(writeClient2, tableConfig, (scala.collection.immutable.Map<String, String>)parameters, jsc.hadoopConfiguration());
                boolean asyncClusteringEnabled = this.isAsyncClusteringEnabled(writeClient2, (scala.collection.immutable.Map<String, String>)parameters);
                if (!asyncCompactionEnabled && !asyncClusteringEnabled) {
                    this.log().info((Object)"Closing write client");
                    writeClient2.close();
                }
            }
        }
        return tuple6;
    }

    public scala.Option<HoodieTableConfig> write$default$5() {
        return Option$.MODULE$.empty();
    }

    public scala.Option<SparkRDDWriteClient<?>> write$default$6() {
        return Option$.MODULE$.empty();
    }

    public scala.Option<Function1<SparkRDDWriteClient<?>, BoxedUnit>> write$default$7() {
        return Option$.MODULE$.empty();
    }

    public scala.Option<Function1<SparkRDDWriteClient<?>, BoxedUnit>> write$default$8() {
        return Option$.MODULE$.empty();
    }

    public scala.Option<BiConsumer<HoodieTableMetaClient, HoodieCommitMetadata>> write$default$9() {
        return Option$.MODULE$.empty();
    }

    /*
     * Enabled aggressive block sorting
     */
    public Schema deduceWriterSchema(Schema sourceSchema, scala.Option<Schema> latestTableSchemaOpt, scala.Option<InternalSchema> internalSchemaOpt, scala.collection.immutable.Map<String, String> opts) {
        Schema schema;
        boolean shouldReconcileSchema = new StringOps(Predef$.MODULE$.augmentString((String)opts.apply((Object)DataSourceWriteOptions$.MODULE$.RECONCILE_SCHEMA().key()))).toBoolean();
        boolean shouldValidateSchemasCompatibility = new StringOps(Predef$.MODULE$.augmentString(JavaConversions$.MODULE$.deprecated$u0020mapAsJavaMap(opts).getOrDefault(HoodieWriteConfig.AVRO_SCHEMA_VALIDATE_ENABLE.key(), HoodieWriteConfig.AVRO_SCHEMA_VALIDATE_ENABLE.defaultValue()))).toBoolean();
        scala.Option<Schema> option = latestTableSchemaOpt;
        if (None$.MODULE$.equals(option)) {
            return sourceSchema;
        }
        if (!(option instanceof Some)) throw new MatchError(option);
        Some some = (Some)option;
        Schema latestTableSchemaWithMetaFields = (Schema)some.value();
        Schema latestTableSchema = HoodieAvroUtils.removeMetadataFields(latestTableSchemaWithMetaFields);
        boolean shouldCanonicalizeNullable = new StringOps(Predef$.MODULE$.augmentString(JavaConversions$.MODULE$.deprecated$u0020mapAsJavaMap(opts).getOrDefault(this.CANONICALIZE_NULLABLE().key(), this.CANONICALIZE_NULLABLE().defaultValue().toString()))).toBoolean();
        boolean mergeIntoWrites = new StringOps(Predef$.MODULE$.augmentString(JavaConversions$.MODULE$.deprecated$u0020mapAsJavaMap(opts).getOrDefault(this.SQL_MERGE_INTO_WRITES().key(), this.SQL_MERGE_INTO_WRITES().defaultValue().toString()))).toBoolean();
        Schema canonicalizedSourceSchema = shouldCanonicalizeNullable ? AvroSchemaEvolutionUtils.canonicalizeColumnNullability(sourceSchema, latestTableSchema) : sourceSchema;
        boolean allowAutoEvolutionColumnDrop = new StringOps(Predef$.MODULE$.augmentString(JavaConversions$.MODULE$.deprecated$u0020mapAsJavaMap(opts).getOrDefault(HoodieWriteConfig.SCHEMA_ALLOW_AUTO_EVOLUTION_COLUMN_DROP.key(), HoodieWriteConfig.SCHEMA_ALLOW_AUTO_EVOLUTION_COLUMN_DROP.defaultValue()))).toBoolean();
        if (shouldReconcileSchema) {
            Schema schema2;
            scala.Option<InternalSchema> option2 = internalSchemaOpt;
            if (option2 instanceof Some) {
                Some some2 = (Some)option2;
                InternalSchema internalSchema = (InternalSchema)some2.value();
                InternalSchema mergedInternalSchema = AvroSchemaEvolutionUtils.reconcileSchema(canonicalizedSourceSchema, internalSchema);
                Schema evolvedSchema = AvroInternalSchemaConverter.convert(mergedInternalSchema, latestTableSchema.getFullName());
                boolean shouldRemoveMetaDataFromInternalSchema = ((SeqLike)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(sourceSchema.getFields()).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)HoodieSparkSqlWriter$.$anonfun$deduceWriterSchema$1(f)))).isEmpty();
                schema2 = shouldRemoveMetaDataFromInternalSchema ? HoodieAvroUtils.removeMetadataFields(evolvedSchema) : evolvedSchema;
            } else {
                if (!None$.MODULE$.equals(option2)) throw new MatchError(option2);
                Tuple2<Schema, Object> tuple2 = this.reconcileSchemasLegacy(latestTableSchema, canonicalizedSourceSchema);
                if (tuple2 == null) throw new MatchError(tuple2);
                Schema reconciledSchema = (Schema)tuple2._1();
                boolean isCompatible = tuple2._2$mcZ$sp();
                Tuple2 tuple22 = new Tuple2((Object)reconciledSchema, (Object)BoxesRunTime.boxToBoolean((boolean)isCompatible));
                Tuple2 tuple23 = tuple22;
                Schema reconciledSchema2 = (Schema)tuple23._1();
                boolean isCompatible2 = tuple23._2$mcZ$sp();
                if (shouldValidateSchemasCompatibility && !isCompatible2) {
                    this.log().error((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(218).append("Failed to reconcile incoming batch schema with the table's one.\n                     |Incoming schema ").append(sourceSchema.toString(true)).append("\n                     |Incoming schema (canonicalized) ").append(canonicalizedSourceSchema.toString(true)).append("\n                     |Table's schema ").append(latestTableSchema.toString(true)).append("\n                     |").toString())).stripMargin());
                    throw new SchemaCompatibilityException("Failed to reconcile incoming schema with the table's one");
                }
                schema2 = reconciledSchema2;
            }
            schema = schema2;
            return schema;
        } else if (mergeIntoWrites) {
            schema = canonicalizedSourceSchema;
            return schema;
        } else if (!shouldValidateSchemasCompatibility) {
            if (!allowAutoEvolutionColumnDrop && !AvroSchemaUtils.canProject(latestTableSchema, canonicalizedSourceSchema)) {
                this.log().error((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(208).append("Incoming batch schema is not compatible with the table's one.\n                   |Incoming schema ").append(sourceSchema.toString(true)).append("\n                   |Incoming schema (canonicalized) ").append(canonicalizedSourceSchema.toString(true)).append("\n                   |Table's schema ").append(latestTableSchema.toString(true)).append("\n                   |").toString())).stripMargin());
                throw new SchemaCompatibilityException("Incoming batch schema is not compatible with the table's one");
            }
            schema = canonicalizedSourceSchema;
            return schema;
        } else {
            if (!AvroSchemaUtils.isSchemaCompatible(latestTableSchema, canonicalizedSourceSchema, allowAutoEvolutionColumnDrop)) {
                this.log().error((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(208).append("Incoming batch schema is not compatible with the table's one.\n                   |Incoming schema ").append(sourceSchema.toString(true)).append("\n                   |Incoming schema (canonicalized) ").append(canonicalizedSourceSchema.toString(true)).append("\n                   |Table's schema ").append(latestTableSchema.toString(true)).append("\n                   |").toString())).stripMargin());
                throw new SchemaCompatibilityException("Incoming batch schema is not compatible with the table's one");
            }
            schema = canonicalizedSourceSchema;
        }
        return schema;
    }

    private List<String> resolvePartitionWildcards(List<String> partitions, JavaSparkContext jsc, HoodieConfig cfg, String basePath) {
        ObjectRef fullPartitions;
        block1: {
            Tuple2 tuple2 = partitions.partition((Function1 & Serializable & scala.Serializable)partition -> BoxesRunTime.boxToBoolean((boolean)partition.contains("*")));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            List wildcardPartitions = (List)tuple2._1();
            List fullPartitions2 = (List)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)wildcardPartitions, (Object)fullPartitions2);
            Tuple2 tuple23 = tuple22;
            List wildcardPartitions2 = (List)tuple23._1();
            fullPartitions = ObjectRef.create((Object)((List)tuple23._2()));
            if (!wildcardPartitions2.nonEmpty()) break block1;
            java.util.List<String> allPartitions = FSUtils.getAllPartitionPaths(new HoodieSparkEngineContext(jsc), HoodieMetadataConfig.newBuilder().fromProperties(cfg.getProps()).build(), basePath);
            wildcardPartitions2.foreach((Function1 & Serializable & scala.Serializable)partition -> {
                HoodieSparkSqlWriter$.$anonfun$resolvePartitionWildcards$2(fullPartitions, allPartitions, partition);
                return BoxedUnit.UNIT;
            });
        }
        return (List)((List)fullPartitions.elem).distinct();
    }

    public Seq<String> getPartitionColumns(String partitionParam) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionParam.split(","))).map((Function1 & Serializable & scala.Serializable)partitionField -> partitionField.trim(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).filter((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)HoodieSparkSqlWriter$.$anonfun$getPartitionColumns$2(x$10))))).toSeq();
    }

    public Schema generateSchemaWithoutPartitionColumns(String partitionParam, Schema schema) {
        Seq<String> partitionColumns = this.getPartitionColumns(partitionParam);
        return HoodieAvroUtils.removeFields(schema, (java.util.Set<String>)((java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)partitionColumns.toSet()).asJava()));
    }

    public scala.collection.immutable.Map<String, String> addSchemaEvolutionParameters(scala.collection.immutable.Map<String, String> parameters, scala.Option<InternalSchema> internalSchemaOpt, scala.Option<Schema> writeSchemaOpt) {
        String schemaEvolutionEnabled = internalSchemaOpt.isDefined() ? "true" : "false";
        boolean schemaReconciliationEnabled = new StringOps(Predef$.MODULE$.augmentString(JavaConversions$.MODULE$.deprecated$u0020mapAsJavaMap(parameters).getOrDefault(DataSourceWriteOptions$.MODULE$.RECONCILE_SCHEMA().key(), DataSourceWriteOptions$.MODULE$.RECONCILE_SCHEMA().defaultValue().toString()))).toBoolean();
        None$ schemaValidationEnabledOpt = new StringOps(Predef$.MODULE$.augmentString(schemaEvolutionEnabled)).toBoolean() && schemaReconciliationEnabled ? new Some((Object)BoxesRunTime.boxToBoolean((boolean)false)) : None$.MODULE$;
        scala.Option correctInternalSchema = internalSchemaOpt.map((Function1 & Serializable & scala.Serializable)internalSchema -> {
            InternalSchema internalSchema2;
            if (internalSchema.findField(HoodieRecord.RECORD_KEY_METADATA_FIELD) == null && writeSchemaOpt.isDefined()) {
                boolean allowOperationMetaDataField = new StringOps(Predef$.MODULE$.augmentString((String)parameters.getOrElse((Object)HoodieWriteConfig.ALLOW_OPERATION_METADATA_FIELD.key(), (Function0 & Serializable & scala.Serializable)() -> "false"))).toBoolean();
                internalSchema2 = AvroInternalSchemaConverter.convert(HoodieAvroUtils.addMetadataFields((Schema)writeSchemaOpt.get(), allowOperationMetaDataField));
            } else {
                internalSchema2 = internalSchema;
            }
            return internalSchema2;
        });
        return parameters.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.INTERNAL_SCHEMA_STRING.key()), (Object)SerDeHelper.toJson((InternalSchema)correctInternalSchema.orNull(Predef$.MODULE$.$conforms()))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieCommonConfig.SCHEMA_EVOLUTION_ENABLE.key()), (Object)schemaEvolutionEnabled)}))).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(schemaValidationEnabledOpt.map((Function1 & Serializable & scala.Serializable)x$11 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.AVRO_SCHEMA_VALIDATE_ENABLE.key()), (Object)((Object)BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)x$11))).toString()))).toSeq());
    }

    public scala.Option<Schema> addSchemaEvolutionParameters$default$3() {
        return None$.MODULE$;
    }

    private Tuple2<Schema, Object> reconcileSchemasLegacy(Schema tableSchema, Schema newSchema) {
        return AvroSchemaUtils.isCompatibleProjectionOf(tableSchema, newSchema) ? new Tuple2((Object)tableSchema, (Object)BoxesRunTime.boxToBoolean((boolean)AvroSchemaUtils.isSchemaCompatible(newSchema, tableSchema))) : new Tuple2((Object)newSchema, (Object)BoxesRunTime.boxToBoolean((boolean)AvroSchemaUtils.isSchemaCompatible(tableSchema, newSchema)));
    }

    public scala.Option<InternalSchema> getLatestTableInternalSchema(HoodieConfig config, HoodieTableMetaClient tableMetaClient) {
        scala.Option option;
        block5: {
            if (!config.getBooleanOrDefault(DataSourceReadOptions$.MODULE$.SCHEMA_EVOLUTION_ENABLED())) {
                option = Option$.MODULE$.empty();
            } else {
                try {
                    TableSchemaResolver tableSchemaResolver = new TableSchemaResolver(tableMetaClient);
                    Option<InternalSchema> internalSchemaOpt = tableSchemaResolver.getTableInternalSchemaFromCommitMetadata();
                    if (internalSchemaOpt.isPresent()) {
                        option = new Some((Object)internalSchemaOpt.get());
                        break block5;
                    }
                    option = None$.MODULE$;
                }
                catch (Exception exception) {
                    option = None$.MODULE$;
                }
            }
        }
        return option;
    }

    private void registerAvroSchemasWithKryo(SparkContext sparkContext, Seq<Schema> targetAvroSchemas) {
        sparkContext.getConf().registerAvroSchemas(targetAvroSchemas);
    }

    private scala.Option<Schema> getLatestTableSchema(SparkSession spark, TableIdentifier tableId, HoodieTableMetaClient tableMetaClient) {
        TableSchemaResolver tableSchemaResolver = new TableSchemaResolver(tableMetaClient);
        scala.Option<Schema> latestTableSchemaFromCommitMetadata = HoodieConversionUtils$.MODULE$.toScalaOption(tableSchemaResolver.getTableAvroSchemaFromLatestCommit(false));
        return latestTableSchemaFromCommitMetadata.orElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.getCatalogTable(spark, tableId).map((Function1 & Serializable & scala.Serializable)catalogTable -> {
            Tuple2<String, String> tuple2 = AvroConversionUtils$.MODULE$.getAvroRecordNameAndNamespace(tableId.table());
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String structName = (String)tuple2._1();
            String namespace = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)structName, (Object)namespace);
            Tuple2 tuple23 = tuple22;
            String structName2 = (String)tuple23._1();
            String namespace2 = (String)tuple23._2();
            return AvroConversionUtils$.MODULE$.convertStructTypeToAvroSchema((DataType)catalogTable.schema(), structName2, namespace2);
        }));
    }

    private scala.Option<CatalogTable> getCatalogTable(SparkSession spark, TableIdentifier tableId) {
        return spark.sessionState().catalog().tableExists(tableId) ? new Some((Object)spark.sessionState().catalog().getTableMetadata(tableId)) : None$.MODULE$;
    }

    public boolean bootstrap(SQLContext sqlContext, SaveMode mode, scala.collection.immutable.Map<String, String> optParams, Dataset<Row> df, scala.Option<HoodieTableConfig> hoodieTableConfigOpt, scala.Option<SparkRDDWriteClient<?>> hoodieWriteClient) {
        boolean bl;
        Predef$.MODULE$.assert(optParams.get((Object)"path").exists((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)HoodieSparkSqlWriter$.$anonfun$bootstrap$1(x$13))), (Function0 & Serializable & scala.Serializable)() -> "'path' must be set");
        String path = (String)optParams.apply((Object)"path");
        Path basePath = new Path(path);
        SparkContext sparkContext = sqlContext.sparkContext();
        FileSystem fs = basePath.getFileSystem(sparkContext.hadoopConfiguration());
        this.tableExists_$eq(fs.exists(new Path(basePath, ".hoodie")));
        HoodieTableConfig tableConfig = this.getHoodieTableConfig(sparkContext, path, mode, hoodieTableConfigOpt);
        SaveMode saveMode = mode;
        SaveMode saveMode2 = SaveMode.Overwrite;
        HoodieWriterUtils$.MODULE$.validateTableConfig(sqlContext.sparkSession(), optParams, tableConfig, !(saveMode != null ? !saveMode.equals(saveMode2) : saveMode2 != null));
        Tuple2<scala.collection.immutable.Map<String, String>, HoodieConfig> tuple2 = this.mergeParamsAndGetHoodieConfig(optParams, tableConfig, mode);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        scala.collection.immutable.Map parameters = (scala.collection.immutable.Map)tuple2._1();
        HoodieConfig hoodieConfig = (HoodieConfig)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)parameters, (Object)hoodieConfig);
        Tuple2 tuple23 = tuple22;
        scala.collection.immutable.Map parameters2 = (scala.collection.immutable.Map)tuple23._1();
        HoodieConfig hoodieConfig2 = (HoodieConfig)tuple23._2();
        String tableName = hoodieConfig2.getStringOrThrow(HoodieWriteConfig.TBL_NAME, new StringBuilder(15).append("'").append(HoodieWriteConfig.TBL_NAME.key()).append("' must be set.").toString());
        String tableType = hoodieConfig2.getStringOrDefault(DataSourceWriteOptions$.MODULE$.TABLE_TYPE());
        String bootstrapBasePath = hoodieConfig2.getStringOrThrow(HoodieBootstrapConfig.BASE_PATH, new StringBuilder(32).append("'").append(HoodieBootstrapConfig.BASE_PATH.key()).append("' is required for '").append(DataSourceWriteOptions$.MODULE$.BOOTSTRAP_OPERATION_OPT_VAL()).append("'").append(" operation'").toString());
        String bootstrapIndexClass = hoodieConfig2.getStringOrDefault(HoodieBootstrapConfig.INDEX_CLASS_NAME);
        ObjectRef schema = ObjectRef.create(null);
        if (df.schema().nonEmpty()) {
            Tuple2<String, String> tuple24 = AvroConversionUtils$.MODULE$.getAvroRecordNameAndNamespace(tableName);
            if (tuple24 == null) {
                throw new MatchError(tuple24);
            }
            String structName = (String)tuple24._1();
            String namespace = (String)tuple24._2();
            Tuple2 tuple25 = new Tuple2((Object)structName, (Object)namespace);
            Tuple2 tuple26 = tuple25;
            String structName2 = (String)tuple26._1();
            String namespace2 = (String)tuple26._2();
            schema.elem = AvroConversionUtils$.MODULE$.convertStructTypeToAvroSchema((DataType)df.schema(), structName2, namespace2).toString();
        } else {
            schema.elem = HoodieAvroUtils.getNullSchema().toString();
        }
        SaveMode saveMode3 = mode;
        SaveMode saveMode4 = SaveMode.Ignore;
        if (!(saveMode3 != null ? !saveMode3.equals(saveMode4) : saveMode4 != null) && this.tableExists()) {
            this.log().warn((Object)new StringBuilder(73).append("hoodie table at ").append(basePath).append(" already exists. Ignoring & not performing actual writes.").toString());
            if (!hoodieWriteClient.isEmpty()) {
                ((BaseHoodieWriteClient)hoodieWriteClient.get()).close();
            }
            bl = false;
        } else {
            boolean metaSyncSuccess;
            Object object;
            this.handleSaveModes(sqlContext.sparkSession(), mode, basePath, tableConfig, tableName, WriteOperationType.BOOTSTRAP, fs);
            if (!this.tableExists()) {
                String archiveLogFolder = hoodieConfig2.getStringOrDefault(HoodieTableConfig.ARCHIVELOG_FOLDER);
                String partitionColumns = HoodieWriterUtils$.MODULE$.getPartitionColumns((scala.collection.immutable.Map<String, String>)parameters2);
                String recordKeyFields = hoodieConfig2.getString(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD());
                String keyGenProp = StringUtils.nonEmpty(hoodieConfig2.getString(HoodieBootstrapConfig.KEYGEN_CLASS_NAME)) ? hoodieConfig2.getString(HoodieBootstrapConfig.KEYGEN_CLASS_NAME) : hoodieConfig2.getString(HoodieTableConfig.KEY_GENERATOR_CLASS_NAME);
                scala.collection.immutable.Map<String, String> timestampKeyGeneratorConfigs = this.extractConfigsRelatedToTimestampBasedKeyGenerator(keyGenProp, (scala.collection.immutable.Map<String, String>)parameters2);
                boolean populateMetaFields = Boolean.parseBoolean((String)parameters2.getOrElse((Object)HoodieTableConfig.POPULATE_META_FIELDS.key(), (Function0 & Serializable & scala.Serializable)() -> String.valueOf(HoodieTableConfig.POPULATE_META_FIELDS.defaultValue())));
                String baseFileFormat = hoodieConfig2.getStringOrDefault(HoodieTableConfig.BASE_FILE_FORMAT);
                boolean useBaseFormatMetaFile = Boolean.parseBoolean((String)parameters2.getOrElse((Object)HoodieTableConfig.PARTITION_METAFILE_USE_BASE_FORMAT.key(), (Function0 & Serializable & scala.Serializable)() -> String.valueOf(HoodieTableConfig.PARTITION_METAFILE_USE_BASE_FORMAT.defaultValue())));
                object = HoodieTableMetaClient.withPropertyBuilder().setTableType(HoodieTableType.valueOf(tableType)).setTableName(tableName).setRecordKeyFields(recordKeyFields).setArchiveLogFolder(archiveLogFolder).setPayloadClassName(hoodieConfig2.getStringOrDefault(DataSourceWriteOptions$.MODULE$.PAYLOAD_CLASS_NAME())).setPreCombineField(hoodieConfig2.getStringOrDefault(DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD(), null)).setBootstrapIndexClass(bootstrapIndexClass).setBaseFileFormat(baseFileFormat).setBootstrapBasePath(bootstrapBasePath).setPartitionFields(partitionColumns).setCDCEnabled(hoodieConfig2.getBooleanOrDefault(HoodieTableConfig.CDC_ENABLED)).setCDCSupplementalLoggingMode(hoodieConfig2.getStringOrDefault(HoodieTableConfig.CDC_SUPPLEMENTAL_LOGGING_MODE)).setPopulateMetaFields(populateMetaFields).setKeyGeneratorClassProp(keyGenProp).set(JavaConversions$.MODULE$.deprecated$u0020mapAsJavaMap(timestampKeyGeneratorConfigs)).setHiveStylePartitioningEnable(hoodieConfig2.getBoolean(DataSourceWriteOptions$.MODULE$.HIVE_STYLE_PARTITIONING())).setUrlEncodePartitioning(hoodieConfig2.getBoolean(DataSourceWriteOptions$.MODULE$.URL_ENCODE_PARTITIONING())).setCommitTimezone(HoodieTimelineTimeZone.valueOf(hoodieConfig2.getStringOrDefault(HoodieTableConfig.TIMELINE_TIMEZONE))).setPartitionMetafileUseBaseFormat(Predef$.MODULE$.boolean2Boolean(useBaseFormatMetaFile)).initTable(sparkContext.hadoopConfiguration(), path);
            } else {
                object = BoxedUnit.UNIT;
            }
            JavaSparkContext jsc = new JavaSparkContext(sqlContext.sparkContext());
            try (SparkRDDWriteClient writeClient = (SparkRDDWriteClient)hoodieWriteClient.getOrElse((Function0 & Serializable & scala.Serializable)() -> DataSourceUtils.createHoodieClient(jsc, (String)schema$1.elem, path, tableName, JavaConversions$.MODULE$.mapAsJavaMap((Map)parameters2)));){
                writeClient.bootstrap(Option.empty());
            }
            bl = metaSyncSuccess = this.metaSync(sqlContext.sparkSession(), hoodieConfig2, basePath, df.schema());
        }
        return bl;
    }

    public scala.Option<HoodieTableConfig> bootstrap$default$5() {
        return Option$.MODULE$.empty();
    }

    public scala.Option<SparkRDDWriteClient<?>> bootstrap$default$6() {
        return Option$.MODULE$.empty();
    }

    public void validateSchemaForHoodieIsDeleted(Schema schema) {
        if (schema.getField("_hoodie_is_deleted") != null) {
            Schema.Type type = ((Schema)AvroConversionUtils$.MODULE$.resolveAvroTypeNullability(schema.getField("_hoodie_is_deleted").schema())._2()).getType();
            Schema.Type type2 = Schema.Type.BOOLEAN;
            if (type == null ? type2 != null : !type.equals(type2)) {
                throw new HoodieException(new StringBuilder(81).append("_hoodie_is_deleted has to be BOOLEAN type. Passed in dataframe's schema has type ").append(schema.getField("_hoodie_is_deleted").schema().getType()).toString());
            }
        }
    }

    public Tuple2<Object, Option<String>> bulkInsertAsRow(SQLContext sqlContext, HoodieConfig hoodieConfig, Dataset<Row> df, String tblName, Path basePath, String path, String instantTime, Schema writerSchema, boolean isTablePartitioned) {
        Tuple2 tuple2;
        Option<BulkInsertPartitioner<Dataset<Row>>> userDefinedBulkInsertPartitionerOpt;
        if (Predef$.MODULE$.Boolean2boolean(hoodieConfig.getBoolean(DataSourceWriteOptions$.MODULE$.INSERT_DROP_DUPS()))) {
            throw new HoodieException("Dropping duplicates with bulk_insert in row writer path is not supported yet");
        }
        String writerSchemaStr = writerSchema.toString();
        scala.collection.immutable.Map opts = JavaConversions$.MODULE$.deprecated$u0020propertiesAsScalaMap((Properties)hoodieConfig.getProps()).toMap(Predef$.MODULE$.$conforms()).$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.AVRO_SCHEMA_STRING.key()), (Object)writerSchemaStr)})));
        HoodieWriteConfig writeConfig = DataSourceUtils.createHoodieConfig(writerSchemaStr, path, tblName, JavaConversions$.MODULE$.mapAsJavaMap((Map)opts));
        Boolean populateMetaFields = hoodieConfig.getBoolean(HoodieTableConfig.POPULATE_META_FIELDS);
        NonSortPartitionerWithRows bulkInsertPartitionerRows = Predef$.MODULE$.Boolean2boolean(populateMetaFields) ? ((userDefinedBulkInsertPartitionerOpt = DataSourceUtils.createUserDefinedBulkInsertPartitionerWithRows(writeConfig)).isPresent() ? userDefinedBulkInsertPartitionerOpt.get() : BulkInsertInternalPartitionerWithRowsFactory.get(writeConfig, isTablePartitioned)) : new NonSortPartitionerWithRows();
        Boolean shouldDropPartitionColumns = hoodieConfig.getBoolean(DataSourceWriteOptions$.MODULE$.DROP_PARTITION_COLUMNS());
        Dataset<Row> hoodieDF = HoodieDatasetBulkInsertHelper$.MODULE$.prepareForBulkInsert(df, writeConfig, bulkInsertPartitionerRows, Predef$.MODULE$.Boolean2boolean(shouldDropPartitionColumns));
        scala.collection.immutable.Map optsOverrides = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.bulkinsert.are.partitioner.records.sorted"), (Object)((Object)BoxesRunTime.boxToBoolean((boolean)bulkInsertPartitionerRows.arePartitionRecordsSorted())).toString())}));
        if (HoodieSparkUtils$.MODULE$.isSpark2()) {
            tuple2 = new Tuple2((Object)"org.apache.hudi.internal", (Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$));
        } else if (HoodieSparkUtils$.MODULE$.isSpark3()) {
            tuple2 = new Tuple2((Object)"org.apache.hudi.spark3.internal", (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieInternalConfig.BULKINSERT_INPUT_DATA_SCHEMA_DDL.key()), (Object)hoodieDF.schema().json())})));
        } else {
            throw new HoodieException("Bulk insert using row writer is not supported with current Spark version. To use row writer please switch to spark 2 or spark 3");
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        String targetFormat = (String)tuple22._1();
        scala.collection.immutable.Map customOpts = (scala.collection.immutable.Map)tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)targetFormat, (Object)customOpts);
        Tuple2 tuple24 = tuple23;
        String targetFormat2 = (String)tuple24._1();
        scala.collection.immutable.Map customOpts2 = (scala.collection.immutable.Map)tuple24._2();
        hoodieDF.write().format(targetFormat2).option("hoodie.instant.time", instantTime).options((Map)opts.$plus$plus((GenTraversableOnce)customOpts2).$plus$plus((GenTraversableOnce)optsOverrides)).mode(SaveMode.Append).save();
        boolean syncHiveSuccess = this.metaSync(sqlContext.sparkSession(), writeConfig, basePath, df.schema());
        return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)syncHiveSuccess), Option.ofNullable(instantTime));
    }

    public void cleanup() {
        Metrics.shutdown();
    }

    private void handleSaveModes(SparkSession spark, SaveMode mode, Path tablePath, HoodieTableConfig tableConfig, String tableName, WriteOperationType operation, FileSystem fs) {
        SaveMode saveMode = mode;
        SaveMode saveMode2 = SaveMode.Append;
        if (!(saveMode != null ? !saveMode.equals(saveMode2) : saveMode2 != null) && this.tableExists()) {
            String existingTableName = tableConfig.getTableName();
            Function2 resolver2 = spark.sessionState().conf().resolver();
            if (!BoxesRunTime.unboxToBoolean((Object)resolver2.apply((Object)existingTableName, (Object)tableName))) {
                throw new HoodieException(new StringBuilder(96).append("hoodie table with name ").append(existingTableName).append(" already exists at ").append(tablePath).append(",").append(" can not append data to the table with another name ").append(tableName).append(".").toString());
            }
        }
        WriteOperationType writeOperationType = operation;
        WriteOperationType writeOperationType2 = WriteOperationType.DELETE;
        if (writeOperationType == null ? writeOperationType2 != null : !((Object)((Object)writeOperationType)).equals((Object)writeOperationType2)) {
            SaveMode saveMode3 = mode;
            SaveMode saveMode4 = SaveMode.ErrorIfExists;
            if (!(saveMode3 != null ? !saveMode3.equals(saveMode4) : saveMode4 != null) && this.tableExists()) {
                throw new HoodieException(new StringBuilder(32).append("hoodie table at ").append(tablePath).append(" already exists.").toString());
            }
            SaveMode saveMode5 = mode;
            SaveMode saveMode6 = SaveMode.Overwrite;
            if (!(saveMode5 != null ? !saveMode5.equals(saveMode6) : saveMode6 != null) && this.tableExists()) {
                WriteOperationType writeOperationType3 = operation;
                WriteOperationType writeOperationType4 = WriteOperationType.INSERT_OVERWRITE_TABLE;
                if (writeOperationType3 == null ? writeOperationType4 != null : !((Object)((Object)writeOperationType3)).equals((Object)writeOperationType4)) {
                    this.log().warn((Object)new StringBuilder(84).append("hoodie table at ").append(tablePath).append(" already exists. Deleting existing data & overwriting with new data.").toString());
                    fs.delete(tablePath, true);
                    this.tableExists_$eq(false);
                }
            }
        } else {
            SaveMode saveMode7 = mode;
            SaveMode saveMode8 = SaveMode.Append;
            if (saveMode7 == null ? saveMode8 != null : !saveMode7.equals(saveMode8)) {
                throw new HoodieException(new StringBuilder(54).append("Append is the only save mode applicable for ").append(operation.toString()).append(" operation").toString());
            }
        }
    }

    private boolean metaSync(SparkSession spark, HoodieConfig hoodieConfig, Path basePath, StructType schema) {
        block4: {
            BoxedUnit boxedUnit;
            boolean hiveSyncEnabled = new StringOps(Predef$.MODULE$.augmentString(hoodieConfig.getStringOrDefault(HiveSyncConfigHolder.HIVE_SYNC_ENABLED))).toBoolean();
            boolean metaSyncEnabled = new StringOps(Predef$.MODULE$.augmentString(hoodieConfig.getStringOrDefault(HoodieSyncConfig.META_SYNC_ENABLED))).toBoolean();
            ObjectRef syncClientToolClassSet = ObjectRef.create((Object)((scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$)));
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])hoodieConfig.getString(DataSourceWriteOptions$.MODULE$.META_SYNC_CLIENT_TOOL_CLASS_NAME()).split(","))).foreach((Function1 & Serializable & scala.Serializable)syncClass -> (scala.collection.mutable.Set)((scala.collection.mutable.Set)syncClientToolClassSet$1.elem).$plus$eq(syncClass));
            if (hiveSyncEnabled) {
                metaSyncEnabled = true;
                boxedUnit = ((scala.collection.mutable.Set)syncClientToolClassSet.elem).$plus$eq((Object)HiveSyncTool.class.getName());
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            if (metaSyncEnabled) {
                FileSystem fs = basePath.getFileSystem(spark.sessionState().newHadoopConf());
                String baseFileFormat = hoodieConfig.getStringOrDefault(HoodieSyncConfig.META_SYNC_BASE_FILE_FORMAT);
                TypedProperties properties = TypedProperties.fromMap(hoodieConfig.getProps());
                properties.put(HiveSyncConfigHolder.HIVE_SYNC_SCHEMA_STRING_LENGTH_THRESHOLD.key(), spark.sessionState().conf().getConf(StaticSQLConf$.MODULE$.SCHEMA_STRING_LENGTH_THRESHOLD()).toString());
                properties.put(HoodieSyncConfig.META_SYNC_SPARK_VERSION.key(), package$.MODULE$.SPARK_VERSION());
                properties.put(HoodieSyncConfig.META_SYNC_USE_FILE_LISTING_FROM_METADATA.key(), hoodieConfig.getBoolean(HoodieMetadataConfig.ENABLE));
                ListBuffer metaSyncExceptions = new ListBuffer();
                ((scala.collection.mutable.Set)syncClientToolClassSet.elem).foreach((Function1 & Serializable & scala.Serializable)impl -> {
                    Object object;
                    try {
                        SyncUtilHelpers.runHoodieMetaSync(impl.trim(), properties, fs.getConf(), fs, basePath.toString(), baseFileFormat);
                        object = BoxedUnit.UNIT;
                    }
                    catch (HoodieException e) {
                        MODULE$.log().info((Object)new StringBuilder(37).append("SyncTool class ").append(impl.trim()).append(" failed with exception").toString(), (Throwable)e);
                        object = BoxesRunTime.boxToBoolean((boolean)JavaConversions$.MODULE$.deprecated$u0020bufferAsJavaList((Buffer)metaSyncExceptions).add(e));
                    }
                    return object;
                });
                if (metaSyncExceptions.nonEmpty()) {
                    throw SyncUtilHelpers.getExceptionFromList(JavaConversions$.MODULE$.deprecated$u0020bufferAsJavaList((Buffer)metaSyncExceptions));
                }
            }
            if (!metaSyncEnabled) break block4;
            this.getHiveTableNames(hoodieConfig).foreach((Function1 & Serializable & scala.Serializable)name -> {
                HoodieSparkSqlWriter$.$anonfun$metaSync$3(hoodieConfig, spark, name);
                return BoxedUnit.UNIT;
            });
        }
        return true;
    }

    private List<String> getHiveTableNames(HoodieConfig hoodieConfig) {
        .colon.colon colon2;
        String tableName = hoodieConfig.getStringOrDefault(DataSourceWriteOptions$.MODULE$.HIVE_TABLE());
        String tableType = hoodieConfig.getStringOrDefault(DataSourceWriteOptions$.MODULE$.TABLE_TYPE());
        if (tableType.equals(DataSourceWriteOptions$.MODULE$.COW_TABLE_TYPE_OPT_VAL())) {
            colon2 = new .colon.colon((Object)tableName, (List)Nil$.MODULE$);
        } else {
            String roSuffix = hoodieConfig.getBooleanOrDefault(DataSourceWriteOptions$.MODULE$.HIVE_SKIP_RO_SUFFIX_FOR_READ_OPTIMIZED_TABLE()) ? "" : "_ro";
            colon2 = new .colon.colon((Object)new StringBuilder(0).append(tableName).append(roSuffix).toString(), (List)new .colon.colon((Object)new StringBuilder(3).append(tableName).append("_rt").toString(), (List)Nil$.MODULE$));
        }
        return colon2;
    }

    private Tuple3<Object, Option<String>, Option<String>> commitAndPerformPostOperations(SparkSession spark, StructType schema, HoodieWriteResult writeResult, scala.collection.immutable.Map<String, String> parameters, SparkRDDWriteClient<?> client, HoodieTableConfig tableConfig, JavaSparkContext jsc, HoodieSparkSqlWriter.TableInstantInfo tableInstantInfo, scala.Option<BiConsumer<HoodieTableMetaClient, HoodieCommitMetadata>> extraPreCommitFn) {
        Tuple3 tuple3;
        if (writeResult.getWriteStatuses().rdd().filter((Function1 & Serializable & scala.Serializable)ws -> BoxesRunTime.boxToBoolean((boolean)ws.hasErrors())).count() == 0L) {
            this.log().info((Object)"Proceeding to commit the write.");
            scala.collection.immutable.Map metaMap = (scala.collection.immutable.Map)parameters.filter((Function1 & Serializable & scala.Serializable)kv -> BoxesRunTime.boxToBoolean((boolean)HoodieSparkSqlWriter$.$anonfun$commitAndPerformPostOperations$2(parameters, kv)));
            boolean commitSuccess = client.commit(tableInstantInfo.instantTime(), writeResult.getWriteStatuses(), Option.of(new HashMap(JavaConversions$.MODULE$.mapAsJavaMap((Map)metaMap))), tableInstantInfo.commitActionType(), writeResult.getPartitionToReplaceFileIds(), Option.ofNullable(extraPreCommitFn.orNull(Predef$.MODULE$.$conforms())));
            if (commitSuccess) {
                this.log().info((Object)new StringBuilder(19).append("Commit ").append(tableInstantInfo.instantTime()).append(" successful!").toString());
            } else {
                this.log().info((Object)new StringBuilder(15).append("Commit ").append(tableInstantInfo.instantTime()).append(" failed!").toString());
            }
            boolean asyncCompactionEnabled = this.isAsyncCompactionEnabled(client, tableConfig, parameters, jsc.hadoopConfiguration());
            Option compactionInstant = asyncCompactionEnabled ? client.scheduleCompaction(Option.of(new HashMap(JavaConversions$.MODULE$.mapAsJavaMap((Map)metaMap)))) : Option.empty();
            this.log().info((Object)new StringBuilder(24).append("Compaction Scheduled is ").append(compactionInstant).toString());
            boolean asyncClusteringEnabled = this.isAsyncClusteringEnabled(client, parameters);
            Option clusteringInstant = asyncClusteringEnabled ? client.scheduleClustering(Option.of(new HashMap(JavaConversions$.MODULE$.mapAsJavaMap((Map)metaMap)))) : Option.empty();
            this.log().info((Object)new StringBuilder(24).append("Clustering Scheduled is ").append(clusteringInstant).toString());
            boolean metaSyncSuccess = this.metaSync(spark, HoodieWriterUtils$.MODULE$.convertMapToHoodieConfig(parameters), tableInstantInfo.basePath(), schema);
            this.log().info((Object)new StringBuilder(30).append("Is Async Compaction Enabled ? ").append(asyncCompactionEnabled).toString());
            tuple3 = new Tuple3((Object)BoxesRunTime.boxToBoolean((commitSuccess && metaSyncSuccess ? 1 : 0) != 0), compactionInstant, clusteringInstant);
        } else {
            this.log().error((Object)new StringBuilder(19).append((Object)tableInstantInfo.operation()).append(" failed with errors").toString());
            if (this.log().isTraceEnabled()) {
                this.log().trace((Object)"Printing out the top 100 errors");
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])writeResult.getWriteStatuses().rdd().filter((Function1 & Serializable & scala.Serializable)ws -> BoxesRunTime.boxToBoolean((boolean)ws.hasErrors())).take(100))).foreach((Function1 & Serializable & scala.Serializable)ws -> {
                    HoodieSparkSqlWriter$.$anonfun$commitAndPerformPostOperations$4(ws);
                    return BoxedUnit.UNIT;
                });
            }
            tuple3 = new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)false), Option.empty(), Option.empty());
        }
        return tuple3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isAsyncCompactionEnabled(SparkRDDWriteClient<?> client, HoodieTableConfig tableConfig, scala.collection.immutable.Map<String, String> parameters, Configuration configuration) {
        this.log().info((Object)new StringBuilder(33).append("Config.inlineCompactionEnabled ? ").append(client.getConfig().inlineCompactionEnabled()).toString());
        if (!this.asyncCompactionTriggerFnDefined()) return false;
        if (client.getConfig().inlineCompactionEnabled()) return false;
        if (!parameters.get((Object)DataSourceWriteOptions$.MODULE$.ASYNC_COMPACT_ENABLE().key()).exists((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)HoodieSparkSqlWriter$.$anonfun$isAsyncCompactionEnabled$1(r)))) return false;
        HoodieTableType hoodieTableType = tableConfig.getTableType();
        HoodieTableType hoodieTableType2 = HoodieTableType.MERGE_ON_READ;
        if (hoodieTableType != null) {
            if (!((Object)((Object)hoodieTableType)).equals((Object)hoodieTableType2)) return false;
            return true;
        }
        if (hoodieTableType2 == null) return true;
        return false;
    }

    private boolean isAsyncClusteringEnabled(SparkRDDWriteClient<?> client, scala.collection.immutable.Map<String, String> parameters) {
        this.log().info((Object)new StringBuilder(32).append("Config.asyncClusteringEnabled ? ").append(client.getConfig().isAsyncClusteringEnabled()).toString());
        return this.asyncClusteringTriggerFnDefined() && !client.getConfig().inlineClusteringEnabled() && client.getConfig().isAsyncClusteringEnabled();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private HoodieTableConfig getHoodieTableConfig(SparkContext sparkContext, String tablePath, SaveMode mode, scala.Option<HoodieTableConfig> hoodieTableConfigOpt) {
        if (!this.tableExists()) return null;
        SaveMode saveMode = mode;
        SaveMode saveMode2 = SaveMode.Overwrite;
        if (saveMode == null) {
            if (saveMode2 == null) return null;
        } else if (saveMode.equals(saveMode2)) return null;
        HoodieTableConfig hoodieTableConfig = (HoodieTableConfig)hoodieTableConfigOpt.getOrElse((Function0 & Serializable & scala.Serializable)() -> HoodieTableMetaClient.builder().setConf(sparkContext.hadoopConfiguration()).setBasePath(tablePath).build().getTableConfig());
        return hoodieTableConfig;
    }

    private Tuple2<scala.collection.immutable.Map<String, String>, HoodieConfig> mergeParamsAndGetHoodieConfig(scala.collection.immutable.Map<String, String> optParams, HoodieTableConfig tableConfig, SaveMode mode) {
        scala.collection.mutable.Map mergedParams;
        scala.collection.immutable.Map<String, String> translatedOptions = DataSourceWriteOptions$.MODULE$.mayBeDerivePartitionPath(optParams);
        ObjectRef translatedOptsWithMappedTableConfig = ObjectRef.create((Object)Map$.MODULE$.empty().$plus$plus((GenTraversableOnce)translatedOptions.toMap(Predef$.MODULE$.$conforms())));
        if (tableConfig != null) {
            SaveMode saveMode = mode;
            SaveMode saveMode2 = SaveMode.Overwrite;
            if (saveMode == null ? saveMode2 != null : !saveMode.equals(saveMode2)) {
                DataSourceOptionsHelper$.MODULE$.fetchMissingWriteConfigsFromTableConfig(tableConfig, optParams).foreach((Function1 & Serializable & scala.Serializable)kv -> (scala.collection.mutable.Map)((scala.collection.mutable.Map)translatedOptsWithMappedTableConfig$1.elem).$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(kv._1()), kv._2())));
            }
        }
        if (!(mergedParams = Map$.MODULE$.empty().$plus$plus(HoodieWriterUtils$.MODULE$.parametersWithWriteDefaults((scala.collection.immutable.Map<String, String>)((scala.collection.mutable.Map)translatedOptsWithMappedTableConfig.elem).toMap(Predef$.MODULE$.$conforms())))).contains((Object)HoodieTableConfig.KEY_GENERATOR_CLASS_NAME.key()) && mergedParams.contains((Object)DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CLASS_NAME().key())) {
            mergedParams.update((Object)HoodieTableConfig.KEY_GENERATOR_CLASS_NAME.key(), mergedParams.apply((Object)DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CLASS_NAME().key()));
        }
        if (tableConfig != null) {
            SaveMode saveMode = mode;
            SaveMode saveMode3 = SaveMode.Overwrite;
            if (saveMode == null ? saveMode3 != null : !saveMode.equals(saveMode3)) {
                ((IterableLike)JavaConversions$.MODULE$.deprecated$u0020propertiesAsScalaMap((Properties)tableConfig.getProps()).filter((Function1 & Serializable & scala.Serializable)kv -> BoxesRunTime.boxToBoolean((boolean)HoodieSparkSqlWriter$.$anonfun$mergeParamsAndGetHoodieConfig$2(mergedParams, kv)))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    HoodieSparkSqlWriter$.$anonfun$mergeParamsAndGetHoodieConfig$3(mergedParams, x0$1);
                    return BoxedUnit.UNIT;
                });
            }
        }
        Object object = mergedParams.contains((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()) ? mergedParams.put((Object)"hoodie.payload.ordering.field", mergedParams.apply((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key())) : BoxedUnit.UNIT;
        scala.collection.immutable.Map params = mergedParams.toMap(Predef$.MODULE$.$conforms());
        return new Tuple2((Object)params, (Object)HoodieWriterUtils$.MODULE$.convertMapToHoodieConfig((scala.collection.immutable.Map<String, String>)params));
    }

    private scala.collection.immutable.Map<String, String> extractConfigsRelatedToTimestampBasedKeyGenerator(String keyGenerator, scala.collection.immutable.Map<String, String> params) {
        return TimestampBasedKeyGenerator.class.getCanonicalName().equals(keyGenerator) || TimestampBasedAvroKeyGenerator.class.getCanonicalName().equals(keyGenerator) ? params.filterKeys((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)HoodieTableConfig.PERSISTED_CONFIG_LIST.contains(x$1))) : Predef$.MODULE$.Map().empty();
    }

    private JavaRDD<HoodieRecord<?>> createHoodieRecordRdd(Dataset<Row> df, HoodieWriteConfig config, scala.collection.immutable.Map<String, String> parameters, String recordName, String recordNameSpace, Schema writerSchema, Schema dataFileSchema, WriteOperationType operation) {
        JavaRDD javaRDD;
        Boolean shouldDropPartitionColumns = config.getBoolean(DataSourceWriteOptions$.MODULE$.DROP_PARTITION_COLUMNS());
        KeyGenerator keyGenerator = HoodieSparkKeyGeneratorFactory.createKeyGenerator(new TypedProperties(config.getProps()));
        HoodieRecord.HoodieRecordType recordType = config.getRecordMerger().getRecordType();
        boolean shouldCombine = WriteOperationType.isInsert(operation) ? new StringOps(Predef$.MODULE$.augmentString((String)parameters.apply((Object)DataSourceWriteOptions$.MODULE$.INSERT_DROP_DUPS().key()))).toBoolean() || new StringOps(Predef$.MODULE$.augmentString((String)parameters.getOrElse((Object)HoodieWriteConfig.COMBINE_BEFORE_INSERT.key(), (Function0 & Serializable & scala.Serializable)() -> HoodieWriteConfig.COMBINE_BEFORE_INSERT.defaultValue()))).toBoolean() : (WriteOperationType.isUpsert(operation) ? new StringOps(Predef$.MODULE$.augmentString((String)parameters.getOrElse((Object)HoodieWriteConfig.COMBINE_BEFORE_UPSERT.key(), (Function0 & Serializable & scala.Serializable)() -> HoodieWriteConfig.COMBINE_BEFORE_UPSERT.defaultValue()))).toBoolean() : true);
        String dataFileSchemaStr = dataFileSchema.toString();
        this.log().debug((Object)new StringBuilder(28).append("Creating HoodieRecords (as ").append((Object)recordType).append(")").toString());
        HoodieRecord.HoodieRecordType hoodieRecordType = recordType;
        if (((Object)((Object)HoodieRecord.HoodieRecordType.AVRO)).equals((Object)hoodieRecordType)) {
            RDD<GenericRecord> avroRecords = HoodieSparkUtils$.MODULE$.createRdd(df, recordName, recordNameSpace, (scala.Option<Schema>)new Some((Object)writerSchema));
            javaRDD = avroRecords.mapPartitions((Function1 & Serializable & scala.Serializable)it -> {
                Schema dataFileSchema = new Schema.Parser().parse(dataFileSchemaStr);
                boolean consistentLogicalTimestampEnabled = new StringOps(Predef$.MODULE$.augmentString((String)parameters.getOrElse((Object)DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CONSISTENT_LOGICAL_TIMESTAMP_ENABLED().key(), (Function0 & Serializable & scala.Serializable)() -> DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CONSISTENT_LOGICAL_TIMESTAMP_ENABLED().defaultValue()))).toBoolean();
                return it.map((Function1 & Serializable & scala.Serializable)avroRecord -> {
                    HoodieRecord hoodieRecord;
                    GenericRecord processedRecord;
                    GenericRecord genericRecord = processedRecord = Predef$.MODULE$.Boolean2boolean(shouldDropPartitionColumns) ? HoodieAvroUtils.rewriteRecord(avroRecord, dataFileSchema) : avroRecord;
                    if (shouldCombine) {
                        Comparable orderingVal = (Comparable)HoodieAvroUtils.getNestedFieldVal(avroRecord, config.getString(DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD()), false, consistentLogicalTimestampEnabled);
                        hoodieRecord = DataSourceUtils.createHoodieRecord(processedRecord, orderingVal, keyGenerator.getKey((GenericRecord)avroRecord), config.getString(DataSourceWriteOptions$.MODULE$.PAYLOAD_CLASS_NAME()));
                    } else {
                        hoodieRecord = DataSourceUtils.createHoodieRecord(processedRecord, keyGenerator.getKey((GenericRecord)avroRecord), config.getString(DataSourceWriteOptions$.MODULE$.PAYLOAD_CLASS_NAME()));
                    }
                    HoodieRecord hoodieRecord2 = hoodieRecord;
                    return hoodieRecord2;
                });
            }, avroRecords.mapPartitions$default$2(), ClassTag$.MODULE$.apply(HoodieRecord.class)).toJavaRDD();
        } else if (((Object)((Object)HoodieRecord.HoodieRecordType.SPARK)).equals((Object)hoodieRecordType)) {
            SparkKeyGeneratorInterface sparkKeyGenerator = (SparkKeyGeneratorInterface)((Object)keyGenerator);
            Schema dataFileSchema2 = new Schema.Parser().parse(dataFileSchemaStr);
            StructType dataFileStructType = HoodieInternalRowUtils$.MODULE$.getCachedSchema(dataFileSchema2);
            StructType writerStructType = HoodieInternalRowUtils$.MODULE$.getCachedSchema(writerSchema);
            StructType sourceStructType = df.schema();
            javaRDD = df.queryExecution().toRdd().mapPartitions((Function1 & Serializable & scala.Serializable)it -> {
                StructType targetStructType = Predef$.MODULE$.Boolean2boolean(shouldDropPartitionColumns) ? dataFileStructType : writerStructType;
                Function1<InternalRow, UnsafeRow> targetStructTypeRowWriter = HoodieInternalRowUtils$.MODULE$.getCachedUnsafeRowWriter(sourceStructType, targetStructType, HoodieInternalRowUtils$.MODULE$.getCachedUnsafeRowWriter$default$3());
                return it.map((Function1 & Serializable & scala.Serializable)sourceRow -> {
                    UTF8String recordKey = sparkKeyGenerator.getRecordKey((InternalRow)sourceRow, sourceStructType);
                    UTF8String partitionPath = sparkKeyGenerator.getPartitionPath((InternalRow)sourceRow, sourceStructType);
                    HoodieKey key = new HoodieKey(recordKey.toString(), partitionPath.toString());
                    UnsafeRow targetRow = (UnsafeRow)targetStructTypeRowWriter.apply(sourceRow);
                    return new HoodieSparkRecord(key, (InternalRow)targetRow, dataFileStructType, false);
                });
            }, df.queryExecution().toRdd().mapPartitions$default$2(), ClassTag$.MODULE$.apply(HoodieSparkRecord.class)).toJavaRDD();
        } else {
            throw new MatchError((Object)hoodieRecordType);
        }
        return javaRDD;
    }

    public static final /* synthetic */ boolean $anonfun$write$1(String x$1) {
        return !StringUtils.isNullOrEmpty(x$1);
    }

    public static final /* synthetic */ boolean $anonfun$deduceWriterSchema$1(Schema.Field f) {
        return f.name().equalsIgnoreCase(HoodieRecord.RECORD_KEY_METADATA_FIELD);
    }

    public static final /* synthetic */ void $anonfun$resolvePartitionWildcards$2(ObjectRef fullPartitions$1, java.util.List allPartitions$1, String partition) {
        String regexPartition = new StringBuilder(6).append("^\\Q").append(partition.replace("*", "\\E.*\\Q")).append("\\E$").toString();
        fullPartitions$1.elem = (List)List$.MODULE$.concat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Traversable[]{(List)fullPartitions$1.elem, (Traversable)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(allPartitions$1).filter((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)x$9.matches(regexPartition)))}));
    }

    public static final /* synthetic */ boolean $anonfun$getPartitionColumns$2(String x$10) {
        return new StringOps(Predef$.MODULE$.augmentString(x$10)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$bootstrap$1(String x$13) {
        return !StringUtils.isNullOrEmpty(x$13);
    }

    public static final /* synthetic */ void $anonfun$metaSync$3(HoodieConfig hoodieConfig$2, SparkSession spark$2, String name) {
        block0: {
            String qualifiedTableName = String.join((CharSequence)".", hoodieConfig$2.getStringOrDefault(DataSourceWriteOptions$.MODULE$.HIVE_DATABASE()), name);
            if (!spark$2.catalog().tableExists(qualifiedTableName)) break block0;
            spark$2.catalog().refreshTable(qualifiedTableName);
        }
    }

    public static final /* synthetic */ boolean $anonfun$commitAndPerformPostOperations$2(scala.collection.immutable.Map parameters$4, Tuple2 kv) {
        return ((String)kv._1()).startsWith((String)parameters$4.apply((Object)DataSourceWriteOptions$.MODULE$.COMMIT_METADATA_KEYPREFIX().key()));
    }

    public static final /* synthetic */ void $anonfun$commitAndPerformPostOperations$5(Tuple2 kt) {
        MODULE$.log().trace((Object)new StringBuilder(15).append("Error for key: ").append(kt._1()).toString(), (Throwable)kt._2());
    }

    public static final /* synthetic */ void $anonfun$commitAndPerformPostOperations$4(WriteStatus ws) {
        block0: {
            MODULE$.log().trace((Object)"Global error :", ws.getGlobalError());
            if (ws.getErrors().size() <= 0) break block0;
            JavaConversions$.MODULE$.deprecated$u0020mapAsScalaMap(ws.getErrors()).foreach((Function1 & Serializable & scala.Serializable)kt -> {
                HoodieSparkSqlWriter$.$anonfun$commitAndPerformPostOperations$5(kt);
                return BoxedUnit.UNIT;
            });
        }
    }

    public static final /* synthetic */ boolean $anonfun$isAsyncCompactionEnabled$1(String r) {
        return new StringOps(Predef$.MODULE$.augmentString(r)).toBoolean();
    }

    public static final /* synthetic */ boolean $anonfun$mergeParamsAndGetHoodieConfig$2(scala.collection.mutable.Map mergedParams$1, Tuple2 kv) {
        return !mergedParams$1.contains(kv._1());
    }

    public static final /* synthetic */ void $anonfun$mergeParamsAndGetHoodieConfig$3(scala.collection.mutable.Map mergedParams$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String key = (String)tuple2._1();
        String value = (String)tuple2._2();
        mergedParams$1.update((Object)key, (Object)value);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private HoodieSparkSqlWriter$() {
        MODULE$ = this;
        this.CANONICALIZE_NULLABLE = ConfigProperty.key("hoodie.internal.write.schema.canonicalize.nullable").defaultValue(BoxesRunTime.boxToBoolean((boolean)true));
        this.SQL_MERGE_INTO_WRITES = ConfigProperty.key("hoodie.internal.sql.merge.into.writes").defaultValue(BoxesRunTime.boxToBoolean((boolean)false));
        this.SPARK_STREAMING_BATCH_ID = "hoodie.internal.spark.streaming.batch.id";
        this.log = LogManager.getLogger(this.getClass());
        this.tableExists = false;
        this.asyncCompactionTriggerFnDefined = false;
        this.asyncClusteringTriggerFnDefined = false;
    }
}

