/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.HoodieSparkSqlWriter$;
import org.apache.hudi.HoodieStreamingSink$;
import org.apache.hudi.async.AsyncClusteringService;
import org.apache.hudi.async.AsyncCompactService;
import org.apache.hudi.async.SparkStreamingAsyncClusteringService;
import org.apache.hudi.async.SparkStreamingAsyncCompactService;
import org.apache.hudi.client.BaseHoodieWriteClient;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.WriteConcurrencyMode;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.marker.MarkerType;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.ClusteringUtils;
import org.apache.hudi.common.util.CommitUtils;
import org.apache.hudi.common.util.CompactionUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieCorruptedDataException;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.TableNotFoundException;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.connector.catalog.TableCapability;
import org.apache.spark.sql.execution.streaming.Sink;
import org.apache.spark.sql.execution.streaming.StreamExecution$;
import org.apache.spark.sql.streaming.OutputMode;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple6;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\t}g\u0001\u0002\u001d:\u0001\u0001C\u0001b\u0017\u0001\u0003\u0002\u0003\u0006I\u0001\u0018\u0005\tA\u0002\u0011\t\u0011)A\u0005C\"Aq\u000e\u0001B\u0001B\u0003%\u0001\u000f\u0003\u0005z\u0001\t\u0005\t\u0015!\u0003{\u0011\u0019y\b\u0001\"\u0001\u0002\u0002!I\u0011q\u0002\u0001A\u0002\u0013%\u0011\u0011\u0003\u0005\n\u00033\u0001\u0001\u0019!C\u0005\u00037A\u0001\"a\n\u0001A\u0003&\u00111\u0003\u0005\n\u0003c\u0001!\u0019!C\u0005\u0003gA\u0001\"!\u0011\u0001A\u0003%\u0011Q\u0007\u0005\n\u0003\u0007\u0002!\u0019!C\u0005\u0003\u000bB\u0001\"!\u0014\u0001A\u0003%\u0011q\t\u0005\n\u0003\u001f\u0002\u0001\u0019!C\u0005\u0003#B\u0011\"!\u001a\u0001\u0001\u0004%I!a\u001a\t\u0011\u0005-\u0004\u0001)Q\u0005\u0003'B\u0011\"!\u001c\u0001\u0005\u0004%I!a\u001c\t\u0011\u0005]\u0004\u0001)A\u0005\u0003cB\u0011\"!\u001f\u0001\u0005\u0004%I!!\u0005\t\u0011\u0005m\u0004\u0001)A\u0005\u0003'A\u0011\"! \u0001\u0005\u0004%I!a \t\u0011\u0005\u001d\u0005\u0001)A\u0005\u0003\u0003C\u0011\"!#\u0001\u0001\u0004%I!a \t\u0013\u0005-\u0005\u00011A\u0005\n\u00055\u0005\u0002CAI\u0001\u0001\u0006K!!!\t\u0013\u0005M\u0005\u00011A\u0005\n\u0005}\u0004\"CAK\u0001\u0001\u0007I\u0011BAL\u0011!\tY\n\u0001Q!\n\u0005\u0005\u0005\"CAO\u0001\t\u0007I\u0011BAP\u0011!\t9\u000b\u0001Q\u0001\n\u0005\u0005\u0006bCAU\u0001\u0001\u0007\t\u0019!C\u0005\u0003WC1\"!/\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002<\"Y\u0011q\u0018\u0001A\u0002\u0003\u0005\u000b\u0015BAW\u0011-\t\t\r\u0001a\u0001\u0002\u0004%I!a1\t\u0017\u0005-\u0007\u00011AA\u0002\u0013%\u0011Q\u001a\u0005\f\u0003#\u0004\u0001\u0019!A!B\u0013\t)\rC\u0005\u0002T\u0002\u0001\r\u0011\"\u0003\u0002V\"I\u0011q \u0001A\u0002\u0013%!\u0011\u0001\u0005\t\u0003_\u0004\u0001\u0015)\u0003\u0002X\"I!q\u0002\u0001A\u0002\u0013%!\u0011\u0003\u0005\n\u00057\u0001\u0001\u0019!C\u0005\u0005;A\u0001B!\t\u0001A\u0003&!1\u0003\u0005\b\u0005G\u0001A\u0011\tB\u0013\u0011\u001d\u0011Y\u0005\u0001C\u0005\u0005\u001bBqA!\u0015\u0001\t\u0003\u0012\u0019\u0006C\u0004\u0003V\u0001!IAa\u0016\t\u000f\t=\u0005\u0001\"\u0005\u0003\u0012\"9!q\u0014\u0001\u0005\u0012\t\u0005\u0006b\u0002BX\u0001\u0011%!\u0011\u0017\u0005\b\u0005o\u0003A\u0011\u0002B]\u000f\u001d\u0011\u0019-\u000fE\u0001\u0005\u000b4a\u0001O\u001d\t\u0002\t\u001d\u0007BB@4\t\u0003\u0011y\rC\u0005\u0003RN\u0012\r\u0011\"\u0001\u0003T\"A!\u0011\\\u001a!\u0002\u0013\u0011)\u000eC\u0005\u0003\\N\n\t\u0011\"\u0003\u0003^\n\u0019\u0002j\\8eS\u0016\u001cFO]3b[&twmU5oW*\u0011!hO\u0001\u0005QV$\u0017N\u0003\u0002={\u00051\u0011\r]1dQ\u0016T\u0011AP\u0001\u0004_J<7\u0001A\n\u0005\u0001\u0005KU\u000b\u0005\u0002C\u000f6\t1I\u0003\u0002E\u000b\u0006!A.\u00198h\u0015\u00051\u0015\u0001\u00026bm\u0006L!\u0001S\"\u0003\r=\u0013'.Z2u!\tQ5+D\u0001L\u0015\taU*A\u0005tiJ,\u0017-\\5oO*\u0011ajT\u0001\nKb,7-\u001e;j_:T!\u0001U)\u0002\u0007M\fHN\u0003\u0002Sw\u0005)1\u000f]1sW&\u0011Ak\u0013\u0002\u0005'&t7\u000e\u0005\u0002W36\tqKC\u0001Y\u0003\u0015\u00198-\u00197b\u0013\tQvK\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0006tc2\u001cuN\u001c;fqR\u0004\"!\u00180\u000e\u0003=K!aX(\u0003\u0015M\u000bFjQ8oi\u0016DH/A\u0004paRLwN\\:\u0011\t\tLG\u000e\u001c\b\u0003G\u001e\u0004\"\u0001Z,\u000e\u0003\u0015T!AZ \u0002\rq\u0012xn\u001c;?\u0013\tAw+\u0001\u0004Qe\u0016$WMZ\u0005\u0003U.\u00141!T1q\u0015\tAw\u000b\u0005\u0002c[&\u0011an\u001b\u0002\u0007'R\u0014\u0018N\\4\u0002!A\f'\u000f^5uS>t7i\u001c7v[:\u001c\bcA9wY:\u0011!\u000f\u001e\b\u0003INL\u0011\u0001W\u0005\u0003k^\u000bq\u0001]1dW\u0006<W-\u0003\u0002xq\n\u00191+Z9\u000b\u0005U<\u0016AC8viB,H/T8eKB\u001110`\u0007\u0002y*\u0011AjT\u0005\u0003}r\u0014!bT;uaV$Xj\u001c3f\u0003\u0019a\u0014N\\5u}QQ\u00111AA\u0004\u0003\u0013\tY!!\u0004\u0011\u0007\u0005\u0015\u0001!D\u0001:\u0011\u0015YV\u00011\u0001]\u0011\u0015\u0001W\u00011\u0001b\u0011\u0015yW\u00011\u0001q\u0011\u0015IX\u00011\u0001{\u0003Ya\u0017\r^3ti\u000e{W.\\5ui\u0016$')\u0019;dQ&#WCAA\n!\r1\u0016QC\u0005\u0004\u0003/9&\u0001\u0002'p]\u001e\f!\u0004\\1uKN$8i\\7nSR$X\r\u001a\"bi\u000eD\u0017\nZ0%KF$B!!\b\u0002$A\u0019a+a\b\n\u0007\u0005\u0005rK\u0001\u0003V]&$\b\"CA\u0013\u000f\u0005\u0005\t\u0019AA\n\u0003\rAH%M\u0001\u0018Y\u0006$Xm\u001d;D_6l\u0017\u000e\u001e;fI\n\u000bGo\u00195JI\u0002B3\u0001CA\u0016!\r1\u0016QF\u0005\u0004\u0003_9&\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0002\u00071|w-\u0006\u0002\u00026A!\u0011qGA\u001f\u001b\t\tIDC\u0002\u0002<m\nQ\u0001\\8hi)LA!a\u0010\u0002:\t1Aj\\4hKJ\fA\u0001\\8hA\u0005IA/\u00192mKB\u000bG\u000f[\u000b\u0003\u0003\u000f\u0002BAVA%Y&\u0019\u00111J,\u0003\r=\u0003H/[8o\u0003)!\u0018M\u00197f!\u0006$\b\u000eI\u0001\u000b[\u0016$\u0018m\u00117jK:$XCAA*!\u00151\u0016\u0011JA+!\u0011\t9&!\u0019\u000e\u0005\u0005e#\u0002BA.\u0003;\nQ\u0001^1cY\u0016T1!a\u0018:\u0003\u0019\u0019w.\\7p]&!\u00111MA-\u0005UAun\u001c3jKR\u000b'\r\\3NKR\f7\t\\5f]R\fa\"\\3uC\u000ec\u0017.\u001a8u?\u0012*\u0017\u000f\u0006\u0003\u0002\u001e\u0005%\u0004\"CA\u0013\u001d\u0005\u0005\t\u0019AA*\u0003-iW\r^1DY&,g\u000e\u001e\u0011\u0002\u0011I,GO]=D]R,\"!!\u001d\u0011\u0007Y\u000b\u0019(C\u0002\u0002v]\u00131!\u00138u\u0003%\u0011X\r\u001e:z\u0007:$\b%A\bsKR\u0014\u00180\u00138uKJ4\u0018\r\\'t\u0003A\u0011X\r\u001e:z\u0013:$XM\u001d<bY6\u001b\b%A\tjO:|'/\u001a$bS2,GMQ1uG\",\"!!!\u0011\u0007Y\u000b\u0019)C\u0002\u0002\u0006^\u0013qAQ8pY\u0016\fg.\u0001\njO:|'/\u001a$bS2,GMQ1uG\"\u0004\u0013!K5t\u0003NLhnY\"p[B\f7\r^8s'\u0016\u0014h/[2f'\",H\u000fZ8x]\u0006\u0013gn\u001c:nC2d\u00170A\u0017jg\u0006\u001b\u0018P\\2D_6\u0004\u0018m\u0019;peN+'O^5dKNCW\u000f\u001e3po:\f%M\\8s[\u0006dG._0%KF$B!!\b\u0002\u0010\"I\u0011QE\f\u0002\u0002\u0003\u0007\u0011\u0011Q\u0001+SN\f5/\u001f8d\u0007>l\u0007/Y2u_J\u001cVM\u001d<jG\u0016\u001c\u0006.\u001e;e_^t\u0017I\u00198pe6\fG\u000e\\=!\u0003)J7/Q:z]\u000e\u001cE.^:uKJLgnZ*feZL7-Z*ikR$wn\u001e8BE:|'/\\1mYf\fa&[:Bgft7m\u00117vgR,'/\u001b8h'\u0016\u0014h/[2f'\",H\u000fZ8x]\u0006\u0013gn\u001c:nC2d\u0017p\u0018\u0013fcR!\u0011QDAM\u0011%\t)CGA\u0001\u0002\u0004\t\t)A\u0016jg\u0006\u001b\u0018P\\2DYV\u001cH/\u001a:j]\u001e\u001cVM\u001d<jG\u0016\u001c\u0006.\u001e;e_^t\u0017I\u00198pe6\fG\u000e\\=!\u0003\u0011iw\u000eZ3\u0016\u0005\u0005\u0005\u0006cA/\u0002$&\u0019\u0011QU(\u0003\u0011M\u000bg/Z'pI\u0016\fQ!\\8eK\u0002\nQ#Y:z]\u000e\u001cu.\u001c9bGR|'oU3sm&\u001cW-\u0006\u0002\u0002.B!\u0011qVA[\u001b\t\t\tLC\u0002\u00024f\nQ!Y:z]\u000eLA!a.\u00022\n\u0019\u0012i]=oG\u000e{W\u000e]1diN+'O^5dK\u0006I\u0012m]=oG\u000e{W\u000e]1di>\u00148+\u001a:wS\u000e,w\fJ3r)\u0011\ti\"!0\t\u0013\u0005\u0015r$!AA\u0002\u00055\u0016AF1ts:\u001c7i\\7qC\u000e$xN]*feZL7-\u001a\u0011\u0002-\u0005\u001c\u0018P\\2DYV\u001cH/\u001a:j]\u001e\u001cVM\u001d<jG\u0016,\"!!2\u0011\t\u0005=\u0016qY\u0005\u0005\u0003\u0013\f\tL\u0001\fBgft7m\u00117vgR,'/\u001b8h'\u0016\u0014h/[2f\u0003i\t7/\u001f8d\u00072,8\u000f^3sS:<7+\u001a:wS\u000e,w\fJ3r)\u0011\ti\"a4\t\u0013\u0005\u0015\"%!AA\u0002\u0005\u0015\u0017aF1ts:\u001c7\t\\;ti\u0016\u0014\u0018N\\4TKJ4\u0018nY3!\u0003-9(/\u001b;f\u00072LWM\u001c;\u0016\u0005\u0005]\u0007#\u0002,\u0002J\u0005e\u0007\u0007BAn\u0003W\u0004b!!8\u0002d\u0006\u001dXBAAp\u0015\r\t\t/O\u0001\u0007G2LWM\u001c;\n\t\u0005\u0015\u0018q\u001c\u0002\u0014'B\f'o\u001b*E\t^\u0013\u0018\u000e^3DY&,g\u000e\u001e\t\u0005\u0003S\fY\u000f\u0004\u0001\u0005\u0017\u00055h%!A\u0001\u0002\u000b\u0005\u0011\u0011\u001f\u0002\u0004?\u0012\n\u0014\u0001D<sSR,7\t\\5f]R\u0004\u0013\u0003BAz\u0003s\u00042AVA{\u0013\r\t9p\u0016\u0002\b\u001d>$\b.\u001b8h!\r1\u00161`\u0005\u0004\u0003{<&aA!os\u0006yqO]5uK\u000ec\u0017.\u001a8u?\u0012*\u0017\u000f\u0006\u0003\u0002\u001e\t\r\u0001\"CA\u0013K\u0005\u0005\t\u0019\u0001B\u0003!\u00151\u0016\u0011\nB\u0004a\u0011\u0011IA!\u0004\u0011\r\u0005u\u00171\u001dB\u0006!\u0011\tIO!\u0004\u0005\u0019\u00055(1AA\u0001\u0002\u0003\u0015\t!!=\u0002#!|w\u000eZ5f)\u0006\u0014G.Z\"p]\u001aLw-\u0006\u0002\u0003\u0014A)a+!\u0013\u0003\u0016A!\u0011q\u000bB\f\u0013\u0011\u0011I\"!\u0017\u0003#!{w\u000eZ5f)\u0006\u0014G.Z\"p]\u001aLw-A\u000bi_>$\u0017.\u001a+bE2,7i\u001c8gS\u001e|F%Z9\u0015\t\u0005u!q\u0004\u0005\n\u0003KA\u0013\u0011!a\u0001\u0005'\t!\u0003[8pI&,G+\u00192mK\u000e{gNZ5hA\u0005A\u0011\r\u001a3CCR\u001c\u0007\u000e\u0006\u0004\u0002\u001e\t\u001d\"1\u0006\u0005\b\u0005SQ\u0003\u0019AA\n\u0003\u001d\u0011\u0017\r^2i\u0013\u0012DqA!\f+\u0001\u0004\u0011y#\u0001\u0003eCR\f\u0007\u0003\u0002B\u0019\u0005\u000brAAa\r\u0003D9!!Q\u0007B!\u001d\u0011\u00119Da\u0010\u000f\t\te\"Q\b\b\u0004I\nm\u0012\"\u0001 \n\u0005qj\u0014B\u0001*<\u0013\t\u0001\u0016+\u0003\u0002v\u001f&!!q\tB%\u0005%!\u0015\r^1Ge\u0006lWM\u0003\u0002v\u001f\u0006\u0019r-\u001a;TiJ,\u0017-\\%eK:$\u0018NZ5feR!\u0011q\tB(\u0011\u0015\u00017\u00061\u0001b\u0003!!xn\u0015;sS:<G#\u00017\u0002\u000bI,GO]=\u0016\t\te#1\u000e\u000b\u0007\u00057\u0012IH! \u0015\t\tu#q\u000e\t\u0007\u0005?\u0012)G!\u001b\u000e\u0005\t\u0005$b\u0001B2/\u0006!Q\u000f^5m\u0013\u0011\u00119G!\u0019\u0003\u0007Q\u0013\u0018\u0010\u0005\u0003\u0002j\n-Da\u0002B7[\t\u0007\u0011\u0011\u001f\u0002\u0002)\"A!\u0011O\u0017\u0005\u0002\u0004\u0011\u0019(\u0001\u0002g]B)aK!\u001e\u0003^%\u0019!qO,\u0003\u0011q\u0012\u0017P\\1nKzBqAa\u001f.\u0001\u0004\t\t(A\u0001o\u0011\u001d\u0011y(\fa\u0001\u0003'\tAb^1ji&sW*\u001b7mSND3!\fBB!\u0011\u0011)Ia#\u000e\u0005\t\u001d%b\u0001BE/\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t5%q\u0011\u0002\bi\u0006LGN]3d\u0003U!(/[4hKJ\f5/\u001f8d\u0007>l\u0007/Y2u_J$B!!\b\u0003\u0014\"9\u0011\u0011\u001d\u0018A\u0002\tU\u0005\u0007\u0002BL\u00057\u0003b!!8\u0002d\ne\u0005\u0003BAu\u00057#AB!(\u0003\u0014\u0006\u0005\t\u0011!B\u0001\u0003c\u00141a\u0018\u00133\u0003Y!(/[4hKJ\f5/\u001f8d\u00072,8\u000f^3sS:<G\u0003BA\u000f\u0005GCq!!90\u0001\u0004\u0011)\u000b\r\u0003\u0003(\n-\u0006CBAo\u0003G\u0014I\u000b\u0005\u0003\u0002j\n-F\u0001\u0004BW\u0005G\u000b\t\u0011!A\u0003\u0002\u0005E(aA0%g\u0005)!/Z:fiR!\u0011Q\u0004BZ\u0011\u001d\u0011)\f\ra\u0001\u0003\u0003\u000bQAZ8sG\u0016\fAbY1o'.L\u0007OQ1uG\"$b!!!\u0003<\n}\u0006b\u0002B_c\u0001\u0007\u00111C\u0001\u0010S:\u001cw.\\5oO\n\u000bGo\u00195JI\"1!\u0011Y\u0019A\u00021\fQb\u001c9fe\u0006$\u0018n\u001c8UsB,\u0017a\u0005%p_\u0012LWm\u0015;sK\u0006l\u0017N\\4TS:\\\u0007cAA\u0003gM!1G!3V!\r1&1Z\u0005\u0004\u0005\u001b<&AB!osJ+g\r\u0006\u0002\u0003F\u0006\u00192+\u0013(L?\u000eCUiQ&Q\u001f&sEkX&F3V\u0011!Q\u001b\t\u0004\u0005\n]\u0017B\u00018D\u0003Q\u0019\u0016JT&`\u0007\"+5i\u0013)P\u0013:#vlS#ZA\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\u0005\t\u0005")
public class HoodieStreamingSink
implements Sink,
scala.Serializable {
    private final SQLContext sqlContext;
    public final Map<String, String> org$apache$hudi$HoodieStreamingSink$$options;
    private volatile long latestCommittedBatchId;
    private final Logger org$apache$hudi$HoodieStreamingSink$$log;
    private final scala.Option<String> tablePath;
    private scala.Option<HoodieTableMetaClient> metaClient;
    private final int retryCnt;
    private final long retryIntervalMs;
    private final boolean ignoreFailedBatch;
    private boolean org$apache$hudi$HoodieStreamingSink$$isAsyncCompactorServiceShutdownAbnormally;
    private boolean org$apache$hudi$HoodieStreamingSink$$isAsyncClusteringServiceShutdownAbnormally;
    private final SaveMode mode;
    private AsyncCompactService asyncCompactorService;
    private AsyncClusteringService asyncClusteringService;
    private scala.Option<SparkRDDWriteClient<?>> writeClient;
    private scala.Option<HoodieTableConfig> hoodieTableConfig;

    public static String SINK_CHECKPOINT_KEY() {
        return HoodieStreamingSink$.MODULE$.SINK_CHECKPOINT_KEY();
    }

    public String name() {
        return Sink.name$((Sink)this);
    }

    public StructType schema() {
        return Sink.schema$((Sink)this);
    }

    public Set<TableCapability> capabilities() {
        return Sink.capabilities$((Sink)this);
    }

    private long latestCommittedBatchId() {
        return this.latestCommittedBatchId;
    }

    private void latestCommittedBatchId_$eq(long x$1) {
        this.latestCommittedBatchId = x$1;
    }

    public Logger org$apache$hudi$HoodieStreamingSink$$log() {
        return this.org$apache$hudi$HoodieStreamingSink$$log;
    }

    private scala.Option<String> tablePath() {
        return this.tablePath;
    }

    private scala.Option<HoodieTableMetaClient> metaClient() {
        return this.metaClient;
    }

    private void metaClient_$eq(scala.Option<HoodieTableMetaClient> x$1) {
        this.metaClient = x$1;
    }

    private int retryCnt() {
        return this.retryCnt;
    }

    private long retryIntervalMs() {
        return this.retryIntervalMs;
    }

    private boolean ignoreFailedBatch() {
        return this.ignoreFailedBatch;
    }

    private boolean org$apache$hudi$HoodieStreamingSink$$isAsyncCompactorServiceShutdownAbnormally() {
        return this.org$apache$hudi$HoodieStreamingSink$$isAsyncCompactorServiceShutdownAbnormally;
    }

    public void org$apache$hudi$HoodieStreamingSink$$isAsyncCompactorServiceShutdownAbnormally_$eq(boolean x$1) {
        this.org$apache$hudi$HoodieStreamingSink$$isAsyncCompactorServiceShutdownAbnormally = x$1;
    }

    private boolean org$apache$hudi$HoodieStreamingSink$$isAsyncClusteringServiceShutdownAbnormally() {
        return this.org$apache$hudi$HoodieStreamingSink$$isAsyncClusteringServiceShutdownAbnormally;
    }

    public void org$apache$hudi$HoodieStreamingSink$$isAsyncClusteringServiceShutdownAbnormally_$eq(boolean x$1) {
        this.org$apache$hudi$HoodieStreamingSink$$isAsyncClusteringServiceShutdownAbnormally = x$1;
    }

    private SaveMode mode() {
        return this.mode;
    }

    private AsyncCompactService asyncCompactorService() {
        return this.asyncCompactorService;
    }

    private void asyncCompactorService_$eq(AsyncCompactService x$1) {
        this.asyncCompactorService = x$1;
    }

    private AsyncClusteringService asyncClusteringService() {
        return this.asyncClusteringService;
    }

    private void asyncClusteringService_$eq(AsyncClusteringService x$1) {
        this.asyncClusteringService = x$1;
    }

    private scala.Option<SparkRDDWriteClient<?>> writeClient() {
        return this.writeClient;
    }

    private void writeClient_$eq(scala.Option<SparkRDDWriteClient<?>> x$1) {
        this.writeClient = x$1;
    }

    private scala.Option<HoodieTableConfig> hoodieTableConfig() {
        return this.hoodieTableConfig;
    }

    private void hoodieTableConfig_$eq(scala.Option<HoodieTableConfig> x$1) {
        this.hoodieTableConfig = x$1;
    }

    public synchronized void addBatch(long batchId, Dataset<Row> data) {
        if (this.org$apache$hudi$HoodieStreamingSink$$isAsyncCompactorServiceShutdownAbnormally()) {
            throw new IllegalStateException("Async Compactor shutdown unexpectedly");
        }
        if (this.org$apache$hudi$HoodieStreamingSink$$isAsyncClusteringServiceShutdownAbnormally()) {
            this.org$apache$hudi$HoodieStreamingSink$$log().error((Object)"Async clustering service shutdown unexpectedly");
            throw new IllegalStateException("Async clustering service shutdown unexpectedly");
        }
        String queryId = this.sqlContext.sparkContext().getLocalProperty(StreamExecution$.MODULE$.QUERY_ID_KEY());
        ValidationUtils.checkArgument(queryId != null, "queryId is null");
        if (this.metaClient().isDefined() && this.canSkipBatch(batchId, JavaConversions$.MODULE$.deprecated$u0020mapAsJavaMap(this.org$apache$hudi$HoodieStreamingSink$$options).getOrDefault(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL()))) {
            this.org$apache$hudi$HoodieStreamingSink$$log().warn((Object)new StringBuilder(43).append("Skipping already completed batch ").append(batchId).append(" in query ").append(queryId).toString());
            return;
        }
        ObjectRef updatedOptions = ObjectRef.create((Object)this.org$apache$hudi$HoodieStreamingSink$$options.updated((Object)HoodieWriteConfig.MARKERS_TYPE.key(), (Object)MarkerType.DIRECT.name()));
        updatedOptions.elem = ((Map)updatedOptions.elem).updated((Object)HoodieWriteConfig.AUTO_ADJUST_LOCK_CONFIGS.key(), (Object)"true");
        updatedOptions.elem = ((Map)updatedOptions.elem).updated((Object)HoodieSparkSqlWriter$.MODULE$.SPARK_STREAMING_BATCH_ID(), (Object)((Object)BoxesRunTime.boxToLong((long)batchId)).toString());
        Try try_ = this.retry(this.retryCnt(), this.retryIntervalMs(), (Function0 & Serializable & scala.Serializable)() -> {
            Failure failure;
            boolean bl = false;
            Success success = null;
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> HoodieSparkSqlWriter$.MODULE$.write($this.sqlContext, this.mode(), (Map<String, String>)((Map)updatedOptions$1.elem), data, this.hoodieTableConfig(), this.writeClient(), (scala.Option<Function1<SparkRDDWriteClient<?>, BoxedUnit>>)new Some((Function1 & Serializable & scala.Serializable)client -> {
                this.triggerAsyncCompactor(client);
                return BoxedUnit.UNIT;
            }), (scala.Option<Function1<SparkRDDWriteClient<?>, BoxedUnit>>)new Some((Function1 & Serializable & scala.Serializable)client -> {
                this.triggerAsyncClustering(client);
                return BoxedUnit.UNIT;
            }), (scala.Option<BiConsumer<HoodieTableMetaClient, HoodieCommitMetadata>>)new Some((Object)new BiConsumer<HoodieTableMetaClient, HoodieCommitMetadata>(this, batchId){
                private final /* synthetic */ HoodieStreamingSink $outer;
                private final long batchId$1;

                public BiConsumer<HoodieTableMetaClient, HoodieCommitMetadata> andThen(BiConsumer<? super HoodieTableMetaClient, ? super HoodieCommitMetadata> x$1) {
                    return BiConsumer.super.andThen(x$1);
                }

                public void accept(HoodieTableMetaClient metaClient, HoodieCommitMetadata newCommitMetadata) {
                    String identifier = (String)this.$outer.org$apache$hudi$HoodieStreamingSink$$options.getOrElse((Object)DataSourceWriteOptions$.MODULE$.STREAMING_CHECKPOINT_IDENTIFIER().key(), (Function0 & Serializable & scala.Serializable)() -> DataSourceWriteOptions$.MODULE$.STREAMING_CHECKPOINT_IDENTIFIER().defaultValue());
                    newCommitMetadata.addMetadata(HoodieStreamingSink$.MODULE$.SINK_CHECKPOINT_KEY(), CommitUtils.getCheckpointValueAsString(identifier, String.valueOf(this.batchId$1)));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.batchId$1 = batchId$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$accept$1()}, serializedLambda);
                }
            })));
            if (try_ instanceof Success) {
                bl = true;
                success = (Success)try_;
                Tuple6 tuple6 = (Tuple6)success.value();
                if (tuple6 != null) {
                    boolean bl2 = BoxesRunTime.unboxToBoolean((Object)tuple6._1());
                    Option commitOps = (Option)tuple6._2();
                    Option compactionInstantOps = (Option)tuple6._3();
                    Option clusteringInstant = (Option)tuple6._4();
                    SparkRDDWriteClient client = (SparkRDDWriteClient)tuple6._5();
                    HoodieTableConfig tableConfig = (HoodieTableConfig)tuple6._6();
                    if (bl2) {
                        boolean bl3 = commitOps.isPresent();
                        String string = true == bl3 ? new StringBuilder(12).append(" for commit=").append(commitOps.get()).toString() : " with no new commits";
                        this.org$apache$hudi$HoodieStreamingSink$$log().info((Object)new StringBuilder(25).append("Micro batch id=").append(batchId).append(" succeeded").append((Object)string).toString());
                        this.org$apache$hudi$HoodieStreamingSink$$log().info((Object)new StringBuilder(86).append("Current value of latestCommittedBatchId: ").append(this.latestCommittedBatchId()).append(". Setting latestCommittedBatchId to batchId ").append(batchId).append(".").toString());
                        this.latestCommittedBatchId_$eq(batchId);
                        this.writeClient_$eq((scala.Option<SparkRDDWriteClient<?>>)new Some((Object)client));
                        this.hoodieTableConfig_$eq((scala.Option<HoodieTableConfig>)new Some((Object)tableConfig));
                        if (client != null) {
                            this.metaClient_$eq((scala.Option<HoodieTableMetaClient>)new Some((Object)HoodieTableMetaClient.builder().setConf($this.sqlContext.sparkContext().hadoopConfiguration()).setBasePath(client.getConfig().getBasePath()).build()));
                        }
                        if (compactionInstantOps.isPresent()) {
                            this.asyncCompactorService().enqueuePendingAsyncServiceInstant(new HoodieInstant(HoodieInstant.State.REQUESTED, "compaction", (String)compactionInstantOps.get()));
                        }
                        if (!clusteringInstant.isPresent()) return new Success((Object)new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)commitOps, (Object)compactionInstantOps));
                        this.asyncClusteringService().enqueuePendingAsyncServiceInstant(new HoodieInstant(HoodieInstant.State.REQUESTED, "replacecommit", (String)clusteringInstant.get()));
                        return new Success((Object)new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)commitOps, (Object)compactionInstantOps));
                    }
                }
            }
            if (try_ instanceof Failure) {
                Failure failure2;
                Failure failure3 = (Failure)try_;
                Throwable e = failure3.exception();
                data.sparkSession().sparkContext().getPersistentRDDs().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    RDD rDD;
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        RDD rdd = (RDD)tuple2._2();
                        try {
                            rDD = rdd.unpersist(rdd.unpersist$default$1());
                        }
                        catch (Exception t) {
                            this.org$apache$hudi$HoodieStreamingSink$$log().warn((Object)"Got excepting trying to unpersist rdd", (Throwable)t);
                            rDD = BoxedUnit.UNIT;
                        }
                    } else {
                        throw new MatchError((Object)tuple2);
                    }
                    RDD rDD2 = rDD;
                    return rDD2;
                });
                this.org$apache$hudi$HoodieStreamingSink$$log().error((Object)new StringBuilder(43).append("Micro batch id=").append(batchId).append(" threw following exception: ").toString(), e);
                if (this.ignoreFailedBatch()) {
                    this.org$apache$hudi$HoodieStreamingSink$$log().warn((Object)new StringBuilder(64).append("Ignore the exception and move on streaming as per ").append(DataSourceWriteOptions$.MODULE$.STREAMING_IGNORE_FAILED_BATCH().key()).append(" configuration").toString());
                    failure2 = new Success((Object)new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)None$.MODULE$, (Object)None$.MODULE$));
                    return failure2;
                } else {
                    if (this.retryCnt() > 1) {
                        this.org$apache$hudi$HoodieStreamingSink$$log().info((Object)new StringBuilder(39).append("Retrying the failed micro batch id=").append(batchId).append(" ...").toString());
                    }
                    failure2 = new Failure(e);
                }
                return failure2;
            }
            if (!bl) throw new MatchError((Object)try_);
            Tuple6 tuple6 = (Tuple6)success.value();
            if (tuple6 == null) throw new MatchError((Object)try_);
            boolean bl4 = BoxesRunTime.unboxToBoolean((Object)tuple6._1());
            Option commitOps = (Option)tuple6._2();
            if (false != bl4) throw new MatchError((Object)try_);
            boolean bl5 = commitOps.isPresent();
            String string = true == bl5 ? new StringBuilder(12).append(" for commit=").append(commitOps.get()).toString() : "";
            this.org$apache$hudi$HoodieStreamingSink$$log().error((Object)new StringBuilder(36).append("Micro batch id=").append(batchId).append(" ended up with errors").append((Object)string).toString());
            if (this.ignoreFailedBatch()) {
                this.org$apache$hudi$HoodieStreamingSink$$log().info((Object)new StringBuilder(61).append("Ignore the errors and move on streaming as per ").append(DataSourceWriteOptions$.MODULE$.STREAMING_IGNORE_FAILED_BATCH().key()).append(" configuration").toString());
                failure = new Success((Object)new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)None$.MODULE$, (Object)None$.MODULE$));
                return failure;
            } else {
                if (this.retryCnt() > 1) {
                    this.org$apache$hudi$HoodieStreamingSink$$log().warn((Object)new StringBuilder(39).append("Retrying the failed micro batch id=").append(batchId).append(" ...").toString());
                }
                failure = new Failure((Throwable)new HoodieCorruptedDataException(new StringBuilder(36).append("Micro batch id=").append(batchId).append(" ended up with errors").toString()));
            }
            return failure;
        });
        if (try_ instanceof Failure) {
            BoxedUnit boxedUnit;
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            if (!this.ignoreFailedBatch()) {
                this.org$apache$hudi$HoodieStreamingSink$$log().error((Object)new StringBuilder(86).append("Micro batch id=").append(batchId).append(" threw following expections,").append("aborting streaming app to avoid data loss: ").toString(), e);
                this.org$apache$hudi$HoodieStreamingSink$$reset(true);
                System.exit(1);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (try_ instanceof Success) {
            this.org$apache$hudi$HoodieStreamingSink$$log().info((Object)new StringBuilder(25).append("Micro batch id=").append(batchId).append(" succeeded").toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(try_);
        }
    }

    private scala.Option<String> getStreamIdentifier(Map<String, String> options) {
        WriteConcurrencyMode writeConcurrencyMode = WriteConcurrencyMode.valueOf(JavaConversions$.MODULE$.deprecated$u0020mapAsJavaMap(options).getOrDefault(HoodieWriteConfig.WRITE_CONCURRENCY_MODE.key(), HoodieWriteConfig.WRITE_CONCURRENCY_MODE.defaultValue()));
        WriteConcurrencyMode writeConcurrencyMode2 = WriteConcurrencyMode.SINGLE_WRITER;
        return !(writeConcurrencyMode != null ? !((Object)((Object)writeConcurrencyMode)).equals((Object)writeConcurrencyMode2) : writeConcurrencyMode2 != null) ? new Some(options.getOrElse((Object)DataSourceWriteOptions$.MODULE$.STREAMING_CHECKPOINT_IDENTIFIER().key(), (Function0 & Serializable & scala.Serializable)() -> DataSourceWriteOptions$.MODULE$.STREAMING_CHECKPOINT_IDENTIFIER().defaultValue())) : options.get((Object)DataSourceWriteOptions$.MODULE$.STREAMING_CHECKPOINT_IDENTIFIER().key());
    }

    public String toString() {
        return new StringBuilder(21).append("HoodieStreamingSink[").append(this.org$apache$hudi$HoodieStreamingSink$$options.apply((Object)"path")).append("]").toString();
    }

    private <T> Try<T> retry(int n, long waitInMillis, Function0<Try<T>> fn) {
        Success success;
        block2: {
            Try try_;
            while (true) {
                if ((try_ = (Try)fn.apply()) instanceof Success) {
                    Success success2;
                    success = success2 = (Success)try_;
                    break block2;
                }
                if (n <= 1) break;
                Thread.sleep(waitInMillis);
                waitInMillis *= 2L;
                --n;
            }
            this.org$apache$hudi$HoodieStreamingSink$$reset(false);
            success = try_;
        }
        return success;
    }

    public void triggerAsyncCompactor(SparkRDDWriteClient<?> client) {
        block0: {
            if (this.asyncCompactorService() != null) break block0;
            this.org$apache$hudi$HoodieStreamingSink$$log().info((Object)"Triggering Async compaction !!");
            this.asyncCompactorService_$eq(new SparkStreamingAsyncCompactService(new HoodieSparkEngineContext(new JavaSparkContext(this.sqlContext.sparkContext())), client));
            this.asyncCompactorService().start(new Function<Boolean, Boolean>(this){
                private final /* synthetic */ HoodieStreamingSink $outer;

                public <V> Function<V, Boolean> compose(Function<? super V, ? extends Boolean> x$1) {
                    return Function.super.compose(x$1);
                }

                public <V> Function<Boolean, V> andThen(Function<? super Boolean, ? extends V> x$1) {
                    return Function.super.andThen(x$1);
                }

                public Boolean apply(Boolean errored) {
                    this.$outer.org$apache$hudi$HoodieStreamingSink$$log().info((Object)new StringBuilder(36).append("Async Compactor shutdown. Errored ? ").append(errored).toString());
                    this.$outer.org$apache$hudi$HoodieStreamingSink$$isAsyncCompactorServiceShutdownAbnormally_$eq(Predef$.MODULE$.Boolean2boolean(errored));
                    this.$outer.org$apache$hudi$HoodieStreamingSink$$reset(false);
                    this.$outer.org$apache$hudi$HoodieStreamingSink$$log().info((Object)"Done resetting write client.");
                    return Predef$.MODULE$.boolean2Boolean(true);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(this){
                private final /* synthetic */ HoodieStreamingSink $outer;

                public void run() {
                    this.$outer.org$apache$hudi$HoodieStreamingSink$$reset(true);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }));
            HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(this.sqlContext.sparkContext().hadoopConfiguration()).setBasePath(client.getConfig().getBasePath()).build();
            List<HoodieInstant> pendingInstants = CompactionUtils.getPendingCompactionInstantTimes(metaClient);
            JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(pendingInstants).foreach((Function1 & Serializable & scala.Serializable)h -> {
                HoodieStreamingSink.$anonfun$triggerAsyncCompactor$1(this, h);
                return BoxedUnit.UNIT;
            });
        }
    }

    public void triggerAsyncClustering(SparkRDDWriteClient<?> client) {
        block0: {
            if (this.asyncClusteringService() != null) break block0;
            this.org$apache$hudi$HoodieStreamingSink$$log().info((Object)"Triggering async clustering!");
            this.asyncClusteringService_$eq(new SparkStreamingAsyncClusteringService(new HoodieSparkEngineContext(new JavaSparkContext(this.sqlContext.sparkContext())), client));
            this.asyncClusteringService().start(new Function<Boolean, Boolean>(this){
                private final /* synthetic */ HoodieStreamingSink $outer;

                public <V> Function<V, Boolean> compose(Function<? super V, ? extends Boolean> x$1) {
                    return Function.super.compose(x$1);
                }

                public <V> Function<Boolean, V> andThen(Function<? super Boolean, ? extends V> x$1) {
                    return Function.super.andThen(x$1);
                }

                public Boolean apply(Boolean errored) {
                    this.$outer.org$apache$hudi$HoodieStreamingSink$$log().info((Object)new StringBuilder(45).append("Async clustering service shutdown. Errored ? ").append(errored).toString());
                    this.$outer.org$apache$hudi$HoodieStreamingSink$$isAsyncClusteringServiceShutdownAbnormally_$eq(Predef$.MODULE$.Boolean2boolean(errored));
                    this.$outer.org$apache$hudi$HoodieStreamingSink$$reset(false);
                    return Predef$.MODULE$.boolean2Boolean(true);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(this){
                private final /* synthetic */ HoodieStreamingSink $outer;

                public void run() {
                    this.$outer.org$apache$hudi$HoodieStreamingSink$$reset(true);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }));
            HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(this.sqlContext.sparkContext().hadoopConfiguration()).setBasePath(client.getConfig().getBasePath()).build();
            List<HoodieInstant> pendingInstants = ClusteringUtils.getPendingClusteringInstantTimes(metaClient);
            JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(pendingInstants).foreach((Function1 & Serializable & scala.Serializable)h -> {
                HoodieStreamingSink.$anonfun$triggerAsyncClustering$1(this, h);
                return BoxedUnit.UNIT;
            });
        }
    }

    public synchronized void org$apache$hudi$HoodieStreamingSink$$reset(boolean force) {
        block2: {
            if (this.asyncCompactorService() != null) {
                this.asyncCompactorService().shutdown(force);
                this.asyncCompactorService_$eq(null);
            }
            if (this.asyncClusteringService() != null) {
                this.asyncClusteringService().shutdown(force);
                this.asyncClusteringService_$eq(null);
            }
            if (!this.writeClient().isDefined()) break block2;
            ((BaseHoodieWriteClient)this.writeClient().get()).close();
            this.writeClient_$eq(Option$.MODULE$.empty());
        }
    }

    private boolean canSkipBatch(long incomingBatchId, String operationType) {
        boolean bl;
        if (!DataSourceWriteOptions$.MODULE$.DELETE_OPERATION_OPT_VAL().equals(operationType)) {
            String identifier = (String)this.org$apache$hudi$HoodieStreamingSink$$options.getOrElse((Object)DataSourceWriteOptions$.MODULE$.STREAMING_CHECKPOINT_IDENTIFIER().key(), (Function0 & Serializable & scala.Serializable)() -> DataSourceWriteOptions$.MODULE$.STREAMING_CHECKPOINT_IDENTIFIER().defaultValue());
            Option<String> lastCheckpoint = CommitUtils.getValidCheckpointForCurrentWriter(((HoodieTableMetaClient)this.metaClient().get()).getActiveTimeline().getWriteTimeline(), HoodieStreamingSink$.MODULE$.SINK_CHECKPOINT_KEY(), identifier);
            if (lastCheckpoint.isPresent()) {
                this.latestCommittedBatchId_$eq(new StringOps(Predef$.MODULE$.augmentString(lastCheckpoint.get())).toLong());
            }
            bl = this.latestCommittedBatchId() >= incomingBatchId;
        } else {
            bl = false;
        }
        return bl;
    }

    private final scala.Option liftedTree1$1() {
        Some some;
        try {
            some = new Some((Object)HoodieTableMetaClient.builder().setConf(this.sqlContext.sparkContext().hadoopConfiguration()).setBasePath((String)this.tablePath().get()).build());
        }
        catch (TableNotFoundException tableNotFoundException) {
            this.org$apache$hudi$HoodieStreamingSink$$log().warn((Object)"Ignore TableNotFoundException as it is first microbatch.");
            some = Option$.MODULE$.empty();
        }
        return some;
    }

    public static final /* synthetic */ void $anonfun$triggerAsyncCompactor$1(HoodieStreamingSink $this, HoodieInstant h) {
        $this.asyncCompactorService().enqueuePendingAsyncServiceInstant(h);
    }

    public static final /* synthetic */ void $anonfun$triggerAsyncClustering$1(HoodieStreamingSink $this, HoodieInstant h) {
        $this.asyncClusteringService().enqueuePendingAsyncServiceInstant(h);
    }

    public HoodieStreamingSink(SQLContext sqlContext, Map<String, String> options, Seq<String> partitionColumns, OutputMode outputMode) {
        this.sqlContext = sqlContext;
        this.org$apache$hudi$HoodieStreamingSink$$options = options;
        Sink.$init$((Sink)this);
        this.latestCommittedBatchId = -1L;
        this.org$apache$hudi$HoodieStreamingSink$$log = LogManager.getLogger(HoodieStreamingSink.class);
        this.tablePath = options.get((Object)"path");
        if (this.tablePath().isEmpty() || this.tablePath().get() == null) {
            throw new HoodieException("'path'  must be specified.");
        }
        this.metaClient = this.liftedTree1$1();
        this.retryCnt = new StringOps(Predef$.MODULE$.augmentString(JavaConversions$.MODULE$.deprecated$u0020mapAsJavaMap(options).getOrDefault(DataSourceWriteOptions$.MODULE$.STREAMING_RETRY_CNT().key(), DataSourceWriteOptions$.MODULE$.STREAMING_RETRY_CNT().defaultValue()))).toInt();
        this.retryIntervalMs = new StringOps(Predef$.MODULE$.augmentString(JavaConversions$.MODULE$.deprecated$u0020mapAsJavaMap(options).getOrDefault(DataSourceWriteOptions$.MODULE$.STREAMING_RETRY_INTERVAL_MS().key(), DataSourceWriteOptions$.MODULE$.STREAMING_RETRY_INTERVAL_MS().defaultValue()))).toLong();
        this.ignoreFailedBatch = new StringOps(Predef$.MODULE$.augmentString(JavaConversions$.MODULE$.deprecated$u0020mapAsJavaMap(options).getOrDefault(DataSourceWriteOptions$.MODULE$.STREAMING_IGNORE_FAILED_BATCH().key(), DataSourceWriteOptions$.MODULE$.STREAMING_IGNORE_FAILED_BATCH().defaultValue()))).toBoolean();
        this.org$apache$hudi$HoodieStreamingSink$$isAsyncCompactorServiceShutdownAbnormally = false;
        this.org$apache$hudi$HoodieStreamingSink$$isAsyncClusteringServiceShutdownAbnormally = false;
        OutputMode outputMode2 = outputMode;
        OutputMode outputMode3 = OutputMode.Append();
        this.mode = !(outputMode2 != null ? !outputMode2.equals(outputMode3) : outputMode3 != null) ? SaveMode.Append : SaveMode.Overwrite;
        this.writeClient = Option$.MODULE$.empty();
        this.hoodieTableConfig = Option$.MODULE$.empty();
    }
}

