/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.io.Serializable;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.AvroProjection;
import org.apache.hudi.AvroProjection$;
import org.apache.hudi.HoodieBaseRelation;
import org.apache.hudi.HoodieConversionUtils$;
import org.apache.hudi.HoodieMergeOnReadFileSplit;
import org.apache.hudi.HoodieTableSchema;
import org.apache.hudi.HoodieTableState;
import org.apache.hudi.LogFileIterator;
import org.apache.hudi.common.engine.EngineType;
import org.apache.hudi.common.model.HoodieAvroIndexedRecord;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordCompatibilityInterface;
import org.apache.hudi.common.model.HoodieRecordMerger;
import org.apache.hudi.common.model.HoodieSparkRecord;
import org.apache.hudi.common.util.HoodieRecordUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.org.apache.spark.sql.avro.HoodieAvroSchemaConverters;
import org.apache.hudi.org.apache.spark.sql.avro.HoodieAvroSerializer;
import org.apache.spark.sql.HoodieCatalystExpressionUtils$;
import org.apache.spark.sql.HoodieInternalRowUtils$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005f\u0001\u0002\u000e\u001c\u0001\tB\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001\u000b\u0005\tW\u0001\u0011\t\u0011)A\u0005Y!AA\b\u0001B\u0001B\u0003%Q\b\u0003\u0005A\u0001\t\u0005\t\u0015!\u0003>\u0011!\t\u0005A!A!\u0002\u0013\u0011\u0005\u0002C#\u0001\u0005\u0003\u0005\u000b\u0011\u0002$\t\u000b9\u0003A\u0011A(\t\u000f]\u0003!\u0019!C\u00051\"1q\f\u0001Q\u0001\neCq\u0001\u0019\u0001C\u0002\u0013%\u0011\r\u0003\u0004l\u0001\u0001\u0006IA\u0019\u0005\bY\u0002\u0011\r\u0011\"\u0003n\u0011\u0019!\b\u0001)A\u0005]\"9Q\u000f\u0001b\u0001\n\u00131\bBB@\u0001A\u0003%q\u000fC\u0005\u0002\u0002\u0001\u0011\r\u0011\"\u0003\u0002\u0004!A\u00111\u0002\u0001!\u0002\u0013\t)\u0001C\u0005\u0002\u000e\u0001\u0011\r\u0011\"\u0003\u0002\u0010!A\u00111\u0006\u0001!\u0002\u0013\t\t\u0002C\u0005\u0002.\u0001\u0011\r\u0011\"\u0003\u00020!A\u0011\u0011\t\u0001!\u0002\u0013\t\t\u0004C\u0004\u0002D\u0001!\t%!\u0012\t\u000f\u00055\u0003\u0001\"\u0003\u0002F!9\u0011Q\f\u0001\u0005\n\u0005}\u0003bBA9\u0001\u0011%\u00111\u000f\u0002\u001a%\u0016\u001cwN\u001d3NKJ<\u0017N\\4GS2,\u0017\n^3sCR|'O\u0003\u0002\u001d;\u0005!\u0001.\u001e3j\u0015\tqr$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002A\u0005\u0019qN]4\u0004\u0001M\u0011\u0001a\t\t\u0003I\u0015j\u0011aG\u0005\u0003Mm\u0011q\u0002T8h\r&dW-\u0013;fe\u0006$xN]\u0001\u0006gBd\u0017\u000e\u001e\t\u0003I%J!AK\u000e\u00035!{w\u000eZ5f\u001b\u0016\u0014x-Z(o%\u0016\fGMR5mKN\u0003H.\u001b;\u0002\u001d\t\f7/\u001a$jY\u0016\u0014V-\u00193feB\u0011Q&\u000f\b\u0003]]r!a\f\u001c\u000f\u0005A*dBA\u00195\u001b\u0005\u0011$BA\u001a\"\u0003\u0019a$o\\8u}%\t\u0001%\u0003\u0002\u001f?%\u0011A$H\u0005\u0003qm\t!\u0003S8pI&,')Y:f%\u0016d\u0017\r^5p]&\u0011!h\u000f\u0002\u000f\u0005\u0006\u001cXMR5mKJ+\u0017\rZ3s\u0015\tA4$\u0001\u0006eCR\f7k\u00195f[\u0006\u0004\"\u0001\n \n\u0005}Z\"!\u0005%p_\u0012LW\rV1cY\u0016\u001c6\r[3nC\u0006q!/Z9vSJ,GmU2iK6\f\u0017A\u0003;bE2,7\u000b^1uKB\u0011AeQ\u0005\u0003\tn\u0011\u0001\u0003S8pI&,G+\u00192mKN#\u0018\r^3\u0002\r\r|gNZ5h!\t9E*D\u0001I\u0015\tI%*\u0001\u0003d_:4'BA&\u001e\u0003\u0019A\u0017\rZ8pa&\u0011Q\n\u0013\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0002\rqJg.\u001b;?)\u001d\u0001\u0016KU*U+Z\u0003\"\u0001\n\u0001\t\u000b\u001d:\u0001\u0019\u0001\u0015\t\u000b-:\u0001\u0019\u0001\u0017\t\u000bq:\u0001\u0019A\u001f\t\u000b\u0001;\u0001\u0019A\u001f\t\u000b\u0005;\u0001\u0019\u0001\"\t\u000b\u0015;\u0001\u0019\u0001$\u00021\t\f7/\u001a$jY\u0016\u0014V-\u00193fe\u00063(o\\*dQ\u0016l\u0017-F\u0001Z!\tQV,D\u0001\\\u0015\taV$\u0001\u0003bmJ|\u0017B\u00010\\\u0005\u0019\u00196\r[3nC\u0006I\"-Y:f\r&dWMU3bI\u0016\u0014\u0018I\u001e:p'\u000eDW-\\1!\u0003)\u0019XM]5bY&TXM]\u000b\u0002EB\u00111-[\u0007\u0002I*\u0011A,\u001a\u0006\u0003M\u001e\f1a]9m\u0015\tAW$A\u0003ta\u0006\u00148.\u0003\u0002kI\n!\u0002j\\8eS\u0016\feO]8TKJL\u0017\r\\5{KJ\f1b]3sS\u0006d\u0017N_3sA\u0005\u0001\"/Z2pe\u0012\\U-_(sI&t\u0017\r\\\u000b\u0002]B\u0011qN]\u0007\u0002a*\t\u0011/A\u0003tG\u0006d\u0017-\u0003\u0002ta\n\u0019\u0011J\u001c;\u0002#I,7m\u001c:e\u0017\u0016LxJ\u001d3j]\u0006d\u0007%\u0001\rsKF,\u0018N]3e'\u000eDW-\\1Qe>TWm\u0019;j_:,\u0012a\u001e\t\u0003qvl\u0011!\u001f\u0006\u0003un\f1\"\u001a=qe\u0016\u001c8/[8og*\u0011A0Z\u0001\tG\u0006$\u0018\r\\=ti&\u0011a0\u001f\u0002\u0011+:\u001c\u0018MZ3Qe>TWm\u0019;j_:\f\u0011D]3rk&\u0014X\rZ*dQ\u0016l\u0017\r\u0015:pU\u0016\u001cG/[8oA\u0005a\"/Z9vSJ,GmU2iK6\f\u0017I\u001e:p!J|'.Z2uS>tWCAA\u0003!\r!\u0013qA\u0005\u0004\u0003\u0013Y\"AD!we>\u0004&o\u001c6fGRLwN\\\u0001\u001ee\u0016\fX/\u001b:fIN\u001b\u0007.Z7b\u0003Z\u0014x\u000e\u0015:pU\u0016\u001cG/[8oA\u0005\u0001\"-Y:f\r&dW-\u0013;fe\u0006$xN]\u000b\u0003\u0003#\u0001b!a\u0005\u0002\u001e\u0005\rb\u0002BA\u000b\u00033q1!MA\f\u0013\u0005\t\u0018bAA\u000ea\u00069\u0001/Y2lC\u001e,\u0017\u0002BA\u0010\u0003C\u0011\u0001\"\u0013;fe\u0006$xN\u001d\u0006\u0004\u00037\u0001\b\u0003BA\u0013\u0003Oi\u0011a_\u0005\u0004\u0003SY(aC%oi\u0016\u0014h.\u00197S_^\f\u0011CY1tK\u001aKG.Z%uKJ\fGo\u001c:!\u00031\u0011XmY8sI6+'oZ3s+\t\t\t\u0004\u0005\u0003\u00024\u0005uRBAA\u001b\u0015\u0011\t9$!\u000f\u0002\u000b5|G-\u001a7\u000b\u0007\u0005m2$\u0001\u0004d_6lwN\\\u0005\u0005\u0003\u007f\t)D\u0001\nI_>$\u0017.\u001a*fG>\u0014H-T3sO\u0016\u0014\u0018!\u0004:fG>\u0014H-T3sO\u0016\u0014\b%A\u0005e_\"\u000b7OT3yiV\u0011\u0011q\t\t\u0004_\u0006%\u0013bAA&a\n9!i\\8mK\u0006t\u0017a\u00045bg:+\u0007\u0010^%oi\u0016\u0014h.\u00197)\u0007]\t\t\u0006\u0005\u0003\u0002T\u0005eSBAA+\u0015\r\t9\u0006]\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA.\u0003+\u0012q\u0001^1jYJ,7-A\u0005tKJL\u0017\r\\5{KR!\u0011\u0011MA7!\u0011\t\u0019'!\u001b\u000e\u0005\u0005\u0015$bAA47\u00069q-\u001a8fe&\u001c\u0017\u0002BA6\u0003K\u0012QbR3oKJL7MU3d_J$\u0007bBA81\u0001\u0007\u00111E\u0001\rGV\u0014(k\\<SK\u000e|'\u000fZ\u0001\u0006[\u0016\u0014x-\u001a\u000b\u0007\u0003k\nY(a \u0011\u000b=\f9(a\t\n\u0007\u0005e\u0004O\u0001\u0004PaRLwN\u001c\u0005\b\u0003{J\u0002\u0019AA\u0012\u0003\u0019\u0019WO\u001d*po\"9\u0011\u0011Q\rA\u0002\u0005\r\u0015!\u00038foJ+7m\u001c:ea\u0011\t))a$\u0011\r\u0005M\u0012qQAF\u0013\u0011\tI)!\u000e\u0003\u0019!{w\u000eZ5f%\u0016\u001cwN\u001d3\u0011\t\u00055\u0015q\u0012\u0007\u0001\t1\t\t*a \u0002\u0002\u0003\u0005)\u0011AAJ\u0005\ryF\u0005N\t\u0005\u0003+\u000bY\nE\u0002p\u0003/K1!!'q\u0005\u001dqu\u000e\u001e5j]\u001e\u00042a\\AO\u0013\r\ty\n\u001d\u0002\u0004\u0003:L\b")
public class RecordMergingFileIterator
extends LogFileIterator {
    private final HoodieBaseRelation.BaseFileReader baseFileReader;
    private final Schema baseFileReaderAvroSchema;
    private final HoodieAvroSerializer serializer;
    private final int recordKeyOrdinal;
    private final UnsafeProjection requiredSchemaProjection;
    private final AvroProjection requiredSchemaAvroProjection;
    private final Iterator<InternalRow> baseFileIterator;
    private final HoodieRecordMerger recordMerger;

    private Schema baseFileReaderAvroSchema() {
        return this.baseFileReaderAvroSchema;
    }

    private HoodieAvroSerializer serializer() {
        return this.serializer;
    }

    private int recordKeyOrdinal() {
        return this.recordKeyOrdinal;
    }

    private UnsafeProjection requiredSchemaProjection() {
        return this.requiredSchemaProjection;
    }

    private AvroProjection requiredSchemaAvroProjection() {
        return this.requiredSchemaAvroProjection;
    }

    private Iterator<InternalRow> baseFileIterator() {
        return this.baseFileIterator;
    }

    private HoodieRecordMerger recordMerger() {
        return this.recordMerger;
    }

    @Override
    public boolean doHasNext() {
        return this.hasNextInternal();
    }

    private boolean hasNextInternal() {
        boolean bl;
        block3: {
            while (this.baseFileIterator().hasNext()) {
                InternalRow curRow = (InternalRow)this.baseFileIterator().next();
                String curKey = curRow.getString(this.recordKeyOrdinal());
                scala.Option<HoodieRecord<?>> updatedRecordOpt = this.removeLogRecord(curKey);
                if (updatedRecordOpt.isEmpty()) {
                    this.nextRecord_$eq(this.requiredSchemaProjection().apply(curRow));
                    bl = true;
                } else {
                    scala.Option<InternalRow> mergedRecordOpt = this.merge(curRow, (HoodieRecord)updatedRecordOpt.get());
                    if (mergedRecordOpt.isEmpty()) continue;
                    this.nextRecord_$eq(mergedRecordOpt.get());
                    bl = true;
                }
                break block3;
            }
            bl = super.doHasNext();
        }
        return bl;
    }

    private GenericRecord serialize(InternalRow curRowRecord) {
        return (GenericRecord)this.serializer().serialize(curRowRecord);
    }

    private scala.Option<InternalRow> merge(InternalRow curRow, HoodieRecord<?> newRecord) {
        scala.Option option;
        HoodieRecord.HoodieRecordType hoodieRecordType = this.recordMerger().getRecordType();
        if (((Object)((Object)HoodieRecord.HoodieRecordType.SPARK)).equals((Object)hoodieRecordType)) {
            HoodieSparkRecord curRecord = new HoodieSparkRecord(curRow, this.baseFileReader.schema());
            Option<Pair<HoodieRecord, Schema>> result = this.recordMerger().merge(curRecord, this.baseFileReaderAvroSchema(), newRecord, this.logFileReaderAvroSchema(), this.payloadProps());
            option = HoodieConversionUtils$.MODULE$.toScalaOption(result).map((Function1 & Serializable & scala.Serializable)r -> {
                StructType schema = HoodieInternalRowUtils$.MODULE$.getCachedSchema((Schema)r.getRight());
                UnsafeProjection projection = HoodieInternalRowUtils$.MODULE$.getCachedUnsafeProjection(schema, this.structTypeSchema());
                return projection.apply((InternalRow)((HoodieRecord)r.getLeft()).getData());
            });
        } else {
            HoodieAvroIndexedRecord curRecord = new HoodieAvroIndexedRecord((IndexedRecord)this.serialize(curRow));
            Option<Pair<HoodieRecord, Schema>> result = this.recordMerger().merge(curRecord, this.baseFileReaderAvroSchema(), newRecord, this.logFileReaderAvroSchema(), this.payloadProps());
            option = HoodieConversionUtils$.MODULE$.toScalaOption(result).map((Function1 & Serializable & scala.Serializable)r -> {
                GenericRecord avroRecord = (GenericRecord)((HoodieRecord)((HoodieRecordCompatibilityInterface)r.getLeft()).toIndexedRecord((Schema)r.getRight(), this.payloadProps()).get()).getData();
                return this.deserialize((GenericRecord)this.requiredSchemaAvroProjection().apply(avroRecord));
            });
        }
        return option;
    }

    public RecordMergingFileIterator(HoodieMergeOnReadFileSplit split, HoodieBaseRelation.BaseFileReader baseFileReader, HoodieTableSchema dataSchema, HoodieTableSchema requiredSchema, HoodieTableState tableState, Configuration config) {
        this.baseFileReader = baseFileReader;
        super(split, dataSchema, requiredSchema, tableState, config);
        HoodieAvroSchemaConverters qual$1 = this.sparkAdapter().getAvroSchemaConverters();
        StructType x$1 = baseFileReader.schema();
        boolean x$2 = false;
        String x$3 = "record";
        String x$4 = qual$1.toAvroType$default$4();
        this.baseFileReaderAvroSchema = qual$1.toAvroType((DataType)x$1, x$2, x$3, x$4);
        this.serializer = this.sparkAdapter().createAvroSerializer((DataType)baseFileReader.schema(), this.baseFileReaderAvroSchema(), false);
        this.recordKeyOrdinal = baseFileReader.schema().fieldIndex(tableState.recordKeyField());
        this.requiredSchemaProjection = HoodieCatalystExpressionUtils$.MODULE$.generateUnsafeProjection(baseFileReader.schema(), this.structTypeSchema());
        this.requiredSchemaAvroProjection = AvroProjection$.MODULE$.create(this.avroSchema());
        this.baseFileIterator = baseFileReader.apply((PartitionedFile)split.dataFile().get());
        this.recordMerger = HoodieRecordUtils.createRecordMerger(tableState.tablePath(), EngineType.SPARK, (List)JavaConverters$.MODULE$.seqAsJavaListConverter(tableState.recordMergerImpls()).asJava(), tableState.recordMergerStrategy());
    }
}

