/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.avro.model;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.util.ConcurrentModificationException;
import java.util.List;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;
import org.apache.hudi.avro.model.HoodieIndexPartitionInfo;

@AvroGenerated
public class HoodieIndexPlan
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = -4401591453419062824L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"HoodieIndexPlan\",\"namespace\":\"org.apache.hudi.avro.model\",\"fields\":[{\"name\":\"version\",\"type\":[\"int\",\"null\"],\"default\":1},{\"name\":\"indexPartitionInfos\",\"type\":[\"null\",{\"type\":\"array\",\"items\":{\"type\":\"record\",\"name\":\"HoodieIndexPartitionInfo\",\"fields\":[{\"name\":\"version\",\"type\":[\"int\",\"null\"],\"default\":1},{\"name\":\"metadataPartitionPath\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"default\":null},{\"name\":\"indexUptoInstant\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"default\":null}]}}],\"default\":null}]}");
    private static SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<HoodieIndexPlan> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<HoodieIndexPlan> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    private Integer version;
    private List<HoodieIndexPartitionInfo> indexPartitionInfos;
    private static final DatumWriter<HoodieIndexPlan> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<HoodieIndexPlan> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<HoodieIndexPlan> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<HoodieIndexPlan> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<HoodieIndexPlan> createDecoder(SchemaStore resolver2) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver2);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static HoodieIndexPlan fromByteBuffer(ByteBuffer b) throws IOException {
        return (HoodieIndexPlan)((Object)DECODER.decode(b));
    }

    public HoodieIndexPlan() {
    }

    public HoodieIndexPlan(Integer version, List<HoodieIndexPartitionInfo> indexPartitionInfos) {
        this.version = version;
        this.indexPartitionInfos = indexPartitionInfos;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.version;
            }
            case 1: {
                return this.indexPartitionInfos;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.version = (Integer)value$;
                break;
            }
            case 1: {
                this.indexPartitionInfos = (List)value$;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer value) {
        this.version = value;
    }

    public List<HoodieIndexPartitionInfo> getIndexPartitionInfos() {
        return this.indexPartitionInfos;
    }

    public void setIndexPartitionInfos(List<HoodieIndexPartitionInfo> value) {
        this.indexPartitionInfos = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(HoodieIndexPlan other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        if (this.version == null) {
            out.writeIndex(1);
            out.writeNull();
        } else {
            out.writeIndex(0);
            out.writeInt(this.version.intValue());
        }
        if (this.indexPartitionInfos == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            long size0 = this.indexPartitionInfos.size();
            out.writeArrayStart();
            out.setItemCount(size0);
            long actualSize0 = 0L;
            for (HoodieIndexPartitionInfo e0 : this.indexPartitionInfos) {
                ++actualSize0;
                out.startItem();
                e0.customEncode(out);
            }
            out.writeArrayEnd();
            if (actualSize0 != size0) {
                throw new ConcurrentModificationException("Array-size written was " + size0 + ", but element count was " + actualSize0 + ".");
            }
        }
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            if (in.readIndex() != 0) {
                in.readNull();
                this.version = null;
            } else {
                this.version = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.indexPartitionInfos = null;
            } else {
                GenericData.Array ga0;
                long size0 = in.readArrayStart();
                GenericData.Array a0 = this.indexPartitionInfos;
                if (a0 == null) {
                    this.indexPartitionInfos = a0 = new GenericData.Array((int)size0, (Schema)SCHEMA$.getField("indexPartitionInfos").schema().getTypes().get(1));
                } else {
                    a0.clear();
                }
                GenericData.Array array = ga0 = a0 instanceof GenericData.Array ? (GenericData.Array)a0 : null;
                while (0L < size0) {
                    while (size0 != 0L) {
                        HoodieIndexPartitionInfo e0;
                        HoodieIndexPartitionInfo hoodieIndexPartitionInfo = e0 = ga0 != null ? (HoodieIndexPartitionInfo)((Object)ga0.peek()) : null;
                        if (e0 == null) {
                            e0 = new HoodieIndexPartitionInfo();
                        }
                        e0.customDecode(in);
                        a0.add(e0);
                        --size0;
                    }
                    size0 = in.arrayNext();
                }
            }
        } else {
            block6: for (int i = 0; i < 2; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        if (in.readIndex() != 0) {
                            in.readNull();
                            this.version = null;
                            continue block6;
                        }
                        this.version = in.readInt();
                        continue block6;
                    }
                    case 1: {
                        GenericData.Array ga0;
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.indexPartitionInfos = null;
                            continue block6;
                        }
                        long size0 = in.readArrayStart();
                        GenericData.Array a0 = this.indexPartitionInfos;
                        if (a0 == null) {
                            this.indexPartitionInfos = a0 = new GenericData.Array((int)size0, (Schema)SCHEMA$.getField("indexPartitionInfos").schema().getTypes().get(1));
                        } else {
                            a0.clear();
                        }
                        GenericData.Array array = ga0 = a0 instanceof GenericData.Array ? (GenericData.Array)a0 : null;
                        while (0L < size0) {
                            while (size0 != 0L) {
                                HoodieIndexPartitionInfo e0;
                                HoodieIndexPartitionInfo hoodieIndexPartitionInfo = e0 = ga0 != null ? (HoodieIndexPartitionInfo)((Object)ga0.peek()) : null;
                                if (e0 == null) {
                                    e0 = new HoodieIndexPartitionInfo();
                                }
                                e0.customDecode(in);
                                a0.add(e0);
                                --size0;
                            }
                            size0 = in.arrayNext();
                        }
                        continue block6;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<HoodieIndexPlan>
    implements RecordBuilder<HoodieIndexPlan> {
        private Integer version;
        private List<HoodieIndexPartitionInfo> indexPartitionInfos;

        private Builder() {
            super(SCHEMA$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.version)) {
                this.version = (Integer)this.data().deepCopy(this.fields()[0].schema(), (Object)other.version);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], other.indexPartitionInfos)) {
                this.indexPartitionInfos = (List)this.data().deepCopy(this.fields()[1].schema(), other.indexPartitionInfos);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
        }

        private Builder(HoodieIndexPlan other) {
            super(SCHEMA$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.version)) {
                this.version = (Integer)this.data().deepCopy(this.fields()[0].schema(), (Object)other.version);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.indexPartitionInfos)) {
                this.indexPartitionInfos = (List)this.data().deepCopy(this.fields()[1].schema(), (Object)other.indexPartitionInfos);
                this.fieldSetFlags()[1] = true;
            }
        }

        public Integer getVersion() {
            return this.version;
        }

        public Builder setVersion(Integer value) {
            this.validate(this.fields()[0], value);
            this.version = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasVersion() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearVersion() {
            this.version = null;
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public List<HoodieIndexPartitionInfo> getIndexPartitionInfos() {
            return this.indexPartitionInfos;
        }

        public Builder setIndexPartitionInfos(List<HoodieIndexPartitionInfo> value) {
            this.validate(this.fields()[1], value);
            this.indexPartitionInfos = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasIndexPartitionInfos() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearIndexPartitionInfos() {
            this.indexPartitionInfos = null;
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public HoodieIndexPlan build() {
            try {
                HoodieIndexPlan record = new HoodieIndexPlan();
                record.version = this.fieldSetFlags()[0] ? this.version : (Integer)this.defaultValue(this.fields()[0]);
                record.indexPartitionInfos = this.fieldSetFlags()[1] ? this.indexPartitionInfos : (List)this.defaultValue(this.fields()[1]);
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

