/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.clustering.plan.strategy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.hudi.avro.model.HoodieClusteringGroup;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.BaseFile;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieClusteringConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.cluster.strategy.PartitionAwareClusteringPlanStrategy;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.api.java.JavaRDD;

public class SparkSizeBasedClusteringPlanStrategy<T>
extends PartitionAwareClusteringPlanStrategy<T, JavaRDD<HoodieRecord<T>>, JavaRDD<HoodieKey>, JavaRDD<WriteStatus>> {
    private static final Logger LOG = LogManager.getLogger(SparkSizeBasedClusteringPlanStrategy.class);

    public SparkSizeBasedClusteringPlanStrategy(HoodieTable table, HoodieEngineContext engineContext, HoodieWriteConfig writeConfig) {
        super(table, engineContext, writeConfig);
    }

    @Override
    protected Stream<HoodieClusteringGroup> buildClusteringGroupsForPartition(String partitionPath, List<FileSlice> fileSlices) {
        HoodieWriteConfig writeConfig = this.getWriteConfig();
        ArrayList fileSliceGroups = new ArrayList();
        ArrayList<FileSlice> currentGroup = new ArrayList<FileSlice>();
        ArrayList<FileSlice> sortedFileSlices = new ArrayList<FileSlice>(fileSlices);
        sortedFileSlices.sort((o1, o2) -> (int)((o2.getBaseFile().isPresent() ? o2.getBaseFile().get().getFileSize() : writeConfig.getParquetMaxFileSize()) - (o1.getBaseFile().isPresent() ? o1.getBaseFile().get().getFileSize() : writeConfig.getParquetMaxFileSize())));
        long totalSizeSoFar = 0L;
        for (FileSlice currentSlice : sortedFileSlices) {
            long currentSize;
            long l = currentSize = currentSlice.getBaseFile().isPresent() ? currentSlice.getBaseFile().get().getFileSize() : writeConfig.getParquetMaxFileSize();
            if (totalSizeSoFar + currentSize > writeConfig.getClusteringMaxBytesInGroup() && !currentGroup.isEmpty()) {
                int numOutputGroups = this.getNumberOfOutputFileGroups(totalSizeSoFar, writeConfig.getClusteringTargetFileMaxBytes());
                LOG.info((Object)("Adding one clustering group " + totalSizeSoFar + " max bytes: " + writeConfig.getClusteringMaxBytesInGroup() + " num input slices: " + currentGroup.size() + " output groups: " + numOutputGroups));
                fileSliceGroups.add(Pair.of(currentGroup, numOutputGroups));
                currentGroup = new ArrayList();
                totalSizeSoFar = 0L;
            }
            currentGroup.add(currentSlice);
            totalSizeSoFar += currentSize;
        }
        if (!currentGroup.isEmpty()) {
            int numOutputGroups = this.getNumberOfOutputFileGroups(totalSizeSoFar, writeConfig.getClusteringTargetFileMaxBytes());
            LOG.info((Object)("Adding final clustering group " + totalSizeSoFar + " max bytes: " + writeConfig.getClusteringMaxBytesInGroup() + " num input slices: " + currentGroup.size() + " output groups: " + numOutputGroups));
            fileSliceGroups.add(Pair.of(currentGroup, numOutputGroups));
        }
        return fileSliceGroups.stream().map(fileSliceGroup -> HoodieClusteringGroup.newBuilder().setSlices(SparkSizeBasedClusteringPlanStrategy.getFileSliceInfo((List)fileSliceGroup.getLeft())).setNumOutputFileGroups((Integer)fileSliceGroup.getRight()).setMetrics(this.buildMetrics((List)fileSliceGroup.getLeft())).build());
    }

    @Override
    protected Map<String, String> getStrategyParams() {
        HashMap<String, String> params = new HashMap<String, String>();
        if (!StringUtils.isNullOrEmpty(this.getWriteConfig().getClusteringSortColumns())) {
            params.put(HoodieClusteringConfig.PLAN_STRATEGY_SORT_COLUMNS.key(), this.getWriteConfig().getClusteringSortColumns());
        }
        return params;
    }

    @Override
    protected Stream<FileSlice> getFileSlicesEligibleForClustering(String partition) {
        return super.getFileSlicesEligibleForClustering(partition).filter(slice -> slice.getBaseFile().map(BaseFile::getFileSize).orElse(0L) < this.getWriteConfig().getClusteringSmallFileLimit());
    }

    private int getNumberOfOutputFileGroups(long groupSize, long targetFileSize) {
        return (int)Math.ceil((double)groupSize / (double)targetFileSize);
    }
}

