/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.clustering.run.strategy;

import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.client.clustering.run.strategy.MultipleSparkJobExecutionStrategy;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.ConsistentHashingNode;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieClusteringException;
import org.apache.hudi.execution.bulkinsert.RDDConsistentBucketPartitioner;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.commit.SparkBulkInsertHelper;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;

public class SparkConsistentBucketClusteringExecutionStrategy<T extends HoodieRecordPayload<T>>
extends MultipleSparkJobExecutionStrategy<T> {
    private static final Logger LOG = LogManager.getLogger(SparkConsistentBucketClusteringExecutionStrategy.class);

    public SparkConsistentBucketClusteringExecutionStrategy(HoodieTable table, HoodieEngineContext engineContext, HoodieWriteConfig writeConfig) {
        super(table, engineContext, writeConfig);
    }

    @Override
    public HoodieData<WriteStatus> performClusteringWithRecordsAsRow(Dataset<Row> inputRecords, int numOutputGroups, String instantTime, Map<String, String> strategyParams, Schema schema, List<HoodieFileGroupId> fileGroupIdList, boolean shouldPreserveHoodieMetadata, Map<String, String> extraMetadata) {
        throw new HoodieClusteringException("Not implement yet");
    }

    @Override
    public HoodieData<WriteStatus> performClusteringWithRecordsRDD(HoodieData<HoodieRecord<T>> inputRecords, int numOutputGroups, String instantTime, Map<String, String> strategyParams, Schema schema, List<HoodieFileGroupId> fileGroupIdList, boolean preserveHoodieMetadata, Map<String, String> extraMetadata) {
        LOG.info((Object)("Starting clustering for a group, parallelism:" + numOutputGroups + " commit:" + instantTime));
        TypedProperties props = this.getWriteConfig().getProps();
        props.put(HoodieWriteConfig.AUTO_COMMIT_ENABLE.key(), Boolean.FALSE.toString());
        HoodieWriteConfig newConfig = HoodieWriteConfig.newBuilder().withProps(props).build();
        RDDConsistentBucketPartitioner partitioner = new RDDConsistentBucketPartitioner(this.getHoodieTable(), strategyParams, preserveHoodieMetadata);
        try {
            List<ConsistentHashingNode> nodes = ConsistentHashingNode.fromJsonString(extraMetadata.get("clustering.group.child.node"));
            partitioner.addHashingChildrenNodes(extraMetadata.get("clustering.group.partition"), nodes);
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to add hashing children nodes", (Throwable)e);
            throw new HoodieClusteringException("Failed to add hashing children nodes", e);
        }
        return SparkBulkInsertHelper.newInstance().bulkInsert(inputRecords, instantTime, this.getHoodieTable(), newConfig, false, partitioner, true, numOutputGroups);
    }
}

