/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.clustering.run.strategy;

import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.hudi.HoodieDatasetBulkInsertHelper;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.client.clustering.run.strategy.MultipleSparkJobExecutionStrategy;
import org.apache.hudi.common.config.HoodieStorageConfig;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.io.CreateHandleFactory;
import org.apache.hudi.io.WriteHandleFactory;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.commit.SparkBulkInsertHelper;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;

public class SparkSortAndSizeExecutionStrategy<T>
extends MultipleSparkJobExecutionStrategy<T> {
    private static final Logger LOG = LogManager.getLogger(SparkSortAndSizeExecutionStrategy.class);

    public SparkSortAndSizeExecutionStrategy(HoodieTable table, HoodieEngineContext engineContext, HoodieWriteConfig writeConfig) {
        super(table, engineContext, writeConfig);
    }

    @Override
    public HoodieData<WriteStatus> performClusteringWithRecordsAsRow(Dataset<Row> inputRecords, int numOutputGroups, String instantTime, Map<String, String> strategyParams, Schema schema, List<HoodieFileGroupId> fileGroupIdList, boolean shouldPreserveHoodieMetadata, Map<String, String> extraMetadata) {
        LOG.info((Object)("Starting clustering for a group, parallelism:" + numOutputGroups + " commit:" + instantTime));
        HoodieWriteConfig newConfig = HoodieWriteConfig.newBuilder().withBulkInsertParallelism(numOutputGroups).withProps(this.getWriteConfig().getProps()).build();
        newConfig.setValue(HoodieStorageConfig.PARQUET_MAX_FILE_SIZE, String.valueOf(this.getWriteConfig().getClusteringMaxBytesInGroup()));
        return HoodieDatasetBulkInsertHelper.bulkInsert(inputRecords, instantTime, this.getHoodieTable(), newConfig, this.getRowPartitioner(strategyParams, schema), numOutputGroups, shouldPreserveHoodieMetadata);
    }

    @Override
    public HoodieData<WriteStatus> performClusteringWithRecordsRDD(HoodieData<HoodieRecord<T>> inputRecords, int numOutputGroups, String instantTime, Map<String, String> strategyParams, Schema schema, List<HoodieFileGroupId> fileGroupIdList, boolean shouldPreserveHoodieMetadata, Map<String, String> extraMetadata) {
        LOG.info((Object)("Starting clustering for a group, parallelism:" + numOutputGroups + " commit:" + instantTime));
        HoodieWriteConfig newConfig = HoodieWriteConfig.newBuilder().withBulkInsertParallelism(numOutputGroups).withProps(this.getWriteConfig().getProps()).build();
        newConfig.setValue(HoodieStorageConfig.PARQUET_MAX_FILE_SIZE, String.valueOf(this.getWriteConfig().getClusteringMaxBytesInGroup()));
        return SparkBulkInsertHelper.newInstance().bulkInsert(inputRecords, instantTime, this.getHoodieTable(), newConfig, false, this.getRDDPartitioner(strategyParams, schema), true, numOutputGroups, (WriteHandleFactory)new CreateHandleFactory(shouldPreserveHoodieMetadata));
    }
}

