/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.validator;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.util.HoodieTimer;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieValidationException;
import org.apache.hudi.table.HoodieSparkTable;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.HoodieWriteMetadata;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;

public abstract class SparkPreCommitValidator<T, I, K, O extends HoodieData<WriteStatus>> {
    private static final Logger LOG = LogManager.getLogger(SparkPreCommitValidator.class);
    private HoodieSparkTable<T> table;
    private HoodieEngineContext engineContext;
    private HoodieWriteConfig writeConfig;

    protected SparkPreCommitValidator(HoodieSparkTable<T> table, HoodieEngineContext engineContext, HoodieWriteConfig writeConfig) {
        this.table = table;
        this.engineContext = engineContext;
        this.writeConfig = writeConfig;
    }

    protected Set<String> getPartitionsModified(HoodieWriteMetadata<O> writeResult) {
        Set<String> partitionsModified = writeResult.getWriteStats().isPresent() ? writeResult.getWriteStats().get().stream().map(HoodieWriteStat::getPartitionPath).collect(Collectors.toSet()) : new HashSet<String>(((HoodieData)writeResult.getWriteStatuses()).map(WriteStatus::getPartitionPath).collectAsList());
        return partitionsModified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate(String instantTime, HoodieWriteMetadata<O> writeResult, Dataset<Row> before, Dataset<Row> after) throws HoodieValidationException {
        HoodieTimer timer = HoodieTimer.start();
        try {
            this.validateRecordsBeforeAndAfter(before, after, this.getPartitionsModified(writeResult));
        }
        finally {
            LOG.info((Object)(this.getClass() + " validator took " + timer.endTimer() + " ms"));
        }
    }

    protected abstract void validateRecordsBeforeAndAfter(Dataset<Row> var1, Dataset<Row> var2, Set<String> var3);

    public HoodieTable getHoodieTable() {
        return this.table;
    }

    public HoodieEngineContext getEngineContext() {
        return this.engineContext;
    }

    public HoodieWriteConfig getWriteConfig() {
        return this.writeConfig;
    }
}

