/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoSerializable;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.hudi.SparkAdapterSupport$;
import org.apache.hudi.client.model.HoodieInternalRow;
import org.apache.hudi.common.model.HoodieAvroIndexedRecord;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieOperation;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordLocation;
import org.apache.hudi.common.model.MetadataValues;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.keygen.BaseKeyGenerator;
import org.apache.hudi.keygen.SparkKeyGeneratorInterface;
import org.apache.spark.sql.HoodieInternalRowUtils;
import org.apache.spark.sql.HoodieUnsafeRowUtils;
import org.apache.spark.sql.catalyst.CatalystTypeConverters;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.JoinedRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Option;

public class HoodieSparkRecord
extends HoodieRecord<InternalRow>
implements KryoSerializable {
    private boolean copy;
    private final transient StructType schema;

    public HoodieSparkRecord(UnsafeRow data) {
        this((InternalRow)data, null);
    }

    public HoodieSparkRecord(InternalRow data, StructType schema) {
        super(null, data);
        HoodieSparkRecord.validateRow(data, schema);
        this.copy = false;
        this.schema = schema;
    }

    public HoodieSparkRecord(HoodieKey key, UnsafeRow data, boolean copy) {
        this(key, (InternalRow)data, null, copy);
    }

    public HoodieSparkRecord(HoodieKey key, InternalRow data, StructType schema, boolean copy) {
        super(key, data);
        HoodieSparkRecord.validateRow(data, schema);
        this.copy = copy;
        this.schema = schema;
    }

    private HoodieSparkRecord(HoodieKey key, InternalRow data, StructType schema, HoodieOperation operation, boolean copy) {
        super(key, data, operation, org.apache.hudi.common.util.Option.empty());
        HoodieSparkRecord.validateRow(data, schema);
        this.copy = copy;
        this.schema = schema;
    }

    public HoodieSparkRecord(HoodieKey key, InternalRow data, StructType schema, HoodieOperation operation, HoodieRecordLocation currentLocation, HoodieRecordLocation newLocation, boolean copy) {
        super(key, data, operation, currentLocation, newLocation);
        this.copy = copy;
        this.schema = schema;
    }

    public HoodieSparkRecord newInstance() {
        return new HoodieSparkRecord(this.key, (InternalRow)this.data, this.schema, this.operation, this.copy);
    }

    public HoodieSparkRecord newInstance(HoodieKey key, HoodieOperation op) {
        return new HoodieSparkRecord(key, (InternalRow)this.data, this.schema, op, this.copy);
    }

    public HoodieSparkRecord newInstance(HoodieKey key) {
        return new HoodieSparkRecord(key, (InternalRow)this.data, this.schema, this.operation, this.copy);
    }

    @Override
    public String getRecordKey(Schema recordSchema, org.apache.hudi.common.util.Option<BaseKeyGenerator> keyGeneratorOpt) {
        if (this.key != null) {
            return this.getRecordKey();
        }
        StructType structType = HoodieInternalRowUtils.getCachedSchema(recordSchema);
        return keyGeneratorOpt.isPresent() ? ((SparkKeyGeneratorInterface)((Object)keyGeneratorOpt.get())).getRecordKey((InternalRow)this.data, structType).toString() : ((InternalRow)this.data).getString(HoodieRecord.HoodieMetadataField.RECORD_KEY_METADATA_FIELD.ordinal());
    }

    @Override
    public String getRecordKey(Schema recordSchema, String keyFieldName) {
        if (this.key != null) {
            return this.getRecordKey();
        }
        StructType structType = HoodieInternalRowUtils.getCachedSchema(recordSchema);
        DataType dataType = structType.apply(keyFieldName).dataType();
        int pos = structType.fieldIndex(keyFieldName);
        return ((InternalRow)this.data).get(pos, dataType).toString();
    }

    @Override
    public HoodieRecord.HoodieRecordType getRecordType() {
        return HoodieRecord.HoodieRecordType.SPARK;
    }

    @Override
    public Object[] getColumnValues(Schema recordSchema, String[] columns, boolean consistentLogicalTimestampEnabled) {
        StructType structType = HoodieInternalRowUtils.getCachedSchema(recordSchema);
        Object[] objects = new Object[columns.length];
        for (int i = 0; i < objects.length; ++i) {
            objects[i] = HoodieSparkRecord.getValue(structType, columns[i], (InternalRow)this.data);
        }
        return objects;
    }

    @Override
    public HoodieRecord joinWith(HoodieRecord other, Schema targetSchema) {
        StructType targetStructType = HoodieInternalRowUtils.getCachedSchema(targetSchema);
        JoinedRow mergeRow = new JoinedRow((InternalRow)this.data, (InternalRow)other.getData());
        UnsafeProjection projection = HoodieInternalRowUtils.getCachedUnsafeProjection(targetStructType, targetStructType);
        return new HoodieSparkRecord(this.getKey(), (InternalRow)projection.apply((InternalRow)mergeRow), targetStructType, this.getOperation(), this.currentLocation, this.newLocation, this.copy);
    }

    @Override
    public HoodieRecord prependMetaFields(Schema recordSchema, Schema targetSchema, MetadataValues metadataValues, Properties props) {
        StructType structType = HoodieInternalRowUtils.getCachedSchema(recordSchema);
        StructType targetStructType = HoodieInternalRowUtils.getCachedSchema(targetSchema);
        HoodieInternalRow updatableRow = HoodieSparkRecord.wrapIntoUpdatableOverlay((InternalRow)this.data, structType);
        HoodieSparkRecord.updateMetadataValuesInternal(updatableRow, metadataValues);
        return new HoodieSparkRecord(this.getKey(), updatableRow, targetStructType, this.getOperation(), this.currentLocation, this.newLocation, false);
    }

    @Override
    public HoodieRecord rewriteRecordWithNewSchema(Schema recordSchema, Properties props, Schema newSchema, Map<String, String> renameCols) {
        StructType structType = HoodieInternalRowUtils.getCachedSchema(recordSchema);
        StructType newStructType = HoodieInternalRowUtils.getCachedSchema(newSchema);
        Function1<InternalRow, UnsafeRow> unsafeRowWriter = HoodieInternalRowUtils.getCachedUnsafeRowWriter(structType, newStructType, renameCols);
        UnsafeRow unsafeRow = (UnsafeRow)unsafeRowWriter.apply(this.data);
        return new HoodieSparkRecord(this.getKey(), (InternalRow)unsafeRow, newStructType, this.getOperation(), this.currentLocation, this.newLocation, false);
    }

    @Override
    public HoodieRecord truncateRecordKey(Schema recordSchema, Properties props, String keyFieldName) {
        StructType structType = HoodieInternalRowUtils.getCachedSchema(recordSchema);
        int pos = structType.fieldIndex(keyFieldName);
        ((InternalRow)this.data).update(pos, CatalystTypeConverters.convertToCatalyst((Object)""));
        return this;
    }

    @Override
    public boolean isDelete(Schema recordSchema, Properties props) throws IOException {
        if (null == this.data) {
            return true;
        }
        if (recordSchema.getField("_hoodie_is_deleted") == null) {
            return false;
        }
        Object deleteMarker = ((InternalRow)this.data).get(recordSchema.getField("_hoodie_is_deleted").pos(), DataTypes.BooleanType);
        return deleteMarker instanceof Boolean && (Boolean)deleteMarker != false;
    }

    @Override
    public boolean shouldIgnore(Schema recordSchema, Properties props) throws IOException {
        return false;
    }

    @Override
    public HoodieRecord wrapIntoHoodieRecordPayloadWithParams(Schema recordSchema, Properties props, org.apache.hudi.common.util.Option<Pair<String, String>> simpleKeyGenFieldsOpt, Boolean withOperation, org.apache.hudi.common.util.Option<String> partitionNameOp, Boolean populateMetaFields) {
        StructType structType = HoodieInternalRowUtils.getCachedSchema(recordSchema);
        if (populateMetaFields.booleanValue()) {
            return HoodieSparkRecord.convertToHoodieSparkRecord(structType, this, withOperation);
        }
        if (simpleKeyGenFieldsOpt.isPresent()) {
            return HoodieSparkRecord.convertToHoodieSparkRecord(structType, this, simpleKeyGenFieldsOpt.get(), withOperation, org.apache.hudi.common.util.Option.empty());
        }
        return HoodieSparkRecord.convertToHoodieSparkRecord(structType, this, withOperation, partitionNameOp);
    }

    @Override
    public HoodieRecord wrapIntoHoodieRecordPayloadWithKeyGen(Schema recordSchema, Properties props, org.apache.hudi.common.util.Option<BaseKeyGenerator> keyGen) {
        String partition;
        String key;
        StructType structType = HoodieInternalRowUtils.getCachedSchema(recordSchema);
        boolean populateMetaFields = Boolean.parseBoolean(props.getOrDefault((Object)HoodieTableConfig.POPULATE_META_FIELDS.key(), HoodieTableConfig.POPULATE_META_FIELDS.defaultValue().toString()).toString());
        if (!populateMetaFields && keyGen.isPresent()) {
            SparkKeyGeneratorInterface keyGenerator = (SparkKeyGeneratorInterface)((Object)keyGen.get());
            key = keyGenerator.getRecordKey((InternalRow)this.data, structType).toString();
            partition = keyGenerator.getPartitionPath((InternalRow)this.data, structType).toString();
        } else {
            key = ((InternalRow)this.data).get(HoodieRecord.HoodieMetadataField.RECORD_KEY_METADATA_FIELD.ordinal(), DataTypes.StringType).toString();
            partition = ((InternalRow)this.data).get(HoodieRecord.HoodieMetadataField.PARTITION_PATH_METADATA_FIELD.ordinal(), DataTypes.StringType).toString();
        }
        HoodieKey hoodieKey = new HoodieKey(key, partition);
        return new HoodieSparkRecord(hoodieKey, (InternalRow)this.data, structType, this.getOperation(), this.currentLocation, this.newLocation, this.copy);
    }

    @Override
    public org.apache.hudi.common.util.Option<Map<String, String>> getMetadata() {
        return org.apache.hudi.common.util.Option.empty();
    }

    @Override
    public org.apache.hudi.common.util.Option<HoodieAvroIndexedRecord> toIndexedRecord(Schema recordSchema, Properties prop) throws IOException {
        throw new UnsupportedOperationException();
    }

    public HoodieSparkRecord copy() {
        if (!this.copy) {
            this.data = ((InternalRow)this.data).copy();
            this.copy = true;
        }
        return this;
    }

    @Override
    public Comparable<?> getOrderingValue(Schema recordSchema, Properties props) {
        String orderingField;
        StructType structType = HoodieInternalRowUtils.getCachedSchema(recordSchema);
        Option<HoodieUnsafeRowUtils.NestedFieldPath> cachedNestedFieldPath = HoodieInternalRowUtils.getCachedPosList(structType, orderingField = ConfigUtils.getOrderingField(props));
        if (cachedNestedFieldPath.isDefined()) {
            HoodieUnsafeRowUtils.NestedFieldPath nestedFieldPath = (HoodieUnsafeRowUtils.NestedFieldPath)cachedNestedFieldPath.get();
            return (Comparable)HoodieUnsafeRowUtils.getNestedInternalRowValue((InternalRow)this.data, nestedFieldPath);
        }
        return 0;
    }

    @Override
    protected final void writeRecordPayload(InternalRow payload, Kryo kryo, Output output) {
        UnsafeRow unsafeRow = HoodieSparkRecord.convertToUnsafeRow(payload, this.schema);
        kryo.writeObjectOrNull(output, (Object)unsafeRow, UnsafeRow.class);
    }

    @Override
    protected final InternalRow readRecordPayload(Kryo kryo, Input input) {
        this.copy = true;
        return (InternalRow)kryo.readObjectOrNull(input, UnsafeRow.class);
    }

    private static UnsafeRow convertToUnsafeRow(InternalRow payload, StructType schema) {
        if (payload == null) {
            return null;
        }
        if (payload instanceof UnsafeRow) {
            return (UnsafeRow)payload;
        }
        UnsafeProjection unsafeProjection = HoodieInternalRowUtils.getCachedUnsafeProjection(schema, schema);
        return unsafeProjection.apply(payload);
    }

    private static HoodieInternalRow wrapIntoUpdatableOverlay(InternalRow data, StructType structType) {
        if (data instanceof HoodieInternalRow) {
            return (HoodieInternalRow)data;
        }
        boolean containsMetaFields = HoodieSparkRecord.hasMetaFields(structType);
        UTF8String[] metaFields = HoodieSparkRecord.extractMetaFields(data, structType);
        return new HoodieInternalRow(metaFields, data, containsMetaFields);
    }

    private static UTF8String[] extractMetaFields(InternalRow row, StructType structType) {
        boolean containsMetaFields = HoodieSparkRecord.hasMetaFields(structType);
        if (containsMetaFields) {
            return (UTF8String[])HoodieRecord.HOODIE_META_COLUMNS.stream().map(col -> row.getUTF8String(((Integer)HOODIE_META_COLUMNS_NAME_TO_POS.get(col)).intValue())).toArray(UTF8String[]::new);
        }
        return new UTF8String[HoodieRecord.HOODIE_META_COLUMNS.size()];
    }

    private static void updateMetadataValuesInternal(HoodieInternalRow updatableRow, MetadataValues metadataValues) {
        String[] values2 = metadataValues.getValues();
        for (int pos = 0; pos < values2.length; ++pos) {
            String value = values2[pos];
            if (value == null) continue;
            updatableRow.update(pos, CatalystTypeConverters.convertToCatalyst((Object)value));
        }
    }

    private static boolean hasMetaFields(StructType structType) {
        return structType.getFieldIndex(HoodieRecord.RECORD_KEY_METADATA_FIELD).isDefined();
    }

    private static HoodieRecord<InternalRow> convertToHoodieSparkRecord(StructType structType, HoodieSparkRecord record, boolean withOperationField) {
        return HoodieSparkRecord.convertToHoodieSparkRecord(structType, record, Pair.of(HoodieRecord.RECORD_KEY_METADATA_FIELD, HoodieRecord.PARTITION_PATH_METADATA_FIELD), withOperationField, org.apache.hudi.common.util.Option.empty());
    }

    private static HoodieRecord<InternalRow> convertToHoodieSparkRecord(StructType structType, HoodieSparkRecord record, boolean withOperationField, org.apache.hudi.common.util.Option<String> partitionName) {
        return HoodieSparkRecord.convertToHoodieSparkRecord(structType, record, Pair.of(HoodieRecord.RECORD_KEY_METADATA_FIELD, HoodieRecord.PARTITION_PATH_METADATA_FIELD), withOperationField, partitionName);
    }

    private static HoodieRecord<InternalRow> convertToHoodieSparkRecord(StructType structType, HoodieSparkRecord record, Pair<String, String> recordKeyPartitionPathFieldPair, boolean withOperationField, org.apache.hudi.common.util.Option<String> partitionName) {
        String recKey = HoodieSparkRecord.getValue(structType, recordKeyPartitionPathFieldPair.getKey(), (InternalRow)record.data).toString();
        String partitionPath = partitionName.isPresent() ? partitionName.get() : HoodieSparkRecord.getValue(structType, recordKeyPartitionPathFieldPair.getRight(), (InternalRow)record.data).toString();
        HoodieOperation operation = withOperationField ? HoodieOperation.fromName(((InternalRow)record.data).getString(structType.fieldIndex(HoodieRecord.OPERATION_METADATA_FIELD))) : null;
        return new HoodieSparkRecord(new HoodieKey(recKey, partitionPath), (InternalRow)record.data, structType, operation, record.copy);
    }

    private static void validateRow(InternalRow data, StructType schema) {
        boolean isValid = data instanceof UnsafeRow || schema != null && (data instanceof HoodieInternalRow || SparkAdapterSupport$.MODULE$.sparkAdapter().isColumnarBatchRow(data));
        ValidationUtils.checkState(isValid);
    }

    private static Object getValue(StructType structType, String fieldName, InternalRow row) {
        Option<HoodieUnsafeRowUtils.NestedFieldPath> cachedNestedFieldPath = HoodieInternalRowUtils.getCachedPosList(structType, fieldName);
        if (cachedNestedFieldPath.isDefined()) {
            return HoodieUnsafeRowUtils.getNestedInternalRowValue(row, (HoodieUnsafeRowUtils.NestedFieldPath)cachedNestedFieldPath.get());
        }
        throw new HoodieException(String.format("Field at %s is not present in %s", fieldName, structType));
    }
}

